;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/eval.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Apr 13 14:07:09 1998                          */
;*    Last change :  Fri Aug 14 16:23:59 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The stuff for Bdb eval commands.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_eval
   (import tools_echo
	   engine_engine
	   command_command
	   command_blocals
	   env_env)
   (export (bdb-eval ::bstring)
	   (bdb-eval-environment exp . file:line-spec)
	   (bdb-eval-env-list exp . file:line-spec)))
 
;*---------------------------------------------------------------------*/
;*    bdb-eval ...                                                     */
;*---------------------------------------------------------------------*/
(define (bdb-eval exp)
   (let ((cmd (string-append "call bdb_eval_for_value(\""
			     (string-for-read exp)
			     "\","
			     (bdb-eval-environment exp)
			     ")")))
      (gdb-echo (string-append (gdb-send-for-value cmd) #"\n"))
      #unspecified))
  
;*---------------------------------------------------------------------*/
;*    bdb-eval-environment ...                                         */
;*    -------------------------------------------------------------    */
;*    This function returns a string that will be argument to a        */
;*    bdb_eval call. It is something like:                             */
;*       "X", x_23, "Y", y_45, 0                                       */
;*    -------------------------------------------------------------    */
;*    For global variables we use here an ad-hoc processing. We look   */
;*    all the symbol used in the expression. For each existing global  */
;*    variable with the name matching the symbol, we bind in the eval  */
;*    environment.                                                     */
;*---------------------------------------------------------------------*/
(define (bdb-eval-environment exp . file+lnum)
   (define (append-var var str)
      (string-append "\""
		     (variable-info-scm-name var)
		     "\", "
		     (if (and (global-info? var)
			      (string? (global-info-value-c-name var)))
			 (global-info-value-c-name var)
			 (variable-info-c-name var))
		     ", "
		     str))
   (let loop ((globals (get-globals (find-symbols exp)))
	      (str     " 0"))
      (if (null? globals)
	  (let laap ((locals (reverse (if (pair? file+lnum)
					  (let ((f+l (get-locals/line-spec
						      (car file+lnum)
						      (cadr file+lnum))))
					     (if (pair? f+l)
						 (cdr f+l)
						 '()))
					  (get-locals))))
		     (str    str))
	     (if (null? locals)
		 str
		 (laap (cdr locals)
		       (append-var (car locals) str))))
	  (loop (cdr globals)
		(append-var (car globals) str)))))

;*---------------------------------------------------------------------*/
;*    bdb-eval-env-list ...                                            */
;*    -------------------------------------------------------------    */
;*    This function is very close to bdb-eval-environment but instead  */
;*    of building a string, it build the list of the C identifier that */
;*    compose the eval environment. This function is used to checked   */
;*    that all the bindings needed by an eval form are actives. The    */
;*    display mechanism uses this function.                            */
;*---------------------------------------------------------------------*/
(define (bdb-eval-env-list exp . file+lnum)
   (define (append-var var res)
      (cons (if (and (global-info? var)
		     (string? (global-info-value-c-name var)))
		(global-info-value-c-name var)
		(variable-info-c-name var))
	    res))
   (let loop ((globals (get-globals (find-symbols exp)))
	      (res     '()))
      (if (null? globals)
	  (let laap ((locals (reverse (if (pair? file+lnum)
					  (let ((f+l (get-locals/line-spec
						      (car file+lnum)
						      (cadr file+lnum))))
					     (if (pair? f+l)
						 (cdr f+l)
						 '()))
					  (get-locals))))
		     (res    res))
	     (if (null? locals)
		 res
		 (laap (cdr locals)
		       (append-var (car locals) res))))
	  (loop (cdr globals)
		(append-var (car globals) res)))))

;*---------------------------------------------------------------------*/
;*    find-symbols ...                                                 */
;*---------------------------------------------------------------------*/
(define (find-symbols str)
   (let* ((port (open-input-string str))
	  (exp  (read port)))
      (close-input-port port)
      (let loop ((expr exp)
		 (res  '()))
	 (cond
	    ((null? expr)
	     res)
	    ((pair? expr)
	     (loop (car expr) (loop (cdr expr) res)))
	    ((symbol? expr)
	     (cons expr res))
	    (else
	     res)))))

      
      
