;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/completion.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 12 13:15:03 1998                          */
;*    Last change :  Thu Jan 28 12:37:40 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The command completion. This module implement the connection     */
;*    read-line.                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_completion
   (extern (export command-generator "command_generator"))
   (import command_command
	   tools_read
	   engine_engine)
   (export (command-generator::obj ::string ::bool)
	   (complete-line ::bstring)
	   (sub-command-completer::obj ::command ::bstring)
	   (gdb-sub-command-completer::obj ::obj ::bstring)))

;*---------------------------------------------------------------------*/
;*    *possible-completions* ...                                       */
;*---------------------------------------------------------------------*/
(define *possible-completions* '())
 
;*---------------------------------------------------------------------*/
;*    command-generator ...                                            */
;*    -------------------------------------------------------------    */
;*    This function is automatically invoked by read-line.             */
;*---------------------------------------------------------------------*/
(define (command-generator text::string state::bool)
   (if (not state)
       ;; this is the first time we reset the completion list
       (set! *possible-completions* (complete-line text)))
   (if (null? *possible-completions*)
       #f
       (let ((res (car *possible-completions*)))
	  (set! *possible-completions* (cdr *possible-completions*))
	  res)))

;*---------------------------------------------------------------------*/
;*    complete-line ...                                                */
;*    -------------------------------------------------------------    */
;*    This function takes as input a command line and it returns       */
;*    a list of the possible comletion for the last word. For instance */
;*    if this function is call with the string `bi mo to', it will     */
;*    return the list '("toto" "tomi" ...)                             */
;*---------------------------------------------------------------------*/
(define (complete-line string)
   (let* ((list  (string->word-list string))
	  (len   (string-length string))
	  (elist (if (and (>fx len 0) (char=? (string-ref string (-fx len 1))
					      #\space))
		     (append list '(""))
		     list)))
      (if (top-level-line-command? elist)
	  (top-level-complete string)
	  (nested-completion string elist))))

;*---------------------------------------------------------------------*/
;*    top-level-complete ...                                           */
;*    -------------------------------------------------------------    */
;*    This function takes in charge the completion at top-level        */
;*    (that is command which are not subcommands). That is, it returns */
;*    the list of all commands that are prefixed with `string'.        */
;*---------------------------------------------------------------------*/
(define (top-level-complete string)
   (let ((len (string-length string))) 
      (if (and (>fx len 0) (char=? (string-ref string (-fx len 1)) #\space))
	  (let ((cmd (find-one-command string (get-command-list))))
	     (if (command? cmd)
		 ((command-completer cmd) cmd "")
		 '()))
	  (let loop ((cmds (get-command-list))
		     (res  '()))
	     (cond
		((null? cmds)
		 (gdb-completer string res))
		((substring=? (command-name (car cmds)) string len)
		 (loop (cdr cmds) (cons (command-name (car cmds)) res)))
		(else
		 (loop (cdr cmds) res)))))))
	  
;*---------------------------------------------------------------------*/
;*    nested-completion ...                                            */
;*---------------------------------------------------------------------*/
(define (nested-completion cmd-string cmd-list)
;*    (print "NC: [" cmd-string "]  list: " cmd-list)                  */
   (let loop ((cmd-list  cmd-list)
	      (completer (lambda (cmd string) '()))
	      (cmd       #f)
	      (cmds      (get-command-list)))
      (if (null? (cdr cmd-list))
	  ;; we have found the last word, the one we complete
	  (if (command? cmd)
	      (completer cmd (car cmd-list))
	      '())
	  ;; we have to decode the current command to find the next
	  ;; completer
	  (let ((cmd (find-one-command (car cmd-list) cmds)))
	     (if (command? cmd)
		 (loop (cdr cmd-list)
		       (command-completer cmd)
		       cmd
		       (command-sub-commands cmd))
		 (loop (cdr cmd-list)
		       completer
		       cmd
		       '()))))))

;*---------------------------------------------------------------------*/
;*    sub-command-completer ...                                        */
;*---------------------------------------------------------------------*/
(define (sub-command-completer cmd string)
;*    (print "SBC: [" cmd "] string: [" string "]")                    */
   (let ((len (string-length string)))
;*       (print "len: " len)                                           */
;*       (print "sub: " (map command-name (command-sub-commands cmd))) */
      (cond
	 ((=fx len 0)
	  (map (lambda (command)
		  (command-name command))
	       (command-sub-commands cmd)))
	 ((char=? (string-ref string (-fx len 1)) #\space)
	  (let ((cmd (find-one-command string (command-sub-commands cmd))))
	     (if (command? cmd)
		 ((command-completer cmd) cmd string)
		 '())))
	 (else
	  (let loop ((cmds (command-sub-commands cmd))
		     (res  '()))
	     (cond
		((null? cmds)
		 res)
		((substring=? (command-name (car cmds)) string len)
		 (loop (cdr cmds) (cons (command-name (car cmds)) res)))
		(else
		 (loop (cdr cmds) res))))))))

;*---------------------------------------------------------------------*/
;*    gdb-sub-command-completer ...                                    */
;*---------------------------------------------------------------------*/
(define (gdb-sub-command-completer cmd string)
;*    (print "GSBC: [" cmd "] string: [" string "]")                   */
   (if (not (command? cmd))
       '()
       (let ((bdb-completions (sub-command-completer cmd string)))
;* 	  (print "bdb-completions: " bdb-completions)                  */
	  (if (command? cmd)
	      (let* ((gdb-string (if (>fx (string-length string) 0)
				     (string-append (command-name cmd)
						    " "
						    string)
				     (string-append (command-name cmd) " ")))
		     (gdb-len    (+fx (string-length (command-name cmd)) 1))
		     (gdb-completions (gdb-completer gdb-string '())))
		 (append bdb-completions
			 (map (lambda (string)
				 (substring string
					    gdb-len
					    (string-length string)))
			      gdb-completions)))
	      bdb-completions))))

;*---------------------------------------------------------------------*/
;*    gdb-completer ...                                                */
;*---------------------------------------------------------------------*/
(define (gdb-completer prefix list)
;*    (print "GBC: [" prefix "] [" list "]")                           */
   (let* ((cmd         (string-append "complete " prefix))
	  (completions (gdb-send-for-output cmd))
	  (port        (open-input-string completions)))
      (let loop ((exp (read-line port))
		 (res list))
	 (if (eof-object? exp)
	     (begin
		(close-input-port port)
		res)
	     (loop (read-line port) (cons exp res))))))
      
