;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/complete.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 18 18:36:32 1998                          */
;*    Last change :  Sat Apr 18 18:57:59 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The complete command.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_complete
   (import tools_read
	   engine_param
	   engine_engine
	   command_command
	   command_completion)
   (export (complete-command ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    complete-command ...                                             */
;*---------------------------------------------------------------------*/
(define (complete-command line line-list)
   (define (do-complete line prefix)
      (let ((completions (complete-line line)))
	 (for-each (lambda (completion)
		      (print prefix completion))
		   completions)))
   (let ((len (string-length line)))
      ;; we disguard the last space char
      (if (char=? (string-ref line (-fx len 1)) #\space)
	  (set! len (-fx len 1)))
      (let loop ((i 0))
	 (cond
	    ((=fx i len)
	     (do-complete "" ""))
	    ((char=? (string-ref line i) #\space)
	     ;; we compute the prefix of all the completions
	     (let ((prefix (let loop ((ll (cdr line-list)))
			      (if (null? (cdr ll))
				  ""
				  (string-append (car ll)
						 " "
						 (loop (cdr ll)))))))
		(do-complete (substring line (+fx i 1) len) prefix)))
	    (else
	     (loop (+fx i 1)))))))
   

