;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/commands.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Apr 28 06:56:34 1998                          */
;*    Last change :  Thu Sep 24 06:36:00 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The commands command.                                            */
;*    -------------------------------------------------------------    */
;*    This command is very specific because it reads its arguments     */
;*    until the keyword end is found.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_commands
   (import tools_read
	   engine_param
	   engine_engine
	   command_eval)
   (extern (read-cmd-line::obj (::string) "read_cmd_line"))
   (export (commands-command ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    commands-command ...                                             */
;*---------------------------------------------------------------------*/
(define (commands-command line line-list)
   (display (parse-output (gdb-send-for-output* (cons line (read-commands))))))

;*---------------------------------------------------------------------*/
;*    parse-output ...                                                 */
;*    -------------------------------------------------------------    */
;*    Because sometime gdb is just a mess we have to parse the         */
;*    output of the commands command. Here we have to check if the     */
;*    commands as been legally registered or if an error occured. We   */
;*    recognize this by scanning the characters of the commands        */
;*    output. If the characters are `>' it is ok. Otherwise and error  */
;*    has occured.                                                     */
;*---------------------------------------------------------------------*/
(define (parse-output output)
   (let ((ok-line? (lambda (output)
		      (let ((p (open-input-string output))
			    (g (regular-grammar ((blank (in #\Space #\Tab)))
				  ((eof (bol (: (* blank) (+ #\>))))
				   #t)
				  (else
				   #f))))
			 (let ((res (read/rp g p)))
			    (close-input-port p)
			    res)))))
      (if (ok-line? output)
	  ;; this is ok, no output
	  ""
	  ;; error, we print until the regular gdb prompt
	  (let ((len (string-length output)))
	     (let loop ((r 0))
		(cond
		   ((=fx r len)
		    output)
		   ((substring/pos=? output r *regular-gdb-prompt*)
		    (substring output 0 r))
		   (else
		    (loop (+fx r 1)))))))))

;*---------------------------------------------------------------------*/
;*    substring/pos=? ...                                              */
;*---------------------------------------------------------------------*/
(define (substring/pos=? str1 r1 str2)
   (let* ((l1 (string-length str1))
	  (l2 (string-length str2))
	  (s1 (+fx r1 l2)))
      (and (>=fx (-fx l1 r1) l2)
	   (let loop ((r2 0)
		      (r1 r1))
	      (cond
		 ((=fx r1 s1)
		  #t)
		 ((char=? (string-ref str1 r1) (string-ref str2 r2))
		  (loop (+fx r2 1) (+fx r1 1)))
		 (else
		  #f))))))

;*---------------------------------------------------------------------*/
;*    read-commands ...                                                */
;*---------------------------------------------------------------------*/
(define (read-commands)
   (let ((end-line? (lambda (line)
		       (let ((p (open-input-string line))
			     (g (regular-grammar ((blank (in #\Space #\Tab)))
				   ((eof (bol (: (* blank) "end" (* blank))))
				    #t)
				   (else
				    #f))))
			  (let ((res (read/rp g p)))
			     (close-input-port p)
			     res)))))
      (let loop ((lines '())
		 (line   (read-cmd-line *commands-prompt*)))
	 (if (end-line? line)
	     (reverse! (cons line lines))
	     (loop (cons line lines)
		   (read-cmd-line *commands-prompt*))))))
      

	  
   
