;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bwhatis.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 10 07:06:57 1998                          */
;*    Last change :  Thu Jan 28 10:56:50 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implement a function that inspects runtime values.   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bwhatis
   (import tools_read
	   engine_engine
	   command_eval)
   (export (bwhatis-command ::bstring ::obj)
	   (bigloo-object?::bool ::bstring)
	   (bigloo-procedure-entry-point ::bstring)))

;*---------------------------------------------------------------------*/
;*    bwhatis-command ...                                              */
;*---------------------------------------------------------------------*/
(define (bwhatis-command line line-list)
   (match-case line-list
      ((?-)
       (print "Argument missing."))
      ((?- ?exp)
       (bdb-eval (string-append "(find-runtime-type " exp ")")))))

;*---------------------------------------------------------------------*/
;*    bigloo-object? ...                                               */
;*---------------------------------------------------------------------*/
(define (bigloo-object? exp)
   (let* ((gdb-cmd-whatis (string-append "whatis " exp))
	  (type-string    (gdb-send-for-output gdb-cmd-whatis))
	  (prefix         "type = ")
	  (prefix-len     (string-length prefix)))
      (if (and (>fx (string-length type-string) prefix-len)
	       (string=? prefix (substring type-string 0 prefix-len)))
	  (let ((type (substring type-string prefix-len
				 (-fx (string-length type-string) 1))))
	     (string=? type "union scmobj *")))))

;*---------------------------------------------------------------------*/
;*    bigloo-procedure-entry-point ...                                 */
;*---------------------------------------------------------------------*/
(define (bigloo-procedure-entry-point exp)
   (print "bigloo-procedure-entry-point: " exp)
   (if (bigloo-object? exp)
       (let ((gdb-cmd (string-append "call bdb_procedure_entry( " exp ")")))
	  (let ((addr (gdb-send-for-value gdb-cmd)))
	     (if (>fx (string-length addr) 0)
		 addr
		 #f)))
       #f))
   
