;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bvariables.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  9 18:16:26 1998                          */
;*    Last change :  Tue Jun 30 11:00:58 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This command print out the list of the Bigloo global variables.  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bvariables
   (import engine_param
	   engine_engine
	   command_command
	   command_blocals
	   command_bbreak
	   tools_regexp
	   tools_file
	   tools_echo
	   env_env
	   tools_read)
   (export (binfo-variables-command      ::bstring ::obj)
	   (bvariables-command-completer ::command ::bstring)
	   (binfo-binding-command        ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    binfo-variables-command ...                                      */
;*---------------------------------------------------------------------*/
(define (binfo-variables-command line line-list)
   (define (binfo-global global)
      (display* "(@ "
		(global-info-scm-name global)
		" "
		(module-info-name (global-info-module global))
 		")")
      (if (string? (global-info-c-name global))
	  (display* "    value: \"" (global-info-c-name global) "\""))
      (if (string? (global-info-value-c-name global))
	  (display* "    breakpoint: \""
		    (global-info-value-c-name global)
		    "\""))
      (newline))
   (match-case line-list
      ((?- ?-)
       (gdb-start-echo)
       (print "All Bigloo variables:")
       (newline)
       (for-each-global binfo-global)
       (gdb-stop-echo))
      ((?- ?- ?regexp)
       (gdb-start-echo)
       (print "All Bigloo variables matching regular expression \""
	      regexp
	      "\":")
       (newline)
       (for-each-global (lambda (global)
			   (if (regexp-match? (bdb-case regexp)
					      (global-info-scm-name global))
			       (binfo-global global))))
       (gdb-stop-echo))))

;*---------------------------------------------------------------------*/
;*    bvariables-command-completer ...                                 */
;*---------------------------------------------------------------------*/
(define (bvariables-command-completer cmd::command string::bstring)
   (bbreak-command-completer cmd string))

;*---------------------------------------------------------------------*/
;*    find-global-names ...                                            */
;*    -------------------------------------------------------------    */
;*    This function build the list of all global variables for whom    */
;*    global filter returns #t.                                        */
;*---------------------------------------------------------------------*/
(define (find-global-names filter)
   (let ((res '()))
      (for-each-global (lambda (global)
			  (let ((name (global-info-scm-name global)))
			     (if (filter name)
				 (set! res (cons name res))))))
      res))
   
;*---------------------------------------------------------------------*/
;*    binfo-binding-command ...                                        */
;*---------------------------------------------------------------------*/
(define (binfo-binding-command line line-list)
   (define (binding-c-name binding file-name line-num)
      (let ((fun+locals (get-locals/line-spec file-name line-num)))
	 (if (pair? fun+locals)
	     (let loop ((locals (cdr fun+locals)))
		(cond
		   ((null? locals)
		    ;; we have to look for a global variable
		    (let ((g-info (find-scm-global binding)))
		       (gdb-start-echo)
		       (if (global-info? g-info)
			   (gdb-echo* "binding: "
				      (global-info-c-name g-info)
				      #\Newline)
			   (newline))))
		   ((string=? (variable-info-scm-name (car locals))
			      (bdb-case binding))
		    ;; when fetching local variable, we have to check if
		    ;; the variable is active
		    (let* ((c-name (local-info-c-name (car locals)))
			   (cmd    (string-append "info address " c-name))
			   (addr   (gdb-send-for-output cmd)))
		       (if (substring=? addr "No" 2)
			   (loop (cdr locals))
			   (gdb-echo* "binding: " c-name #\Newline))))
		   (else
		    (loop (cdr locals)))))
	     (newline))))
   (match-case line-list
      ((?- ?- ?binding ?file:lnum)
       (multiple-value-bind (line-num file-name)
	  (parse-ident file:lnum)
	  (binding-c-name binding file-name line-num)))
      ((?- ?- ?file:lnum)
       (multiple-value-bind (line-num file-name)
	  (parse-ident file:lnum)
	  (let ((fun+locals (get-locals/line-spec file-name line-num)))
	     (if (pair? fun+locals)
		 (begin
		    (gdb-start-echo)
		    (display* (variable-info-scm-name (car fun+locals)) ": ")
		    (for-each (lambda (local)
				 (display* (local-info-scm-name local)
					   #\space))
			      (cdr fun+locals))
		    (newline)
		    (gdb-stop-echo))))))
      (else
       (newline))))

       


