;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bstack.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Apr 13 07:09:29 1998                          */
;*    Last change :  Sun Oct 25 08:58:59 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The implementation of the `binfo stack' command.                 */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bstack
   (import env_env
	   tools_read
	   tools_echo
	   engine_engine)
   (export (binfo-stack-command line list)
	   (info-stack-command line list)))

;*---------------------------------------------------------------------*/
;*    binfo-stack-command ...                                          */
;*---------------------------------------------------------------------*/
(define (binfo-stack-command line line-list)
   ;; first, we build the gdb command that print out the stack trace
   ;; and execute it
   (let* ((gdb-cmd (match-case line-list
		      ((?- ?- ?num)
		       (string-append "info stack " num))
		      (else
		       (string-append "info stack"))))
	  (stack   (gdb-send-for-output gdb-cmd)))
      ;; now we parse it
      (if (substring=? stack "No stack." 8)
	  (display stack)
	  (let ((port (open-input-string stack)))
	     (set! *output?* #f)
	     (set! *output-buffer* #f)
	     (read/rp *backtrace-grammar* port)
	     (close-input-port port)))))

;*---------------------------------------------------------------------*/
;*    backtrace state control ...                                      */
;*---------------------------------------------------------------------*/
(define *output?* #f)
(define *output-buffer* #f)

;*---------------------------------------------------------------------*/
;*    *backtrace-grammar* ...                                          */
;*    -------------------------------------------------------------    */
;*    The grammar to parse a gdb backtrace.                            */
;*---------------------------------------------------------------------*/
(define *backtrace-grammar*
   (regular-grammar ((frame-number (: #\# (+ digit)))
		     (address      (: #\0 (in #\x #\X) (+ xdigit)))
		     (ident        (: (or #\_ alpha)
				      (* (or #\_ alpha digit))))
		     (blank        (in #\space #\tab))
		     (otherchars   (in #\( #\) #\, #\= #\" #\. #\:
				       #\/ #\- #\+ #\/ #\* #\@ #\< #\>)))

      ;; first line shape: #XXX id (args-list) at file
      ((: frame-number (+ blank))
       (if (and *output?* (string? *output-buffer*))
	   (display *output-buffer*))
       (set! *output-buffer* "")
       (set! *output?* #f)
       (rgc-context 'id)
       (set! *output-buffer* (string-append *output-buffer* (the-string)))
       (ignore))

      ;; second one: #XXX address in id (args-list) at file
      ((: frame-number (+ blank) address (+ blank) #\i #\n (+ blank))
       (if (and *output?* (string? *output-buffer*))
	   (display *output-buffer*))
       (set! *output-buffer* "")
       (set! *output?* #f)
       (rgc-context 'id)
       (set! *output-buffer* (string-append *output-buffer* (the-string)))
       (ignore))

      ;; we have a function identifier. we look if it corresponds to a
      ;; bigloo identifier.
      ((context id ident)
       (let* ((cname    (the-string))
	      (fun-info (find-c-function cname)))
	  (if (function-info? fun-info)
	      (begin
		 (set! *output?* #t)
		 (set! *output-buffer* (string-append *output-buffer*
						      (function-info-scm-name
						       fun-info))))))
       (rgc-context)
       (ignore))

      (ident
       (set! *output-buffer* (string-append *output-buffer* (the-string)))
       (ignore))

      ((+ (or otherchars digit blank))
       (rgc-context)
       (set! *output-buffer* (string-append *output-buffer* (the-string)))
       (ignore))

      ((+ #\Newline)
       (set! *output-buffer* (string-append *output-buffer* (the-string)))
       (ignore))
	   
      (else
       (let ((c (the-failure)))
	  (if (eof-object? c)
	      'done
	      (begin
		 (warning "Umatched char (*backtrace-grammar*) " c)
		 (rgc-context)
		 (set! *output-buffer*
		       (string-append *output-buffer* (the-string)))
		 (ignore)))))))

;*---------------------------------------------------------------------*/
;*    info-stack-command ...                                           */
;*---------------------------------------------------------------------*/
(define (info-stack-command line line-list)
   ;; first, we build the gdb command that print out the stack trace
   ;; and execute it
   (let* ((gdb-cmd (match-case line-list
		      ((?- ?- ?num)
		       (string-append "info stack " num))
		      (else
		       (string-append "info stack"))))
	  (stack   (gdb-send-for-output gdb-cmd)))
      ;; now we parse it
      (if (substring=? stack "No stack." 8)
	  (display stack)
	  (let ((port (open-input-string stack)))
	     (read/rp *c-backtrace-grammar* port)
	     (close-input-port port)))))

;*---------------------------------------------------------------------*/
;*    *c-backtrace-grammar* ...                                        */
;*    -------------------------------------------------------------    */
;*    The grammar to parse a gdb backtrace.                            */
;*---------------------------------------------------------------------*/
(define *c-backtrace-grammar*
   (regular-grammar ((frame-number (: #\# (+ digit)))
		     (address      (: #\0 (in #\x #\X) (+ xdigit)))
		     (ident        (: (or #\_ alpha)
				      (* (or #\_ alpha digit))))
		     (blank        (in #\space #\tab #\Newline))
		     (otherchars   (in #\( #\) #\, #\= #\" #\.
				       #\: #\/ #\+ #\- #\/ #\* #\@ #\< #\>)))

      ;; first line shape: #XXX id (args-list) at file
      ((: frame-number (+ blank))
       (rgc-context 'id)
       (display (the-string))
       (ignore))

      ;; second one: #XXX address in id (args-list) at file
      ((: frame-number (+ blank) address (+ blank) #\i #\n (+ blank))
       (rgc-context 'id)
       (display (the-string))
       (ignore))

      ;; we have a function identifier. we look if it corresponds to a
      ;; bigloo identifier.
      ((context id ident)
       (let* ((cname    (the-string))
	      (fun-info (find-c-function cname)))
	  (if (function-info? fun-info)
	      (display* (function-info-scm-name fun-info) " \"" cname #\")
	      (display cname)))
       (rgc-context)
       (ignore))

      (ident
       (display (the-string))
       (ignore))

      ((+ (or otherchars digit blank))
       (rgc-context)
       (display (the-string))
       (ignore))

      (else
       (let ((c (the-failure)))
	  (if (eof-object? c)
	      'done
	      (begin
		 (warning "Umatched char (*backtrace-grammar*) " c)
		 (rgc-context)
		 (display c)
		 (ignore)))))))
       
	  
	  
      

      
