;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bprint.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 10 07:02:28 1998                          */
;*    Last change :  Sun Oct 25 09:12:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements the function that display a value.        */
;*    The function implemented here check the type of the expression.  */
;*    If the type is union object *, it will uses the Bigloo running   */
;*    bdb-display function. Otherwise, it will use the gdb print       */
;*    command.                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bprint
   (import tools_read
	   tools_echo
	   engine_engine
	   env_env
	   command_command
	   command_blocals
	   command_bfunction
	   command_bwhatis)
   (export (bprint-command/exp ::bstring)
	   (bprint-command     ::bstring ::obj)
	   (cprint-command     ::bstring ::obj)
	   (dprint-command     ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    bprint-command/exp ...                                           */
;*---------------------------------------------------------------------*/
(define (bprint-command/exp exp)
   ;; first we have to find the expression type
   (let ((cmd-display (string-append "call bdb_display( " exp " )")))
      (gdb-send-for-output cmd-display)))

;*---------------------------------------------------------------------*/
;*    bprint-command ...                                               */
;*---------------------------------------------------------------------*/
(define (bprint-command line line-list)
   (match-case line-list
      ((?-)
       (gdb-echo #"Argument missing.\n"))
      ((?- ?exp)
       ;;; this is the user entry point, we have to resolve name demangling
       (let ((glo-info (get-current-global)))
	  (if (not (global-info? glo-info))
	      (gdb-echo #"No Bigloo function.\n")
	      (let ((l-info (find-scm-local (string-upcase exp) glo-info)))
		 (if (local-info? l-info)
		     (let ((cmd (string-append
				 "call bdb_display( "
				 (local-info-c-name l-info)
				 " )")))
			(display (gdb-send-for-output cmd)))
		     (let ((g-info (find-scm-global (string-upcase exp))))
			(if (global-info? g-info)
			    (let ((cmd (string-append
					"call bdb_display( "
					(global-info-c-name g-info)
					" )")))
			       (display (gdb-send-for-output cmd)))
			    (gdb-echo (string-append
				       "No symbol \""
				       exp
				       #"\" in current context.\n")))))))))
      ((?- ?exp ?width)
       ;; this is the balloon entry point. name are already resolved.
       (let ((cmd (string-append "call bdb_display_width( "
				 exp ", " width " )")))
	  (gdb-send-for-output cmd)))))

;*---------------------------------------------------------------------*/
;*    cprint-command ...                                               */
;*    -------------------------------------------------------------    */
;*    This function simply uses the gdb print facility but its         */
;*    results is not surrounded with io markers.                       */
;*---------------------------------------------------------------------*/
(define (cprint-command line line-list)
   (match-case line-list
      ((?-)
       (gdb-echo #"Argument missing.\n"))
      ((?- ?exp)
       (let ((cmd (string-append "print " exp)))
	  (display (gdb-send-for-output cmd))))))

;*---------------------------------------------------------------------*/
;*    dprint-command ...                                               */
;*    -------------------------------------------------------------    */
;*    This function simply uses the gdb print facility but its         */
;*    results is not surrounded with io markers.                       */
;*---------------------------------------------------------------------*/
(define (dprint-command line line-list)
   (match-case line-list
      ((?-)
       (gdb-echo #"Argument missing.\n"))
      ((?- ?exp)
       (let ((cmd (string-append "call dprint( " exp " )")))
	  (display (gdb-send-for-output cmd))))))

