;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bmodule.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 12 11:57:06 1998                          */
;*    Last change :  Thu May 14 07:22:08 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The implementation of the `binfo module' command.                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bmodule
   (import tools_regexp
	   tools_echo
	   env_env
	   command_command
	   engine_param)
   (export (binfo-module-command line list)
	   (bmodule-command-completer ::command ::bstring)))

;*---------------------------------------------------------------------*/
;*    binfo-module-command ...                                         */
;*---------------------------------------------------------------------*/
(define (binfo-module-command line line-list)
   (gdb-start-echo)
   (match-case line-list
      ((?- ?- ?regexp)
       (print "Bigloo modules matching regular expression \"" regexp "\":")
       (newline)
       (print-module-info (lambda (name)
			     (regexp-match? (bdb-case regexp) name))))
      (else
       (print "All Bigloo modules:")
       (newline)
       (print-module-info (lambda (x) #t))))
   (gdb-stop-echo))

;*---------------------------------------------------------------------*/
;*    print-module-info ...                                            */
;*---------------------------------------------------------------------*/
(define (print-module-info filter)
   (for-each-module
    (lambda (modinfo)
       (with-access::module-info modinfo (name sources globals init-c-name)
	  (if (filter name)
	      (begin
		 ;; the name of the modules and
		 (display "--- ")
		 (display name)
		 (display ", ")
		 ;; the file implementing that module
		 (write sources)
		 (display* ", init: (@ " name ") [" init-c-name #"] --- \n")
		 ;; the global defined in the module
		 (for-each (lambda (global)
			      (display* "   " (global-info-scm-name global))
			      (if (string? (global-info-c-name global))
				  (display* "    value: \""
					    (global-info-c-name global) "\""))
			      (if (string? (global-info-value-c-name global))
				  (display* "    breakpoint: \""
					    (global-info-value-c-name global)
					    "\""))
			      (newline))
			   globals)
		 (newline)))))))

;*---------------------------------------------------------------------*/
;*    bmodule-command-completer ...                                    */
;*---------------------------------------------------------------------*/
(define (bmodule-command-completer cmd::command string::bstring)
   (define (find-modules filter)
      (let ((res '()))
	 (for-each-module
	  (lambda (modinfo)
	     (with-access::module-info modinfo (name sources globals)
		(if (filter name)
		    (set! res (cons name res))))))
	 res))
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (find-modules (lambda (name) #t))
	  (find-modules (lambda (name)
			   (if *bdb-case-sensitive?*
			       (substring=? name string len)
			       (substring-ci=? name string len)))))))
