;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/blocals.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  9 19:16:49 1998                          */
;*    Last change :  Thu Feb 11 14:11:12 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The blocals and bargs commands                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_blocals
   (import engine_engine
	   command_command
	   command_bfunction
	   command_bprint
	   command_file
	   tools_regexp
	   tools_file
	   tools_echo
	   env_env
	   tools_read)
   (export (info-blocals-command ::bstring ::obj)
	   (info-bargs-command   ::bstring ::obj)
	   (binfo-locals-command ::bstring ::obj)
	   (binfo-args-command   ::bstring ::obj)
	   (get-locals)
	   (get-locals/line-spec ::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    info-blocals-command ...                                         */
;*---------------------------------------------------------------------*/
(define (info-blocals-command line line-list)
   (match-case line-list
      ((?- ?-)
       (let ((glo-info (get-current-global))
	     (cmd "info locals"))
	  (if (global-info? glo-info)
	      (begin
		 (print "Scheme locals:")
		 (binfo-local-variables cmd #f))
	      (begin
		 (print "C locals:")
		 (display (gdb-send-for-output cmd))))))))

;*---------------------------------------------------------------------*/
;*    info-bargs-command ...                                           */
;*---------------------------------------------------------------------*/
(define (info-bargs-command line line-list)
   (match-case line-list
      ((?- ?-)
       (let ((glo-info (get-current-global))
	     (cmd "info args"))
	  (if (global-info? glo-info)
	      (begin
		 (print "Scheme args:")
		 (binfo-local-variables cmd #f))
	      (begin
		 (print "C args:")
		 (display (gdb-send-for-output cmd))))))))

;*---------------------------------------------------------------------*/
;*    binfo-locals-command ...                                         */
;*---------------------------------------------------------------------*/
(define (binfo-locals-command line line-list)
   (match-case line-list
      ((?- ?-)
       (binfo-local-variables "info locals" #t))))

;*---------------------------------------------------------------------*/
;*    binfo-args-command ...                                           */
;*---------------------------------------------------------------------*/
(define (binfo-args-command line line-list)
   (match-case line-list
      ((?- ?-)
       (binfo-local-variables "info args" #t))))

;*---------------------------------------------------------------------*/
;*    binfo-local-variables ...                                        */
;*---------------------------------------------------------------------*/
(define (binfo-local-variables gdb-info-cmd-line gdb-echo?)
   (define (binfo-local-variable/line glo-info line)
      (if (and (>fx (string-length line) 0)
	       (not (char=? (string-ref line 0) #\space)))
	  (let* ((lport    (open-input-string line))
		 (l-c-name (let ((c-name (read-case-sensitive lport)))
			      (if (symbol? c-name)
				  (symbol->string c-name)
				  #f))))
	     (close-input-port lport)
	     (if l-c-name
		 (let ((l-info (find-c-local l-c-name glo-info)))
		    (if (local-info? l-info)
			(begin
			   (display
			    (local-info-scm-name l-info))
			   (display " = ")
			   (flush-output-port
			    (current-output-port))
			   (bprint-command/exp l-c-name))))))))
   (define (binfo-local-variables/glo-info glo-info)
      (let* ((args (gdb-send-for-output gdb-info-cmd-line))
	     (port (open-input-string args)))
	 (if gdb-echo? (gdb-start-echo))
	 (let loop ((line (read-line port)))
	    (if (not (eof-object? line))
		(begin
		   (binfo-local-variable/line glo-info line)
		   (loop (read-line port)))))
	 (if gdb-echo? (gdb-stop-echo))
	 (close-input-port port)))
   (let ((glo-info (get-current-global)))
      (if (not (global-info? glo-info))
	  (gdb-echo #"No Bigloo function.\n")
	  (binfo-local-variables/glo-info glo-info))))

;*---------------------------------------------------------------------*/
;*    get-locals ...                                                   */
;*    -------------------------------------------------------------    */
;*    This function returns the list of locals variable available      */
;*    at the current execution position.                               */
;*---------------------------------------------------------------------*/
(define (get-locals)
   (define (get-locals/cmd cmd)
      (let ((glo-info (get-current-global)))
	 (if (not (global-info? glo-info))
	     '()
	     (let* ((args (gdb-send-for-output cmd))
		    (port (open-input-string args)))
		(let loop ((line (read-line port))
			   (res  '()))
		   (if (not (eof-object? line))
		       (let* ((lport    (open-input-string line))
			      (l-c-name (symbol->string
					 (read-case-sensitive lport))))
			  (close-input-port lport)
			  (let ((l-info (find-c-local l-c-name glo-info)))
			     (if (local-info? l-info)
				 (loop (read-line port)
				       (cons l-info res))
				 (loop (read-line port)
				       res))))
		       (begin
			  (close-input-port port)
			  res)))))))
   (append (get-locals/cmd "info locals") (get-locals/cmd "info args")))
	   
;*---------------------------------------------------------------------*/
;*    get-locals/line-spec ...                                         */
;*    -------------------------------------------------------------    */
;*    This function returns the list of local variables at             */
;*    file:num position. The first value of the list is the function   */
;*    at the position.                                                 */
;*---------------------------------------------------------------------*/
(define (get-locals/line-spec file::bstring lnum::bstring)
   ;; first we store the current breakpoint
   (let* ((addr-grammar (regular-grammar ((digit (in (#\0 #\9)
						     (#\a #\f)
						     (#\A #\F))))
			   ((: "0x" (+ digit))
			    (the-string))
			   (else
			    (let ((c (the-failure)))
			       (if (eof-object? c)
				   #f
				   (ignore))))))
	  (frame        (gdb-send-for-output "info frame")))
      (if (substring=? frame "No stack" 8)
	  ;; if `no stack' is reached, it means that no execution has been
	  ;; spawned. we then set initial breakpoint, start executing,
	  ;; ask for local bindings and stop executing.
	  (dummy-run! (lambda () (get-locals/line-spec file lnum)))
	  (let ((frame-num (string->integer
			    (substring frame 12 (string-length frame)))))
	     ;; we return to frame 0
	     (if (>fx frame-num 0)
		 (gdb-send-for-output "frame 0"))
	     (let* ((current-pc   (gdb-send-for-output "p $pc"))
		    (addr-port    (open-input-string current-pc))
		    (current-addr (read/rp addr-grammar addr-port))
		    (target-pos   (string-append file ":" lnum)))
		(close-input-port addr-port)
		(if (string? current-addr)
		    (begin
		       ;; we set a temporary breakpoint
		       ;; at the target location
		       (gdb-send-for-output
			(string-append "tbreak " target-pos))
		       ;; we now jump to the location
		       (gdb-send-for-output
			(string-append "jump " target-pos))
		       ;; we fetch the locals
		       (let ((locals (get-locals))
			     (fun    (get-current-global)))
			  ;; we return to the previous position
			  (gdb-send-for-output
			   (string-append "tbreak *" current-addr))
			  (gdb-send-for-output
			   (string-append "jump *" current-addr))
			  ;; we now return to the old frame level
			  (if (>fx frame-num 0)
			      (gdb-send-for-output
			       (string-append "frame "
					      (integer->string frame-num))))
			  (cons fun locals)))
		    ;; we are unable to find locals for this address
		    '()))))))



