;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/bfunction.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  9 16:32:07 1998                          */
;*    Last change :  Thu Jan 28 11:04:33 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implement a tools that give the name of the current  */
;*    function and the file where it is implemented.                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_bfunction
   (import tools_read
	   tools_echo
	   tools_regexp
	   engine_engine
	   engine_param
	   env_env
	   command_command
	   command_bbreak)
   (export (get-current-global)
	   (binfo-functions-command      ::bstring ::obj)
 	   (bfunctions-command-completer ::command ::bstring)))

;*---------------------------------------------------------------------*/
;*    get-current-global ...                                           */
;*---------------------------------------------------------------------*/
(define (get-current-global)
   (let ((stack (gdb-send-for-output "frame")))
      (let* ((port (open-input-string (string-append
				       (remove-emacs-control stack)
				       *closing*)))
	     (line (begin (read-char port) (port->list port))))
	 (close-input-port port)
	 (match-case line
	    ;; A regular frame looks like:
	    ;;   #0 identifier (args) at file-name:line
	    ((?- ?id ?- ?at ?fname:lnum . ?-)
	     (if (eq? at *at*)
		 (let* ((grammar   (regular-grammar ()
				      ((+ (out #\:))
				       (the-string))
				      (else
				       #f)))
			(port      (open-input-string
				    (symbol->string fname:lnum)))
			(file-name (read/rp grammar port))
			(file-info (find-file file-name)))
		    (if (not (file-info? file-info))
			#f
			(find-c-global (symbol->string id)
				       (file-info-module file-info))))
		 (match-case line
		    ;; or it may looks like:
		    ;;   #num addr in ?id (args) at file-name:line
		    ((?- ?- ?in ?id ?- ?at ?fname:lnum . ?-)
		     (if (and (eq? at *at*)
			      (eq? in *in*))
			 (let* ((grammar (regular-grammar ()
					    ((+ (out #\:))
					     (the-string))
					    (else
					     #f)))
				(port (open-input-string
				       (symbol->string fname:lnum)))
				(file-name (read/rp grammar port))
				(file-info (find-file file-name)))
			    (if (not (file-info? file-info))
				#f
				(find-c-global
				 (symbol->string id)
				 (file-info-module file-info))))
			 #f))
		    (else
		     #f))))
	    (else
	     #f)))))

;*---------------------------------------------------------------------*/
;*    remove-emacs-control ...                                         */
;*---------------------------------------------------------------------*/
(define (remove-emacs-control string)
   (if (not *bdb-emacs?*)
       string
       (let ((len (-fx (string-length string) 1)))
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 string)
		((<=fx (char->integer (string-ref string i)) 26)
		 (if (char=? (string-ref string i) #\Newline)
		     (loop (+fx i 1))
		     (substring string 0 i)))
		(else
		 (loop (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    *at*/*in* ...                                                    */
;*---------------------------------------------------------------------*/
(define *at* (string->symbol "at"))
(define *in* (string->symbol "in"))
(define *closing* (make-string 80 #\)))

;*---------------------------------------------------------------------*/
;*    binfo-functions-command ...                                      */
;*---------------------------------------------------------------------*/
(define (binfo-functions-command line line-list)
   (define (binfo-function-global global)
      (if (global-info-function? global)
	  (let ((bp-c-name (function-breakpoint global)))
	     (if (and (string? bp-c-name)
		      (string? (global-info-value-c-name global)))
		 (begin
		    (display* "(@ "
			      (global-info-scm-name global)
			      " "
			      (module-info-name (global-info-module global))
			      ")")
		    (if (string? (global-info-c-name global))
			(display* "    value: \"" (global-info-c-name global)
				  "\""))
		    (display* "    breakpoint: \""
			      (global-info-value-c-name global)
			      "\"")
		    (newline))))))
   (let ((frame (gdb-send-for-output "info frame")))
      (if (substring=? frame "No stack" 8)
	  ;; if `no stack' is reached, it means that no execution has been
	  ;; spawned. we then set initial breakpoint, start executing,
	  ;; ask for local bindings and stop executing.
	  (dummy-run! (lambda () (binfo-functions-command line line-list)))
	  (match-case line-list
	     ((?- ?-)
	      (gdb-start-echo)
	      (print "All Bigloo functions:")
	      (newline)
	      (for-each-global binfo-function-global)
	      (gdb-stop-echo))
	     ((?- ?- ?regexp)
	      (gdb-start-echo)
	      (print "All Bigloo functions matching regular expression \""
		     regexp
		     "\":")
	      (newline)
	      (for-each-global
	       (lambda (global)
		  (if (regexp-match? (bdb-case regexp)
				     (global-info-scm-name global))
		      (binfo-function-global global))))
	      (gdb-stop-echo))))))

;*---------------------------------------------------------------------*/
;*    bfunctions-command-completer ...                                 */
;*---------------------------------------------------------------------*/
(define (bfunctions-command-completer cmd::command string::bstring)
   (bbreak-command-completer cmd string))

