;*=====================================================================*/
;*    serrano/prgm/project/bigloo/contrib/rx.scm                       */
;*    -------------------------------------------------------------    */
;*    Author      :  John Gerard Malecki                               */
;*    Creation    :  Mon Jul  8 08:31:56 1996                          */
;*    Last change :  Sun Mar 29 09:02:46 1998 (johnm)                  */
;*    -------------------------------------------------------------    */
;*    A simple `apropos' interface to the interpreter as in:           */
;*     1:=> (pp (apropos "-LENGTH$"))                                  */
;*		(THE-LENGTH                                            */
;*		  MARKED-PAIR-LENGTH                                   */
;*		  STRUCT-LENGTH                                        */
;*		  STRING-LENGTH                                        */
;*		...                                                    */
;*    Note that you must edit runtime/Clib/csymbol.c and remove the    */
;*    `static' declaration from c_symtab.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module apropos
   (main main)

   (eval (export apropos)

	 (export regcomp)
	 (export regexec))

   (extern (c_symtab::obj "c_symtab")
	   
	   (include "re_comp.h")
	   
	   (macro c-re_comp::string (string) "re_comp")
	   (macro c-re_exec::int (string) "re_exec")))

;*---------------------------------------------------------------------*/
;*    regcomp ...                                                      */
;*---------------------------------------------------------------------*/
(define (regcomp pattern)
  (let ((rc (c-re_comp pattern)))
    (if (string-null? rc) #t
	(error 'regcomp "error occurred" rc))))

;*---------------------------------------------------------------------*/
;*    regexec ...                                                      */
;*---------------------------------------------------------------------*/
(define (regexec string)
  (let ((rc (c-re_exec string)))
    (case rc
      ((0) #f)
      ((1) #t)
      (else (error 'regexec "error occurred" rc)))))
      
;*---------------------------------------------------------------------*/
;*    remove-if-not ...                                                */
;*---------------------------------------------------------------------*/
(define (remove-if-not p l)
  (cond ((null? l) l)
        ((p (car l)) (cons (car l) (remove-if-not p (cdr l))))
        (else (remove-if-not p (cdr l)))))

;*---------------------------------------------------------------------*/
;*    *oblist* ...                                                     */
;*---------------------------------------------------------------------*/
(define *oblist*
  (apply append (vector->list c_symtab)))

;*---------------------------------------------------------------------*/
;*    apropos ...                                                      */
;*---------------------------------------------------------------------*/
(define (apropos pattern)
  (if (symbol? pattern) (set! pattern (symbol->string pattern)))

  (regcomp pattern)

  (define (match? symbol)
    (regexec (symbol->string symbol)))

  (remove-if-not match? *oblist*))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main args)
  (repl))
