;*=====================================================================*/
;*    serrano/prgm/project/bigloo/contrib/apropos/apropos.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  John Gerard Malecki                               */
;*    Creation    :  Mon Jul  8 08:31:56 1996                          */
;*    Last change :  Wed Apr  1 08:33:03 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A gnu rx package connection which implements an `apropos'        */
;*    facility as in:                                                  */
;*     1:=> (pp (apropos "-length$"))                                  */
;*		(THE-LENGTH                                            */
;*		  MARKED-PAIR-LENGTH                                   */
;*		  STRUCT-LENGTH                                        */
;*		  _struct-length                                       */
;*		  _tvector-length                                      */
;*		  _vector-length                                       */
;*		  STRING-LENGTH                                        */
;*		...                                                    */
;*    Note that you must edit runtime/Clib/csymbol.c and remove the    */
;*    `static' declaration from c_symtab.                              */
;*    -------------------------------------------------------------    */
;*    This package requires the POSIX regcomp facility to be           */
;*    available.                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module apropos
   (main main)

   (eval (export apropos)

	 (export regcomp)
	 (export regexec))

   (extern (c_symtab::obj "c_symtab")

      (include "rxposix.h")
	   
      (type regex_t (struct) "regex_t")

      (macro reg-icase::int "REG_ICASE")

      (macro c-regcomp::int (regex_t* string int) "regcomp")
      (macro c-regexec::int (regex_t* string int) "c_regexec")))

;*---------------------------------------------------------------------*/
;*    c_regexec                                                        */
;*---------------------------------------------------------------------*/
(pragma "#define c_regexec(c,s,e) regexec(c,s,0,0,e)")

;*---------------------------------------------------------------------*/
;*    regcomp ...                                                      */
;*---------------------------------------------------------------------*/
(define (regcomp pattern cflags)
   (let ((compiled (make-regex_t*)))
      
      (let ((rc (c-regcomp compiled pattern cflags)))

	 (if (zero? rc) compiled
	     (error 'regcomp "" rc)))))

;*---------------------------------------------------------------------*/
;*    regexec ...                                                      */
;*---------------------------------------------------------------------*/
(define (regexec compiled string eflags)
  (if (zero? (c-regexec compiled string eflags)) #t
      #f))

;*---------------------------------------------------------------------*/
;*    remove-if-not ...                                                */
;*---------------------------------------------------------------------*/
(define (remove-if-not p l)
  (cond ((null? l) l)
        ((p (car l)) (cons (car l) (remove-if-not p (cdr l))))
        (else (remove-if-not p (cdr l)))))

;*---------------------------------------------------------------------*/
;*    symtab ...                                                       */
;*---------------------------------------------------------------------*/
(define (symtab)
  c_symtab)

;*---------------------------------------------------------------------*/
;*    *oblist* ...                                                     */
;*---------------------------------------------------------------------*/
(define *oblist*
  (apply append (vector->list c_symtab)))

;*---------------------------------------------------------------------*/
;*    apropos ...                                                      */
;*---------------------------------------------------------------------*/
(define (apropos pattern)
   (if (symbol? pattern) (set! pattern (symbol->string pattern)))

   (let ((compiled (regcomp pattern reg-icase)))

      (define (apropos symbol)
	 (regexec compiled (symbol->string symbol) 0))

      (remove-if-not apropos *oblist*)))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main args)
  (repl))
