(in-package :ext)
(export '*batch-mode*)
(in-package :user)

(in-package "USER")
	;(pushnew :cross-compiler *features*)
(setf *features* (remove :cross-compiler *features*))
	;(pushnew :bootstrap *features*)
(setf *features* (remove :bootstrap *features*))

(pushnew :new-random *features*)
(pushnew :propagate-float-type *features*)
(pushnew :propagate-fun-type *features*)
(setf *features* (remove :propagate-trig-fun *features*))
(pushnew :constrain-float-type *features*)

(pushnew :signed-array *features*)

(pushnew :cgc *features*)
; Conservative GC
(pushnew :cmu17 *features*)
(pushnew :small *features*)
; this just means: consider bytecode for some parts
(pushnew :linux *features*)
(pushnew :x86-lra *features*)
; if x86-lra is removed the resulting image will
; segv on ANY fault, sending it into the debugger,
; segv again , sending it into the ....
;
; you get the picture

(setf *features* (remove :bsd *features*))
(setf *features* (remove :freebsd *features*))

(setf (ext:search-list "target:")
      '(
        "/usr/src/18a/x86/"      ; object dir
; place stuff there, get if from below
        "/usr/src/18a/src/"    ; source dir
        ))
(setf (ext:search-list "library:") '("/usr/lib/cmucl/"))

;;; Tailor this for what you want. This is the basics.
;;; The worldload process will use these features or lack thereof.
;;(pushnew :no-compiler *features*)
;(pushnew :no-pcl *features*)
(setf *features* (remove :no-pcl *features*))
; pcl isn't build by do-build, do do-pcl to get it

;(setf *features* (remove :no-clx *features*))
;(setf *features* (remove :no-hemlock  *features*))
(pushnew :no-clx *features*)
(pushnew :no-clm *features*)
(pushnew :no-hemlock *features*)
; it's best to compile this to packages...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setf lisp::*genesis-c-header-name* "target:lisp/internals.h")
(setf lisp::*genesis-symbol-table* "target:lisp/lisp.nm")
(setf lisp::*genesis-map-name* "target:lisp/lisp.map")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
