comment
waves(n) will create n pages of a wave moving (default 10).
animate(d) will animate these pages with time increment delta
(default 0.2).
You may increase n, if you have enough memory.
You could decrease the size of your window, if necessary.
256 colors use less memory too.
Be patient during the creation.
--- Press any key to continue ---
endcomment

wait;

function waves (p=10)
reset();
twosides(0);
deletepages();
clg;
title("Creating Animation");
addpage();
showpage(1);
t=linspace(0,1,p);
x=linspace(-2*pi,2*pi,20); y=x'; r=sqrt(x*x+y*y);
loop 1 to cols(t);
solid(x/pi,y/pi,sin(r-t[#]*2*pi)*exp(-t[#]*3)/5);
addpage();
end;
return cols(t);
endfunction;	

function animate (d=0.2)
repeat
loop 2 to pages();
showpage(#);
if wait(d)<d; showpage(0); return pages(); endif;
end;
end;
showpage(0);
return pages();
endfunction

waves;
animate;
