class PLATFORM

inherit

   GENERAL

feature

   Character_bits: INTEGER is
         -- Number of bits used to represent a character
      external "C"
      alias "_ert_char_size"
      end -- Character_bits

   Integer_bits: INTEGER is
         -- Number of bits used to represent a integer
      external "C"
      alias "_ert_int_size"
      end -- Integer_bits

   Real_bits: INTEGER is
         -- Number of bits used to represent a real
      external "C"
      alias "_ert_real_size"
      end -- Real_bits

   Double_bits: INTEGER is
         -- Number of bits used to represent a double
      external "C"
      alias "_ert_double_size"
      end -- Double_bits

   Pointer_bits: INTEGER is
         -- Number of bits used to represent a pointer to a feature
      external "C"
      alias "_ert_ptr_size"
      end -- Pointer_bits

   Maximum_character_code: INTEGER is
         -- Maximum supported character code (128 or more)
      external "C"
      alias "_ert_max_char"
      end -- Maximum_character_code

   bit_size: INTEGER
         -- number of bits used to store current object

   Signal_SIGHUP		:INTEGER is 1
   Signal_SIGINT		:INTEGER is 2
   Signal_SIGQUIT		:INTEGER is 3
   Signal_SIGFPE		:INTEGER is 8
   Signal_SIGKILL		:INTEGER is 9
   Signal_SIGBUS		:INTEGER is 10
   Signal_SIGSEGV		:INTEGER is 11
   Signal_SIGPIPE		:INTEGER is 13
   Signal_SIGALRM		:INTEGER is 14
   Signal_SIGTERM		:INTEGER is 15
   Signal_SIGUSR1		:INTEGER is 16
   Signal_SIGUSR2		:INTEGER is 17
      -- Signals corrispond to Unix include/sys/signal.h
      -- Only the most useful/likely to occur are included
	 -- Those that are unavailable on DOS are dummied in 
      -- ert.H
	

invariant

   Maximum_character_code >= 127

end -- class PLATFORM
