.TH EP l 11/11/92 "FU BERLIN"
.SH NAME
ep \- Eiffel-3 Parser

.SH SYNOPSIS
.B ep 
[ 
.B -MEY | -ISE | -SIG 
] 
[ 
.B \-bfiq 
] 
.I filename 
\&.\|.\|.

.B ep 
[ 
.B -MEY | -ISE | -SIG 
] 
.B -t 
.I filename 
\&.\|.\|.
.SH DESCRIPTION
By default 
.B ep 
parses the source file given by 
.I filename 
and generates a readable abstract syntax tree (ast) if the source 
file is syntax correct according to the Eiffel-3 syntax as defined in
.B [1] 
and 
.BR [2] .
If errors occur they are printed on stderr and no tree is generated.
If 
.I filename 
does not end with 
.B \.e 
.B ep 
uses 
.IB filename .e
as source file. The file containing the abstract syntax tree is 
named after the source file \- the suffix 
.B \&.atr 
replacing 
.BR \&.e \&. 
.B ep 
was implemented using the Karlsruhe Toolbox for Compiler Construction
.BR [3] \&.
.SH OPTIONS
.LP
Compatibility
.TP 1i
.B \-MEY  
The default. The syntax check is performed according to
.B [1] 
and 
.BR [2] \&.
.TP
.B \-ISE  
The syntax check is performed according to 
.BR [1] , 
.B [2] 
and deviations as indicated by Eiffel-3 source files provided by ISE.
.TP
.B \-SIG  
The syntax check is performed according to 
.BR [1] , 
.BR [2] , 
.B [4] 
and deviations as indicated by Eiffel-3 source files shipped with 
SIG Eiffel-3/S 1.2 (beta).

.LP
Output Format
.TP
.B \-b
A tree in a binary format for further use by the Karlsruhe 
Toolbox for Compiler Construction or other tools is generated. 
The format is specified in 
.B [6].
The filename suffix is
.BR .btr \&.
.TP
.B \-f
The generated tree is printed on 
.I stdout \&.
.TP
.B \-i   
An integrated error listing is generated and placed in
the same directory as the source file.  The error listing file 
is named after the source file - the suffix .lst replacing .e 
in the name of the error listing.
.TP
.B \-q 
An interactive tree browser 
.BR [5] ,
is activated with the generated tree as input. The user is prompted 
to provide one of the following commands:
.nf
 parent            display parent node
 quit              quit the tree browser
 <selector>        display specified child (first match)
 <selector><space> display specified child (exact match)
All commands can be abbreviated to an unambigous prefix.
.SH 
.TP
.B \-t  
No tree is generated if the source is syntax correct. Only errors 
are reported. 
.SH SEE ALSO
.TP
.B [1]
B. Meyer: Eiffel - The Language. Prentice Hall, Englewood Cliffs, 1992.
.TP
.B [2]
B. Meyer: Eiffel-3 syntax revision, comp.lang.eiffel, July 1992.
.TP
.B [3]
J. Grosch: Toolbox Introduction. Compiler Generation Report No.25,
GMD Forschungsstelle at the University of Karlsruhe, Aug. 1992.
.TP
.B [4]
M. Schweitzer and L. Strether: Eiffel/S: The Compiler, SIG Computer 
GmbH, 1st edition, 1991.
.TP
.B [5]
J. Grosch: Ast - A Generator for Abstract Syntax Trees (Revised
Version), Compiler Generation Report No.15, GMD Forschungsstelle at 
the University of Karlsruhe, Aug. 1989.
.TP
.B [6]
B. Groeber and O. Langmack: A Compiler Front-End for Eiffel-3,
Report B-92-25, Freie Universitaet Berlin - Institut fuer Informatik, 1992.
.SH BUGS
.nf
No known bugs. 
Please send questions, comments and error reports to:
		
	Burghardt Groeber 
	Institut fuer Informatik
	FU Berlin
	Nestorstr. 8/9
	W-1000 Berlin 31

	groeber@inf.fu-berlin.de

.SH AUTHORS
.nf
B. Groeber
O. Langmack




