# include "Tree.h"
# define yyALLOC(ptr, size)	if ((ptr = (tTree) Tree_PoolFreePtr) >= (tTree) Tree_PoolMaxPtr) \
  ptr = Tree_Alloc (); \
  Tree_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyTree.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include <stdio.h>
# include "yyTree.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

/* line 10 "eiffel.ast" */

char str[COMMENT_SIZE];

#define writetPosition(a)	(void) fprintf(yyf,"%4d %3d", a.Line, a.Column);
#define readtPosition(a)	(void) fscanf(yyf, "%hd%hd", &a.Line, &a.Column);
#define gettPosition(a)		(void) fscanf(yyf, "%hd%hd%*c", &a.Line, &a.Column);
#define puttPosition(a)		(void) fprintf(yyf,"%4d %3d\n", a.Line, a.Column);
#define readdouble(a)		(void) fscanf(yyf, "%lG", &a);
#define writedouble(a)		(void) fprintf(yyf, "%lG", a);
#define writetStringRef(a)	StGetString(a, str);\
				(void) fprintf(yyf, "%s", str);putc('\0',yyf);
#define readtStringRef(a)	getStr(yyf); a = PutString(str,strlen(str));	
#define gettStringRef(a)	getStr(yyf); a = PutString(str,strlen(str));
#define puttStringRef(a)	StGetString(a, str);\
				(void) fprintf(yyf, "%s", str);putc('\0',yyf);

#ifdef Select	/* because in Sets.h Select is already defined	*/	
#undef Select
#endif

void getStr(fp)
FILE *fp;
{
	unsigned i = 0;

	while((str[i] = getc(fp)) != 0) i++;
	
}
	


static void yyExit () { Exit (1); }

void (* Tree_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tTree TreeRoot;
unsigned long Tree_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoTree;
char * Tree_PoolFreePtr	= (char *) NoTree;
char * Tree_PoolMaxPtr	= (char *) NoTree;
static unsigned short yyMaxSize	= 0;
unsigned short Tree_NodeSize [192 + 1] = { 0,
 sizeof (yEiffel),
 sizeof (yClasses),
 sizeof (yClasses0),
 sizeof (yClasses1),
 sizeof (yClass_declaration),
 sizeof (yIndex_list),
 sizeof (yIndex_list0),
 sizeof (yIndex_list1),
 sizeof (yIndex_clause),
 sizeof (yClass_header),
 sizeof (yClass_header0),
 sizeof (yClass),
 sizeof (yExpanded_class),
 sizeof (yDeferred_class),
 sizeof (yFeatures),
 sizeof (yFeatures0),
 sizeof (yFeatures1),
 sizeof (yFeature_clause),
 sizeof (yClients),
 sizeof (yClients0),
 sizeof (yClients1),
 sizeof (yFeature_decls),
 sizeof (yFeature_decls0),
 sizeof (yFeature_decls1),
 sizeof (yFeature_decl),
 sizeof (yDeclaration_body),
 sizeof (yConst_or_routine),
 sizeof (yConst_or_routine0),
 sizeof (yM_const),
 sizeof (yUnique),
 sizeof (yRoutine),
 sizeof (yParent_list),
 sizeof (yParent_list0),
 sizeof (yParent_list1),
 sizeof (yParent),
 sizeof (yFeature_adaptation),
 sizeof (yFeature_adaptation0),
 sizeof (yFeature_adaptation1),
 sizeof (yRename_list),
 sizeof (yRename_list0),
 sizeof (yRename_list1),
 sizeof (yRename_pair),
 sizeof (yCreators),
 sizeof (yCreators0),
 sizeof (yCreators1),
 sizeof (yCreation_clause),
 sizeof (yNew_feature_list),
 sizeof (yNew_feature_list0),
 sizeof (yNew_feature_list1),
 sizeof (yFeature_name),
 sizeof (yFrozen),
 sizeof (yIdent_name),
 sizeof (yOp),
 sizeof (yPrefix),
 sizeof (yInfix),
 sizeof (yOp_name),
 sizeof (yFree_op),
 sizeof (yOper),
 sizeof (yNew_export_list),
 sizeof (yNew_export_list0),
 sizeof (yNew_export_list1),
 sizeof (yNew_export_item),
 sizeof (yFeature_list),
 sizeof (yAll),
 sizeof (yFeature_list0),
 sizeof (yFeature_list1),
 sizeof (yFormal_args),
 sizeof (yFormal_args0),
 sizeof (yFormal_args1),
 sizeof (yRoutine_body),
 sizeof (yRoutine_body0),
 sizeof (yEffective),
 sizeof (yInternal),
 sizeof (yDo_body),
 sizeof (yOnce_body),
 sizeof (yExternal),
 sizeof (yDeferred),
 sizeof (yEntity_decl_group),
 sizeof (yFormal_generics),
 sizeof (yFormal_generics0),
 sizeof (yFormal_generics1),
 sizeof (yFormal_generic),
 sizeof (yConstraint),
 sizeof (yConstraint0),
 sizeof (yConstraint1),
 sizeof (yCompound),
 sizeof (yCompound0),
 sizeof (yCompound1),
 sizeof (yThen_part_list),
 sizeof (yThen_part_list0),
 sizeof (yThen_part_list1),
 sizeof (yThen_part),
 sizeof (yWhen_part_list),
 sizeof (yWhen_part_list0),
 sizeof (yWhen_part_list1),
 sizeof (yWhen_part),
 sizeof (yChoices),
 sizeof (yChoices0),
 sizeof (yChoices1),
 sizeof (yChoice),
 sizeof (yInterval),
 sizeof (yVal),
 sizeof (yInstruction),
 sizeof (yInstruction0),
 sizeof (yCreation),
 sizeof (yCall_instruct),
 sizeof (yAssign),
 sizeof (yRev_assign),
 sizeof (yConditional),
 sizeof (yMulti_branch),
 sizeof (yLoop),
 sizeof (yCheck),
 sizeof (yDebug),
 sizeof (yRetry),
 sizeof (yLoop_body),
 sizeof (yLoop_body0),
 sizeof (yLoop_body1),
 sizeof (yType),
 sizeof (yType0),
 sizeof (yClass_type),
 sizeof (yClass_type_expanded),
 sizeof (yBit_type),
 sizeof (ySimple_type),
 sizeof (yAnchored),
 sizeof (yActual_generics),
 sizeof (yActual_generics0),
 sizeof (yActual_generics1),
 sizeof (yCondition),
 sizeof (yCondition0),
 sizeof (yCondition1),
 sizeof (yAssertion),
 sizeof (yAssertion0),
 sizeof (yAssertion1),
 sizeof (yAssertion_clause),
 sizeof (yAssertion_clause0),
 sizeof (yAssertion_clause1),
 sizeof (yType_list),
 sizeof (yType_list0),
 sizeof (yType_list1),
 sizeof (yCall_chain),
 sizeof (yCall_chain0),
 sizeof (yCall_chain1),
 sizeof (yUnqual_call),
 sizeof (yUnqual_call0),
 sizeof (yUnqual_call1),
 sizeof (yActuals),
 sizeof (yActuals0),
 sizeof (yActuals1),
 sizeof (yActual_list),
 sizeof (yActual_list0),
 sizeof (yActual_list1),
 sizeof (yActual),
 sizeof (yAddr),
 sizeof (yExpression),
 sizeof (yExpression0),
 sizeof (yComment),
 sizeof (ySimple_expr),
 sizeof (yCall),
 sizeof (yBin_expr),
 sizeof (yUn_expr),
 sizeof (yParenth),
 sizeof (yManifest_array),
 sizeof (yManifest_array0),
 sizeof (yManifest_array1),
 sizeof (yOld),
 sizeof (yStrip),
 sizeof (yList),
 sizeof (ynolist),
 sizeof (ylist),
 sizeof (yManifest_constant),
 sizeof (yManifest_constant0),
 sizeof (yCh),
 sizeof (yTrue),
 sizeof (yFalse),
 sizeof (yInt),
 sizeof (yReal),
 sizeof (y_CHARACTER),
 sizeof (y_INTEGER),
 sizeof (y_REAL),
 sizeof (y_DOUBLE),
 sizeof (y_BOOLEAN),
 sizeof (y_STRING),
 sizeof (y_BIT),
 sizeof (y_NONE),
 sizeof (yBitseq),
 sizeof (yString),
 sizeof (yString0),
 sizeof (yEntity),
 sizeof (yEntity0),
 sizeof (yCurrent),
 sizeof (yResult),
 sizeof (yId),
};
char * Tree_NodeName [192 + 1] = {
 "NoTree",
 "Eiffel",
 "Classes",
 "Classes0",
 "Classes1",
 "Class_declaration",
 "Index_list",
 "Index_list0",
 "Index_list1",
 "Index_clause",
 "Class_header",
 "Class_header0",
 "Class",
 "Expanded_class",
 "Deferred_class",
 "Features",
 "Features0",
 "Features1",
 "Feature_clause",
 "Clients",
 "Clients0",
 "Clients1",
 "Feature_decls",
 "Feature_decls0",
 "Feature_decls1",
 "Feature_decl",
 "Declaration_body",
 "Const_or_routine",
 "Const_or_routine0",
 "M_const",
 "Unique",
 "Routine",
 "Parent_list",
 "Parent_list0",
 "Parent_list1",
 "Parent",
 "Feature_adaptation",
 "Feature_adaptation0",
 "Feature_adaptation1",
 "Rename_list",
 "Rename_list0",
 "Rename_list1",
 "Rename_pair",
 "Creators",
 "Creators0",
 "Creators1",
 "Creation_clause",
 "New_feature_list",
 "New_feature_list0",
 "New_feature_list1",
 "Feature_name",
 "Frozen",
 "Ident_name",
 "Op",
 "Prefix",
 "Infix",
 "Op_name",
 "Free_op",
 "Oper",
 "New_export_list",
 "New_export_list0",
 "New_export_list1",
 "New_export_item",
 "Feature_list",
 "All",
 "Feature_list0",
 "Feature_list1",
 "Formal_args",
 "Formal_args0",
 "Formal_args1",
 "Routine_body",
 "Routine_body0",
 "Effective",
 "Internal",
 "Do_body",
 "Once_body",
 "External",
 "Deferred",
 "Entity_decl_group",
 "Formal_generics",
 "Formal_generics0",
 "Formal_generics1",
 "Formal_generic",
 "Constraint",
 "Constraint0",
 "Constraint1",
 "Compound",
 "Compound0",
 "Compound1",
 "Then_part_list",
 "Then_part_list0",
 "Then_part_list1",
 "Then_part",
 "When_part_list",
 "When_part_list0",
 "When_part_list1",
 "When_part",
 "Choices",
 "Choices0",
 "Choices1",
 "Choice",
 "Interval",
 "Val",
 "Instruction",
 "Instruction0",
 "Creation",
 "Call_instruct",
 "Assign",
 "Rev_assign",
 "Conditional",
 "Multi_branch",
 "Loop",
 "Check",
 "Debug",
 "Retry",
 "Loop_body",
 "Loop_body0",
 "Loop_body1",
 "Type",
 "Type0",
 "Class_type",
 "Class_type_expanded",
 "Bit_type",
 "Simple_type",
 "Anchored",
 "Actual_generics",
 "Actual_generics0",
 "Actual_generics1",
 "Condition",
 "Condition0",
 "Condition1",
 "Assertion",
 "Assertion0",
 "Assertion1",
 "Assertion_clause",
 "Assertion_clause0",
 "Assertion_clause1",
 "Type_list",
 "Type_list0",
 "Type_list1",
 "Call_chain",
 "Call_chain0",
 "Call_chain1",
 "Unqual_call",
 "Unqual_call0",
 "Unqual_call1",
 "Actuals",
 "Actuals0",
 "Actuals1",
 "Actual_list",
 "Actual_list0",
 "Actual_list1",
 "Actual",
 "Addr",
 "Expression",
 "Expression0",
 "Comment",
 "Simple_expr",
 "Call",
 "Bin_expr",
 "Un_expr",
 "Parenth",
 "Manifest_array",
 "Manifest_array0",
 "Manifest_array1",
 "Old",
 "Strip",
 "List",
 "nolist",
 "list",
 "Manifest_constant",
 "Manifest_constant0",
 "Ch",
 "True",
 "False",
 "Int",
 "Real",
 "_CHARACTER",
 "_INTEGER",
 "_REAL",
 "_DOUBLE",
 "_BOOLEAN",
 "_STRING",
 "_BIT",
 "_NONE",
 "Bitseq",
 "String",
 "String0",
 "Entity",
 "Entity0",
 "Current",
 "Result",
 "Id",
};
static Tree_tKind yyTypeRange [192 + 1] = { 0,
 kEiffel,
 kClasses1,
 kClasses0,
 kClasses1,
 kClass_declaration,
 kIndex_list1,
 kIndex_list0,
 kIndex_list1,
 kIndex_clause,
 kDeferred_class,
 kClass_header0,
 kClass,
 kExpanded_class,
 kDeferred_class,
 kFeatures1,
 kFeatures0,
 kFeatures1,
 kFeature_clause,
 kClients1,
 kClients0,
 kClients1,
 kFeature_decls1,
 kFeature_decls0,
 kFeature_decls1,
 kFeature_decl,
 kDeclaration_body,
 kRoutine,
 kConst_or_routine0,
 kM_const,
 kUnique,
 kRoutine,
 kParent_list1,
 kParent_list0,
 kParent_list1,
 kParent,
 kFeature_adaptation1,
 kFeature_adaptation0,
 kFeature_adaptation1,
 kRename_list1,
 kRename_list0,
 kRename_list1,
 kRename_pair,
 kCreators1,
 kCreators0,
 kCreators1,
 kCreation_clause,
 kNew_feature_list1,
 kNew_feature_list0,
 kNew_feature_list1,
 kInfix,
 kFrozen,
 kIdent_name,
 kInfix,
 kPrefix,
 kInfix,
 kOper,
 kFree_op,
 kOper,
 kNew_export_list1,
 kNew_export_list0,
 kNew_export_list1,
 kNew_export_item,
 kFeature_list1,
 kAll,
 kFeature_list0,
 kFeature_list1,
 kFormal_args1,
 kFormal_args0,
 kFormal_args1,
 kDeferred,
 kRoutine_body0,
 kExternal,
 kOnce_body,
 kDo_body,
 kOnce_body,
 kExternal,
 kDeferred,
 kEntity_decl_group,
 kFormal_generics1,
 kFormal_generics0,
 kFormal_generics1,
 kFormal_generic,
 kConstraint1,
 kConstraint0,
 kConstraint1,
 kCompound1,
 kCompound0,
 kCompound1,
 kThen_part_list1,
 kThen_part_list0,
 kThen_part_list1,
 kThen_part,
 kWhen_part_list1,
 kWhen_part_list0,
 kWhen_part_list1,
 kWhen_part,
 kChoices1,
 kChoices0,
 kChoices1,
 kVal,
 kInterval,
 kVal,
 kRetry,
 kInstruction0,
 kCreation,
 kCall_instruct,
 kAssign,
 kRev_assign,
 kConditional,
 kMulti_branch,
 kLoop,
 kCheck,
 kDebug,
 kRetry,
 kLoop_body1,
 kLoop_body0,
 kLoop_body1,
 kAnchored,
 kType0,
 kClass_type,
 kClass_type_expanded,
 kBit_type,
 kSimple_type,
 kAnchored,
 kActual_generics1,
 kActual_generics0,
 kActual_generics1,
 kCondition1,
 kCondition0,
 kCondition1,
 kAssertion1,
 kAssertion0,
 kAssertion1,
 kAssertion_clause1,
 kAssertion_clause0,
 kAssertion_clause1,
 kType_list1,
 kType_list0,
 kType_list1,
 kCall_chain1,
 kCall_chain0,
 kCall_chain1,
 kUnqual_call1,
 kUnqual_call0,
 kUnqual_call1,
 kActuals1,
 kActuals0,
 kActuals1,
 kActual_list1,
 kActual_list0,
 kActual_list1,
 kStrip,
 kAddr,
 kStrip,
 kExpression0,
 kComment,
 kSimple_expr,
 kCall,
 kBin_expr,
 kUn_expr,
 kParenth,
 kManifest_array1,
 kManifest_array0,
 kManifest_array1,
 kOld,
 kStrip,
 klist,
 knolist,
 klist,
 kId,
 kManifest_constant0,
 kCh,
 kTrue,
 kFalse,
 kInt,
 kReal,
 k_CHARACTER,
 k_INTEGER,
 k_REAL,
 k_DOUBLE,
 k_BOOLEAN,
 k_STRING,
 k_BIT,
 k_NONE,
 kBitseq,
 kString,
 kString0,
 kId,
 kEntity0,
 kCurrent,
 kResult,
 kId,
};

tTree Tree_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 192; i ++) {
   Tree_NodeSize [i] = (Tree_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Tree_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Tree_PoolFreePtr = yyBlockList->yyBlock;
 Tree_PoolMaxPtr = Tree_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Tree_HeapUsed += yyBlockSize;
 return (tTree) Tree_PoolFreePtr;
}

tTree MakeTree
# if defined __STDC__ | defined __cplusplus
 (Tree_tKind yyKind)
# else
 (yyKind) Tree_tKind yyKind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool Tree_IsType
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt, register Tree_tKind yyKind)
# else
 (yyt, yyKind) register tTree yyt; register Tree_tKind yyKind;
# endif
{
 return yyt != NoTree && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}

tTree nEiffel () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEiffel])
 yyt->Kind = kEiffel;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Eiffel.Classes)
 return yyt;
}

tTree nClasses () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses])
 yyt->Kind = kClasses;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClasses0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses0])
 yyt->Kind = kClasses0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClasses1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses1])
 yyt->Kind = kClasses1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Classes1.Class_declaration)
 begintTree(yyt->Classes1.Classes)
 return yyt;
}

tTree nClass_declaration () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_declaration])
 yyt->Kind = kClass_declaration;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Class_declaration.Indexing)
 begintTree(yyt->Class_declaration.Class_header)
 begintTree(yyt->Class_declaration.Formal_generics)
 begintTree(yyt->Class_declaration.Obsolete)
 begintTree(yyt->Class_declaration.Inheritance)
 begintTree(yyt->Class_declaration.Creators)
 begintTree(yyt->Class_declaration.Features)
 begintTree(yyt->Class_declaration.Invariant)
 begintStringRef(yyt->Class_declaration.comment)
 return yyt;
}

tTree nIndex_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list])
 yyt->Kind = kIndex_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nIndex_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list0])
 yyt->Kind = kIndex_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nIndex_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list1])
 yyt->Kind = kIndex_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Index_list1.Index_clause)
 begintTree(yyt->Index_list1.Index_list)
 return yyt;
}

tTree nIndex_clause () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_clause])
 yyt->Kind = kIndex_clause;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Index_clause.Index)
 begintTree(yyt->Index_clause.Index_terms)
 return yyt;
}

tTree nClass_header () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_header])
 yyt->Kind = kClass_header;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClass_header0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_header0])
 yyt->Kind = kClass_header0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClass () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass])
 yyt->Kind = kClass;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Class.Name)
 return yyt;
}

tTree nExpanded_class () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpanded_class])
 yyt->Kind = kExpanded_class;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Expanded_class.Name)
 return yyt;
}

tTree nDeferred_class () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeferred_class])
 yyt->Kind = kDeferred_class;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Deferred_class.Name)
 return yyt;
}

tTree nFeatures () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures])
 yyt->Kind = kFeatures;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeatures0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures0])
 yyt->Kind = kFeatures0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeatures1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures1])
 yyt->Kind = kFeatures1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Features1.Feature_clause)
 begintTree(yyt->Features1.Features)
 return yyt;
}

tTree nFeature_clause () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_clause])
 yyt->Kind = kFeature_clause;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Feature_clause.Clients)
 begintStringRef(yyt->Feature_clause.comment)
 begintTree(yyt->Feature_clause.Feature_decls)
 return yyt;
}

tTree nClients () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients])
 yyt->Kind = kClients;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClients0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients0])
 yyt->Kind = kClients0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClients1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients1])
 yyt->Kind = kClients1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Clients1.List)
 return yyt;
}

tTree nFeature_decls () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls])
 yyt->Kind = kFeature_decls;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_decls0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls0])
 yyt->Kind = kFeature_decls0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_decls1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls1])
 yyt->Kind = kFeature_decls1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Feature_decls1.Feature_decl)
 begintTree(yyt->Feature_decls1.Feature_decls)
 return yyt;
}

tTree nFeature_decl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decl])
 yyt->Kind = kFeature_decl;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Feature_decl.New_feature_list)
 begintTree(yyt->Feature_decl.Declaration_body)
 return yyt;
}

tTree nDeclaration_body () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeclaration_body])
 yyt->Kind = kDeclaration_body;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Declaration_body.Formal_args)
 begintTree(yyt->Declaration_body.Type_mark)
 begintTree(yyt->Declaration_body.Const_or_routine)
 return yyt;
}

tTree nConst_or_routine () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConst_or_routine])
 yyt->Kind = kConst_or_routine;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nConst_or_routine0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConst_or_routine0])
 yyt->Kind = kConst_or_routine0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nM_const () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kM_const])
 yyt->Kind = kM_const;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->M_const.Manifest_constant)
 return yyt;
}

tTree nUnique () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnique])
 yyt->Kind = kUnique;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Unique.pos)
 return yyt;
}

tTree nRoutine () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine])
 yyt->Kind = kRoutine;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Routine.Obsolete)
 begintStringRef(yyt->Routine.comment)
 begintTree(yyt->Routine.Precondition)
 begintTree(yyt->Routine.Local_decls)
 begintTree(yyt->Routine.Routine_body)
 begintTree(yyt->Routine.Postcondition)
 begintTree(yyt->Routine.Rescue)
 begintStringRef(yyt->Routine.end_comment)
 return yyt;
}

tTree nParent_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list])
 yyt->Kind = kParent_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nParent_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list0])
 yyt->Kind = kParent_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nParent_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list1])
 yyt->Kind = kParent_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Parent_list1.Parent)
 begintTree(yyt->Parent_list1.Parent_list)
 return yyt;
}

tTree nParent () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent])
 yyt->Kind = kParent;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Parent.Class_type)
 begintTree(yyt->Parent.Feature_adaptation)
 return yyt;
}

tTree nFeature_adaptation () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation])
 yyt->Kind = kFeature_adaptation;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_adaptation0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation0])
 yyt->Kind = kFeature_adaptation0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_adaptation1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation1])
 yyt->Kind = kFeature_adaptation1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Feature_adaptation1.Rename)
 begintTree(yyt->Feature_adaptation1.New_export)
 begintTree(yyt->Feature_adaptation1.Undefine)
 begintTree(yyt->Feature_adaptation1.Redefine)
 begintTree(yyt->Feature_adaptation1.Select)
 return yyt;
}

tTree nRename_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list])
 yyt->Kind = kRename_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nRename_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list0])
 yyt->Kind = kRename_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nRename_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list1])
 yyt->Kind = kRename_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Rename_list1.Rename_pair)
 begintTree(yyt->Rename_list1.Rename_list)
 return yyt;
}

tTree nRename_pair () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_pair])
 yyt->Kind = kRename_pair;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Rename_pair.Name1)
 begintTree(yyt->Rename_pair.Name2)
 return yyt;
}

tTree nCreators () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators])
 yyt->Kind = kCreators;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCreators0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators0])
 yyt->Kind = kCreators0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCreators1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators1])
 yyt->Kind = kCreators1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Creators1.Creation_clause)
 begintTree(yyt->Creators1.Creators)
 return yyt;
}

tTree nCreation_clause () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreation_clause])
 yyt->Kind = kCreation_clause;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Creation_clause.Clients)
 begintStringRef(yyt->Creation_clause.comment)
 begintTree(yyt->Creation_clause.Feature_list)
 return yyt;
}

tTree nNew_feature_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list])
 yyt->Kind = kNew_feature_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nNew_feature_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list0])
 yyt->Kind = kNew_feature_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nNew_feature_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list1])
 yyt->Kind = kNew_feature_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->New_feature_list1.Feature_name)
 begintTree(yyt->New_feature_list1.New_feature_list)
 return yyt;
}

tTree nFeature_name () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_name])
 yyt->Kind = kFeature_name;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFrozen () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFrozen])
 yyt->Kind = kFrozen;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Frozen.Feature_name)
 return yyt;
}

tTree nIdent_name () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIdent_name])
 yyt->Kind = kIdent_name;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Ident_name.Id)
 return yyt;
}

tTree nOp () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOp])
 yyt->Kind = kOp;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nPrefix () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPrefix])
 yyt->Kind = kPrefix;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Prefix.Op_name)
 return yyt;
}

tTree nInfix () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInfix])
 yyt->Kind = kInfix;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Infix.Op_name)
 return yyt;
}

tTree nOp_name () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOp_name])
 yyt->Kind = kOp_name;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Op_name.pos)
 return yyt;
}

tTree nFree_op () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFree_op])
 yyt->Kind = kFree_op;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Free_op.pos)
 begintIdent(yyt->Free_op.ident)
 return yyt;
}

tTree nOper () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOper])
 yyt->Kind = kOper;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Oper.pos)
 beginint(yyt->Oper.op)
 return yyt;
}

tTree nNew_export_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list])
 yyt->Kind = kNew_export_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nNew_export_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list0])
 yyt->Kind = kNew_export_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nNew_export_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list1])
 yyt->Kind = kNew_export_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->New_export_list1.New_export_item)
 begintTree(yyt->New_export_list1.New_export_list)
 return yyt;
}

tTree nNew_export_item () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_item])
 yyt->Kind = kNew_export_item;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->New_export_item.Clients)
 begintTree(yyt->New_export_item.Feature_set)
 return yyt;
}

tTree nFeature_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list])
 yyt->Kind = kFeature_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAll () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAll])
 yyt->Kind = kAll;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list0])
 yyt->Kind = kFeature_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFeature_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list1])
 yyt->Kind = kFeature_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Feature_list1.Feature_name)
 begintTree(yyt->Feature_list1.Feature_list)
 return yyt;
}

tTree nFormal_args () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args])
 yyt->Kind = kFormal_args;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFormal_args0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args0])
 yyt->Kind = kFormal_args0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFormal_args1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args1])
 yyt->Kind = kFormal_args1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Formal_args1.Entity_decl_group)
 begintTree(yyt->Formal_args1.Formal_args)
 return yyt;
}

tTree nRoutine_body () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine_body])
 yyt->Kind = kRoutine_body;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nRoutine_body0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine_body0])
 yyt->Kind = kRoutine_body0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nEffective () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEffective])
 yyt->Kind = kEffective;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nInternal () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInternal])
 yyt->Kind = kInternal;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nDo_body () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDo_body])
 yyt->Kind = kDo_body;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Do_body.Compound)
 return yyt;
}

tTree nOnce_body () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOnce_body])
 yyt->Kind = kOnce_body;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Once_body.Compound)
 return yyt;
}

tTree nExternal () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExternal])
 yyt->Kind = kExternal;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->External.Lang1)
 begintTree(yyt->External.Lang2)
 return yyt;
}

tTree nDeferred () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeferred])
 yyt->Kind = kDeferred;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Deferred.pos)
 return yyt;
}

tTree nEntity_decl_group () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity_decl_group])
 yyt->Kind = kEntity_decl_group;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Entity_decl_group.Id_list)
 begintTree(yyt->Entity_decl_group.Type_mark)
 return yyt;
}

tTree nFormal_generics () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics])
 yyt->Kind = kFormal_generics;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFormal_generics0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics0])
 yyt->Kind = kFormal_generics0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nFormal_generics1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics1])
 yyt->Kind = kFormal_generics1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Formal_generics1.Formal_generic)
 begintTree(yyt->Formal_generics1.Formal_generics)
 return yyt;
}

tTree nFormal_generic () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generic])
 yyt->Kind = kFormal_generic;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Formal_generic.Id)
 begintTree(yyt->Formal_generic.Constraint)
 return yyt;
}

tTree nConstraint () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint])
 yyt->Kind = kConstraint;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nConstraint0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint0])
 yyt->Kind = kConstraint0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nConstraint1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint1])
 yyt->Kind = kConstraint1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Constraint1.Class_type)
 return yyt;
}

tTree nCompound () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound])
 yyt->Kind = kCompound;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCompound0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound0])
 yyt->Kind = kCompound0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCompound1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound1])
 yyt->Kind = kCompound1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Compound1.Instruction)
 begintTree(yyt->Compound1.Compound)
 return yyt;
}

tTree nThen_part_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list])
 yyt->Kind = kThen_part_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nThen_part_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list0])
 yyt->Kind = kThen_part_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nThen_part_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list1])
 yyt->Kind = kThen_part_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Then_part_list1.Then_part)
 begintTree(yyt->Then_part_list1.Then_part_list)
 return yyt;
}

tTree nThen_part () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part])
 yyt->Kind = kThen_part;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Then_part.Guard)
 begintTree(yyt->Then_part.Compound)
 return yyt;
}

tTree nWhen_part_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list])
 yyt->Kind = kWhen_part_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nWhen_part_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list0])
 yyt->Kind = kWhen_part_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nWhen_part_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list1])
 yyt->Kind = kWhen_part_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->When_part_list1.When_part)
 begintTree(yyt->When_part_list1.When_part_list)
 return yyt;
}

tTree nWhen_part () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part])
 yyt->Kind = kWhen_part;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->When_part.Choices)
 begintTree(yyt->When_part.Compound)
 return yyt;
}

tTree nChoices () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices])
 yyt->Kind = kChoices;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nChoices0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices0])
 yyt->Kind = kChoices0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nChoices1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices1])
 yyt->Kind = kChoices1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Choices1.Choice)
 begintTree(yyt->Choices1.Choices)
 return yyt;
}

tTree nChoice () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoice])
 yyt->Kind = kChoice;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nInterval () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInterval])
 yyt->Kind = kInterval;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Interval.From)
 begintTree(yyt->Interval.To)
 return yyt;
}

tTree nVal () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVal])
 yyt->Kind = kVal;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Val.Manifest_constant)
 return yyt;
}

tTree nInstruction () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInstruction])
 yyt->Kind = kInstruction;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nInstruction0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInstruction0])
 yyt->Kind = kInstruction0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCreation () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreation])
 yyt->Kind = kCreation;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Creation.Type)
 begintTree(yyt->Creation.Entity)
 begintTree(yyt->Creation.Unqual_call)
 return yyt;
}

tTree nCall_instruct () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_instruct])
 yyt->Kind = kCall_instruct;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Call_instruct.Call)
 return yyt;
}

tTree nAssign () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssign])
 yyt->Kind = kAssign;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Assign.Addr)
 begintTree(yyt->Assign.Expression)
 return yyt;
}

tTree nRev_assign () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRev_assign])
 yyt->Kind = kRev_assign;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Rev_assign.Addr)
 begintTree(yyt->Rev_assign.Expression)
 return yyt;
}

tTree nConditional () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConditional])
 yyt->Kind = kConditional;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Conditional.Then_part)
 begintTree(yyt->Conditional.Else_part)
 return yyt;
}

tTree nMulti_branch () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMulti_branch])
 yyt->Kind = kMulti_branch;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Multi_branch.Guard)
 begintTree(yyt->Multi_branch.When_part_list)
 begintTree(yyt->Multi_branch.Else_part)
 return yyt;
}

tTree nLoop () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop])
 yyt->Kind = kLoop;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Loop.Initialization)
 begintTree(yyt->Loop.Invariant)
 begintTree(yyt->Loop.Variant)
 begintTree(yyt->Loop.Loop_body)
 return yyt;
}

tTree nCheck () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCheck])
 yyt->Kind = kCheck;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Check.Assertion)
 return yyt;
}

tTree nDebug () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDebug])
 yyt->Kind = kDebug;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Debug.Debug_keys)
 begintTree(yyt->Debug.Compound)
 return yyt;
}

tTree nRetry () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRetry])
 yyt->Kind = kRetry;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Retry.pos)
 return yyt;
}

tTree nLoop_body () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body])
 yyt->Kind = kLoop_body;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nLoop_body0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body0])
 yyt->Kind = kLoop_body0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nLoop_body1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body1])
 yyt->Kind = kLoop_body1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Loop_body1.Exit)
 begintTree(yyt->Loop_body1.Compound)
 return yyt;
}

tTree nType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType])
 yyt->Kind = kType;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nType0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType0])
 yyt->Kind = kType0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nClass_type () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_type])
 yyt->Kind = kClass_type;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Class_type.Id)
 begintTree(yyt->Class_type.Actual_generics)
 return yyt;
}

tTree nClass_type_expanded () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_type_expanded])
 yyt->Kind = kClass_type_expanded;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Class_type_expanded.Id)
 begintTree(yyt->Class_type_expanded.Actual_generics)
 return yyt;
}

tTree nBit_type () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBit_type])
 yyt->Kind = kBit_type;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Bit_type.Manifest_constant)
 return yyt;
}

tTree nSimple_type () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSimple_type])
 yyt->Kind = kSimple_type;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Simple_type.Manifest_constant)
 return yyt;
}

tTree nAnchored () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAnchored])
 yyt->Kind = kAnchored;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Anchored.Entity)
 return yyt;
}

tTree nActual_generics () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics])
 yyt->Kind = kActual_generics;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActual_generics0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics0])
 yyt->Kind = kActual_generics0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActual_generics1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics1])
 yyt->Kind = kActual_generics1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Actual_generics1.Type_list)
 return yyt;
}

tTree nCondition () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition])
 yyt->Kind = kCondition;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCondition0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition0])
 yyt->Kind = kCondition0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCondition1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition1])
 yyt->Kind = kCondition1;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->Condition1.extension)
 begintTree(yyt->Condition1.Assertion)
 return yyt;
}

tTree nAssertion () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion])
 yyt->Kind = kAssertion;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAssertion0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion0])
 yyt->Kind = kAssertion0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAssertion1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion1])
 yyt->Kind = kAssertion1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Assertion1.Assertion_clause)
 begintTree(yyt->Assertion1.Assertion)
 return yyt;
}

tTree nAssertion_clause () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause])
 yyt->Kind = kAssertion_clause;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAssertion_clause0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause0])
 yyt->Kind = kAssertion_clause0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAssertion_clause1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause1])
 yyt->Kind = kAssertion_clause1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Assertion_clause1.Tag)
 begintTree(yyt->Assertion_clause1.Expression)
 return yyt;
}

tTree nType_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list])
 yyt->Kind = kType_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nType_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list0])
 yyt->Kind = kType_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nType_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list1])
 yyt->Kind = kType_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Type_list1.Type)
 begintTree(yyt->Type_list1.Type_list)
 return yyt;
}

tTree nCall_chain () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain])
 yyt->Kind = kCall_chain;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCall_chain0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain0])
 yyt->Kind = kCall_chain0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCall_chain1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain1])
 yyt->Kind = kCall_chain1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Call_chain1.Unqual_call)
 begintTree(yyt->Call_chain1.Call_chain)
 return yyt;
}

tTree nUnqual_call () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call])
 yyt->Kind = kUnqual_call;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nUnqual_call0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call0])
 yyt->Kind = kUnqual_call0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nUnqual_call1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call1])
 yyt->Kind = kUnqual_call1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Unqual_call1.Entity)
 begintTree(yyt->Unqual_call1.Actuals)
 return yyt;
}

tTree nActuals () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals])
 yyt->Kind = kActuals;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActuals0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals0])
 yyt->Kind = kActuals0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActuals1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals1])
 yyt->Kind = kActuals1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Actuals1.Actual_list)
 return yyt;
}

tTree nActual_list () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list])
 yyt->Kind = kActual_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActual_list0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list0])
 yyt->Kind = kActual_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nActual_list1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list1])
 yyt->Kind = kActual_list1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Actual_list1.Actual)
 begintTree(yyt->Actual_list1.Actual_list)
 return yyt;
}

tTree nActual () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual])
 yyt->Kind = kActual;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nAddr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAddr])
 yyt->Kind = kAddr;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Addr.Entity)
 return yyt;
}

tTree nExpression () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpression])
 yyt->Kind = kExpression;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nExpression0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpression0])
 yyt->Kind = kExpression0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nComment () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kComment])
 yyt->Kind = kComment;
 yyt->yyHead.yyMark = 0;
 begintStringRef(yyt->Comment.comment)
 return yyt;
}

tTree nSimple_expr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSimple_expr])
 yyt->Kind = kSimple_expr;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Simple_expr.Manifest_constant)
 return yyt;
}

tTree nCall () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall])
 yyt->Kind = kCall;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Call.Qual)
 begintTree(yyt->Call.Call_chain)
 return yyt;
}

tTree nBin_expr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBin_expr])
 yyt->Kind = kBin_expr;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Bin_expr.Lop)
 begintTree(yyt->Bin_expr.Op)
 begintTree(yyt->Bin_expr.Rop)
 return yyt;
}

tTree nUn_expr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUn_expr])
 yyt->Kind = kUn_expr;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Un_expr.Op)
 begintTree(yyt->Un_expr.Expression)
 return yyt;
}

tTree nParenth () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParenth])
 yyt->Kind = kParenth;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Parenth.Expression)
 return yyt;
}

tTree nManifest_array () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array])
 yyt->Kind = kManifest_array;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nManifest_array0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array0])
 yyt->Kind = kManifest_array0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nManifest_array1 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array1])
 yyt->Kind = kManifest_array1;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Manifest_array1.Expression)
 begintTree(yyt->Manifest_array1.Manifest_array)
 return yyt;
}

tTree nOld () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOld])
 yyt->Kind = kOld;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Old.Expression)
 return yyt;
}

tTree nStrip () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kStrip])
 yyt->Kind = kStrip;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Strip.List)
 return yyt;
}

tTree nList () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kList])
 yyt->Kind = kList;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nnolist () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [knolist])
 yyt->Kind = knolist;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nlist () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [klist])
 yyt->Kind = klist;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->list.Manifest_constant)
 begintTree(yyt->list.List)
 return yyt;
}

tTree nManifest_constant () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_constant])
 yyt->Kind = kManifest_constant;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nManifest_constant0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_constant0])
 yyt->Kind = kManifest_constant0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCh () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCh])
 yyt->Kind = kCh;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->Ch.ch)
 begintPosition(yyt->Ch.pos)
 return yyt;
}

tTree nTrue () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTrue])
 yyt->Kind = kTrue;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->True.pos)
 return yyt;
}

tTree nFalse () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFalse])
 yyt->Kind = kFalse;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->False.pos)
 return yyt;
}

tTree nInt () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInt])
 yyt->Kind = kInt;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Int.Sign)
 beginlong(yyt->Int.value)
 begintPosition(yyt->Int.pos)
 return yyt;
}

tTree nReal () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kReal])
 yyt->Kind = kReal;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->Real.Sign)
 begindouble(yyt->Real.value)
 begintPosition(yyt->Real.pos)
 return yyt;
}

tTree n_CHARACTER () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_CHARACTER])
 yyt->Kind = k_CHARACTER;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_CHARACTER.pos)
 return yyt;
}

tTree n_INTEGER () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_INTEGER])
 yyt->Kind = k_INTEGER;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_INTEGER.pos)
 return yyt;
}

tTree n_REAL () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_REAL])
 yyt->Kind = k_REAL;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_REAL.pos)
 return yyt;
}

tTree n_DOUBLE () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_DOUBLE])
 yyt->Kind = k_DOUBLE;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_DOUBLE.pos)
 return yyt;
}

tTree n_BOOLEAN () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_BOOLEAN])
 yyt->Kind = k_BOOLEAN;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_BOOLEAN.pos)
 return yyt;
}

tTree n_STRING () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_STRING])
 yyt->Kind = k_STRING;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_STRING.pos)
 return yyt;
}

tTree n_BIT () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_BIT])
 yyt->Kind = k_BIT;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_BIT.pos)
 return yyt;
}

tTree n_NONE () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_NONE])
 yyt->Kind = k_NONE;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->_NONE.pos)
 return yyt;
}

tTree nBitseq () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBitseq])
 yyt->Kind = kBitseq;
 yyt->yyHead.yyMark = 0;
 begintStringRef(yyt->Bitseq.literal)
 begintPosition(yyt->Bitseq.pos)
 return yyt;
}

tTree nString () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kString])
 yyt->Kind = kString;
 yyt->yyHead.yyMark = 0;
 begintStringRef(yyt->String.string)
 begintPosition(yyt->String.pos)
 return yyt;
}

tTree nString0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kString0])
 yyt->Kind = kString0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nEntity () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity])
 yyt->Kind = kEntity;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nEntity0 () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity0])
 yyt->Kind = kEntity0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nCurrent () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCurrent])
 yyt->Kind = kCurrent;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Current.pos)
 return yyt;
}

tTree nResult () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kResult])
 yyt->Kind = kResult;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->Result.pos)
 return yyt;
}

tTree nId () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kId])
 yyt->Kind = kId;
 yyt->yyHead.yyMark = 0;
 begintIdent(yyt->Id.ident)
 begintPosition(yyt->Id.pos)
 return yyt;
}


tTree mEiffel
# if defined __STDC__ | defined __cplusplus
(tTree pClasses)
# else
(pClasses)
tTree pClasses;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEiffel])
 yyt->Kind = kEiffel;
 yyt->yyHead.yyMark = 0;
 yyt->Eiffel.Classes = pClasses;
 return yyt;
}

tTree mClasses
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses])
 yyt->Kind = kClasses;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClasses0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses0])
 yyt->Kind = kClasses0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClasses1
# if defined __STDC__ | defined __cplusplus
(tTree pClass_declaration, tTree pClasses)
# else
(pClass_declaration, pClasses)
tTree pClass_declaration;
tTree pClasses;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClasses1])
 yyt->Kind = kClasses1;
 yyt->yyHead.yyMark = 0;
 yyt->Classes1.Class_declaration = pClass_declaration;
 yyt->Classes1.Classes = pClasses;
 return yyt;
}

tTree mClass_declaration
# if defined __STDC__ | defined __cplusplus
(tTree pIndexing, tTree pClass_header, tTree pFormal_generics, tTree pObsolete, tTree pInheritance, tTree pCreators, tTree pFeatures, tTree pInvariant, tStringRef pcomment)
# else
(pIndexing, pClass_header, pFormal_generics, pObsolete, pInheritance, pCreators, pFeatures, pInvariant, pcomment)
tTree pIndexing;
tTree pClass_header;
tTree pFormal_generics;
tTree pObsolete;
tTree pInheritance;
tTree pCreators;
tTree pFeatures;
tTree pInvariant;
tStringRef pcomment;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_declaration])
 yyt->Kind = kClass_declaration;
 yyt->yyHead.yyMark = 0;
 yyt->Class_declaration.Indexing = pIndexing;
 yyt->Class_declaration.Class_header = pClass_header;
 yyt->Class_declaration.Formal_generics = pFormal_generics;
 yyt->Class_declaration.Obsolete = pObsolete;
 yyt->Class_declaration.Inheritance = pInheritance;
 yyt->Class_declaration.Creators = pCreators;
 yyt->Class_declaration.Features = pFeatures;
 yyt->Class_declaration.Invariant = pInvariant;
 yyt->Class_declaration.comment = pcomment;
 return yyt;
}

tTree mIndex_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list])
 yyt->Kind = kIndex_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mIndex_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list0])
 yyt->Kind = kIndex_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mIndex_list1
# if defined __STDC__ | defined __cplusplus
(tTree pIndex_clause, tTree pIndex_list)
# else
(pIndex_clause, pIndex_list)
tTree pIndex_clause;
tTree pIndex_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_list1])
 yyt->Kind = kIndex_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Index_list1.Index_clause = pIndex_clause;
 yyt->Index_list1.Index_list = pIndex_list;
 return yyt;
}

tTree mIndex_clause
# if defined __STDC__ | defined __cplusplus
(tTree pIndex, tTree pIndex_terms)
# else
(pIndex, pIndex_terms)
tTree pIndex;
tTree pIndex_terms;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIndex_clause])
 yyt->Kind = kIndex_clause;
 yyt->yyHead.yyMark = 0;
 yyt->Index_clause.Index = pIndex;
 yyt->Index_clause.Index_terms = pIndex_terms;
 return yyt;
}

tTree mClass_header
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_header])
 yyt->Kind = kClass_header;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClass_header0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_header0])
 yyt->Kind = kClass_header0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClass
# if defined __STDC__ | defined __cplusplus
(tTree pName)
# else
(pName)
tTree pName;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass])
 yyt->Kind = kClass;
 yyt->yyHead.yyMark = 0;
 yyt->Class.Name = pName;
 return yyt;
}

tTree mExpanded_class
# if defined __STDC__ | defined __cplusplus
(tTree pName)
# else
(pName)
tTree pName;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpanded_class])
 yyt->Kind = kExpanded_class;
 yyt->yyHead.yyMark = 0;
 yyt->Expanded_class.Name = pName;
 return yyt;
}

tTree mDeferred_class
# if defined __STDC__ | defined __cplusplus
(tTree pName)
# else
(pName)
tTree pName;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeferred_class])
 yyt->Kind = kDeferred_class;
 yyt->yyHead.yyMark = 0;
 yyt->Deferred_class.Name = pName;
 return yyt;
}

tTree mFeatures
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures])
 yyt->Kind = kFeatures;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeatures0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures0])
 yyt->Kind = kFeatures0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeatures1
# if defined __STDC__ | defined __cplusplus
(tTree pFeature_clause, tTree pFeatures)
# else
(pFeature_clause, pFeatures)
tTree pFeature_clause;
tTree pFeatures;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeatures1])
 yyt->Kind = kFeatures1;
 yyt->yyHead.yyMark = 0;
 yyt->Features1.Feature_clause = pFeature_clause;
 yyt->Features1.Features = pFeatures;
 return yyt;
}

tTree mFeature_clause
# if defined __STDC__ | defined __cplusplus
(tTree pClients, tStringRef pcomment, tTree pFeature_decls)
# else
(pClients, pcomment, pFeature_decls)
tTree pClients;
tStringRef pcomment;
tTree pFeature_decls;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_clause])
 yyt->Kind = kFeature_clause;
 yyt->yyHead.yyMark = 0;
 yyt->Feature_clause.Clients = pClients;
 yyt->Feature_clause.comment = pcomment;
 yyt->Feature_clause.Feature_decls = pFeature_decls;
 return yyt;
}

tTree mClients
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients])
 yyt->Kind = kClients;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClients0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients0])
 yyt->Kind = kClients0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClients1
# if defined __STDC__ | defined __cplusplus
(tTree pList)
# else
(pList)
tTree pList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClients1])
 yyt->Kind = kClients1;
 yyt->yyHead.yyMark = 0;
 yyt->Clients1.List = pList;
 return yyt;
}

tTree mFeature_decls
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls])
 yyt->Kind = kFeature_decls;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_decls0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls0])
 yyt->Kind = kFeature_decls0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_decls1
# if defined __STDC__ | defined __cplusplus
(tTree pFeature_decl, tTree pFeature_decls)
# else
(pFeature_decl, pFeature_decls)
tTree pFeature_decl;
tTree pFeature_decls;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decls1])
 yyt->Kind = kFeature_decls1;
 yyt->yyHead.yyMark = 0;
 yyt->Feature_decls1.Feature_decl = pFeature_decl;
 yyt->Feature_decls1.Feature_decls = pFeature_decls;
 return yyt;
}

tTree mFeature_decl
# if defined __STDC__ | defined __cplusplus
(tTree pNew_feature_list, tTree pDeclaration_body)
# else
(pNew_feature_list, pDeclaration_body)
tTree pNew_feature_list;
tTree pDeclaration_body;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_decl])
 yyt->Kind = kFeature_decl;
 yyt->yyHead.yyMark = 0;
 yyt->Feature_decl.New_feature_list = pNew_feature_list;
 yyt->Feature_decl.Declaration_body = pDeclaration_body;
 return yyt;
}

tTree mDeclaration_body
# if defined __STDC__ | defined __cplusplus
(tTree pFormal_args, tTree pType_mark, tTree pConst_or_routine)
# else
(pFormal_args, pType_mark, pConst_or_routine)
tTree pFormal_args;
tTree pType_mark;
tTree pConst_or_routine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeclaration_body])
 yyt->Kind = kDeclaration_body;
 yyt->yyHead.yyMark = 0;
 yyt->Declaration_body.Formal_args = pFormal_args;
 yyt->Declaration_body.Type_mark = pType_mark;
 yyt->Declaration_body.Const_or_routine = pConst_or_routine;
 return yyt;
}

tTree mConst_or_routine
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConst_or_routine])
 yyt->Kind = kConst_or_routine;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mConst_or_routine0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConst_or_routine0])
 yyt->Kind = kConst_or_routine0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mM_const
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant)
# else
(pManifest_constant)
tTree pManifest_constant;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kM_const])
 yyt->Kind = kM_const;
 yyt->yyHead.yyMark = 0;
 yyt->M_const.Manifest_constant = pManifest_constant;
 return yyt;
}

tTree mUnique
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnique])
 yyt->Kind = kUnique;
 yyt->yyHead.yyMark = 0;
 yyt->Unique.pos = ppos;
 return yyt;
}

tTree mRoutine
# if defined __STDC__ | defined __cplusplus
(tTree pObsolete, tStringRef pcomment, tTree pPrecondition, tTree pLocal_decls, tTree pRoutine_body, tTree pPostcondition, tTree pRescue, tStringRef pend_comment)
# else
(pObsolete, pcomment, pPrecondition, pLocal_decls, pRoutine_body, pPostcondition, pRescue, pend_comment)
tTree pObsolete;
tStringRef pcomment;
tTree pPrecondition;
tTree pLocal_decls;
tTree pRoutine_body;
tTree pPostcondition;
tTree pRescue;
tStringRef pend_comment;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine])
 yyt->Kind = kRoutine;
 yyt->yyHead.yyMark = 0;
 yyt->Routine.Obsolete = pObsolete;
 yyt->Routine.comment = pcomment;
 yyt->Routine.Precondition = pPrecondition;
 yyt->Routine.Local_decls = pLocal_decls;
 yyt->Routine.Routine_body = pRoutine_body;
 yyt->Routine.Postcondition = pPostcondition;
 yyt->Routine.Rescue = pRescue;
 yyt->Routine.end_comment = pend_comment;
 return yyt;
}

tTree mParent_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list])
 yyt->Kind = kParent_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mParent_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list0])
 yyt->Kind = kParent_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mParent_list1
# if defined __STDC__ | defined __cplusplus
(tTree pParent, tTree pParent_list)
# else
(pParent, pParent_list)
tTree pParent;
tTree pParent_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent_list1])
 yyt->Kind = kParent_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Parent_list1.Parent = pParent;
 yyt->Parent_list1.Parent_list = pParent_list;
 return yyt;
}

tTree mParent
# if defined __STDC__ | defined __cplusplus
(tTree pClass_type, tTree pFeature_adaptation)
# else
(pClass_type, pFeature_adaptation)
tTree pClass_type;
tTree pFeature_adaptation;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParent])
 yyt->Kind = kParent;
 yyt->yyHead.yyMark = 0;
 yyt->Parent.Class_type = pClass_type;
 yyt->Parent.Feature_adaptation = pFeature_adaptation;
 return yyt;
}

tTree mFeature_adaptation
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation])
 yyt->Kind = kFeature_adaptation;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_adaptation0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation0])
 yyt->Kind = kFeature_adaptation0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_adaptation1
# if defined __STDC__ | defined __cplusplus
(tTree pRename, tTree pNew_export, tTree pUndefine, tTree pRedefine, tTree pSelect)
# else
(pRename, pNew_export, pUndefine, pRedefine, pSelect)
tTree pRename;
tTree pNew_export;
tTree pUndefine;
tTree pRedefine;
tTree pSelect;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_adaptation1])
 yyt->Kind = kFeature_adaptation1;
 yyt->yyHead.yyMark = 0;
 yyt->Feature_adaptation1.Rename = pRename;
 yyt->Feature_adaptation1.New_export = pNew_export;
 yyt->Feature_adaptation1.Undefine = pUndefine;
 yyt->Feature_adaptation1.Redefine = pRedefine;
 yyt->Feature_adaptation1.Select = pSelect;
 return yyt;
}

tTree mRename_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list])
 yyt->Kind = kRename_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mRename_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list0])
 yyt->Kind = kRename_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mRename_list1
# if defined __STDC__ | defined __cplusplus
(tTree pRename_pair, tTree pRename_list)
# else
(pRename_pair, pRename_list)
tTree pRename_pair;
tTree pRename_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_list1])
 yyt->Kind = kRename_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Rename_list1.Rename_pair = pRename_pair;
 yyt->Rename_list1.Rename_list = pRename_list;
 return yyt;
}

tTree mRename_pair
# if defined __STDC__ | defined __cplusplus
(tTree pName1, tTree pName2)
# else
(pName1, pName2)
tTree pName1;
tTree pName2;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRename_pair])
 yyt->Kind = kRename_pair;
 yyt->yyHead.yyMark = 0;
 yyt->Rename_pair.Name1 = pName1;
 yyt->Rename_pair.Name2 = pName2;
 return yyt;
}

tTree mCreators
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators])
 yyt->Kind = kCreators;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCreators0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators0])
 yyt->Kind = kCreators0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCreators1
# if defined __STDC__ | defined __cplusplus
(tTree pCreation_clause, tTree pCreators)
# else
(pCreation_clause, pCreators)
tTree pCreation_clause;
tTree pCreators;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreators1])
 yyt->Kind = kCreators1;
 yyt->yyHead.yyMark = 0;
 yyt->Creators1.Creation_clause = pCreation_clause;
 yyt->Creators1.Creators = pCreators;
 return yyt;
}

tTree mCreation_clause
# if defined __STDC__ | defined __cplusplus
(tTree pClients, tStringRef pcomment, tTree pFeature_list)
# else
(pClients, pcomment, pFeature_list)
tTree pClients;
tStringRef pcomment;
tTree pFeature_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreation_clause])
 yyt->Kind = kCreation_clause;
 yyt->yyHead.yyMark = 0;
 yyt->Creation_clause.Clients = pClients;
 yyt->Creation_clause.comment = pcomment;
 yyt->Creation_clause.Feature_list = pFeature_list;
 return yyt;
}

tTree mNew_feature_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list])
 yyt->Kind = kNew_feature_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mNew_feature_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list0])
 yyt->Kind = kNew_feature_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mNew_feature_list1
# if defined __STDC__ | defined __cplusplus
(tTree pFeature_name, tTree pNew_feature_list)
# else
(pFeature_name, pNew_feature_list)
tTree pFeature_name;
tTree pNew_feature_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_feature_list1])
 yyt->Kind = kNew_feature_list1;
 yyt->yyHead.yyMark = 0;
 yyt->New_feature_list1.Feature_name = pFeature_name;
 yyt->New_feature_list1.New_feature_list = pNew_feature_list;
 return yyt;
}

tTree mFeature_name
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_name])
 yyt->Kind = kFeature_name;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFrozen
# if defined __STDC__ | defined __cplusplus
(tTree pFeature_name)
# else
(pFeature_name)
tTree pFeature_name;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFrozen])
 yyt->Kind = kFrozen;
 yyt->yyHead.yyMark = 0;
 yyt->Frozen.Feature_name = pFeature_name;
 return yyt;
}

tTree mIdent_name
# if defined __STDC__ | defined __cplusplus
(tTree pId)
# else
(pId)
tTree pId;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIdent_name])
 yyt->Kind = kIdent_name;
 yyt->yyHead.yyMark = 0;
 yyt->Ident_name.Id = pId;
 return yyt;
}

tTree mOp
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOp])
 yyt->Kind = kOp;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mPrefix
# if defined __STDC__ | defined __cplusplus
(tTree pOp_name)
# else
(pOp_name)
tTree pOp_name;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPrefix])
 yyt->Kind = kPrefix;
 yyt->yyHead.yyMark = 0;
 yyt->Prefix.Op_name = pOp_name;
 return yyt;
}

tTree mInfix
# if defined __STDC__ | defined __cplusplus
(tTree pOp_name)
# else
(pOp_name)
tTree pOp_name;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInfix])
 yyt->Kind = kInfix;
 yyt->yyHead.yyMark = 0;
 yyt->Infix.Op_name = pOp_name;
 return yyt;
}

tTree mOp_name
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOp_name])
 yyt->Kind = kOp_name;
 yyt->yyHead.yyMark = 0;
 yyt->Op_name.pos = ppos;
 return yyt;
}

tTree mFree_op
# if defined __STDC__ | defined __cplusplus
(tPosition ppos, tIdent pident)
# else
(ppos, pident)
tPosition ppos;
tIdent pident;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFree_op])
 yyt->Kind = kFree_op;
 yyt->yyHead.yyMark = 0;
 yyt->Free_op.pos = ppos;
 yyt->Free_op.ident = pident;
 return yyt;
}

tTree mOper
# if defined __STDC__ | defined __cplusplus
(tPosition ppos, int pop)
# else
(ppos, pop)
tPosition ppos;
int pop;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOper])
 yyt->Kind = kOper;
 yyt->yyHead.yyMark = 0;
 yyt->Oper.pos = ppos;
 yyt->Oper.op = pop;
 return yyt;
}

tTree mNew_export_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list])
 yyt->Kind = kNew_export_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mNew_export_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list0])
 yyt->Kind = kNew_export_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mNew_export_list1
# if defined __STDC__ | defined __cplusplus
(tTree pNew_export_item, tTree pNew_export_list)
# else
(pNew_export_item, pNew_export_list)
tTree pNew_export_item;
tTree pNew_export_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_list1])
 yyt->Kind = kNew_export_list1;
 yyt->yyHead.yyMark = 0;
 yyt->New_export_list1.New_export_item = pNew_export_item;
 yyt->New_export_list1.New_export_list = pNew_export_list;
 return yyt;
}

tTree mNew_export_item
# if defined __STDC__ | defined __cplusplus
(tTree pClients, tTree pFeature_set)
# else
(pClients, pFeature_set)
tTree pClients;
tTree pFeature_set;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNew_export_item])
 yyt->Kind = kNew_export_item;
 yyt->yyHead.yyMark = 0;
 yyt->New_export_item.Clients = pClients;
 yyt->New_export_item.Feature_set = pFeature_set;
 return yyt;
}

tTree mFeature_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list])
 yyt->Kind = kFeature_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAll
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAll])
 yyt->Kind = kAll;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list0])
 yyt->Kind = kFeature_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFeature_list1
# if defined __STDC__ | defined __cplusplus
(tTree pFeature_name, tTree pFeature_list)
# else
(pFeature_name, pFeature_list)
tTree pFeature_name;
tTree pFeature_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFeature_list1])
 yyt->Kind = kFeature_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Feature_list1.Feature_name = pFeature_name;
 yyt->Feature_list1.Feature_list = pFeature_list;
 return yyt;
}

tTree mFormal_args
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args])
 yyt->Kind = kFormal_args;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFormal_args0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args0])
 yyt->Kind = kFormal_args0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFormal_args1
# if defined __STDC__ | defined __cplusplus
(tTree pEntity_decl_group, tTree pFormal_args)
# else
(pEntity_decl_group, pFormal_args)
tTree pEntity_decl_group;
tTree pFormal_args;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_args1])
 yyt->Kind = kFormal_args1;
 yyt->yyHead.yyMark = 0;
 yyt->Formal_args1.Entity_decl_group = pEntity_decl_group;
 yyt->Formal_args1.Formal_args = pFormal_args;
 return yyt;
}

tTree mRoutine_body
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine_body])
 yyt->Kind = kRoutine_body;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mRoutine_body0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRoutine_body0])
 yyt->Kind = kRoutine_body0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mEffective
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEffective])
 yyt->Kind = kEffective;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mInternal
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInternal])
 yyt->Kind = kInternal;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mDo_body
# if defined __STDC__ | defined __cplusplus
(tTree pCompound)
# else
(pCompound)
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDo_body])
 yyt->Kind = kDo_body;
 yyt->yyHead.yyMark = 0;
 yyt->Do_body.Compound = pCompound;
 return yyt;
}

tTree mOnce_body
# if defined __STDC__ | defined __cplusplus
(tTree pCompound)
# else
(pCompound)
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOnce_body])
 yyt->Kind = kOnce_body;
 yyt->yyHead.yyMark = 0;
 yyt->Once_body.Compound = pCompound;
 return yyt;
}

tTree mExternal
# if defined __STDC__ | defined __cplusplus
(tTree pLang1, tTree pLang2)
# else
(pLang1, pLang2)
tTree pLang1;
tTree pLang2;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExternal])
 yyt->Kind = kExternal;
 yyt->yyHead.yyMark = 0;
 yyt->External.Lang1 = pLang1;
 yyt->External.Lang2 = pLang2;
 return yyt;
}

tTree mDeferred
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDeferred])
 yyt->Kind = kDeferred;
 yyt->yyHead.yyMark = 0;
 yyt->Deferred.pos = ppos;
 return yyt;
}

tTree mEntity_decl_group
# if defined __STDC__ | defined __cplusplus
(tTree pId_list, tTree pType_mark)
# else
(pId_list, pType_mark)
tTree pId_list;
tTree pType_mark;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity_decl_group])
 yyt->Kind = kEntity_decl_group;
 yyt->yyHead.yyMark = 0;
 yyt->Entity_decl_group.Id_list = pId_list;
 yyt->Entity_decl_group.Type_mark = pType_mark;
 return yyt;
}

tTree mFormal_generics
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics])
 yyt->Kind = kFormal_generics;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFormal_generics0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics0])
 yyt->Kind = kFormal_generics0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mFormal_generics1
# if defined __STDC__ | defined __cplusplus
(tTree pFormal_generic, tTree pFormal_generics)
# else
(pFormal_generic, pFormal_generics)
tTree pFormal_generic;
tTree pFormal_generics;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generics1])
 yyt->Kind = kFormal_generics1;
 yyt->yyHead.yyMark = 0;
 yyt->Formal_generics1.Formal_generic = pFormal_generic;
 yyt->Formal_generics1.Formal_generics = pFormal_generics;
 return yyt;
}

tTree mFormal_generic
# if defined __STDC__ | defined __cplusplus
(tTree pId, tTree pConstraint)
# else
(pId, pConstraint)
tTree pId;
tTree pConstraint;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFormal_generic])
 yyt->Kind = kFormal_generic;
 yyt->yyHead.yyMark = 0;
 yyt->Formal_generic.Id = pId;
 yyt->Formal_generic.Constraint = pConstraint;
 return yyt;
}

tTree mConstraint
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint])
 yyt->Kind = kConstraint;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mConstraint0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint0])
 yyt->Kind = kConstraint0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mConstraint1
# if defined __STDC__ | defined __cplusplus
(tTree pClass_type)
# else
(pClass_type)
tTree pClass_type;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConstraint1])
 yyt->Kind = kConstraint1;
 yyt->yyHead.yyMark = 0;
 yyt->Constraint1.Class_type = pClass_type;
 return yyt;
}

tTree mCompound
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound])
 yyt->Kind = kCompound;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCompound0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound0])
 yyt->Kind = kCompound0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCompound1
# if defined __STDC__ | defined __cplusplus
(tTree pInstruction, tTree pCompound)
# else
(pInstruction, pCompound)
tTree pInstruction;
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCompound1])
 yyt->Kind = kCompound1;
 yyt->yyHead.yyMark = 0;
 yyt->Compound1.Instruction = pInstruction;
 yyt->Compound1.Compound = pCompound;
 return yyt;
}

tTree mThen_part_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list])
 yyt->Kind = kThen_part_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mThen_part_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list0])
 yyt->Kind = kThen_part_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mThen_part_list1
# if defined __STDC__ | defined __cplusplus
(tTree pThen_part, tTree pThen_part_list)
# else
(pThen_part, pThen_part_list)
tTree pThen_part;
tTree pThen_part_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part_list1])
 yyt->Kind = kThen_part_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Then_part_list1.Then_part = pThen_part;
 yyt->Then_part_list1.Then_part_list = pThen_part_list;
 return yyt;
}

tTree mThen_part
# if defined __STDC__ | defined __cplusplus
(tTree pGuard, tTree pCompound)
# else
(pGuard, pCompound)
tTree pGuard;
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kThen_part])
 yyt->Kind = kThen_part;
 yyt->yyHead.yyMark = 0;
 yyt->Then_part.Guard = pGuard;
 yyt->Then_part.Compound = pCompound;
 return yyt;
}

tTree mWhen_part_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list])
 yyt->Kind = kWhen_part_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mWhen_part_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list0])
 yyt->Kind = kWhen_part_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mWhen_part_list1
# if defined __STDC__ | defined __cplusplus
(tTree pWhen_part, tTree pWhen_part_list)
# else
(pWhen_part, pWhen_part_list)
tTree pWhen_part;
tTree pWhen_part_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part_list1])
 yyt->Kind = kWhen_part_list1;
 yyt->yyHead.yyMark = 0;
 yyt->When_part_list1.When_part = pWhen_part;
 yyt->When_part_list1.When_part_list = pWhen_part_list;
 return yyt;
}

tTree mWhen_part
# if defined __STDC__ | defined __cplusplus
(tTree pChoices, tTree pCompound)
# else
(pChoices, pCompound)
tTree pChoices;
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kWhen_part])
 yyt->Kind = kWhen_part;
 yyt->yyHead.yyMark = 0;
 yyt->When_part.Choices = pChoices;
 yyt->When_part.Compound = pCompound;
 return yyt;
}

tTree mChoices
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices])
 yyt->Kind = kChoices;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mChoices0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices0])
 yyt->Kind = kChoices0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mChoices1
# if defined __STDC__ | defined __cplusplus
(tTree pChoice, tTree pChoices)
# else
(pChoice, pChoices)
tTree pChoice;
tTree pChoices;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoices1])
 yyt->Kind = kChoices1;
 yyt->yyHead.yyMark = 0;
 yyt->Choices1.Choice = pChoice;
 yyt->Choices1.Choices = pChoices;
 return yyt;
}

tTree mChoice
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kChoice])
 yyt->Kind = kChoice;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mInterval
# if defined __STDC__ | defined __cplusplus
(tTree pFrom, tTree pTo)
# else
(pFrom, pTo)
tTree pFrom;
tTree pTo;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInterval])
 yyt->Kind = kInterval;
 yyt->yyHead.yyMark = 0;
 yyt->Interval.From = pFrom;
 yyt->Interval.To = pTo;
 return yyt;
}

tTree mVal
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant)
# else
(pManifest_constant)
tTree pManifest_constant;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVal])
 yyt->Kind = kVal;
 yyt->yyHead.yyMark = 0;
 yyt->Val.Manifest_constant = pManifest_constant;
 return yyt;
}

tTree mInstruction
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInstruction])
 yyt->Kind = kInstruction;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mInstruction0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInstruction0])
 yyt->Kind = kInstruction0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCreation
# if defined __STDC__ | defined __cplusplus
(tTree pType, tTree pEntity, tTree pUnqual_call)
# else
(pType, pEntity, pUnqual_call)
tTree pType;
tTree pEntity;
tTree pUnqual_call;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCreation])
 yyt->Kind = kCreation;
 yyt->yyHead.yyMark = 0;
 yyt->Creation.Type = pType;
 yyt->Creation.Entity = pEntity;
 yyt->Creation.Unqual_call = pUnqual_call;
 return yyt;
}

tTree mCall_instruct
# if defined __STDC__ | defined __cplusplus
(tTree pCall)
# else
(pCall)
tTree pCall;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_instruct])
 yyt->Kind = kCall_instruct;
 yyt->yyHead.yyMark = 0;
 yyt->Call_instruct.Call = pCall;
 return yyt;
}

tTree mAssign
# if defined __STDC__ | defined __cplusplus
(tTree pAddr, tTree pExpression)
# else
(pAddr, pExpression)
tTree pAddr;
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssign])
 yyt->Kind = kAssign;
 yyt->yyHead.yyMark = 0;
 yyt->Assign.Addr = pAddr;
 yyt->Assign.Expression = pExpression;
 return yyt;
}

tTree mRev_assign
# if defined __STDC__ | defined __cplusplus
(tTree pAddr, tTree pExpression)
# else
(pAddr, pExpression)
tTree pAddr;
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRev_assign])
 yyt->Kind = kRev_assign;
 yyt->yyHead.yyMark = 0;
 yyt->Rev_assign.Addr = pAddr;
 yyt->Rev_assign.Expression = pExpression;
 return yyt;
}

tTree mConditional
# if defined __STDC__ | defined __cplusplus
(tTree pThen_part, tTree pElse_part)
# else
(pThen_part, pElse_part)
tTree pThen_part;
tTree pElse_part;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kConditional])
 yyt->Kind = kConditional;
 yyt->yyHead.yyMark = 0;
 yyt->Conditional.Then_part = pThen_part;
 yyt->Conditional.Else_part = pElse_part;
 return yyt;
}

tTree mMulti_branch
# if defined __STDC__ | defined __cplusplus
(tTree pGuard, tTree pWhen_part_list, tTree pElse_part)
# else
(pGuard, pWhen_part_list, pElse_part)
tTree pGuard;
tTree pWhen_part_list;
tTree pElse_part;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMulti_branch])
 yyt->Kind = kMulti_branch;
 yyt->yyHead.yyMark = 0;
 yyt->Multi_branch.Guard = pGuard;
 yyt->Multi_branch.When_part_list = pWhen_part_list;
 yyt->Multi_branch.Else_part = pElse_part;
 return yyt;
}

tTree mLoop
# if defined __STDC__ | defined __cplusplus
(tTree pInitialization, tTree pInvariant, tTree pVariant, tTree pLoop_body)
# else
(pInitialization, pInvariant, pVariant, pLoop_body)
tTree pInitialization;
tTree pInvariant;
tTree pVariant;
tTree pLoop_body;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop])
 yyt->Kind = kLoop;
 yyt->yyHead.yyMark = 0;
 yyt->Loop.Initialization = pInitialization;
 yyt->Loop.Invariant = pInvariant;
 yyt->Loop.Variant = pVariant;
 yyt->Loop.Loop_body = pLoop_body;
 return yyt;
}

tTree mCheck
# if defined __STDC__ | defined __cplusplus
(tTree pAssertion)
# else
(pAssertion)
tTree pAssertion;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCheck])
 yyt->Kind = kCheck;
 yyt->yyHead.yyMark = 0;
 yyt->Check.Assertion = pAssertion;
 return yyt;
}

tTree mDebug
# if defined __STDC__ | defined __cplusplus
(tTree pDebug_keys, tTree pCompound)
# else
(pDebug_keys, pCompound)
tTree pDebug_keys;
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDebug])
 yyt->Kind = kDebug;
 yyt->yyHead.yyMark = 0;
 yyt->Debug.Debug_keys = pDebug_keys;
 yyt->Debug.Compound = pCompound;
 return yyt;
}

tTree mRetry
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRetry])
 yyt->Kind = kRetry;
 yyt->yyHead.yyMark = 0;
 yyt->Retry.pos = ppos;
 return yyt;
}

tTree mLoop_body
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body])
 yyt->Kind = kLoop_body;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mLoop_body0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body0])
 yyt->Kind = kLoop_body0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mLoop_body1
# if defined __STDC__ | defined __cplusplus
(tTree pExit, tTree pCompound)
# else
(pExit, pCompound)
tTree pExit;
tTree pCompound;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLoop_body1])
 yyt->Kind = kLoop_body1;
 yyt->yyHead.yyMark = 0;
 yyt->Loop_body1.Exit = pExit;
 yyt->Loop_body1.Compound = pCompound;
 return yyt;
}

tTree mType
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType])
 yyt->Kind = kType;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mType0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType0])
 yyt->Kind = kType0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mClass_type
# if defined __STDC__ | defined __cplusplus
(tTree pId, tTree pActual_generics)
# else
(pId, pActual_generics)
tTree pId;
tTree pActual_generics;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_type])
 yyt->Kind = kClass_type;
 yyt->yyHead.yyMark = 0;
 yyt->Class_type.Id = pId;
 yyt->Class_type.Actual_generics = pActual_generics;
 return yyt;
}

tTree mClass_type_expanded
# if defined __STDC__ | defined __cplusplus
(tTree pId, tTree pActual_generics)
# else
(pId, pActual_generics)
tTree pId;
tTree pActual_generics;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kClass_type_expanded])
 yyt->Kind = kClass_type_expanded;
 yyt->yyHead.yyMark = 0;
 yyt->Class_type_expanded.Id = pId;
 yyt->Class_type_expanded.Actual_generics = pActual_generics;
 return yyt;
}

tTree mBit_type
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant)
# else
(pManifest_constant)
tTree pManifest_constant;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBit_type])
 yyt->Kind = kBit_type;
 yyt->yyHead.yyMark = 0;
 yyt->Bit_type.Manifest_constant = pManifest_constant;
 return yyt;
}

tTree mSimple_type
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant)
# else
(pManifest_constant)
tTree pManifest_constant;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSimple_type])
 yyt->Kind = kSimple_type;
 yyt->yyHead.yyMark = 0;
 yyt->Simple_type.Manifest_constant = pManifest_constant;
 return yyt;
}

tTree mAnchored
# if defined __STDC__ | defined __cplusplus
(tTree pEntity)
# else
(pEntity)
tTree pEntity;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAnchored])
 yyt->Kind = kAnchored;
 yyt->yyHead.yyMark = 0;
 yyt->Anchored.Entity = pEntity;
 return yyt;
}

tTree mActual_generics
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics])
 yyt->Kind = kActual_generics;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActual_generics0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics0])
 yyt->Kind = kActual_generics0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActual_generics1
# if defined __STDC__ | defined __cplusplus
(tTree pType_list)
# else
(pType_list)
tTree pType_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_generics1])
 yyt->Kind = kActual_generics1;
 yyt->yyHead.yyMark = 0;
 yyt->Actual_generics1.Type_list = pType_list;
 return yyt;
}

tTree mCondition
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition])
 yyt->Kind = kCondition;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCondition0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition0])
 yyt->Kind = kCondition0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCondition1
# if defined __STDC__ | defined __cplusplus
(int pextension, tTree pAssertion)
# else
(pextension, pAssertion)
int pextension;
tTree pAssertion;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCondition1])
 yyt->Kind = kCondition1;
 yyt->yyHead.yyMark = 0;
 yyt->Condition1.extension = pextension;
 yyt->Condition1.Assertion = pAssertion;
 return yyt;
}

tTree mAssertion
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion])
 yyt->Kind = kAssertion;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAssertion0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion0])
 yyt->Kind = kAssertion0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAssertion1
# if defined __STDC__ | defined __cplusplus
(tTree pAssertion_clause, tTree pAssertion)
# else
(pAssertion_clause, pAssertion)
tTree pAssertion_clause;
tTree pAssertion;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion1])
 yyt->Kind = kAssertion1;
 yyt->yyHead.yyMark = 0;
 yyt->Assertion1.Assertion_clause = pAssertion_clause;
 yyt->Assertion1.Assertion = pAssertion;
 return yyt;
}

tTree mAssertion_clause
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause])
 yyt->Kind = kAssertion_clause;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAssertion_clause0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause0])
 yyt->Kind = kAssertion_clause0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAssertion_clause1
# if defined __STDC__ | defined __cplusplus
(tTree pTag, tTree pExpression)
# else
(pTag, pExpression)
tTree pTag;
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAssertion_clause1])
 yyt->Kind = kAssertion_clause1;
 yyt->yyHead.yyMark = 0;
 yyt->Assertion_clause1.Tag = pTag;
 yyt->Assertion_clause1.Expression = pExpression;
 return yyt;
}

tTree mType_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list])
 yyt->Kind = kType_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mType_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list0])
 yyt->Kind = kType_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mType_list1
# if defined __STDC__ | defined __cplusplus
(tTree pType, tTree pType_list)
# else
(pType, pType_list)
tTree pType;
tTree pType_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kType_list1])
 yyt->Kind = kType_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Type_list1.Type = pType;
 yyt->Type_list1.Type_list = pType_list;
 return yyt;
}

tTree mCall_chain
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain])
 yyt->Kind = kCall_chain;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCall_chain0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain0])
 yyt->Kind = kCall_chain0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCall_chain1
# if defined __STDC__ | defined __cplusplus
(tTree pUnqual_call, tTree pCall_chain)
# else
(pUnqual_call, pCall_chain)
tTree pUnqual_call;
tTree pCall_chain;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall_chain1])
 yyt->Kind = kCall_chain1;
 yyt->yyHead.yyMark = 0;
 yyt->Call_chain1.Unqual_call = pUnqual_call;
 yyt->Call_chain1.Call_chain = pCall_chain;
 return yyt;
}

tTree mUnqual_call
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call])
 yyt->Kind = kUnqual_call;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mUnqual_call0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call0])
 yyt->Kind = kUnqual_call0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mUnqual_call1
# if defined __STDC__ | defined __cplusplus
(tTree pEntity, tTree pActuals)
# else
(pEntity, pActuals)
tTree pEntity;
tTree pActuals;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUnqual_call1])
 yyt->Kind = kUnqual_call1;
 yyt->yyHead.yyMark = 0;
 yyt->Unqual_call1.Entity = pEntity;
 yyt->Unqual_call1.Actuals = pActuals;
 return yyt;
}

tTree mActuals
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals])
 yyt->Kind = kActuals;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActuals0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals0])
 yyt->Kind = kActuals0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActuals1
# if defined __STDC__ | defined __cplusplus
(tTree pActual_list)
# else
(pActual_list)
tTree pActual_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActuals1])
 yyt->Kind = kActuals1;
 yyt->yyHead.yyMark = 0;
 yyt->Actuals1.Actual_list = pActual_list;
 return yyt;
}

tTree mActual_list
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list])
 yyt->Kind = kActual_list;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActual_list0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list0])
 yyt->Kind = kActual_list0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mActual_list1
# if defined __STDC__ | defined __cplusplus
(tTree pActual, tTree pActual_list)
# else
(pActual, pActual_list)
tTree pActual;
tTree pActual_list;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual_list1])
 yyt->Kind = kActual_list1;
 yyt->yyHead.yyMark = 0;
 yyt->Actual_list1.Actual = pActual;
 yyt->Actual_list1.Actual_list = pActual_list;
 return yyt;
}

tTree mActual
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kActual])
 yyt->Kind = kActual;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mAddr
# if defined __STDC__ | defined __cplusplus
(tTree pEntity)
# else
(pEntity)
tTree pEntity;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kAddr])
 yyt->Kind = kAddr;
 yyt->yyHead.yyMark = 0;
 yyt->Addr.Entity = pEntity;
 return yyt;
}

tTree mExpression
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpression])
 yyt->Kind = kExpression;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mExpression0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kExpression0])
 yyt->Kind = kExpression0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mComment
# if defined __STDC__ | defined __cplusplus
(tStringRef pcomment)
# else
(pcomment)
tStringRef pcomment;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kComment])
 yyt->Kind = kComment;
 yyt->yyHead.yyMark = 0;
 yyt->Comment.comment = pcomment;
 return yyt;
}

tTree mSimple_expr
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant)
# else
(pManifest_constant)
tTree pManifest_constant;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSimple_expr])
 yyt->Kind = kSimple_expr;
 yyt->yyHead.yyMark = 0;
 yyt->Simple_expr.Manifest_constant = pManifest_constant;
 return yyt;
}

tTree mCall
# if defined __STDC__ | defined __cplusplus
(tTree pQual, tTree pCall_chain)
# else
(pQual, pCall_chain)
tTree pQual;
tTree pCall_chain;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCall])
 yyt->Kind = kCall;
 yyt->yyHead.yyMark = 0;
 yyt->Call.Qual = pQual;
 yyt->Call.Call_chain = pCall_chain;
 return yyt;
}

tTree mBin_expr
# if defined __STDC__ | defined __cplusplus
(tTree pLop, tTree pOp, tTree pRop)
# else
(pLop, pOp, pRop)
tTree pLop;
tTree pOp;
tTree pRop;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBin_expr])
 yyt->Kind = kBin_expr;
 yyt->yyHead.yyMark = 0;
 yyt->Bin_expr.Lop = pLop;
 yyt->Bin_expr.Op = pOp;
 yyt->Bin_expr.Rop = pRop;
 return yyt;
}

tTree mUn_expr
# if defined __STDC__ | defined __cplusplus
(tTree pOp, tTree pExpression)
# else
(pOp, pExpression)
tTree pOp;
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUn_expr])
 yyt->Kind = kUn_expr;
 yyt->yyHead.yyMark = 0;
 yyt->Un_expr.Op = pOp;
 yyt->Un_expr.Expression = pExpression;
 return yyt;
}

tTree mParenth
# if defined __STDC__ | defined __cplusplus
(tTree pExpression)
# else
(pExpression)
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kParenth])
 yyt->Kind = kParenth;
 yyt->yyHead.yyMark = 0;
 yyt->Parenth.Expression = pExpression;
 return yyt;
}

tTree mManifest_array
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array])
 yyt->Kind = kManifest_array;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mManifest_array0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array0])
 yyt->Kind = kManifest_array0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mManifest_array1
# if defined __STDC__ | defined __cplusplus
(tTree pExpression, tTree pManifest_array)
# else
(pExpression, pManifest_array)
tTree pExpression;
tTree pManifest_array;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_array1])
 yyt->Kind = kManifest_array1;
 yyt->yyHead.yyMark = 0;
 yyt->Manifest_array1.Expression = pExpression;
 yyt->Manifest_array1.Manifest_array = pManifest_array;
 return yyt;
}

tTree mOld
# if defined __STDC__ | defined __cplusplus
(tTree pExpression)
# else
(pExpression)
tTree pExpression;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOld])
 yyt->Kind = kOld;
 yyt->yyHead.yyMark = 0;
 yyt->Old.Expression = pExpression;
 return yyt;
}

tTree mStrip
# if defined __STDC__ | defined __cplusplus
(tTree pList)
# else
(pList)
tTree pList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kStrip])
 yyt->Kind = kStrip;
 yyt->yyHead.yyMark = 0;
 yyt->Strip.List = pList;
 return yyt;
}

tTree mList
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kList])
 yyt->Kind = kList;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mnolist
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [knolist])
 yyt->Kind = knolist;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mlist
# if defined __STDC__ | defined __cplusplus
(tTree pManifest_constant, tTree pList)
# else
(pManifest_constant, pList)
tTree pManifest_constant;
tTree pList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [klist])
 yyt->Kind = klist;
 yyt->yyHead.yyMark = 0;
 yyt->list.Manifest_constant = pManifest_constant;
 yyt->list.List = pList;
 return yyt;
}

tTree mManifest_constant
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_constant])
 yyt->Kind = kManifest_constant;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mManifest_constant0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kManifest_constant0])
 yyt->Kind = kManifest_constant0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCh
# if defined __STDC__ | defined __cplusplus
(int pch, tPosition ppos)
# else
(pch, ppos)
int pch;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCh])
 yyt->Kind = kCh;
 yyt->yyHead.yyMark = 0;
 yyt->Ch.ch = pch;
 yyt->Ch.pos = ppos;
 return yyt;
}

tTree mTrue
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTrue])
 yyt->Kind = kTrue;
 yyt->yyHead.yyMark = 0;
 yyt->True.pos = ppos;
 return yyt;
}

tTree mFalse
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFalse])
 yyt->Kind = kFalse;
 yyt->yyHead.yyMark = 0;
 yyt->False.pos = ppos;
 return yyt;
}

tTree mInt
# if defined __STDC__ | defined __cplusplus
(tTree pSign, long pvalue, tPosition ppos)
# else
(pSign, pvalue, ppos)
tTree pSign;
long pvalue;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kInt])
 yyt->Kind = kInt;
 yyt->yyHead.yyMark = 0;
 yyt->Int.Sign = pSign;
 yyt->Int.value = pvalue;
 yyt->Int.pos = ppos;
 return yyt;
}

tTree mReal
# if defined __STDC__ | defined __cplusplus
(tTree pSign, double pvalue, tPosition ppos)
# else
(pSign, pvalue, ppos)
tTree pSign;
double pvalue;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kReal])
 yyt->Kind = kReal;
 yyt->yyHead.yyMark = 0;
 yyt->Real.Sign = pSign;
 yyt->Real.value = pvalue;
 yyt->Real.pos = ppos;
 return yyt;
}

tTree m_CHARACTER
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_CHARACTER])
 yyt->Kind = k_CHARACTER;
 yyt->yyHead.yyMark = 0;
 yyt->_CHARACTER.pos = ppos;
 return yyt;
}

tTree m_INTEGER
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_INTEGER])
 yyt->Kind = k_INTEGER;
 yyt->yyHead.yyMark = 0;
 yyt->_INTEGER.pos = ppos;
 return yyt;
}

tTree m_REAL
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_REAL])
 yyt->Kind = k_REAL;
 yyt->yyHead.yyMark = 0;
 yyt->_REAL.pos = ppos;
 return yyt;
}

tTree m_DOUBLE
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_DOUBLE])
 yyt->Kind = k_DOUBLE;
 yyt->yyHead.yyMark = 0;
 yyt->_DOUBLE.pos = ppos;
 return yyt;
}

tTree m_BOOLEAN
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_BOOLEAN])
 yyt->Kind = k_BOOLEAN;
 yyt->yyHead.yyMark = 0;
 yyt->_BOOLEAN.pos = ppos;
 return yyt;
}

tTree m_STRING
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_STRING])
 yyt->Kind = k_STRING;
 yyt->yyHead.yyMark = 0;
 yyt->_STRING.pos = ppos;
 return yyt;
}

tTree m_BIT
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_BIT])
 yyt->Kind = k_BIT;
 yyt->yyHead.yyMark = 0;
 yyt->_BIT.pos = ppos;
 return yyt;
}

tTree m_NONE
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [k_NONE])
 yyt->Kind = k_NONE;
 yyt->yyHead.yyMark = 0;
 yyt->_NONE.pos = ppos;
 return yyt;
}

tTree mBitseq
# if defined __STDC__ | defined __cplusplus
(tStringRef pliteral, tPosition ppos)
# else
(pliteral, ppos)
tStringRef pliteral;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBitseq])
 yyt->Kind = kBitseq;
 yyt->yyHead.yyMark = 0;
 yyt->Bitseq.literal = pliteral;
 yyt->Bitseq.pos = ppos;
 return yyt;
}

tTree mString
# if defined __STDC__ | defined __cplusplus
(tStringRef pstring, tPosition ppos)
# else
(pstring, ppos)
tStringRef pstring;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kString])
 yyt->Kind = kString;
 yyt->yyHead.yyMark = 0;
 yyt->String.string = pstring;
 yyt->String.pos = ppos;
 return yyt;
}

tTree mString0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kString0])
 yyt->Kind = kString0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mEntity
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity])
 yyt->Kind = kEntity;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mEntity0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEntity0])
 yyt->Kind = kEntity0;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mCurrent
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCurrent])
 yyt->Kind = kCurrent;
 yyt->yyHead.yyMark = 0;
 yyt->Current.pos = ppos;
 return yyt;
}

tTree mResult
# if defined __STDC__ | defined __cplusplus
(tPosition ppos)
# else
(ppos)
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kResult])
 yyt->Kind = kResult;
 yyt->yyHead.yyMark = 0;
 yyt->Result.pos = ppos;
 return yyt;
}

tTree mId
# if defined __STDC__ | defined __cplusplus
(tIdent pident, tPosition ppos)
# else
(pident, ppos)
tIdent pident;
tPosition ppos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kId])
 yyt->Kind = kId;
 yyt->yyHead.yyMark = 0;
 yyt->Id.ident = pident;
 yyt->Id.pos = ppos;
 return yyt;
}

typedef tTree * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kEiffel:
yyt = yyt->Eiffel.Classes; break;
case kClasses1:
yyMark (yyt->Classes1.Class_declaration);
yyt = yyt->Classes1.Classes; break;
case kClass_declaration:
yyMark (yyt->Class_declaration.Indexing);
yyMark (yyt->Class_declaration.Class_header);
yyMark (yyt->Class_declaration.Formal_generics);
yyMark (yyt->Class_declaration.Obsolete);
yyMark (yyt->Class_declaration.Inheritance);
yyMark (yyt->Class_declaration.Creators);
yyMark (yyt->Class_declaration.Features);
yyt = yyt->Class_declaration.Invariant; break;
case kIndex_list1:
yyMark (yyt->Index_list1.Index_clause);
yyt = yyt->Index_list1.Index_list; break;
case kIndex_clause:
yyMark (yyt->Index_clause.Index);
yyt = yyt->Index_clause.Index_terms; break;
case kClass:
yyt = yyt->Class.Name; break;
case kExpanded_class:
yyt = yyt->Expanded_class.Name; break;
case kDeferred_class:
yyt = yyt->Deferred_class.Name; break;
case kFeatures1:
yyMark (yyt->Features1.Feature_clause);
yyt = yyt->Features1.Features; break;
case kFeature_clause:
yyMark (yyt->Feature_clause.Clients);
yyt = yyt->Feature_clause.Feature_decls; break;
case kClients1:
yyt = yyt->Clients1.List; break;
case kFeature_decls1:
yyMark (yyt->Feature_decls1.Feature_decl);
yyt = yyt->Feature_decls1.Feature_decls; break;
case kFeature_decl:
yyMark (yyt->Feature_decl.New_feature_list);
yyt = yyt->Feature_decl.Declaration_body; break;
case kDeclaration_body:
yyMark (yyt->Declaration_body.Formal_args);
yyMark (yyt->Declaration_body.Type_mark);
yyt = yyt->Declaration_body.Const_or_routine; break;
case kM_const:
yyt = yyt->M_const.Manifest_constant; break;
case kRoutine:
yyMark (yyt->Routine.Obsolete);
yyMark (yyt->Routine.Precondition);
yyMark (yyt->Routine.Local_decls);
yyMark (yyt->Routine.Routine_body);
yyMark (yyt->Routine.Postcondition);
yyt = yyt->Routine.Rescue; break;
case kParent_list1:
yyMark (yyt->Parent_list1.Parent);
yyt = yyt->Parent_list1.Parent_list; break;
case kParent:
yyMark (yyt->Parent.Class_type);
yyt = yyt->Parent.Feature_adaptation; break;
case kFeature_adaptation1:
yyMark (yyt->Feature_adaptation1.Rename);
yyMark (yyt->Feature_adaptation1.New_export);
yyMark (yyt->Feature_adaptation1.Undefine);
yyMark (yyt->Feature_adaptation1.Redefine);
yyt = yyt->Feature_adaptation1.Select; break;
case kRename_list1:
yyMark (yyt->Rename_list1.Rename_pair);
yyt = yyt->Rename_list1.Rename_list; break;
case kRename_pair:
yyMark (yyt->Rename_pair.Name1);
yyt = yyt->Rename_pair.Name2; break;
case kCreators1:
yyMark (yyt->Creators1.Creation_clause);
yyt = yyt->Creators1.Creators; break;
case kCreation_clause:
yyMark (yyt->Creation_clause.Clients);
yyt = yyt->Creation_clause.Feature_list; break;
case kNew_feature_list1:
yyMark (yyt->New_feature_list1.Feature_name);
yyt = yyt->New_feature_list1.New_feature_list; break;
case kFrozen:
yyt = yyt->Frozen.Feature_name; break;
case kIdent_name:
yyt = yyt->Ident_name.Id; break;
case kPrefix:
yyt = yyt->Prefix.Op_name; break;
case kInfix:
yyt = yyt->Infix.Op_name; break;
case kNew_export_list1:
yyMark (yyt->New_export_list1.New_export_item);
yyt = yyt->New_export_list1.New_export_list; break;
case kNew_export_item:
yyMark (yyt->New_export_item.Clients);
yyt = yyt->New_export_item.Feature_set; break;
case kFeature_list1:
yyMark (yyt->Feature_list1.Feature_name);
yyt = yyt->Feature_list1.Feature_list; break;
case kFormal_args1:
yyMark (yyt->Formal_args1.Entity_decl_group);
yyt = yyt->Formal_args1.Formal_args; break;
case kDo_body:
yyt = yyt->Do_body.Compound; break;
case kOnce_body:
yyt = yyt->Once_body.Compound; break;
case kExternal:
yyMark (yyt->External.Lang1);
yyt = yyt->External.Lang2; break;
case kEntity_decl_group:
yyMark (yyt->Entity_decl_group.Id_list);
yyt = yyt->Entity_decl_group.Type_mark; break;
case kFormal_generics1:
yyMark (yyt->Formal_generics1.Formal_generic);
yyt = yyt->Formal_generics1.Formal_generics; break;
case kFormal_generic:
yyMark (yyt->Formal_generic.Id);
yyt = yyt->Formal_generic.Constraint; break;
case kConstraint1:
yyt = yyt->Constraint1.Class_type; break;
case kCompound1:
yyMark (yyt->Compound1.Instruction);
yyt = yyt->Compound1.Compound; break;
case kThen_part_list1:
yyMark (yyt->Then_part_list1.Then_part);
yyt = yyt->Then_part_list1.Then_part_list; break;
case kThen_part:
yyMark (yyt->Then_part.Guard);
yyt = yyt->Then_part.Compound; break;
case kWhen_part_list1:
yyMark (yyt->When_part_list1.When_part);
yyt = yyt->When_part_list1.When_part_list; break;
case kWhen_part:
yyMark (yyt->When_part.Choices);
yyt = yyt->When_part.Compound; break;
case kChoices1:
yyMark (yyt->Choices1.Choice);
yyt = yyt->Choices1.Choices; break;
case kInterval:
yyMark (yyt->Interval.From);
yyt = yyt->Interval.To; break;
case kVal:
yyt = yyt->Val.Manifest_constant; break;
case kCreation:
yyMark (yyt->Creation.Type);
yyMark (yyt->Creation.Entity);
yyt = yyt->Creation.Unqual_call; break;
case kCall_instruct:
yyt = yyt->Call_instruct.Call; break;
case kAssign:
yyMark (yyt->Assign.Addr);
yyt = yyt->Assign.Expression; break;
case kRev_assign:
yyMark (yyt->Rev_assign.Addr);
yyt = yyt->Rev_assign.Expression; break;
case kConditional:
yyMark (yyt->Conditional.Then_part);
yyt = yyt->Conditional.Else_part; break;
case kMulti_branch:
yyMark (yyt->Multi_branch.Guard);
yyMark (yyt->Multi_branch.When_part_list);
yyt = yyt->Multi_branch.Else_part; break;
case kLoop:
yyMark (yyt->Loop.Initialization);
yyMark (yyt->Loop.Invariant);
yyMark (yyt->Loop.Variant);
yyt = yyt->Loop.Loop_body; break;
case kCheck:
yyt = yyt->Check.Assertion; break;
case kDebug:
yyMark (yyt->Debug.Debug_keys);
yyt = yyt->Debug.Compound; break;
case kLoop_body1:
yyMark (yyt->Loop_body1.Exit);
yyt = yyt->Loop_body1.Compound; break;
case kClass_type:
yyMark (yyt->Class_type.Id);
yyt = yyt->Class_type.Actual_generics; break;
case kClass_type_expanded:
yyMark (yyt->Class_type_expanded.Id);
yyt = yyt->Class_type_expanded.Actual_generics; break;
case kBit_type:
yyt = yyt->Bit_type.Manifest_constant; break;
case kSimple_type:
yyt = yyt->Simple_type.Manifest_constant; break;
case kAnchored:
yyt = yyt->Anchored.Entity; break;
case kActual_generics1:
yyt = yyt->Actual_generics1.Type_list; break;
case kCondition1:
yyt = yyt->Condition1.Assertion; break;
case kAssertion1:
yyMark (yyt->Assertion1.Assertion_clause);
yyt = yyt->Assertion1.Assertion; break;
case kAssertion_clause1:
yyMark (yyt->Assertion_clause1.Tag);
yyt = yyt->Assertion_clause1.Expression; break;
case kType_list1:
yyMark (yyt->Type_list1.Type);
yyt = yyt->Type_list1.Type_list; break;
case kCall_chain1:
yyMark (yyt->Call_chain1.Unqual_call);
yyt = yyt->Call_chain1.Call_chain; break;
case kUnqual_call1:
yyMark (yyt->Unqual_call1.Entity);
yyt = yyt->Unqual_call1.Actuals; break;
case kActuals1:
yyt = yyt->Actuals1.Actual_list; break;
case kActual_list1:
yyMark (yyt->Actual_list1.Actual);
yyt = yyt->Actual_list1.Actual_list; break;
case kAddr:
yyt = yyt->Addr.Entity; break;
case kSimple_expr:
yyt = yyt->Simple_expr.Manifest_constant; break;
case kCall:
yyMark (yyt->Call.Qual);
yyt = yyt->Call.Call_chain; break;
case kBin_expr:
yyMark (yyt->Bin_expr.Lop);
yyMark (yyt->Bin_expr.Op);
yyt = yyt->Bin_expr.Rop; break;
case kUn_expr:
yyMark (yyt->Un_expr.Op);
yyt = yyt->Un_expr.Expression; break;
case kParenth:
yyt = yyt->Parenth.Expression; break;
case kManifest_array1:
yyMark (yyt->Manifest_array1.Expression);
yyt = yyt->Manifest_array1.Manifest_array; break;
case kOld:
yyt = yyt->Old.Expression; break;
case kStrip:
yyt = yyt->Strip.List; break;
case klist:
yyMark (yyt->list.Manifest_constant);
yyt = yyt->list.List; break;
case kInt:
yyt = yyt->Int.Sign; break;
case kReal:
yyt = yyt->Real.Sign; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tTree yyTreeStore [yyInitTreeStoreSize];
static tTree * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static Tree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteTree ();

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) (void) fputs ("NoTree", yyf);
 else yyWriteHex ((unsigned char *) & yyt, sizeof (yyt));
 yyWriteNl ();
}

static void yWriteNodeEiffel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Classes"); yyWriteAdr (yyt->Eiffel.Classes);
}

static void yWriteNodeClasses1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Class_declaration"); yyWriteAdr (yyt->Classes1.Class_declaration);
 yyWriteSelector ("Classes"); yyWriteAdr (yyt->Classes1.Classes);
}

static void yWriteNodeClass_declaration
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Indexing"); yyWriteAdr (yyt->Class_declaration.Indexing);
 yyWriteSelector ("Class_header"); yyWriteAdr (yyt->Class_declaration.Class_header);
 yyWriteSelector ("Formal_generics"); yyWriteAdr (yyt->Class_declaration.Formal_generics);
 yyWriteSelector ("Obsolete"); yyWriteAdr (yyt->Class_declaration.Obsolete);
 yyWriteSelector ("Inheritance"); yyWriteAdr (yyt->Class_declaration.Inheritance);
 yyWriteSelector ("Creators"); yyWriteAdr (yyt->Class_declaration.Creators);
 yyWriteSelector ("Features"); yyWriteAdr (yyt->Class_declaration.Features);
 yyWriteSelector ("Invariant"); yyWriteAdr (yyt->Class_declaration.Invariant);
 yyWriteSelector ("comment"); writetStringRef (yyt->Class_declaration.comment) yyWriteNl ();
}

static void yWriteNodeIndex_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Index_clause"); yyWriteAdr (yyt->Index_list1.Index_clause);
 yyWriteSelector ("Index_list"); yyWriteAdr (yyt->Index_list1.Index_list);
}

static void yWriteNodeIndex_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Index"); yyWriteAdr (yyt->Index_clause.Index);
 yyWriteSelector ("Index_terms"); yyWriteAdr (yyt->Index_clause.Index_terms);
}

static void yWriteNodeClass
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); yyWriteAdr (yyt->Class.Name);
}

static void yWriteNodeExpanded_class
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); yyWriteAdr (yyt->Expanded_class.Name);
}

static void yWriteNodeDeferred_class
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); yyWriteAdr (yyt->Deferred_class.Name);
}

static void yWriteNodeFeatures1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Feature_clause"); yyWriteAdr (yyt->Features1.Feature_clause);
 yyWriteSelector ("Features"); yyWriteAdr (yyt->Features1.Features);
}

static void yWriteNodeFeature_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Clients"); yyWriteAdr (yyt->Feature_clause.Clients);
 yyWriteSelector ("comment"); writetStringRef (yyt->Feature_clause.comment) yyWriteNl ();
 yyWriteSelector ("Feature_decls"); yyWriteAdr (yyt->Feature_clause.Feature_decls);
}

static void yWriteNodeClients1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("List"); yyWriteAdr (yyt->Clients1.List);
}

static void yWriteNodeFeature_decls1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Feature_decl"); yyWriteAdr (yyt->Feature_decls1.Feature_decl);
 yyWriteSelector ("Feature_decls"); yyWriteAdr (yyt->Feature_decls1.Feature_decls);
}

static void yWriteNodeFeature_decl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("New_feature_list"); yyWriteAdr (yyt->Feature_decl.New_feature_list);
 yyWriteSelector ("Declaration_body"); yyWriteAdr (yyt->Feature_decl.Declaration_body);
}

static void yWriteNodeDeclaration_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Formal_args"); yyWriteAdr (yyt->Declaration_body.Formal_args);
 yyWriteSelector ("Type_mark"); yyWriteAdr (yyt->Declaration_body.Type_mark);
 yyWriteSelector ("Const_or_routine"); yyWriteAdr (yyt->Declaration_body.Const_or_routine);
}

static void yWriteNodeM_const
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->M_const.Manifest_constant);
}

static void yWriteNodeUnique
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Unique.pos) yyWriteNl ();
}

static void yWriteNodeRoutine
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Obsolete"); yyWriteAdr (yyt->Routine.Obsolete);
 yyWriteSelector ("comment"); writetStringRef (yyt->Routine.comment) yyWriteNl ();
 yyWriteSelector ("Precondition"); yyWriteAdr (yyt->Routine.Precondition);
 yyWriteSelector ("Local_decls"); yyWriteAdr (yyt->Routine.Local_decls);
 yyWriteSelector ("Routine_body"); yyWriteAdr (yyt->Routine.Routine_body);
 yyWriteSelector ("Postcondition"); yyWriteAdr (yyt->Routine.Postcondition);
 yyWriteSelector ("Rescue"); yyWriteAdr (yyt->Routine.Rescue);
 yyWriteSelector ("end_comment"); writetStringRef (yyt->Routine.end_comment) yyWriteNl ();
}

static void yWriteNodeParent_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Parent"); yyWriteAdr (yyt->Parent_list1.Parent);
 yyWriteSelector ("Parent_list"); yyWriteAdr (yyt->Parent_list1.Parent_list);
}

static void yWriteNodeParent
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Class_type"); yyWriteAdr (yyt->Parent.Class_type);
 yyWriteSelector ("Feature_adaptation"); yyWriteAdr (yyt->Parent.Feature_adaptation);
}

static void yWriteNodeFeature_adaptation1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Rename"); yyWriteAdr (yyt->Feature_adaptation1.Rename);
 yyWriteSelector ("New_export"); yyWriteAdr (yyt->Feature_adaptation1.New_export);
 yyWriteSelector ("Undefine"); yyWriteAdr (yyt->Feature_adaptation1.Undefine);
 yyWriteSelector ("Redefine"); yyWriteAdr (yyt->Feature_adaptation1.Redefine);
 yyWriteSelector ("Select"); yyWriteAdr (yyt->Feature_adaptation1.Select);
}

static void yWriteNodeRename_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Rename_pair"); yyWriteAdr (yyt->Rename_list1.Rename_pair);
 yyWriteSelector ("Rename_list"); yyWriteAdr (yyt->Rename_list1.Rename_list);
}

static void yWriteNodeRename_pair
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name1"); yyWriteAdr (yyt->Rename_pair.Name1);
 yyWriteSelector ("Name2"); yyWriteAdr (yyt->Rename_pair.Name2);
}

static void yWriteNodeCreators1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Creation_clause"); yyWriteAdr (yyt->Creators1.Creation_clause);
 yyWriteSelector ("Creators"); yyWriteAdr (yyt->Creators1.Creators);
}

static void yWriteNodeCreation_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Clients"); yyWriteAdr (yyt->Creation_clause.Clients);
 yyWriteSelector ("comment"); writetStringRef (yyt->Creation_clause.comment) yyWriteNl ();
 yyWriteSelector ("Feature_list"); yyWriteAdr (yyt->Creation_clause.Feature_list);
}

static void yWriteNodeNew_feature_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Feature_name"); yyWriteAdr (yyt->New_feature_list1.Feature_name);
 yyWriteSelector ("New_feature_list"); yyWriteAdr (yyt->New_feature_list1.New_feature_list);
}

static void yWriteNodeFrozen
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Feature_name"); yyWriteAdr (yyt->Frozen.Feature_name);
}

static void yWriteNodeIdent_name
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Id"); yyWriteAdr (yyt->Ident_name.Id);
}

static void yWriteNodePrefix
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Op_name"); yyWriteAdr (yyt->Prefix.Op_name);
}

static void yWriteNodeInfix
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Op_name"); yyWriteAdr (yyt->Infix.Op_name);
}

static void yWriteNodeOp_name
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Op_name.pos) yyWriteNl ();
}

static void yWriteNodeFree_op
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeOp_name (yyt); 
 yyWriteSelector ("ident"); writetIdent (yyt->Free_op.ident) yyWriteNl ();
}

static void yWriteNodeOper
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeOp_name (yyt); 
 yyWriteSelector ("op"); writeint (yyt->Oper.op) yyWriteNl ();
}

static void yWriteNodeNew_export_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("New_export_item"); yyWriteAdr (yyt->New_export_list1.New_export_item);
 yyWriteSelector ("New_export_list"); yyWriteAdr (yyt->New_export_list1.New_export_list);
}

static void yWriteNodeNew_export_item
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Clients"); yyWriteAdr (yyt->New_export_item.Clients);
 yyWriteSelector ("Feature_set"); yyWriteAdr (yyt->New_export_item.Feature_set);
}

static void yWriteNodeFeature_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Feature_name"); yyWriteAdr (yyt->Feature_list1.Feature_name);
 yyWriteSelector ("Feature_list"); yyWriteAdr (yyt->Feature_list1.Feature_list);
}

static void yWriteNodeFormal_args1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Entity_decl_group"); yyWriteAdr (yyt->Formal_args1.Entity_decl_group);
 yyWriteSelector ("Formal_args"); yyWriteAdr (yyt->Formal_args1.Formal_args);
}

static void yWriteNodeDo_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Do_body.Compound);
}

static void yWriteNodeOnce_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Once_body.Compound);
}

static void yWriteNodeExternal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Lang1"); yyWriteAdr (yyt->External.Lang1);
 yyWriteSelector ("Lang2"); yyWriteAdr (yyt->External.Lang2);
}

static void yWriteNodeDeferred
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Deferred.pos) yyWriteNl ();
}

static void yWriteNodeEntity_decl_group
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Id_list"); yyWriteAdr (yyt->Entity_decl_group.Id_list);
 yyWriteSelector ("Type_mark"); yyWriteAdr (yyt->Entity_decl_group.Type_mark);
}

static void yWriteNodeFormal_generics1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Formal_generic"); yyWriteAdr (yyt->Formal_generics1.Formal_generic);
 yyWriteSelector ("Formal_generics"); yyWriteAdr (yyt->Formal_generics1.Formal_generics);
}

static void yWriteNodeFormal_generic
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Id"); yyWriteAdr (yyt->Formal_generic.Id);
 yyWriteSelector ("Constraint"); yyWriteAdr (yyt->Formal_generic.Constraint);
}

static void yWriteNodeConstraint1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Class_type"); yyWriteAdr (yyt->Constraint1.Class_type);
}

static void yWriteNodeCompound1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Instruction"); yyWriteAdr (yyt->Compound1.Instruction);
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Compound1.Compound);
}

static void yWriteNodeThen_part_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Then_part"); yyWriteAdr (yyt->Then_part_list1.Then_part);
 yyWriteSelector ("Then_part_list"); yyWriteAdr (yyt->Then_part_list1.Then_part_list);
}

static void yWriteNodeThen_part
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Guard"); yyWriteAdr (yyt->Then_part.Guard);
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Then_part.Compound);
}

static void yWriteNodeWhen_part_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("When_part"); yyWriteAdr (yyt->When_part_list1.When_part);
 yyWriteSelector ("When_part_list"); yyWriteAdr (yyt->When_part_list1.When_part_list);
}

static void yWriteNodeWhen_part
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Choices"); yyWriteAdr (yyt->When_part.Choices);
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->When_part.Compound);
}

static void yWriteNodeChoices1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Choice"); yyWriteAdr (yyt->Choices1.Choice);
 yyWriteSelector ("Choices"); yyWriteAdr (yyt->Choices1.Choices);
}

static void yWriteNodeInterval
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("From"); yyWriteAdr (yyt->Interval.From);
 yyWriteSelector ("To"); yyWriteAdr (yyt->Interval.To);
}

static void yWriteNodeVal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->Val.Manifest_constant);
}

static void yWriteNodeCreation
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Type"); yyWriteAdr (yyt->Creation.Type);
 yyWriteSelector ("Entity"); yyWriteAdr (yyt->Creation.Entity);
 yyWriteSelector ("Unqual_call"); yyWriteAdr (yyt->Creation.Unqual_call);
}

static void yWriteNodeCall_instruct
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Call"); yyWriteAdr (yyt->Call_instruct.Call);
}

static void yWriteNodeAssign
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Addr"); yyWriteAdr (yyt->Assign.Addr);
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Assign.Expression);
}

static void yWriteNodeRev_assign
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Addr"); yyWriteAdr (yyt->Rev_assign.Addr);
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Rev_assign.Expression);
}

static void yWriteNodeConditional
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Then_part"); yyWriteAdr (yyt->Conditional.Then_part);
 yyWriteSelector ("Else_part"); yyWriteAdr (yyt->Conditional.Else_part);
}

static void yWriteNodeMulti_branch
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Guard"); yyWriteAdr (yyt->Multi_branch.Guard);
 yyWriteSelector ("When_part_list"); yyWriteAdr (yyt->Multi_branch.When_part_list);
 yyWriteSelector ("Else_part"); yyWriteAdr (yyt->Multi_branch.Else_part);
}

static void yWriteNodeLoop
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Initialization"); yyWriteAdr (yyt->Loop.Initialization);
 yyWriteSelector ("Invariant"); yyWriteAdr (yyt->Loop.Invariant);
 yyWriteSelector ("Variant"); yyWriteAdr (yyt->Loop.Variant);
 yyWriteSelector ("Loop_body"); yyWriteAdr (yyt->Loop.Loop_body);
}

static void yWriteNodeCheck
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Assertion"); yyWriteAdr (yyt->Check.Assertion);
}

static void yWriteNodeDebug
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Debug_keys"); yyWriteAdr (yyt->Debug.Debug_keys);
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Debug.Compound);
}

static void yWriteNodeRetry
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Retry.pos) yyWriteNl ();
}

static void yWriteNodeLoop_body1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Exit"); yyWriteAdr (yyt->Loop_body1.Exit);
 yyWriteSelector ("Compound"); yyWriteAdr (yyt->Loop_body1.Compound);
}

static void yWriteNodeClass_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Id"); yyWriteAdr (yyt->Class_type.Id);
 yyWriteSelector ("Actual_generics"); yyWriteAdr (yyt->Class_type.Actual_generics);
}

static void yWriteNodeClass_type_expanded
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Id"); yyWriteAdr (yyt->Class_type_expanded.Id);
 yyWriteSelector ("Actual_generics"); yyWriteAdr (yyt->Class_type_expanded.Actual_generics);
}

static void yWriteNodeBit_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->Bit_type.Manifest_constant);
}

static void yWriteNodeSimple_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->Simple_type.Manifest_constant);
}

static void yWriteNodeAnchored
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Entity"); yyWriteAdr (yyt->Anchored.Entity);
}

static void yWriteNodeActual_generics1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Type_list"); yyWriteAdr (yyt->Actual_generics1.Type_list);
}

static void yWriteNodeCondition1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("extension"); writeint (yyt->Condition1.extension) yyWriteNl ();
 yyWriteSelector ("Assertion"); yyWriteAdr (yyt->Condition1.Assertion);
}

static void yWriteNodeAssertion1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Assertion_clause"); yyWriteAdr (yyt->Assertion1.Assertion_clause);
 yyWriteSelector ("Assertion"); yyWriteAdr (yyt->Assertion1.Assertion);
}

static void yWriteNodeAssertion_clause1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Tag"); yyWriteAdr (yyt->Assertion_clause1.Tag);
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Assertion_clause1.Expression);
}

static void yWriteNodeType_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Type"); yyWriteAdr (yyt->Type_list1.Type);
 yyWriteSelector ("Type_list"); yyWriteAdr (yyt->Type_list1.Type_list);
}

static void yWriteNodeCall_chain1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Unqual_call"); yyWriteAdr (yyt->Call_chain1.Unqual_call);
 yyWriteSelector ("Call_chain"); yyWriteAdr (yyt->Call_chain1.Call_chain);
}

static void yWriteNodeUnqual_call1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Entity"); yyWriteAdr (yyt->Unqual_call1.Entity);
 yyWriteSelector ("Actuals"); yyWriteAdr (yyt->Unqual_call1.Actuals);
}

static void yWriteNodeActuals1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Actual_list"); yyWriteAdr (yyt->Actuals1.Actual_list);
}

static void yWriteNodeActual_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Actual"); yyWriteAdr (yyt->Actual_list1.Actual);
 yyWriteSelector ("Actual_list"); yyWriteAdr (yyt->Actual_list1.Actual_list);
}

static void yWriteNodeAddr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Entity"); yyWriteAdr (yyt->Addr.Entity);
}

static void yWriteNodeComment
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("comment"); writetStringRef (yyt->Comment.comment) yyWriteNl ();
}

static void yWriteNodeSimple_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->Simple_expr.Manifest_constant);
}

static void yWriteNodeCall
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Qual"); yyWriteAdr (yyt->Call.Qual);
 yyWriteSelector ("Call_chain"); yyWriteAdr (yyt->Call.Call_chain);
}

static void yWriteNodeBin_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Lop"); yyWriteAdr (yyt->Bin_expr.Lop);
 yyWriteSelector ("Op"); yyWriteAdr (yyt->Bin_expr.Op);
 yyWriteSelector ("Rop"); yyWriteAdr (yyt->Bin_expr.Rop);
}

static void yWriteNodeUn_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Op"); yyWriteAdr (yyt->Un_expr.Op);
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Un_expr.Expression);
}

static void yWriteNodeParenth
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Parenth.Expression);
}

static void yWriteNodeManifest_array1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Manifest_array1.Expression);
 yyWriteSelector ("Manifest_array"); yyWriteAdr (yyt->Manifest_array1.Manifest_array);
}

static void yWriteNodeOld
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Expression"); yyWriteAdr (yyt->Old.Expression);
}

static void yWriteNodeStrip
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("List"); yyWriteAdr (yyt->Strip.List);
}

static void yWriteNodelist
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Manifest_constant"); yyWriteAdr (yyt->list.Manifest_constant);
 yyWriteSelector ("List"); yyWriteAdr (yyt->list.List);
}

static void yWriteNodeCh
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ch"); writeint (yyt->Ch.ch) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->Ch.pos) yyWriteNl ();
}

static void yWriteNodeTrue
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->True.pos) yyWriteNl ();
}

static void yWriteNodeFalse
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->False.pos) yyWriteNl ();
}

static void yWriteNodeInt
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Sign"); yyWriteAdr (yyt->Int.Sign);
 yyWriteSelector ("value"); writelong (yyt->Int.value) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->Int.pos) yyWriteNl ();
}

static void yWriteNodeReal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Sign"); yyWriteAdr (yyt->Real.Sign);
 yyWriteSelector ("value"); writedouble (yyt->Real.value) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->Real.pos) yyWriteNl ();
}

static void yWriteNode_CHARACTER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_CHARACTER.pos) yyWriteNl ();
}

static void yWriteNode_INTEGER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_INTEGER.pos) yyWriteNl ();
}

static void yWriteNode_REAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_REAL.pos) yyWriteNl ();
}

static void yWriteNode_DOUBLE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_DOUBLE.pos) yyWriteNl ();
}

static void yWriteNode_BOOLEAN
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_BOOLEAN.pos) yyWriteNl ();
}

static void yWriteNode_STRING
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_STRING.pos) yyWriteNl ();
}

static void yWriteNode_BIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_BIT.pos) yyWriteNl ();
}

static void yWriteNode_NONE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->_NONE.pos) yyWriteNl ();
}

static void yWriteNodeBitseq
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("literal"); writetStringRef (yyt->Bitseq.literal) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->Bitseq.pos) yyWriteNl ();
}

static void yWriteNodeString
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("string"); writetStringRef (yyt->String.string) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->String.pos) yyWriteNl ();
}

static void yWriteNodeCurrent
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Current.pos) yyWriteNl ();
}

static void yWriteNodeResult
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("pos"); writetPosition (yyt->Result.pos) yyWriteNl ();
}

static void yWriteNodeId
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ident"); writetIdent (yyt->Id.ident) yyWriteNl ();
 yyWriteSelector ("pos"); writetPosition (yyt->Id.pos) yyWriteNl ();
}

void WriteTreeNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoTree) { (void) fputs ("NoTree\n", yyf); return; }

 switch (yyt->Kind) {
case kEiffel: (void) fputs (Tree_NodeName [kEiffel], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEiffel (yyt); break;
case kClasses: (void) fputs (Tree_NodeName [kClasses], yyf); (void) fputc ('\n', yyf);
 break;
case kClasses0: (void) fputs (Tree_NodeName [kClasses0], yyf); (void) fputc ('\n', yyf);
 break;
case kClasses1: (void) fputs (Tree_NodeName [kClasses1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClasses1 (yyt); break;
case kClass_declaration: (void) fputs (Tree_NodeName [kClass_declaration], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClass_declaration (yyt); break;
case kIndex_list: (void) fputs (Tree_NodeName [kIndex_list], yyf); (void) fputc ('\n', yyf);
 break;
case kIndex_list0: (void) fputs (Tree_NodeName [kIndex_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kIndex_list1: (void) fputs (Tree_NodeName [kIndex_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIndex_list1 (yyt); break;
case kIndex_clause: (void) fputs (Tree_NodeName [kIndex_clause], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIndex_clause (yyt); break;
case kClass_header: (void) fputs (Tree_NodeName [kClass_header], yyf); (void) fputc ('\n', yyf);
 break;
case kClass_header0: (void) fputs (Tree_NodeName [kClass_header0], yyf); (void) fputc ('\n', yyf);
 break;
case kClass: (void) fputs (Tree_NodeName [kClass], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClass (yyt); break;
case kExpanded_class: (void) fputs (Tree_NodeName [kExpanded_class], yyf); (void) fputc ('\n', yyf);
 yWriteNodeExpanded_class (yyt); break;
case kDeferred_class: (void) fputs (Tree_NodeName [kDeferred_class], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDeferred_class (yyt); break;
case kFeatures: (void) fputs (Tree_NodeName [kFeatures], yyf); (void) fputc ('\n', yyf);
 break;
case kFeatures0: (void) fputs (Tree_NodeName [kFeatures0], yyf); (void) fputc ('\n', yyf);
 break;
case kFeatures1: (void) fputs (Tree_NodeName [kFeatures1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeatures1 (yyt); break;
case kFeature_clause: (void) fputs (Tree_NodeName [kFeature_clause], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeature_clause (yyt); break;
case kClients: (void) fputs (Tree_NodeName [kClients], yyf); (void) fputc ('\n', yyf);
 break;
case kClients0: (void) fputs (Tree_NodeName [kClients0], yyf); (void) fputc ('\n', yyf);
 break;
case kClients1: (void) fputs (Tree_NodeName [kClients1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClients1 (yyt); break;
case kFeature_decls: (void) fputs (Tree_NodeName [kFeature_decls], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_decls0: (void) fputs (Tree_NodeName [kFeature_decls0], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_decls1: (void) fputs (Tree_NodeName [kFeature_decls1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeature_decls1 (yyt); break;
case kFeature_decl: (void) fputs (Tree_NodeName [kFeature_decl], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeature_decl (yyt); break;
case kDeclaration_body: (void) fputs (Tree_NodeName [kDeclaration_body], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDeclaration_body (yyt); break;
case kConst_or_routine: (void) fputs (Tree_NodeName [kConst_or_routine], yyf); (void) fputc ('\n', yyf);
 break;
case kConst_or_routine0: (void) fputs (Tree_NodeName [kConst_or_routine0], yyf); (void) fputc ('\n', yyf);
 break;
case kM_const: (void) fputs (Tree_NodeName [kM_const], yyf); (void) fputc ('\n', yyf);
 yWriteNodeM_const (yyt); break;
case kUnique: (void) fputs (Tree_NodeName [kUnique], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUnique (yyt); break;
case kRoutine: (void) fputs (Tree_NodeName [kRoutine], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRoutine (yyt); break;
case kParent_list: (void) fputs (Tree_NodeName [kParent_list], yyf); (void) fputc ('\n', yyf);
 break;
case kParent_list0: (void) fputs (Tree_NodeName [kParent_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kParent_list1: (void) fputs (Tree_NodeName [kParent_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeParent_list1 (yyt); break;
case kParent: (void) fputs (Tree_NodeName [kParent], yyf); (void) fputc ('\n', yyf);
 yWriteNodeParent (yyt); break;
case kFeature_adaptation: (void) fputs (Tree_NodeName [kFeature_adaptation], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_adaptation0: (void) fputs (Tree_NodeName [kFeature_adaptation0], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_adaptation1: (void) fputs (Tree_NodeName [kFeature_adaptation1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeature_adaptation1 (yyt); break;
case kRename_list: (void) fputs (Tree_NodeName [kRename_list], yyf); (void) fputc ('\n', yyf);
 break;
case kRename_list0: (void) fputs (Tree_NodeName [kRename_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kRename_list1: (void) fputs (Tree_NodeName [kRename_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRename_list1 (yyt); break;
case kRename_pair: (void) fputs (Tree_NodeName [kRename_pair], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRename_pair (yyt); break;
case kCreators: (void) fputs (Tree_NodeName [kCreators], yyf); (void) fputc ('\n', yyf);
 break;
case kCreators0: (void) fputs (Tree_NodeName [kCreators0], yyf); (void) fputc ('\n', yyf);
 break;
case kCreators1: (void) fputs (Tree_NodeName [kCreators1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCreators1 (yyt); break;
case kCreation_clause: (void) fputs (Tree_NodeName [kCreation_clause], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCreation_clause (yyt); break;
case kNew_feature_list: (void) fputs (Tree_NodeName [kNew_feature_list], yyf); (void) fputc ('\n', yyf);
 break;
case kNew_feature_list0: (void) fputs (Tree_NodeName [kNew_feature_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kNew_feature_list1: (void) fputs (Tree_NodeName [kNew_feature_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNew_feature_list1 (yyt); break;
case kFeature_name: (void) fputs (Tree_NodeName [kFeature_name], yyf); (void) fputc ('\n', yyf);
 break;
case kFrozen: (void) fputs (Tree_NodeName [kFrozen], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFrozen (yyt); break;
case kIdent_name: (void) fputs (Tree_NodeName [kIdent_name], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIdent_name (yyt); break;
case kOp: (void) fputs (Tree_NodeName [kOp], yyf); (void) fputc ('\n', yyf);
 break;
case kPrefix: (void) fputs (Tree_NodeName [kPrefix], yyf); (void) fputc ('\n', yyf);
 yWriteNodePrefix (yyt); break;
case kInfix: (void) fputs (Tree_NodeName [kInfix], yyf); (void) fputc ('\n', yyf);
 yWriteNodeInfix (yyt); break;
case kOp_name: (void) fputs (Tree_NodeName [kOp_name], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOp_name (yyt); break;
case kFree_op: (void) fputs (Tree_NodeName [kFree_op], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFree_op (yyt); break;
case kOper: (void) fputs (Tree_NodeName [kOper], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOper (yyt); break;
case kNew_export_list: (void) fputs (Tree_NodeName [kNew_export_list], yyf); (void) fputc ('\n', yyf);
 break;
case kNew_export_list0: (void) fputs (Tree_NodeName [kNew_export_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kNew_export_list1: (void) fputs (Tree_NodeName [kNew_export_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNew_export_list1 (yyt); break;
case kNew_export_item: (void) fputs (Tree_NodeName [kNew_export_item], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNew_export_item (yyt); break;
case kFeature_list: (void) fputs (Tree_NodeName [kFeature_list], yyf); (void) fputc ('\n', yyf);
 break;
case kAll: (void) fputs (Tree_NodeName [kAll], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_list0: (void) fputs (Tree_NodeName [kFeature_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kFeature_list1: (void) fputs (Tree_NodeName [kFeature_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFeature_list1 (yyt); break;
case kFormal_args: (void) fputs (Tree_NodeName [kFormal_args], yyf); (void) fputc ('\n', yyf);
 break;
case kFormal_args0: (void) fputs (Tree_NodeName [kFormal_args0], yyf); (void) fputc ('\n', yyf);
 break;
case kFormal_args1: (void) fputs (Tree_NodeName [kFormal_args1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFormal_args1 (yyt); break;
case kRoutine_body: (void) fputs (Tree_NodeName [kRoutine_body], yyf); (void) fputc ('\n', yyf);
 break;
case kRoutine_body0: (void) fputs (Tree_NodeName [kRoutine_body0], yyf); (void) fputc ('\n', yyf);
 break;
case kEffective: (void) fputs (Tree_NodeName [kEffective], yyf); (void) fputc ('\n', yyf);
 break;
case kInternal: (void) fputs (Tree_NodeName [kInternal], yyf); (void) fputc ('\n', yyf);
 break;
case kDo_body: (void) fputs (Tree_NodeName [kDo_body], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDo_body (yyt); break;
case kOnce_body: (void) fputs (Tree_NodeName [kOnce_body], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOnce_body (yyt); break;
case kExternal: (void) fputs (Tree_NodeName [kExternal], yyf); (void) fputc ('\n', yyf);
 yWriteNodeExternal (yyt); break;
case kDeferred: (void) fputs (Tree_NodeName [kDeferred], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDeferred (yyt); break;
case kEntity_decl_group: (void) fputs (Tree_NodeName [kEntity_decl_group], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEntity_decl_group (yyt); break;
case kFormal_generics: (void) fputs (Tree_NodeName [kFormal_generics], yyf); (void) fputc ('\n', yyf);
 break;
case kFormal_generics0: (void) fputs (Tree_NodeName [kFormal_generics0], yyf); (void) fputc ('\n', yyf);
 break;
case kFormal_generics1: (void) fputs (Tree_NodeName [kFormal_generics1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFormal_generics1 (yyt); break;
case kFormal_generic: (void) fputs (Tree_NodeName [kFormal_generic], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFormal_generic (yyt); break;
case kConstraint: (void) fputs (Tree_NodeName [kConstraint], yyf); (void) fputc ('\n', yyf);
 break;
case kConstraint0: (void) fputs (Tree_NodeName [kConstraint0], yyf); (void) fputc ('\n', yyf);
 break;
case kConstraint1: (void) fputs (Tree_NodeName [kConstraint1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeConstraint1 (yyt); break;
case kCompound: (void) fputs (Tree_NodeName [kCompound], yyf); (void) fputc ('\n', yyf);
 break;
case kCompound0: (void) fputs (Tree_NodeName [kCompound0], yyf); (void) fputc ('\n', yyf);
 break;
case kCompound1: (void) fputs (Tree_NodeName [kCompound1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCompound1 (yyt); break;
case kThen_part_list: (void) fputs (Tree_NodeName [kThen_part_list], yyf); (void) fputc ('\n', yyf);
 break;
case kThen_part_list0: (void) fputs (Tree_NodeName [kThen_part_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kThen_part_list1: (void) fputs (Tree_NodeName [kThen_part_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeThen_part_list1 (yyt); break;
case kThen_part: (void) fputs (Tree_NodeName [kThen_part], yyf); (void) fputc ('\n', yyf);
 yWriteNodeThen_part (yyt); break;
case kWhen_part_list: (void) fputs (Tree_NodeName [kWhen_part_list], yyf); (void) fputc ('\n', yyf);
 break;
case kWhen_part_list0: (void) fputs (Tree_NodeName [kWhen_part_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kWhen_part_list1: (void) fputs (Tree_NodeName [kWhen_part_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeWhen_part_list1 (yyt); break;
case kWhen_part: (void) fputs (Tree_NodeName [kWhen_part], yyf); (void) fputc ('\n', yyf);
 yWriteNodeWhen_part (yyt); break;
case kChoices: (void) fputs (Tree_NodeName [kChoices], yyf); (void) fputc ('\n', yyf);
 break;
case kChoices0: (void) fputs (Tree_NodeName [kChoices0], yyf); (void) fputc ('\n', yyf);
 break;
case kChoices1: (void) fputs (Tree_NodeName [kChoices1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeChoices1 (yyt); break;
case kChoice: (void) fputs (Tree_NodeName [kChoice], yyf); (void) fputc ('\n', yyf);
 break;
case kInterval: (void) fputs (Tree_NodeName [kInterval], yyf); (void) fputc ('\n', yyf);
 yWriteNodeInterval (yyt); break;
case kVal: (void) fputs (Tree_NodeName [kVal], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVal (yyt); break;
case kInstruction: (void) fputs (Tree_NodeName [kInstruction], yyf); (void) fputc ('\n', yyf);
 break;
case kInstruction0: (void) fputs (Tree_NodeName [kInstruction0], yyf); (void) fputc ('\n', yyf);
 break;
case kCreation: (void) fputs (Tree_NodeName [kCreation], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCreation (yyt); break;
case kCall_instruct: (void) fputs (Tree_NodeName [kCall_instruct], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCall_instruct (yyt); break;
case kAssign: (void) fputs (Tree_NodeName [kAssign], yyf); (void) fputc ('\n', yyf);
 yWriteNodeAssign (yyt); break;
case kRev_assign: (void) fputs (Tree_NodeName [kRev_assign], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRev_assign (yyt); break;
case kConditional: (void) fputs (Tree_NodeName [kConditional], yyf); (void) fputc ('\n', yyf);
 yWriteNodeConditional (yyt); break;
case kMulti_branch: (void) fputs (Tree_NodeName [kMulti_branch], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMulti_branch (yyt); break;
case kLoop: (void) fputs (Tree_NodeName [kLoop], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLoop (yyt); break;
case kCheck: (void) fputs (Tree_NodeName [kCheck], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCheck (yyt); break;
case kDebug: (void) fputs (Tree_NodeName [kDebug], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDebug (yyt); break;
case kRetry: (void) fputs (Tree_NodeName [kRetry], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRetry (yyt); break;
case kLoop_body: (void) fputs (Tree_NodeName [kLoop_body], yyf); (void) fputc ('\n', yyf);
 break;
case kLoop_body0: (void) fputs (Tree_NodeName [kLoop_body0], yyf); (void) fputc ('\n', yyf);
 break;
case kLoop_body1: (void) fputs (Tree_NodeName [kLoop_body1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLoop_body1 (yyt); break;
case kType: (void) fputs (Tree_NodeName [kType], yyf); (void) fputc ('\n', yyf);
 break;
case kType0: (void) fputs (Tree_NodeName [kType0], yyf); (void) fputc ('\n', yyf);
 break;
case kClass_type: (void) fputs (Tree_NodeName [kClass_type], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClass_type (yyt); break;
case kClass_type_expanded: (void) fputs (Tree_NodeName [kClass_type_expanded], yyf); (void) fputc ('\n', yyf);
 yWriteNodeClass_type_expanded (yyt); break;
case kBit_type: (void) fputs (Tree_NodeName [kBit_type], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBit_type (yyt); break;
case kSimple_type: (void) fputs (Tree_NodeName [kSimple_type], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSimple_type (yyt); break;
case kAnchored: (void) fputs (Tree_NodeName [kAnchored], yyf); (void) fputc ('\n', yyf);
 yWriteNodeAnchored (yyt); break;
case kActual_generics: (void) fputs (Tree_NodeName [kActual_generics], yyf); (void) fputc ('\n', yyf);
 break;
case kActual_generics0: (void) fputs (Tree_NodeName [kActual_generics0], yyf); (void) fputc ('\n', yyf);
 break;
case kActual_generics1: (void) fputs (Tree_NodeName [kActual_generics1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeActual_generics1 (yyt); break;
case kCondition: (void) fputs (Tree_NodeName [kCondition], yyf); (void) fputc ('\n', yyf);
 break;
case kCondition0: (void) fputs (Tree_NodeName [kCondition0], yyf); (void) fputc ('\n', yyf);
 break;
case kCondition1: (void) fputs (Tree_NodeName [kCondition1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCondition1 (yyt); break;
case kAssertion: (void) fputs (Tree_NodeName [kAssertion], yyf); (void) fputc ('\n', yyf);
 break;
case kAssertion0: (void) fputs (Tree_NodeName [kAssertion0], yyf); (void) fputc ('\n', yyf);
 break;
case kAssertion1: (void) fputs (Tree_NodeName [kAssertion1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeAssertion1 (yyt); break;
case kAssertion_clause: (void) fputs (Tree_NodeName [kAssertion_clause], yyf); (void) fputc ('\n', yyf);
 break;
case kAssertion_clause0: (void) fputs (Tree_NodeName [kAssertion_clause0], yyf); (void) fputc ('\n', yyf);
 break;
case kAssertion_clause1: (void) fputs (Tree_NodeName [kAssertion_clause1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeAssertion_clause1 (yyt); break;
case kType_list: (void) fputs (Tree_NodeName [kType_list], yyf); (void) fputc ('\n', yyf);
 break;
case kType_list0: (void) fputs (Tree_NodeName [kType_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kType_list1: (void) fputs (Tree_NodeName [kType_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeType_list1 (yyt); break;
case kCall_chain: (void) fputs (Tree_NodeName [kCall_chain], yyf); (void) fputc ('\n', yyf);
 break;
case kCall_chain0: (void) fputs (Tree_NodeName [kCall_chain0], yyf); (void) fputc ('\n', yyf);
 break;
case kCall_chain1: (void) fputs (Tree_NodeName [kCall_chain1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCall_chain1 (yyt); break;
case kUnqual_call: (void) fputs (Tree_NodeName [kUnqual_call], yyf); (void) fputc ('\n', yyf);
 break;
case kUnqual_call0: (void) fputs (Tree_NodeName [kUnqual_call0], yyf); (void) fputc ('\n', yyf);
 break;
case kUnqual_call1: (void) fputs (Tree_NodeName [kUnqual_call1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUnqual_call1 (yyt); break;
case kActuals: (void) fputs (Tree_NodeName [kActuals], yyf); (void) fputc ('\n', yyf);
 break;
case kActuals0: (void) fputs (Tree_NodeName [kActuals0], yyf); (void) fputc ('\n', yyf);
 break;
case kActuals1: (void) fputs (Tree_NodeName [kActuals1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeActuals1 (yyt); break;
case kActual_list: (void) fputs (Tree_NodeName [kActual_list], yyf); (void) fputc ('\n', yyf);
 break;
case kActual_list0: (void) fputs (Tree_NodeName [kActual_list0], yyf); (void) fputc ('\n', yyf);
 break;
case kActual_list1: (void) fputs (Tree_NodeName [kActual_list1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeActual_list1 (yyt); break;
case kActual: (void) fputs (Tree_NodeName [kActual], yyf); (void) fputc ('\n', yyf);
 break;
case kAddr: (void) fputs (Tree_NodeName [kAddr], yyf); (void) fputc ('\n', yyf);
 yWriteNodeAddr (yyt); break;
case kExpression: (void) fputs (Tree_NodeName [kExpression], yyf); (void) fputc ('\n', yyf);
 break;
case kExpression0: (void) fputs (Tree_NodeName [kExpression0], yyf); (void) fputc ('\n', yyf);
 break;
case kComment: (void) fputs (Tree_NodeName [kComment], yyf); (void) fputc ('\n', yyf);
 yWriteNodeComment (yyt); break;
case kSimple_expr: (void) fputs (Tree_NodeName [kSimple_expr], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSimple_expr (yyt); break;
case kCall: (void) fputs (Tree_NodeName [kCall], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCall (yyt); break;
case kBin_expr: (void) fputs (Tree_NodeName [kBin_expr], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBin_expr (yyt); break;
case kUn_expr: (void) fputs (Tree_NodeName [kUn_expr], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUn_expr (yyt); break;
case kParenth: (void) fputs (Tree_NodeName [kParenth], yyf); (void) fputc ('\n', yyf);
 yWriteNodeParenth (yyt); break;
case kManifest_array: (void) fputs (Tree_NodeName [kManifest_array], yyf); (void) fputc ('\n', yyf);
 break;
case kManifest_array0: (void) fputs (Tree_NodeName [kManifest_array0], yyf); (void) fputc ('\n', yyf);
 break;
case kManifest_array1: (void) fputs (Tree_NodeName [kManifest_array1], yyf); (void) fputc ('\n', yyf);
 yWriteNodeManifest_array1 (yyt); break;
case kOld: (void) fputs (Tree_NodeName [kOld], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOld (yyt); break;
case kStrip: (void) fputs (Tree_NodeName [kStrip], yyf); (void) fputc ('\n', yyf);
 yWriteNodeStrip (yyt); break;
case kList: (void) fputs (Tree_NodeName [kList], yyf); (void) fputc ('\n', yyf);
 break;
case knolist: (void) fputs (Tree_NodeName [knolist], yyf); (void) fputc ('\n', yyf);
 break;
case klist: (void) fputs (Tree_NodeName [klist], yyf); (void) fputc ('\n', yyf);
 yWriteNodelist (yyt); break;
case kManifest_constant: (void) fputs (Tree_NodeName [kManifest_constant], yyf); (void) fputc ('\n', yyf);
 break;
case kManifest_constant0: (void) fputs (Tree_NodeName [kManifest_constant0], yyf); (void) fputc ('\n', yyf);
 break;
case kCh: (void) fputs (Tree_NodeName [kCh], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCh (yyt); break;
case kTrue: (void) fputs (Tree_NodeName [kTrue], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTrue (yyt); break;
case kFalse: (void) fputs (Tree_NodeName [kFalse], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFalse (yyt); break;
case kInt: (void) fputs (Tree_NodeName [kInt], yyf); (void) fputc ('\n', yyf);
 yWriteNodeInt (yyt); break;
case kReal: (void) fputs (Tree_NodeName [kReal], yyf); (void) fputc ('\n', yyf);
 yWriteNodeReal (yyt); break;
case k_CHARACTER: (void) fputs (Tree_NodeName [k_CHARACTER], yyf); (void) fputc ('\n', yyf);
 yWriteNode_CHARACTER (yyt); break;
case k_INTEGER: (void) fputs (Tree_NodeName [k_INTEGER], yyf); (void) fputc ('\n', yyf);
 yWriteNode_INTEGER (yyt); break;
case k_REAL: (void) fputs (Tree_NodeName [k_REAL], yyf); (void) fputc ('\n', yyf);
 yWriteNode_REAL (yyt); break;
case k_DOUBLE: (void) fputs (Tree_NodeName [k_DOUBLE], yyf); (void) fputc ('\n', yyf);
 yWriteNode_DOUBLE (yyt); break;
case k_BOOLEAN: (void) fputs (Tree_NodeName [k_BOOLEAN], yyf); (void) fputc ('\n', yyf);
 yWriteNode_BOOLEAN (yyt); break;
case k_STRING: (void) fputs (Tree_NodeName [k_STRING], yyf); (void) fputc ('\n', yyf);
 yWriteNode_STRING (yyt); break;
case k_BIT: (void) fputs (Tree_NodeName [k_BIT], yyf); (void) fputc ('\n', yyf);
 yWriteNode_BIT (yyt); break;
case k_NONE: (void) fputs (Tree_NodeName [k_NONE], yyf); (void) fputc ('\n', yyf);
 yWriteNode_NONE (yyt); break;
case kBitseq: (void) fputs (Tree_NodeName [kBitseq], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBitseq (yyt); break;
case kString: (void) fputs (Tree_NodeName [kString], yyf); (void) fputc ('\n', yyf);
 yWriteNodeString (yyt); break;
case kString0: (void) fputs (Tree_NodeName [kString0], yyf); (void) fputc ('\n', yyf);
 break;
case kEntity: (void) fputs (Tree_NodeName [kEntity], yyf); (void) fputc ('\n', yyf);
 break;
case kEntity0: (void) fputs (Tree_NodeName [kEntity0], yyf); (void) fputc ('\n', yyf);
 break;
case kCurrent: (void) fputs (Tree_NodeName [kCurrent], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCurrent (yyt); break;
case kResult: (void) fputs (Tree_NodeName [kResult], yyf); (void) fputc ('\n', yyf);
 yWriteNodeResult (yyt); break;
case kId: (void) fputs (Tree_NodeName [kId], yyf); (void) fputc ('\n', yyf);
 yWriteNodeId (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tTree yyt)
# else
 (yys, yyt) char * yys; tTree yyt;
# endif
{ yyIndentSelector (yys); writetTree (yyt) }

static void yWriteEiffel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEiffel], yyf); (void) fputc ('\n', yyf);
}

static void yWriteClasses1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClasses1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Class_declaration", yyt->Classes1.Class_declaration);
}

static void yWriteClass_declaration
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClass_declaration], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Indexing", yyt->Class_declaration.Indexing);
 yyIndentSelectorTree ("Class_header", yyt->Class_declaration.Class_header);
 yyIndentSelectorTree ("Formal_generics", yyt->Class_declaration.Formal_generics);
 yyIndentSelectorTree ("Obsolete", yyt->Class_declaration.Obsolete);
 yyIndentSelectorTree ("Inheritance", yyt->Class_declaration.Inheritance);
 yyIndentSelectorTree ("Creators", yyt->Class_declaration.Creators);
 yyIndentSelectorTree ("Features", yyt->Class_declaration.Features);
 yyIndentSelector ("comment"); writetStringRef (yyt->Class_declaration.comment) yyWriteNl ();
}

static void yWriteIndex_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIndex_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Index_clause", yyt->Index_list1.Index_clause);
}

static void yWriteIndex_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIndex_clause], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Index", yyt->Index_clause.Index);
}

static void yWriteClass
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClass], yyf); (void) fputc ('\n', yyf);
}

static void yWriteExpanded_class
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kExpanded_class], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDeferred_class
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDeferred_class], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFeatures1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeatures1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Feature_clause", yyt->Features1.Feature_clause);
}

static void yWriteFeature_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeature_clause], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Clients", yyt->Feature_clause.Clients);
 yyIndentSelector ("comment"); writetStringRef (yyt->Feature_clause.comment) yyWriteNl ();
}

static void yWriteClients1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClients1], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFeature_decls1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeature_decls1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Feature_decl", yyt->Feature_decls1.Feature_decl);
}

static void yWriteFeature_decl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeature_decl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("New_feature_list", yyt->Feature_decl.New_feature_list);
}

static void yWriteDeclaration_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDeclaration_body], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Formal_args", yyt->Declaration_body.Formal_args);
 yyIndentSelectorTree ("Type_mark", yyt->Declaration_body.Type_mark);
}

static void yWriteM_const
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kM_const], yyf); (void) fputc ('\n', yyf);
}

static void yWriteUnique
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUnique], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Unique.pos) yyWriteNl ();
}

static void yWriteRoutine
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRoutine], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Obsolete", yyt->Routine.Obsolete);
 yyIndentSelector ("comment"); writetStringRef (yyt->Routine.comment) yyWriteNl ();
 yyIndentSelectorTree ("Precondition", yyt->Routine.Precondition);
 yyIndentSelectorTree ("Local_decls", yyt->Routine.Local_decls);
 yyIndentSelectorTree ("Routine_body", yyt->Routine.Routine_body);
 yyIndentSelectorTree ("Postcondition", yyt->Routine.Postcondition);
 yyIndentSelector ("end_comment"); writetStringRef (yyt->Routine.end_comment) yyWriteNl ();
}

static void yWriteParent_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kParent_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Parent", yyt->Parent_list1.Parent);
}

static void yWriteParent
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kParent], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Class_type", yyt->Parent.Class_type);
}

static void yWriteFeature_adaptation1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeature_adaptation1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Rename", yyt->Feature_adaptation1.Rename);
 yyIndentSelectorTree ("New_export", yyt->Feature_adaptation1.New_export);
 yyIndentSelectorTree ("Undefine", yyt->Feature_adaptation1.Undefine);
 yyIndentSelectorTree ("Redefine", yyt->Feature_adaptation1.Redefine);
}

static void yWriteRename_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRename_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Rename_pair", yyt->Rename_list1.Rename_pair);
}

static void yWriteRename_pair
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRename_pair], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Name1", yyt->Rename_pair.Name1);
}

static void yWriteCreators1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCreators1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Creation_clause", yyt->Creators1.Creation_clause);
}

static void yWriteCreation_clause
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCreation_clause], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Clients", yyt->Creation_clause.Clients);
 yyIndentSelector ("comment"); writetStringRef (yyt->Creation_clause.comment) yyWriteNl ();
}

static void yWriteNew_feature_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNew_feature_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Feature_name", yyt->New_feature_list1.Feature_name);
}

static void yWriteFrozen
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFrozen], yyf); (void) fputc ('\n', yyf);
}

static void yWriteIdent_name
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIdent_name], yyf); (void) fputc ('\n', yyf);
}

static void yWritePrefix
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPrefix], yyf); (void) fputc ('\n', yyf);
}

static void yWriteInfix
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kInfix], yyf); (void) fputc ('\n', yyf);
}

static void yWriteOp_name
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOp_name], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Op_name.pos) yyWriteNl ();
}

static void yWriteFree_op
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFree_op], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Free_op.pos) yyWriteNl ();
 yyIndentSelector ("ident"); writetIdent (yyt->Free_op.ident) yyWriteNl ();
}

static void yWriteOper
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOper], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Oper.pos) yyWriteNl ();
 yyIndentSelector ("op"); writeint (yyt->Oper.op) yyWriteNl ();
}

static void yWriteNew_export_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNew_export_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("New_export_item", yyt->New_export_list1.New_export_item);
}

static void yWriteNew_export_item
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNew_export_item], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Clients", yyt->New_export_item.Clients);
}

static void yWriteFeature_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFeature_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Feature_name", yyt->Feature_list1.Feature_name);
}

static void yWriteFormal_args1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFormal_args1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Entity_decl_group", yyt->Formal_args1.Entity_decl_group);
}

static void yWriteDo_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDo_body], yyf); (void) fputc ('\n', yyf);
}

static void yWriteOnce_body
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOnce_body], yyf); (void) fputc ('\n', yyf);
}

static void yWriteExternal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kExternal], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Lang1", yyt->External.Lang1);
}

static void yWriteDeferred
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDeferred], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Deferred.pos) yyWriteNl ();
}

static void yWriteEntity_decl_group
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEntity_decl_group], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Id_list", yyt->Entity_decl_group.Id_list);
}

static void yWriteFormal_generics1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFormal_generics1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Formal_generic", yyt->Formal_generics1.Formal_generic);
}

static void yWriteFormal_generic
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFormal_generic], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Id", yyt->Formal_generic.Id);
}

static void yWriteConstraint1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kConstraint1], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCompound1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCompound1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Instruction", yyt->Compound1.Instruction);
}

static void yWriteThen_part_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kThen_part_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Then_part", yyt->Then_part_list1.Then_part);
}

static void yWriteThen_part
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kThen_part], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Guard", yyt->Then_part.Guard);
}

static void yWriteWhen_part_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kWhen_part_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("When_part", yyt->When_part_list1.When_part);
}

static void yWriteWhen_part
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kWhen_part], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Choices", yyt->When_part.Choices);
}

static void yWriteChoices1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kChoices1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Choice", yyt->Choices1.Choice);
}

static void yWriteInterval
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kInterval], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("From", yyt->Interval.From);
}

static void yWriteVal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVal], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCreation
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCreation], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Type", yyt->Creation.Type);
 yyIndentSelectorTree ("Entity", yyt->Creation.Entity);
}

static void yWriteCall_instruct
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCall_instruct], yyf); (void) fputc ('\n', yyf);
}

static void yWriteAssign
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kAssign], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Addr", yyt->Assign.Addr);
}

static void yWriteRev_assign
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRev_assign], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Addr", yyt->Rev_assign.Addr);
}

static void yWriteConditional
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kConditional], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Then_part", yyt->Conditional.Then_part);
}

static void yWriteMulti_branch
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMulti_branch], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Guard", yyt->Multi_branch.Guard);
 yyIndentSelectorTree ("When_part_list", yyt->Multi_branch.When_part_list);
}

static void yWriteLoop
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLoop], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Initialization", yyt->Loop.Initialization);
 yyIndentSelectorTree ("Invariant", yyt->Loop.Invariant);
 yyIndentSelectorTree ("Variant", yyt->Loop.Variant);
}

static void yWriteCheck
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCheck], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDebug
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDebug], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Debug_keys", yyt->Debug.Debug_keys);
}

static void yWriteRetry
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRetry], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Retry.pos) yyWriteNl ();
}

static void yWriteLoop_body1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLoop_body1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Exit", yyt->Loop_body1.Exit);
}

static void yWriteClass_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClass_type], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Id", yyt->Class_type.Id);
}

static void yWriteClass_type_expanded
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kClass_type_expanded], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Id", yyt->Class_type_expanded.Id);
}

static void yWriteBit_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBit_type], yyf); (void) fputc ('\n', yyf);
}

static void yWriteSimple_type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSimple_type], yyf); (void) fputc ('\n', yyf);
}

static void yWriteAnchored
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kAnchored], yyf); (void) fputc ('\n', yyf);
}

static void yWriteActual_generics1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kActual_generics1], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCondition1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCondition1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("extension"); writeint (yyt->Condition1.extension) yyWriteNl ();
}

static void yWriteAssertion1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kAssertion1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Assertion_clause", yyt->Assertion1.Assertion_clause);
}

static void yWriteAssertion_clause1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kAssertion_clause1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Tag", yyt->Assertion_clause1.Tag);
}

static void yWriteType_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kType_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Type", yyt->Type_list1.Type);
}

static void yWriteCall_chain1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCall_chain1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Unqual_call", yyt->Call_chain1.Unqual_call);
}

static void yWriteUnqual_call1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUnqual_call1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Entity", yyt->Unqual_call1.Entity);
}

static void yWriteActuals1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kActuals1], yyf); (void) fputc ('\n', yyf);
}

static void yWriteActual_list1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kActual_list1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Actual", yyt->Actual_list1.Actual);
}

static void yWriteAddr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kAddr], yyf); (void) fputc ('\n', yyf);
}

static void yWriteComment
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kComment], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("comment"); writetStringRef (yyt->Comment.comment) yyWriteNl ();
}

static void yWriteSimple_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSimple_expr], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCall
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCall], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Qual", yyt->Call.Qual);
}

static void yWriteBin_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBin_expr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Lop", yyt->Bin_expr.Lop);
 yyIndentSelectorTree ("Op", yyt->Bin_expr.Op);
}

static void yWriteUn_expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUn_expr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Op", yyt->Un_expr.Op);
}

static void yWriteParenth
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kParenth], yyf); (void) fputc ('\n', yyf);
}

static void yWriteManifest_array1
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kManifest_array1], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Expression", yyt->Manifest_array1.Expression);
}

static void yWriteOld
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOld], yyf); (void) fputc ('\n', yyf);
}

static void yWriteStrip
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kStrip], yyf); (void) fputc ('\n', yyf);
}

static void yWritelist
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [klist], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Manifest_constant", yyt->list.Manifest_constant);
}

static void yWriteCh
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCh], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ch"); writeint (yyt->Ch.ch) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->Ch.pos) yyWriteNl ();
}

static void yWriteTrue
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTrue], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->True.pos) yyWriteNl ();
}

static void yWriteFalse
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFalse], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->False.pos) yyWriteNl ();
}

static void yWriteInt
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kInt], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writelong (yyt->Int.value) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->Int.pos) yyWriteNl ();
}

static void yWriteReal
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kReal], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writedouble (yyt->Real.value) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->Real.pos) yyWriteNl ();
}

static void yWrite_CHARACTER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_CHARACTER], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_CHARACTER.pos) yyWriteNl ();
}

static void yWrite_INTEGER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_INTEGER], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_INTEGER.pos) yyWriteNl ();
}

static void yWrite_REAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_REAL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_REAL.pos) yyWriteNl ();
}

static void yWrite_DOUBLE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_DOUBLE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_DOUBLE.pos) yyWriteNl ();
}

static void yWrite_BOOLEAN
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_BOOLEAN], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_BOOLEAN.pos) yyWriteNl ();
}

static void yWrite_STRING
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_STRING], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_STRING.pos) yyWriteNl ();
}

static void yWrite_BIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_BIT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_BIT.pos) yyWriteNl ();
}

static void yWrite_NONE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [k_NONE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->_NONE.pos) yyWriteNl ();
}

static void yWriteBitseq
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBitseq], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("literal"); writetStringRef (yyt->Bitseq.literal) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->Bitseq.pos) yyWriteNl ();
}

static void yWriteString
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kString], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("string"); writetStringRef (yyt->String.string) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->String.pos) yyWriteNl ();
}

static void yWriteCurrent
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCurrent], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Current.pos) yyWriteNl ();
}

static void yWriteResult
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kResult], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("pos"); writetPosition (yyt->Result.pos) yyWriteNl ();
}

static void yWriteId
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kId], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ident"); writetIdent (yyt->Id.ident) yyWriteNl ();
 yyIndentSelector ("pos"); writetPosition (yyt->Id.pos) yyWriteNl ();
}

static void yyWriteTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoTree) { (void) fputs (" NoTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kEiffel: yWriteEiffel (yyt); yyIndentSelector ("Classes"); yyt = yyt->Eiffel.Classes; break;
case kClasses: (void) fputs (Tree_NodeName [kClasses], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClasses0: (void) fputs (Tree_NodeName [kClasses0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClasses1: yWriteClasses1 (yyt); yyIndentSelector ("Classes"); yyt = yyt->Classes1.Classes; break;
case kClass_declaration: yWriteClass_declaration (yyt); yyIndentSelector ("Invariant"); yyt = yyt->Class_declaration.Invariant; break;
case kIndex_list: (void) fputs (Tree_NodeName [kIndex_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kIndex_list0: (void) fputs (Tree_NodeName [kIndex_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kIndex_list1: yWriteIndex_list1 (yyt); yyIndentSelector ("Index_list"); yyt = yyt->Index_list1.Index_list; break;
case kIndex_clause: yWriteIndex_clause (yyt); yyIndentSelector ("Index_terms"); yyt = yyt->Index_clause.Index_terms; break;
case kClass_header: (void) fputs (Tree_NodeName [kClass_header], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClass_header0: (void) fputs (Tree_NodeName [kClass_header0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClass: yWriteClass (yyt); yyIndentSelector ("Name"); yyt = yyt->Class.Name; break;
case kExpanded_class: yWriteExpanded_class (yyt); yyIndentSelector ("Name"); yyt = yyt->Expanded_class.Name; break;
case kDeferred_class: yWriteDeferred_class (yyt); yyIndentSelector ("Name"); yyt = yyt->Deferred_class.Name; break;
case kFeatures: (void) fputs (Tree_NodeName [kFeatures], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeatures0: (void) fputs (Tree_NodeName [kFeatures0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeatures1: yWriteFeatures1 (yyt); yyIndentSelector ("Features"); yyt = yyt->Features1.Features; break;
case kFeature_clause: yWriteFeature_clause (yyt); yyIndentSelector ("Feature_decls"); yyt = yyt->Feature_clause.Feature_decls; break;
case kClients: (void) fputs (Tree_NodeName [kClients], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClients0: (void) fputs (Tree_NodeName [kClients0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClients1: yWriteClients1 (yyt); yyIndentSelector ("List"); yyt = yyt->Clients1.List; break;
case kFeature_decls: (void) fputs (Tree_NodeName [kFeature_decls], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_decls0: (void) fputs (Tree_NodeName [kFeature_decls0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_decls1: yWriteFeature_decls1 (yyt); yyIndentSelector ("Feature_decls"); yyt = yyt->Feature_decls1.Feature_decls; break;
case kFeature_decl: yWriteFeature_decl (yyt); yyIndentSelector ("Declaration_body"); yyt = yyt->Feature_decl.Declaration_body; break;
case kDeclaration_body: yWriteDeclaration_body (yyt); yyIndentSelector ("Const_or_routine"); yyt = yyt->Declaration_body.Const_or_routine; break;
case kConst_or_routine: (void) fputs (Tree_NodeName [kConst_or_routine], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kConst_or_routine0: (void) fputs (Tree_NodeName [kConst_or_routine0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kM_const: yWriteM_const (yyt); yyIndentSelector ("Manifest_constant"); yyt = yyt->M_const.Manifest_constant; break;
case kUnique: yWriteUnique (yyt); goto yyExit;
case kRoutine: yWriteRoutine (yyt); yyIndentSelector ("Rescue"); yyt = yyt->Routine.Rescue; break;
case kParent_list: (void) fputs (Tree_NodeName [kParent_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kParent_list0: (void) fputs (Tree_NodeName [kParent_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kParent_list1: yWriteParent_list1 (yyt); yyIndentSelector ("Parent_list"); yyt = yyt->Parent_list1.Parent_list; break;
case kParent: yWriteParent (yyt); yyIndentSelector ("Feature_adaptation"); yyt = yyt->Parent.Feature_adaptation; break;
case kFeature_adaptation: (void) fputs (Tree_NodeName [kFeature_adaptation], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_adaptation0: (void) fputs (Tree_NodeName [kFeature_adaptation0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_adaptation1: yWriteFeature_adaptation1 (yyt); yyIndentSelector ("Select"); yyt = yyt->Feature_adaptation1.Select; break;
case kRename_list: (void) fputs (Tree_NodeName [kRename_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRename_list0: (void) fputs (Tree_NodeName [kRename_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRename_list1: yWriteRename_list1 (yyt); yyIndentSelector ("Rename_list"); yyt = yyt->Rename_list1.Rename_list; break;
case kRename_pair: yWriteRename_pair (yyt); yyIndentSelector ("Name2"); yyt = yyt->Rename_pair.Name2; break;
case kCreators: (void) fputs (Tree_NodeName [kCreators], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCreators0: (void) fputs (Tree_NodeName [kCreators0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCreators1: yWriteCreators1 (yyt); yyIndentSelector ("Creators"); yyt = yyt->Creators1.Creators; break;
case kCreation_clause: yWriteCreation_clause (yyt); yyIndentSelector ("Feature_list"); yyt = yyt->Creation_clause.Feature_list; break;
case kNew_feature_list: (void) fputs (Tree_NodeName [kNew_feature_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNew_feature_list0: (void) fputs (Tree_NodeName [kNew_feature_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNew_feature_list1: yWriteNew_feature_list1 (yyt); yyIndentSelector ("New_feature_list"); yyt = yyt->New_feature_list1.New_feature_list; break;
case kFeature_name: (void) fputs (Tree_NodeName [kFeature_name], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFrozen: yWriteFrozen (yyt); yyIndentSelector ("Feature_name"); yyt = yyt->Frozen.Feature_name; break;
case kIdent_name: yWriteIdent_name (yyt); yyIndentSelector ("Id"); yyt = yyt->Ident_name.Id; break;
case kOp: (void) fputs (Tree_NodeName [kOp], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kPrefix: yWritePrefix (yyt); yyIndentSelector ("Op_name"); yyt = yyt->Prefix.Op_name; break;
case kInfix: yWriteInfix (yyt); yyIndentSelector ("Op_name"); yyt = yyt->Infix.Op_name; break;
case kOp_name: yWriteOp_name (yyt); goto yyExit;
case kFree_op: yWriteFree_op (yyt); goto yyExit;
case kOper: yWriteOper (yyt); goto yyExit;
case kNew_export_list: (void) fputs (Tree_NodeName [kNew_export_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNew_export_list0: (void) fputs (Tree_NodeName [kNew_export_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNew_export_list1: yWriteNew_export_list1 (yyt); yyIndentSelector ("New_export_list"); yyt = yyt->New_export_list1.New_export_list; break;
case kNew_export_item: yWriteNew_export_item (yyt); yyIndentSelector ("Feature_set"); yyt = yyt->New_export_item.Feature_set; break;
case kFeature_list: (void) fputs (Tree_NodeName [kFeature_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAll: (void) fputs (Tree_NodeName [kAll], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_list0: (void) fputs (Tree_NodeName [kFeature_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFeature_list1: yWriteFeature_list1 (yyt); yyIndentSelector ("Feature_list"); yyt = yyt->Feature_list1.Feature_list; break;
case kFormal_args: (void) fputs (Tree_NodeName [kFormal_args], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFormal_args0: (void) fputs (Tree_NodeName [kFormal_args0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFormal_args1: yWriteFormal_args1 (yyt); yyIndentSelector ("Formal_args"); yyt = yyt->Formal_args1.Formal_args; break;
case kRoutine_body: (void) fputs (Tree_NodeName [kRoutine_body], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRoutine_body0: (void) fputs (Tree_NodeName [kRoutine_body0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kEffective: (void) fputs (Tree_NodeName [kEffective], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kInternal: (void) fputs (Tree_NodeName [kInternal], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDo_body: yWriteDo_body (yyt); yyIndentSelector ("Compound"); yyt = yyt->Do_body.Compound; break;
case kOnce_body: yWriteOnce_body (yyt); yyIndentSelector ("Compound"); yyt = yyt->Once_body.Compound; break;
case kExternal: yWriteExternal (yyt); yyIndentSelector ("Lang2"); yyt = yyt->External.Lang2; break;
case kDeferred: yWriteDeferred (yyt); goto yyExit;
case kEntity_decl_group: yWriteEntity_decl_group (yyt); yyIndentSelector ("Type_mark"); yyt = yyt->Entity_decl_group.Type_mark; break;
case kFormal_generics: (void) fputs (Tree_NodeName [kFormal_generics], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFormal_generics0: (void) fputs (Tree_NodeName [kFormal_generics0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kFormal_generics1: yWriteFormal_generics1 (yyt); yyIndentSelector ("Formal_generics"); yyt = yyt->Formal_generics1.Formal_generics; break;
case kFormal_generic: yWriteFormal_generic (yyt); yyIndentSelector ("Constraint"); yyt = yyt->Formal_generic.Constraint; break;
case kConstraint: (void) fputs (Tree_NodeName [kConstraint], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kConstraint0: (void) fputs (Tree_NodeName [kConstraint0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kConstraint1: yWriteConstraint1 (yyt); yyIndentSelector ("Class_type"); yyt = yyt->Constraint1.Class_type; break;
case kCompound: (void) fputs (Tree_NodeName [kCompound], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCompound0: (void) fputs (Tree_NodeName [kCompound0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCompound1: yWriteCompound1 (yyt); yyIndentSelector ("Compound"); yyt = yyt->Compound1.Compound; break;
case kThen_part_list: (void) fputs (Tree_NodeName [kThen_part_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kThen_part_list0: (void) fputs (Tree_NodeName [kThen_part_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kThen_part_list1: yWriteThen_part_list1 (yyt); yyIndentSelector ("Then_part_list"); yyt = yyt->Then_part_list1.Then_part_list; break;
case kThen_part: yWriteThen_part (yyt); yyIndentSelector ("Compound"); yyt = yyt->Then_part.Compound; break;
case kWhen_part_list: (void) fputs (Tree_NodeName [kWhen_part_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kWhen_part_list0: (void) fputs (Tree_NodeName [kWhen_part_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kWhen_part_list1: yWriteWhen_part_list1 (yyt); yyIndentSelector ("When_part_list"); yyt = yyt->When_part_list1.When_part_list; break;
case kWhen_part: yWriteWhen_part (yyt); yyIndentSelector ("Compound"); yyt = yyt->When_part.Compound; break;
case kChoices: (void) fputs (Tree_NodeName [kChoices], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kChoices0: (void) fputs (Tree_NodeName [kChoices0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kChoices1: yWriteChoices1 (yyt); yyIndentSelector ("Choices"); yyt = yyt->Choices1.Choices; break;
case kChoice: (void) fputs (Tree_NodeName [kChoice], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kInterval: yWriteInterval (yyt); yyIndentSelector ("To"); yyt = yyt->Interval.To; break;
case kVal: yWriteVal (yyt); yyIndentSelector ("Manifest_constant"); yyt = yyt->Val.Manifest_constant; break;
case kInstruction: (void) fputs (Tree_NodeName [kInstruction], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kInstruction0: (void) fputs (Tree_NodeName [kInstruction0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCreation: yWriteCreation (yyt); yyIndentSelector ("Unqual_call"); yyt = yyt->Creation.Unqual_call; break;
case kCall_instruct: yWriteCall_instruct (yyt); yyIndentSelector ("Call"); yyt = yyt->Call_instruct.Call; break;
case kAssign: yWriteAssign (yyt); yyIndentSelector ("Expression"); yyt = yyt->Assign.Expression; break;
case kRev_assign: yWriteRev_assign (yyt); yyIndentSelector ("Expression"); yyt = yyt->Rev_assign.Expression; break;
case kConditional: yWriteConditional (yyt); yyIndentSelector ("Else_part"); yyt = yyt->Conditional.Else_part; break;
case kMulti_branch: yWriteMulti_branch (yyt); yyIndentSelector ("Else_part"); yyt = yyt->Multi_branch.Else_part; break;
case kLoop: yWriteLoop (yyt); yyIndentSelector ("Loop_body"); yyt = yyt->Loop.Loop_body; break;
case kCheck: yWriteCheck (yyt); yyIndentSelector ("Assertion"); yyt = yyt->Check.Assertion; break;
case kDebug: yWriteDebug (yyt); yyIndentSelector ("Compound"); yyt = yyt->Debug.Compound; break;
case kRetry: yWriteRetry (yyt); goto yyExit;
case kLoop_body: (void) fputs (Tree_NodeName [kLoop_body], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLoop_body0: (void) fputs (Tree_NodeName [kLoop_body0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLoop_body1: yWriteLoop_body1 (yyt); yyIndentSelector ("Compound"); yyt = yyt->Loop_body1.Compound; break;
case kType: (void) fputs (Tree_NodeName [kType], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kType0: (void) fputs (Tree_NodeName [kType0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kClass_type: yWriteClass_type (yyt); yyIndentSelector ("Actual_generics"); yyt = yyt->Class_type.Actual_generics; break;
case kClass_type_expanded: yWriteClass_type_expanded (yyt); yyIndentSelector ("Actual_generics"); yyt = yyt->Class_type_expanded.Actual_generics; break;
case kBit_type: yWriteBit_type (yyt); yyIndentSelector ("Manifest_constant"); yyt = yyt->Bit_type.Manifest_constant; break;
case kSimple_type: yWriteSimple_type (yyt); yyIndentSelector ("Manifest_constant"); yyt = yyt->Simple_type.Manifest_constant; break;
case kAnchored: yWriteAnchored (yyt); yyIndentSelector ("Entity"); yyt = yyt->Anchored.Entity; break;
case kActual_generics: (void) fputs (Tree_NodeName [kActual_generics], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActual_generics0: (void) fputs (Tree_NodeName [kActual_generics0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActual_generics1: yWriteActual_generics1 (yyt); yyIndentSelector ("Type_list"); yyt = yyt->Actual_generics1.Type_list; break;
case kCondition: (void) fputs (Tree_NodeName [kCondition], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCondition0: (void) fputs (Tree_NodeName [kCondition0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCondition1: yWriteCondition1 (yyt); yyIndentSelector ("Assertion"); yyt = yyt->Condition1.Assertion; break;
case kAssertion: (void) fputs (Tree_NodeName [kAssertion], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAssertion0: (void) fputs (Tree_NodeName [kAssertion0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAssertion1: yWriteAssertion1 (yyt); yyIndentSelector ("Assertion"); yyt = yyt->Assertion1.Assertion; break;
case kAssertion_clause: (void) fputs (Tree_NodeName [kAssertion_clause], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAssertion_clause0: (void) fputs (Tree_NodeName [kAssertion_clause0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAssertion_clause1: yWriteAssertion_clause1 (yyt); yyIndentSelector ("Expression"); yyt = yyt->Assertion_clause1.Expression; break;
case kType_list: (void) fputs (Tree_NodeName [kType_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kType_list0: (void) fputs (Tree_NodeName [kType_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kType_list1: yWriteType_list1 (yyt); yyIndentSelector ("Type_list"); yyt = yyt->Type_list1.Type_list; break;
case kCall_chain: (void) fputs (Tree_NodeName [kCall_chain], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCall_chain0: (void) fputs (Tree_NodeName [kCall_chain0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCall_chain1: yWriteCall_chain1 (yyt); yyIndentSelector ("Call_chain"); yyt = yyt->Call_chain1.Call_chain; break;
case kUnqual_call: (void) fputs (Tree_NodeName [kUnqual_call], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUnqual_call0: (void) fputs (Tree_NodeName [kUnqual_call0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUnqual_call1: yWriteUnqual_call1 (yyt); yyIndentSelector ("Actuals"); yyt = yyt->Unqual_call1.Actuals; break;
case kActuals: (void) fputs (Tree_NodeName [kActuals], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActuals0: (void) fputs (Tree_NodeName [kActuals0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActuals1: yWriteActuals1 (yyt); yyIndentSelector ("Actual_list"); yyt = yyt->Actuals1.Actual_list; break;
case kActual_list: (void) fputs (Tree_NodeName [kActual_list], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActual_list0: (void) fputs (Tree_NodeName [kActual_list0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kActual_list1: yWriteActual_list1 (yyt); yyIndentSelector ("Actual_list"); yyt = yyt->Actual_list1.Actual_list; break;
case kActual: (void) fputs (Tree_NodeName [kActual], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kAddr: yWriteAddr (yyt); yyIndentSelector ("Entity"); yyt = yyt->Addr.Entity; break;
case kExpression: (void) fputs (Tree_NodeName [kExpression], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kExpression0: (void) fputs (Tree_NodeName [kExpression0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kComment: yWriteComment (yyt); goto yyExit;
case kSimple_expr: yWriteSimple_expr (yyt); yyIndentSelector ("Manifest_constant"); yyt = yyt->Simple_expr.Manifest_constant; break;
case kCall: yWriteCall (yyt); yyIndentSelector ("Call_chain"); yyt = yyt->Call.Call_chain; break;
case kBin_expr: yWriteBin_expr (yyt); yyIndentSelector ("Rop"); yyt = yyt->Bin_expr.Rop; break;
case kUn_expr: yWriteUn_expr (yyt); yyIndentSelector ("Expression"); yyt = yyt->Un_expr.Expression; break;
case kParenth: yWriteParenth (yyt); yyIndentSelector ("Expression"); yyt = yyt->Parenth.Expression; break;
case kManifest_array: (void) fputs (Tree_NodeName [kManifest_array], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kManifest_array0: (void) fputs (Tree_NodeName [kManifest_array0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kManifest_array1: yWriteManifest_array1 (yyt); yyIndentSelector ("Manifest_array"); yyt = yyt->Manifest_array1.Manifest_array; break;
case kOld: yWriteOld (yyt); yyIndentSelector ("Expression"); yyt = yyt->Old.Expression; break;
case kStrip: yWriteStrip (yyt); yyIndentSelector ("List"); yyt = yyt->Strip.List; break;
case kList: (void) fputs (Tree_NodeName [kList], yyf); (void) fputc ('\n', yyf); goto yyExit;
case knolist: (void) fputs (Tree_NodeName [knolist], yyf); (void) fputc ('\n', yyf); goto yyExit;
case klist: yWritelist (yyt); yyIndentSelector ("List"); yyt = yyt->list.List; break;
case kManifest_constant: (void) fputs (Tree_NodeName [kManifest_constant], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kManifest_constant0: (void) fputs (Tree_NodeName [kManifest_constant0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCh: yWriteCh (yyt); goto yyExit;
case kTrue: yWriteTrue (yyt); goto yyExit;
case kFalse: yWriteFalse (yyt); goto yyExit;
case kInt: yWriteInt (yyt); yyIndentSelector ("Sign"); yyt = yyt->Int.Sign; break;
case kReal: yWriteReal (yyt); yyIndentSelector ("Sign"); yyt = yyt->Real.Sign; break;
case k_CHARACTER: yWrite_CHARACTER (yyt); goto yyExit;
case k_INTEGER: yWrite_INTEGER (yyt); goto yyExit;
case k_REAL: yWrite_REAL (yyt); goto yyExit;
case k_DOUBLE: yWrite_DOUBLE (yyt); goto yyExit;
case k_BOOLEAN: yWrite_BOOLEAN (yyt); goto yyExit;
case k_STRING: yWrite_STRING (yyt); goto yyExit;
case k_BIT: yWrite_BIT (yyt); goto yyExit;
case k_NONE: yWrite_NONE (yyt); goto yyExit;
case kBitseq: yWriteBitseq (yyt); goto yyExit;
case kString: yWriteString (yyt); goto yyExit;
case kString0: (void) fputs (Tree_NodeName [kString0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kEntity: (void) fputs (Tree_NodeName [kEntity], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kEntity0: (void) fputs (Tree_NodeName [kEntity0], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCurrent: yWriteCurrent (yyt); goto yyExit;
case kResult: yWriteResult (yyt); goto yyExit;
case kId: yWriteId (yyt); goto yyExit;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

static tIdent yyKindToIdent [192 + 1];
static bool yyIsInitialized = false;

static short yyMapToKind
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyk;
 register tIdent yyi = MakeIdent ((tString) yys, strlen (yys));
 for (yyk = 0; yyk <= 192; yyk ++) {
  if (yyKindToIdent [yyk] == yyi) return yyk;
 }
 return 0;
}

static void yyReadNl () { (void) fscanf (yyf, "\n"); }

static tIdent yyReadIdent ()
{
 char yys [256];
 (void) fscanf (yyf, "%s", yys);
 return MakeIdent ((tString) yys, strlen (yys));
}

static void yyReadHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{
 register int yyi; int yyk;
 for (yyi = 0; yyi < yysize; yyi ++) { (void) fscanf (yyf, "%x ", & yyk); yyx [yyi] = yyk; }
}

static void yySkip () { (void) fscanf (yyf, " %*s =%*c"); }

static void yyReadTree
# if defined __STDC__ | defined __cplusplus
 (yyPtrtTree yyt)
# else
 (yyt) yyPtrtTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 static Tree_tKind yyKind;
 static char yys [256];
 for (;;) {
  switch (getc (yyf)) {
  case '^': (void) fscanf (yyf, "%hd\n", & yyLabel); * yyt = yyMapToTree (yyLabel); return;
  case '\n': case '0': (void) fscanf (yyf, "%hd%*c %s\n", & yyLabel, yys);
   yyKind = yyMapToKind (yys); * yyt = MakeTree (yyKind);
   if (yyLabel != yyMapToLabel (* yyt)) { (void) fputs ("Tree: error in ReadTree\n", stderr); Tree_Exit (); } break;
  default: ;
   (void) fscanf (yyf, "%s", yys);
   yyKind = yyMapToKind (yys);
   if (yyKind == 0) { * yyt = NoTree; return; }
   * yyt = MakeTree (yyKind);
  }

  switch (yyKind) {
case kEiffel:
yySkip (); yyt = & ((* yyt)->Eiffel.Classes); break;
case kClasses1:
yySkip (); readtTree (& ((* yyt)->Classes1.Class_declaration))
yySkip (); yyt = & ((* yyt)->Classes1.Classes); break;
case kClass_declaration:
yySkip (); readtTree (& ((* yyt)->Class_declaration.Indexing))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Class_header))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Formal_generics))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Obsolete))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Inheritance))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Creators))
yySkip (); readtTree (& ((* yyt)->Class_declaration.Features))
yySkip (); readtStringRef ((* yyt)->Class_declaration.comment) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Class_declaration.Invariant); break;
case kIndex_list1:
yySkip (); readtTree (& ((* yyt)->Index_list1.Index_clause))
yySkip (); yyt = & ((* yyt)->Index_list1.Index_list); break;
case kIndex_clause:
yySkip (); readtTree (& ((* yyt)->Index_clause.Index))
yySkip (); yyt = & ((* yyt)->Index_clause.Index_terms); break;
case kClass:
yySkip (); yyt = & ((* yyt)->Class.Name); break;
case kExpanded_class:
yySkip (); yyt = & ((* yyt)->Expanded_class.Name); break;
case kDeferred_class:
yySkip (); yyt = & ((* yyt)->Deferred_class.Name); break;
case kFeatures1:
yySkip (); readtTree (& ((* yyt)->Features1.Feature_clause))
yySkip (); yyt = & ((* yyt)->Features1.Features); break;
case kFeature_clause:
yySkip (); readtTree (& ((* yyt)->Feature_clause.Clients))
yySkip (); readtStringRef ((* yyt)->Feature_clause.comment) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Feature_clause.Feature_decls); break;
case kClients1:
yySkip (); yyt = & ((* yyt)->Clients1.List); break;
case kFeature_decls1:
yySkip (); readtTree (& ((* yyt)->Feature_decls1.Feature_decl))
yySkip (); yyt = & ((* yyt)->Feature_decls1.Feature_decls); break;
case kFeature_decl:
yySkip (); readtTree (& ((* yyt)->Feature_decl.New_feature_list))
yySkip (); yyt = & ((* yyt)->Feature_decl.Declaration_body); break;
case kDeclaration_body:
yySkip (); readtTree (& ((* yyt)->Declaration_body.Formal_args))
yySkip (); readtTree (& ((* yyt)->Declaration_body.Type_mark))
yySkip (); yyt = & ((* yyt)->Declaration_body.Const_or_routine); break;
case kM_const:
yySkip (); yyt = & ((* yyt)->M_const.Manifest_constant); break;
case kUnique:
yySkip (); readtPosition ((* yyt)->Unique.pos) yyReadNl ();
return;
case kRoutine:
yySkip (); readtTree (& ((* yyt)->Routine.Obsolete))
yySkip (); readtStringRef ((* yyt)->Routine.comment) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->Routine.Precondition))
yySkip (); readtTree (& ((* yyt)->Routine.Local_decls))
yySkip (); readtTree (& ((* yyt)->Routine.Routine_body))
yySkip (); readtTree (& ((* yyt)->Routine.Postcondition))
yySkip (); readtStringRef ((* yyt)->Routine.end_comment) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Routine.Rescue); break;
case kParent_list1:
yySkip (); readtTree (& ((* yyt)->Parent_list1.Parent))
yySkip (); yyt = & ((* yyt)->Parent_list1.Parent_list); break;
case kParent:
yySkip (); readtTree (& ((* yyt)->Parent.Class_type))
yySkip (); yyt = & ((* yyt)->Parent.Feature_adaptation); break;
case kFeature_adaptation1:
yySkip (); readtTree (& ((* yyt)->Feature_adaptation1.Rename))
yySkip (); readtTree (& ((* yyt)->Feature_adaptation1.New_export))
yySkip (); readtTree (& ((* yyt)->Feature_adaptation1.Undefine))
yySkip (); readtTree (& ((* yyt)->Feature_adaptation1.Redefine))
yySkip (); yyt = & ((* yyt)->Feature_adaptation1.Select); break;
case kRename_list1:
yySkip (); readtTree (& ((* yyt)->Rename_list1.Rename_pair))
yySkip (); yyt = & ((* yyt)->Rename_list1.Rename_list); break;
case kRename_pair:
yySkip (); readtTree (& ((* yyt)->Rename_pair.Name1))
yySkip (); yyt = & ((* yyt)->Rename_pair.Name2); break;
case kCreators1:
yySkip (); readtTree (& ((* yyt)->Creators1.Creation_clause))
yySkip (); yyt = & ((* yyt)->Creators1.Creators); break;
case kCreation_clause:
yySkip (); readtTree (& ((* yyt)->Creation_clause.Clients))
yySkip (); readtStringRef ((* yyt)->Creation_clause.comment) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Creation_clause.Feature_list); break;
case kNew_feature_list1:
yySkip (); readtTree (& ((* yyt)->New_feature_list1.Feature_name))
yySkip (); yyt = & ((* yyt)->New_feature_list1.New_feature_list); break;
case kFrozen:
yySkip (); yyt = & ((* yyt)->Frozen.Feature_name); break;
case kIdent_name:
yySkip (); yyt = & ((* yyt)->Ident_name.Id); break;
case kPrefix:
yySkip (); yyt = & ((* yyt)->Prefix.Op_name); break;
case kInfix:
yySkip (); yyt = & ((* yyt)->Infix.Op_name); break;
case kOp_name:
yySkip (); readtPosition ((* yyt)->Op_name.pos) yyReadNl ();
return;
case kFree_op:
yySkip (); readtPosition ((* yyt)->Free_op.pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->Free_op.ident) yyReadNl ();
return;
case kOper:
yySkip (); readtPosition ((* yyt)->Oper.pos) yyReadNl ();
yySkip (); readint ((* yyt)->Oper.op) yyReadNl ();
return;
case kNew_export_list1:
yySkip (); readtTree (& ((* yyt)->New_export_list1.New_export_item))
yySkip (); yyt = & ((* yyt)->New_export_list1.New_export_list); break;
case kNew_export_item:
yySkip (); readtTree (& ((* yyt)->New_export_item.Clients))
yySkip (); yyt = & ((* yyt)->New_export_item.Feature_set); break;
case kFeature_list1:
yySkip (); readtTree (& ((* yyt)->Feature_list1.Feature_name))
yySkip (); yyt = & ((* yyt)->Feature_list1.Feature_list); break;
case kFormal_args1:
yySkip (); readtTree (& ((* yyt)->Formal_args1.Entity_decl_group))
yySkip (); yyt = & ((* yyt)->Formal_args1.Formal_args); break;
case kDo_body:
yySkip (); yyt = & ((* yyt)->Do_body.Compound); break;
case kOnce_body:
yySkip (); yyt = & ((* yyt)->Once_body.Compound); break;
case kExternal:
yySkip (); readtTree (& ((* yyt)->External.Lang1))
yySkip (); yyt = & ((* yyt)->External.Lang2); break;
case kDeferred:
yySkip (); readtPosition ((* yyt)->Deferred.pos) yyReadNl ();
return;
case kEntity_decl_group:
yySkip (); readtTree (& ((* yyt)->Entity_decl_group.Id_list))
yySkip (); yyt = & ((* yyt)->Entity_decl_group.Type_mark); break;
case kFormal_generics1:
yySkip (); readtTree (& ((* yyt)->Formal_generics1.Formal_generic))
yySkip (); yyt = & ((* yyt)->Formal_generics1.Formal_generics); break;
case kFormal_generic:
yySkip (); readtTree (& ((* yyt)->Formal_generic.Id))
yySkip (); yyt = & ((* yyt)->Formal_generic.Constraint); break;
case kConstraint1:
yySkip (); yyt = & ((* yyt)->Constraint1.Class_type); break;
case kCompound1:
yySkip (); readtTree (& ((* yyt)->Compound1.Instruction))
yySkip (); yyt = & ((* yyt)->Compound1.Compound); break;
case kThen_part_list1:
yySkip (); readtTree (& ((* yyt)->Then_part_list1.Then_part))
yySkip (); yyt = & ((* yyt)->Then_part_list1.Then_part_list); break;
case kThen_part:
yySkip (); readtTree (& ((* yyt)->Then_part.Guard))
yySkip (); yyt = & ((* yyt)->Then_part.Compound); break;
case kWhen_part_list1:
yySkip (); readtTree (& ((* yyt)->When_part_list1.When_part))
yySkip (); yyt = & ((* yyt)->When_part_list1.When_part_list); break;
case kWhen_part:
yySkip (); readtTree (& ((* yyt)->When_part.Choices))
yySkip (); yyt = & ((* yyt)->When_part.Compound); break;
case kChoices1:
yySkip (); readtTree (& ((* yyt)->Choices1.Choice))
yySkip (); yyt = & ((* yyt)->Choices1.Choices); break;
case kInterval:
yySkip (); readtTree (& ((* yyt)->Interval.From))
yySkip (); yyt = & ((* yyt)->Interval.To); break;
case kVal:
yySkip (); yyt = & ((* yyt)->Val.Manifest_constant); break;
case kCreation:
yySkip (); readtTree (& ((* yyt)->Creation.Type))
yySkip (); readtTree (& ((* yyt)->Creation.Entity))
yySkip (); yyt = & ((* yyt)->Creation.Unqual_call); break;
case kCall_instruct:
yySkip (); yyt = & ((* yyt)->Call_instruct.Call); break;
case kAssign:
yySkip (); readtTree (& ((* yyt)->Assign.Addr))
yySkip (); yyt = & ((* yyt)->Assign.Expression); break;
case kRev_assign:
yySkip (); readtTree (& ((* yyt)->Rev_assign.Addr))
yySkip (); yyt = & ((* yyt)->Rev_assign.Expression); break;
case kConditional:
yySkip (); readtTree (& ((* yyt)->Conditional.Then_part))
yySkip (); yyt = & ((* yyt)->Conditional.Else_part); break;
case kMulti_branch:
yySkip (); readtTree (& ((* yyt)->Multi_branch.Guard))
yySkip (); readtTree (& ((* yyt)->Multi_branch.When_part_list))
yySkip (); yyt = & ((* yyt)->Multi_branch.Else_part); break;
case kLoop:
yySkip (); readtTree (& ((* yyt)->Loop.Initialization))
yySkip (); readtTree (& ((* yyt)->Loop.Invariant))
yySkip (); readtTree (& ((* yyt)->Loop.Variant))
yySkip (); yyt = & ((* yyt)->Loop.Loop_body); break;
case kCheck:
yySkip (); yyt = & ((* yyt)->Check.Assertion); break;
case kDebug:
yySkip (); readtTree (& ((* yyt)->Debug.Debug_keys))
yySkip (); yyt = & ((* yyt)->Debug.Compound); break;
case kRetry:
yySkip (); readtPosition ((* yyt)->Retry.pos) yyReadNl ();
return;
case kLoop_body1:
yySkip (); readtTree (& ((* yyt)->Loop_body1.Exit))
yySkip (); yyt = & ((* yyt)->Loop_body1.Compound); break;
case kClass_type:
yySkip (); readtTree (& ((* yyt)->Class_type.Id))
yySkip (); yyt = & ((* yyt)->Class_type.Actual_generics); break;
case kClass_type_expanded:
yySkip (); readtTree (& ((* yyt)->Class_type_expanded.Id))
yySkip (); yyt = & ((* yyt)->Class_type_expanded.Actual_generics); break;
case kBit_type:
yySkip (); yyt = & ((* yyt)->Bit_type.Manifest_constant); break;
case kSimple_type:
yySkip (); yyt = & ((* yyt)->Simple_type.Manifest_constant); break;
case kAnchored:
yySkip (); yyt = & ((* yyt)->Anchored.Entity); break;
case kActual_generics1:
yySkip (); yyt = & ((* yyt)->Actual_generics1.Type_list); break;
case kCondition1:
yySkip (); readint ((* yyt)->Condition1.extension) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Condition1.Assertion); break;
case kAssertion1:
yySkip (); readtTree (& ((* yyt)->Assertion1.Assertion_clause))
yySkip (); yyt = & ((* yyt)->Assertion1.Assertion); break;
case kAssertion_clause1:
yySkip (); readtTree (& ((* yyt)->Assertion_clause1.Tag))
yySkip (); yyt = & ((* yyt)->Assertion_clause1.Expression); break;
case kType_list1:
yySkip (); readtTree (& ((* yyt)->Type_list1.Type))
yySkip (); yyt = & ((* yyt)->Type_list1.Type_list); break;
case kCall_chain1:
yySkip (); readtTree (& ((* yyt)->Call_chain1.Unqual_call))
yySkip (); yyt = & ((* yyt)->Call_chain1.Call_chain); break;
case kUnqual_call1:
yySkip (); readtTree (& ((* yyt)->Unqual_call1.Entity))
yySkip (); yyt = & ((* yyt)->Unqual_call1.Actuals); break;
case kActuals1:
yySkip (); yyt = & ((* yyt)->Actuals1.Actual_list); break;
case kActual_list1:
yySkip (); readtTree (& ((* yyt)->Actual_list1.Actual))
yySkip (); yyt = & ((* yyt)->Actual_list1.Actual_list); break;
case kAddr:
yySkip (); yyt = & ((* yyt)->Addr.Entity); break;
case kComment:
yySkip (); readtStringRef ((* yyt)->Comment.comment) yyReadNl ();
return;
case kSimple_expr:
yySkip (); yyt = & ((* yyt)->Simple_expr.Manifest_constant); break;
case kCall:
yySkip (); readtTree (& ((* yyt)->Call.Qual))
yySkip (); yyt = & ((* yyt)->Call.Call_chain); break;
case kBin_expr:
yySkip (); readtTree (& ((* yyt)->Bin_expr.Lop))
yySkip (); readtTree (& ((* yyt)->Bin_expr.Op))
yySkip (); yyt = & ((* yyt)->Bin_expr.Rop); break;
case kUn_expr:
yySkip (); readtTree (& ((* yyt)->Un_expr.Op))
yySkip (); yyt = & ((* yyt)->Un_expr.Expression); break;
case kParenth:
yySkip (); yyt = & ((* yyt)->Parenth.Expression); break;
case kManifest_array1:
yySkip (); readtTree (& ((* yyt)->Manifest_array1.Expression))
yySkip (); yyt = & ((* yyt)->Manifest_array1.Manifest_array); break;
case kOld:
yySkip (); yyt = & ((* yyt)->Old.Expression); break;
case kStrip:
yySkip (); yyt = & ((* yyt)->Strip.List); break;
case klist:
yySkip (); readtTree (& ((* yyt)->list.Manifest_constant))
yySkip (); yyt = & ((* yyt)->list.List); break;
case kCh:
yySkip (); readint ((* yyt)->Ch.ch) yyReadNl ();
yySkip (); readtPosition ((* yyt)->Ch.pos) yyReadNl ();
return;
case kTrue:
yySkip (); readtPosition ((* yyt)->True.pos) yyReadNl ();
return;
case kFalse:
yySkip (); readtPosition ((* yyt)->False.pos) yyReadNl ();
return;
case kInt:
yySkip (); readlong ((* yyt)->Int.value) yyReadNl ();
yySkip (); readtPosition ((* yyt)->Int.pos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Int.Sign); break;
case kReal:
yySkip (); readdouble ((* yyt)->Real.value) yyReadNl ();
yySkip (); readtPosition ((* yyt)->Real.pos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->Real.Sign); break;
case k_CHARACTER:
yySkip (); readtPosition ((* yyt)->_CHARACTER.pos) yyReadNl ();
return;
case k_INTEGER:
yySkip (); readtPosition ((* yyt)->_INTEGER.pos) yyReadNl ();
return;
case k_REAL:
yySkip (); readtPosition ((* yyt)->_REAL.pos) yyReadNl ();
return;
case k_DOUBLE:
yySkip (); readtPosition ((* yyt)->_DOUBLE.pos) yyReadNl ();
return;
case k_BOOLEAN:
yySkip (); readtPosition ((* yyt)->_BOOLEAN.pos) yyReadNl ();
return;
case k_STRING:
yySkip (); readtPosition ((* yyt)->_STRING.pos) yyReadNl ();
return;
case k_BIT:
yySkip (); readtPosition ((* yyt)->_BIT.pos) yyReadNl ();
return;
case k_NONE:
yySkip (); readtPosition ((* yyt)->_NONE.pos) yyReadNl ();
return;
case kBitseq:
yySkip (); readtStringRef ((* yyt)->Bitseq.literal) yyReadNl ();
yySkip (); readtPosition ((* yyt)->Bitseq.pos) yyReadNl ();
return;
case kString:
yySkip (); readtStringRef ((* yyt)->String.string) yyReadNl ();
yySkip (); readtPosition ((* yyt)->String.pos) yyReadNl ();
return;
case kCurrent:
yySkip (); readtPosition ((* yyt)->Current.pos) yyReadNl ();
return;
case kResult:
yySkip (); readtPosition ((* yyt)->Result.pos) yyReadNl ();
return;
case kId:
yySkip (); readtIdent ((* yyt)->Id.ident) yyReadNl ();
yySkip (); readtPosition ((* yyt)->Id.pos) yyReadNl ();
return;
  default: return;
  }
 }
}

tTree ReadTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf)
# else
 (yyyf) FILE * yyyf;
# endif
{
 tTree yyt;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 if (! yyIsInitialized) {
  register int yyi;
  for (yyi = 0; yyi <= 192; yyi ++)
   yyKindToIdent [yyi] = MakeIdent ((tString) Tree_NodeName [yyi], strlen (Tree_NodeName [yyi]));
  yyIsInitialized = true;
 }
 yyReadTree (& yyt);
 yyRecursionLevel --;
 return yyt;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static void yyPut
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fwrite (yyx, 1, yysize, yyf); }

static void yyPutIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent yyi)
# else
 (yyi) tIdent yyi;
# endif
{
 char yys [256];
 GetString (yyi, (tString) yys);
 (void) fprintf (yyf, "%s\n", yys);
}

static void yyPutTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 for (;;) {
  if (yyt == NoTree) {
   (void) putc (yyNil, yyf); return;
  } else if (yyt->yyHead.yyMark == 0) {
   (void) putc (yyLabelUse, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel)); return;
  } else if (yyt->yyHead.yyMark > 1) {
   (void) putc (yyLabelDef, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel));
   (void) putc ((char) yyt->Kind, yyf);
  } else {
   (void) putc ((char) yyt->Kind, yyf);
  }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kEiffel:
yyt = yyt->Eiffel.Classes; break;
case kClasses1:
puttTree (yyt->Classes1.Class_declaration)
yyt = yyt->Classes1.Classes; break;
case kClass_declaration:
puttTree (yyt->Class_declaration.Indexing)
puttTree (yyt->Class_declaration.Class_header)
puttTree (yyt->Class_declaration.Formal_generics)
puttTree (yyt->Class_declaration.Obsolete)
puttTree (yyt->Class_declaration.Inheritance)
puttTree (yyt->Class_declaration.Creators)
puttTree (yyt->Class_declaration.Features)
puttStringRef (yyt->Class_declaration.comment)
yyt = yyt->Class_declaration.Invariant; break;
case kIndex_list1:
puttTree (yyt->Index_list1.Index_clause)
yyt = yyt->Index_list1.Index_list; break;
case kIndex_clause:
puttTree (yyt->Index_clause.Index)
yyt = yyt->Index_clause.Index_terms; break;
case kClass:
yyt = yyt->Class.Name; break;
case kExpanded_class:
yyt = yyt->Expanded_class.Name; break;
case kDeferred_class:
yyt = yyt->Deferred_class.Name; break;
case kFeatures1:
puttTree (yyt->Features1.Feature_clause)
yyt = yyt->Features1.Features; break;
case kFeature_clause:
puttTree (yyt->Feature_clause.Clients)
puttStringRef (yyt->Feature_clause.comment)
yyt = yyt->Feature_clause.Feature_decls; break;
case kClients1:
yyt = yyt->Clients1.List; break;
case kFeature_decls1:
puttTree (yyt->Feature_decls1.Feature_decl)
yyt = yyt->Feature_decls1.Feature_decls; break;
case kFeature_decl:
puttTree (yyt->Feature_decl.New_feature_list)
yyt = yyt->Feature_decl.Declaration_body; break;
case kDeclaration_body:
puttTree (yyt->Declaration_body.Formal_args)
puttTree (yyt->Declaration_body.Type_mark)
yyt = yyt->Declaration_body.Const_or_routine; break;
case kM_const:
yyt = yyt->M_const.Manifest_constant; break;
case kUnique:
puttPosition (yyt->Unique.pos)
return;
case kRoutine:
puttTree (yyt->Routine.Obsolete)
puttStringRef (yyt->Routine.comment)
puttTree (yyt->Routine.Precondition)
puttTree (yyt->Routine.Local_decls)
puttTree (yyt->Routine.Routine_body)
puttTree (yyt->Routine.Postcondition)
puttStringRef (yyt->Routine.end_comment)
yyt = yyt->Routine.Rescue; break;
case kParent_list1:
puttTree (yyt->Parent_list1.Parent)
yyt = yyt->Parent_list1.Parent_list; break;
case kParent:
puttTree (yyt->Parent.Class_type)
yyt = yyt->Parent.Feature_adaptation; break;
case kFeature_adaptation1:
puttTree (yyt->Feature_adaptation1.Rename)
puttTree (yyt->Feature_adaptation1.New_export)
puttTree (yyt->Feature_adaptation1.Undefine)
puttTree (yyt->Feature_adaptation1.Redefine)
yyt = yyt->Feature_adaptation1.Select; break;
case kRename_list1:
puttTree (yyt->Rename_list1.Rename_pair)
yyt = yyt->Rename_list1.Rename_list; break;
case kRename_pair:
puttTree (yyt->Rename_pair.Name1)
yyt = yyt->Rename_pair.Name2; break;
case kCreators1:
puttTree (yyt->Creators1.Creation_clause)
yyt = yyt->Creators1.Creators; break;
case kCreation_clause:
puttTree (yyt->Creation_clause.Clients)
puttStringRef (yyt->Creation_clause.comment)
yyt = yyt->Creation_clause.Feature_list; break;
case kNew_feature_list1:
puttTree (yyt->New_feature_list1.Feature_name)
yyt = yyt->New_feature_list1.New_feature_list; break;
case kFrozen:
yyt = yyt->Frozen.Feature_name; break;
case kIdent_name:
yyt = yyt->Ident_name.Id; break;
case kPrefix:
yyt = yyt->Prefix.Op_name; break;
case kInfix:
yyt = yyt->Infix.Op_name; break;
case kOp_name:
puttPosition (yyt->Op_name.pos)
return;
case kFree_op:
puttPosition (yyt->Free_op.pos)
puttIdent (yyt->Free_op.ident)
return;
case kOper:
puttPosition (yyt->Oper.pos)
putint (yyt->Oper.op)
return;
case kNew_export_list1:
puttTree (yyt->New_export_list1.New_export_item)
yyt = yyt->New_export_list1.New_export_list; break;
case kNew_export_item:
puttTree (yyt->New_export_item.Clients)
yyt = yyt->New_export_item.Feature_set; break;
case kFeature_list1:
puttTree (yyt->Feature_list1.Feature_name)
yyt = yyt->Feature_list1.Feature_list; break;
case kFormal_args1:
puttTree (yyt->Formal_args1.Entity_decl_group)
yyt = yyt->Formal_args1.Formal_args; break;
case kDo_body:
yyt = yyt->Do_body.Compound; break;
case kOnce_body:
yyt = yyt->Once_body.Compound; break;
case kExternal:
puttTree (yyt->External.Lang1)
yyt = yyt->External.Lang2; break;
case kDeferred:
puttPosition (yyt->Deferred.pos)
return;
case kEntity_decl_group:
puttTree (yyt->Entity_decl_group.Id_list)
yyt = yyt->Entity_decl_group.Type_mark; break;
case kFormal_generics1:
puttTree (yyt->Formal_generics1.Formal_generic)
yyt = yyt->Formal_generics1.Formal_generics; break;
case kFormal_generic:
puttTree (yyt->Formal_generic.Id)
yyt = yyt->Formal_generic.Constraint; break;
case kConstraint1:
yyt = yyt->Constraint1.Class_type; break;
case kCompound1:
puttTree (yyt->Compound1.Instruction)
yyt = yyt->Compound1.Compound; break;
case kThen_part_list1:
puttTree (yyt->Then_part_list1.Then_part)
yyt = yyt->Then_part_list1.Then_part_list; break;
case kThen_part:
puttTree (yyt->Then_part.Guard)
yyt = yyt->Then_part.Compound; break;
case kWhen_part_list1:
puttTree (yyt->When_part_list1.When_part)
yyt = yyt->When_part_list1.When_part_list; break;
case kWhen_part:
puttTree (yyt->When_part.Choices)
yyt = yyt->When_part.Compound; break;
case kChoices1:
puttTree (yyt->Choices1.Choice)
yyt = yyt->Choices1.Choices; break;
case kInterval:
puttTree (yyt->Interval.From)
yyt = yyt->Interval.To; break;
case kVal:
yyt = yyt->Val.Manifest_constant; break;
case kCreation:
puttTree (yyt->Creation.Type)
puttTree (yyt->Creation.Entity)
yyt = yyt->Creation.Unqual_call; break;
case kCall_instruct:
yyt = yyt->Call_instruct.Call; break;
case kAssign:
puttTree (yyt->Assign.Addr)
yyt = yyt->Assign.Expression; break;
case kRev_assign:
puttTree (yyt->Rev_assign.Addr)
yyt = yyt->Rev_assign.Expression; break;
case kConditional:
puttTree (yyt->Conditional.Then_part)
yyt = yyt->Conditional.Else_part; break;
case kMulti_branch:
puttTree (yyt->Multi_branch.Guard)
puttTree (yyt->Multi_branch.When_part_list)
yyt = yyt->Multi_branch.Else_part; break;
case kLoop:
puttTree (yyt->Loop.Initialization)
puttTree (yyt->Loop.Invariant)
puttTree (yyt->Loop.Variant)
yyt = yyt->Loop.Loop_body; break;
case kCheck:
yyt = yyt->Check.Assertion; break;
case kDebug:
puttTree (yyt->Debug.Debug_keys)
yyt = yyt->Debug.Compound; break;
case kRetry:
puttPosition (yyt->Retry.pos)
return;
case kLoop_body1:
puttTree (yyt->Loop_body1.Exit)
yyt = yyt->Loop_body1.Compound; break;
case kClass_type:
puttTree (yyt->Class_type.Id)
yyt = yyt->Class_type.Actual_generics; break;
case kClass_type_expanded:
puttTree (yyt->Class_type_expanded.Id)
yyt = yyt->Class_type_expanded.Actual_generics; break;
case kBit_type:
yyt = yyt->Bit_type.Manifest_constant; break;
case kSimple_type:
yyt = yyt->Simple_type.Manifest_constant; break;
case kAnchored:
yyt = yyt->Anchored.Entity; break;
case kActual_generics1:
yyt = yyt->Actual_generics1.Type_list; break;
case kCondition1:
putint (yyt->Condition1.extension)
yyt = yyt->Condition1.Assertion; break;
case kAssertion1:
puttTree (yyt->Assertion1.Assertion_clause)
yyt = yyt->Assertion1.Assertion; break;
case kAssertion_clause1:
puttTree (yyt->Assertion_clause1.Tag)
yyt = yyt->Assertion_clause1.Expression; break;
case kType_list1:
puttTree (yyt->Type_list1.Type)
yyt = yyt->Type_list1.Type_list; break;
case kCall_chain1:
puttTree (yyt->Call_chain1.Unqual_call)
yyt = yyt->Call_chain1.Call_chain; break;
case kUnqual_call1:
puttTree (yyt->Unqual_call1.Entity)
yyt = yyt->Unqual_call1.Actuals; break;
case kActuals1:
yyt = yyt->Actuals1.Actual_list; break;
case kActual_list1:
puttTree (yyt->Actual_list1.Actual)
yyt = yyt->Actual_list1.Actual_list; break;
case kAddr:
yyt = yyt->Addr.Entity; break;
case kComment:
puttStringRef (yyt->Comment.comment)
return;
case kSimple_expr:
yyt = yyt->Simple_expr.Manifest_constant; break;
case kCall:
puttTree (yyt->Call.Qual)
yyt = yyt->Call.Call_chain; break;
case kBin_expr:
puttTree (yyt->Bin_expr.Lop)
puttTree (yyt->Bin_expr.Op)
yyt = yyt->Bin_expr.Rop; break;
case kUn_expr:
puttTree (yyt->Un_expr.Op)
yyt = yyt->Un_expr.Expression; break;
case kParenth:
yyt = yyt->Parenth.Expression; break;
case kManifest_array1:
puttTree (yyt->Manifest_array1.Expression)
yyt = yyt->Manifest_array1.Manifest_array; break;
case kOld:
yyt = yyt->Old.Expression; break;
case kStrip:
yyt = yyt->Strip.List; break;
case klist:
puttTree (yyt->list.Manifest_constant)
yyt = yyt->list.List; break;
case kCh:
putint (yyt->Ch.ch)
puttPosition (yyt->Ch.pos)
return;
case kTrue:
puttPosition (yyt->True.pos)
return;
case kFalse:
puttPosition (yyt->False.pos)
return;
case kInt:
putlong (yyt->Int.value)
puttPosition (yyt->Int.pos)
yyt = yyt->Int.Sign; break;
case kReal:
putdouble (yyt->Real.value)
puttPosition (yyt->Real.pos)
yyt = yyt->Real.Sign; break;
case k_CHARACTER:
puttPosition (yyt->_CHARACTER.pos)
return;
case k_INTEGER:
puttPosition (yyt->_INTEGER.pos)
return;
case k_REAL:
puttPosition (yyt->_REAL.pos)
return;
case k_DOUBLE:
puttPosition (yyt->_DOUBLE.pos)
return;
case k_BOOLEAN:
puttPosition (yyt->_BOOLEAN.pos)
return;
case k_STRING:
puttPosition (yyt->_STRING.pos)
return;
case k_BIT:
puttPosition (yyt->_BIT.pos)
return;
case k_NONE:
puttPosition (yyt->_NONE.pos)
return;
case kBitseq:
puttStringRef (yyt->Bitseq.literal)
puttPosition (yyt->Bitseq.pos)
return;
case kString:
puttStringRef (yyt->String.string)
puttPosition (yyt->String.pos)
return;
case kCurrent:
puttPosition (yyt->Current.pos)
return;
case kResult:
puttPosition (yyt->Result.pos)
return;
case kId:
puttIdent (yyt->Id.ident)
puttPosition (yyt->Id.pos)
return;
  default: return;
  }
 }
}

void PutTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyPutTree (yyt);
 yyRecursionLevel --;
}

static void yyGet
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fread (yyx, 1, yysize, yyf); }

static void yyGetIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent * yyi)
# else
 (yyi) tIdent * yyi;
# endif
{
 char yys [256];
 (void) fscanf (yyf, "%s%*c", yys);
 * yyi = MakeIdent ((tString) yys, strlen (yys));
}

static void yyGetTree
# if defined __STDC__ | defined __cplusplus
 (yyPtrtTree yyt)
# else
 (yyt) yyPtrtTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 static Tree_tKind yyKind;
 for (;;) {
  switch (yyKind = getc (yyf)) {
  case yyNil		: * yyt = NoTree; return;
  case yyLabelUse	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   * yyt = yyMapToTree (yyLabel); return;
  case yyLabelDef	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   yyKind = getc (yyf);   * yyt = MakeTree (yyKind);
   if (yyLabel != yyMapToLabel (* yyt)) { (void) fputs ("Tree: error in GetTree\n", stderr); Tree_Exit (); } break;
  default	: * yyt = MakeTree (yyKind);
  }

  switch (yyKind) {
case kEiffel:
yyt = & ((* yyt)->Eiffel.Classes); break;
case kClasses1:
gettTree (& ((* yyt)->Classes1.Class_declaration))
yyt = & ((* yyt)->Classes1.Classes); break;
case kClass_declaration:
gettTree (& ((* yyt)->Class_declaration.Indexing))
gettTree (& ((* yyt)->Class_declaration.Class_header))
gettTree (& ((* yyt)->Class_declaration.Formal_generics))
gettTree (& ((* yyt)->Class_declaration.Obsolete))
gettTree (& ((* yyt)->Class_declaration.Inheritance))
gettTree (& ((* yyt)->Class_declaration.Creators))
gettTree (& ((* yyt)->Class_declaration.Features))
gettStringRef ((* yyt)->Class_declaration.comment)
yyt = & ((* yyt)->Class_declaration.Invariant); break;
case kIndex_list1:
gettTree (& ((* yyt)->Index_list1.Index_clause))
yyt = & ((* yyt)->Index_list1.Index_list); break;
case kIndex_clause:
gettTree (& ((* yyt)->Index_clause.Index))
yyt = & ((* yyt)->Index_clause.Index_terms); break;
case kClass:
yyt = & ((* yyt)->Class.Name); break;
case kExpanded_class:
yyt = & ((* yyt)->Expanded_class.Name); break;
case kDeferred_class:
yyt = & ((* yyt)->Deferred_class.Name); break;
case kFeatures1:
gettTree (& ((* yyt)->Features1.Feature_clause))
yyt = & ((* yyt)->Features1.Features); break;
case kFeature_clause:
gettTree (& ((* yyt)->Feature_clause.Clients))
gettStringRef ((* yyt)->Feature_clause.comment)
yyt = & ((* yyt)->Feature_clause.Feature_decls); break;
case kClients1:
yyt = & ((* yyt)->Clients1.List); break;
case kFeature_decls1:
gettTree (& ((* yyt)->Feature_decls1.Feature_decl))
yyt = & ((* yyt)->Feature_decls1.Feature_decls); break;
case kFeature_decl:
gettTree (& ((* yyt)->Feature_decl.New_feature_list))
yyt = & ((* yyt)->Feature_decl.Declaration_body); break;
case kDeclaration_body:
gettTree (& ((* yyt)->Declaration_body.Formal_args))
gettTree (& ((* yyt)->Declaration_body.Type_mark))
yyt = & ((* yyt)->Declaration_body.Const_or_routine); break;
case kM_const:
yyt = & ((* yyt)->M_const.Manifest_constant); break;
case kUnique:
gettPosition ((* yyt)->Unique.pos)
return;
case kRoutine:
gettTree (& ((* yyt)->Routine.Obsolete))
gettStringRef ((* yyt)->Routine.comment)
gettTree (& ((* yyt)->Routine.Precondition))
gettTree (& ((* yyt)->Routine.Local_decls))
gettTree (& ((* yyt)->Routine.Routine_body))
gettTree (& ((* yyt)->Routine.Postcondition))
gettStringRef ((* yyt)->Routine.end_comment)
yyt = & ((* yyt)->Routine.Rescue); break;
case kParent_list1:
gettTree (& ((* yyt)->Parent_list1.Parent))
yyt = & ((* yyt)->Parent_list1.Parent_list); break;
case kParent:
gettTree (& ((* yyt)->Parent.Class_type))
yyt = & ((* yyt)->Parent.Feature_adaptation); break;
case kFeature_adaptation1:
gettTree (& ((* yyt)->Feature_adaptation1.Rename))
gettTree (& ((* yyt)->Feature_adaptation1.New_export))
gettTree (& ((* yyt)->Feature_adaptation1.Undefine))
gettTree (& ((* yyt)->Feature_adaptation1.Redefine))
yyt = & ((* yyt)->Feature_adaptation1.Select); break;
case kRename_list1:
gettTree (& ((* yyt)->Rename_list1.Rename_pair))
yyt = & ((* yyt)->Rename_list1.Rename_list); break;
case kRename_pair:
gettTree (& ((* yyt)->Rename_pair.Name1))
yyt = & ((* yyt)->Rename_pair.Name2); break;
case kCreators1:
gettTree (& ((* yyt)->Creators1.Creation_clause))
yyt = & ((* yyt)->Creators1.Creators); break;
case kCreation_clause:
gettTree (& ((* yyt)->Creation_clause.Clients))
gettStringRef ((* yyt)->Creation_clause.comment)
yyt = & ((* yyt)->Creation_clause.Feature_list); break;
case kNew_feature_list1:
gettTree (& ((* yyt)->New_feature_list1.Feature_name))
yyt = & ((* yyt)->New_feature_list1.New_feature_list); break;
case kFrozen:
yyt = & ((* yyt)->Frozen.Feature_name); break;
case kIdent_name:
yyt = & ((* yyt)->Ident_name.Id); break;
case kPrefix:
yyt = & ((* yyt)->Prefix.Op_name); break;
case kInfix:
yyt = & ((* yyt)->Infix.Op_name); break;
case kOp_name:
gettPosition ((* yyt)->Op_name.pos)
return;
case kFree_op:
gettPosition ((* yyt)->Free_op.pos)
gettIdent ((* yyt)->Free_op.ident)
return;
case kOper:
gettPosition ((* yyt)->Oper.pos)
getint ((* yyt)->Oper.op)
return;
case kNew_export_list1:
gettTree (& ((* yyt)->New_export_list1.New_export_item))
yyt = & ((* yyt)->New_export_list1.New_export_list); break;
case kNew_export_item:
gettTree (& ((* yyt)->New_export_item.Clients))
yyt = & ((* yyt)->New_export_item.Feature_set); break;
case kFeature_list1:
gettTree (& ((* yyt)->Feature_list1.Feature_name))
yyt = & ((* yyt)->Feature_list1.Feature_list); break;
case kFormal_args1:
gettTree (& ((* yyt)->Formal_args1.Entity_decl_group))
yyt = & ((* yyt)->Formal_args1.Formal_args); break;
case kDo_body:
yyt = & ((* yyt)->Do_body.Compound); break;
case kOnce_body:
yyt = & ((* yyt)->Once_body.Compound); break;
case kExternal:
gettTree (& ((* yyt)->External.Lang1))
yyt = & ((* yyt)->External.Lang2); break;
case kDeferred:
gettPosition ((* yyt)->Deferred.pos)
return;
case kEntity_decl_group:
gettTree (& ((* yyt)->Entity_decl_group.Id_list))
yyt = & ((* yyt)->Entity_decl_group.Type_mark); break;
case kFormal_generics1:
gettTree (& ((* yyt)->Formal_generics1.Formal_generic))
yyt = & ((* yyt)->Formal_generics1.Formal_generics); break;
case kFormal_generic:
gettTree (& ((* yyt)->Formal_generic.Id))
yyt = & ((* yyt)->Formal_generic.Constraint); break;
case kConstraint1:
yyt = & ((* yyt)->Constraint1.Class_type); break;
case kCompound1:
gettTree (& ((* yyt)->Compound1.Instruction))
yyt = & ((* yyt)->Compound1.Compound); break;
case kThen_part_list1:
gettTree (& ((* yyt)->Then_part_list1.Then_part))
yyt = & ((* yyt)->Then_part_list1.Then_part_list); break;
case kThen_part:
gettTree (& ((* yyt)->Then_part.Guard))
yyt = & ((* yyt)->Then_part.Compound); break;
case kWhen_part_list1:
gettTree (& ((* yyt)->When_part_list1.When_part))
yyt = & ((* yyt)->When_part_list1.When_part_list); break;
case kWhen_part:
gettTree (& ((* yyt)->When_part.Choices))
yyt = & ((* yyt)->When_part.Compound); break;
case kChoices1:
gettTree (& ((* yyt)->Choices1.Choice))
yyt = & ((* yyt)->Choices1.Choices); break;
case kInterval:
gettTree (& ((* yyt)->Interval.From))
yyt = & ((* yyt)->Interval.To); break;
case kVal:
yyt = & ((* yyt)->Val.Manifest_constant); break;
case kCreation:
gettTree (& ((* yyt)->Creation.Type))
gettTree (& ((* yyt)->Creation.Entity))
yyt = & ((* yyt)->Creation.Unqual_call); break;
case kCall_instruct:
yyt = & ((* yyt)->Call_instruct.Call); break;
case kAssign:
gettTree (& ((* yyt)->Assign.Addr))
yyt = & ((* yyt)->Assign.Expression); break;
case kRev_assign:
gettTree (& ((* yyt)->Rev_assign.Addr))
yyt = & ((* yyt)->Rev_assign.Expression); break;
case kConditional:
gettTree (& ((* yyt)->Conditional.Then_part))
yyt = & ((* yyt)->Conditional.Else_part); break;
case kMulti_branch:
gettTree (& ((* yyt)->Multi_branch.Guard))
gettTree (& ((* yyt)->Multi_branch.When_part_list))
yyt = & ((* yyt)->Multi_branch.Else_part); break;
case kLoop:
gettTree (& ((* yyt)->Loop.Initialization))
gettTree (& ((* yyt)->Loop.Invariant))
gettTree (& ((* yyt)->Loop.Variant))
yyt = & ((* yyt)->Loop.Loop_body); break;
case kCheck:
yyt = & ((* yyt)->Check.Assertion); break;
case kDebug:
gettTree (& ((* yyt)->Debug.Debug_keys))
yyt = & ((* yyt)->Debug.Compound); break;
case kRetry:
gettPosition ((* yyt)->Retry.pos)
return;
case kLoop_body1:
gettTree (& ((* yyt)->Loop_body1.Exit))
yyt = & ((* yyt)->Loop_body1.Compound); break;
case kClass_type:
gettTree (& ((* yyt)->Class_type.Id))
yyt = & ((* yyt)->Class_type.Actual_generics); break;
case kClass_type_expanded:
gettTree (& ((* yyt)->Class_type_expanded.Id))
yyt = & ((* yyt)->Class_type_expanded.Actual_generics); break;
case kBit_type:
yyt = & ((* yyt)->Bit_type.Manifest_constant); break;
case kSimple_type:
yyt = & ((* yyt)->Simple_type.Manifest_constant); break;
case kAnchored:
yyt = & ((* yyt)->Anchored.Entity); break;
case kActual_generics1:
yyt = & ((* yyt)->Actual_generics1.Type_list); break;
case kCondition1:
getint ((* yyt)->Condition1.extension)
yyt = & ((* yyt)->Condition1.Assertion); break;
case kAssertion1:
gettTree (& ((* yyt)->Assertion1.Assertion_clause))
yyt = & ((* yyt)->Assertion1.Assertion); break;
case kAssertion_clause1:
gettTree (& ((* yyt)->Assertion_clause1.Tag))
yyt = & ((* yyt)->Assertion_clause1.Expression); break;
case kType_list1:
gettTree (& ((* yyt)->Type_list1.Type))
yyt = & ((* yyt)->Type_list1.Type_list); break;
case kCall_chain1:
gettTree (& ((* yyt)->Call_chain1.Unqual_call))
yyt = & ((* yyt)->Call_chain1.Call_chain); break;
case kUnqual_call1:
gettTree (& ((* yyt)->Unqual_call1.Entity))
yyt = & ((* yyt)->Unqual_call1.Actuals); break;
case kActuals1:
yyt = & ((* yyt)->Actuals1.Actual_list); break;
case kActual_list1:
gettTree (& ((* yyt)->Actual_list1.Actual))
yyt = & ((* yyt)->Actual_list1.Actual_list); break;
case kAddr:
yyt = & ((* yyt)->Addr.Entity); break;
case kComment:
gettStringRef ((* yyt)->Comment.comment)
return;
case kSimple_expr:
yyt = & ((* yyt)->Simple_expr.Manifest_constant); break;
case kCall:
gettTree (& ((* yyt)->Call.Qual))
yyt = & ((* yyt)->Call.Call_chain); break;
case kBin_expr:
gettTree (& ((* yyt)->Bin_expr.Lop))
gettTree (& ((* yyt)->Bin_expr.Op))
yyt = & ((* yyt)->Bin_expr.Rop); break;
case kUn_expr:
gettTree (& ((* yyt)->Un_expr.Op))
yyt = & ((* yyt)->Un_expr.Expression); break;
case kParenth:
yyt = & ((* yyt)->Parenth.Expression); break;
case kManifest_array1:
gettTree (& ((* yyt)->Manifest_array1.Expression))
yyt = & ((* yyt)->Manifest_array1.Manifest_array); break;
case kOld:
yyt = & ((* yyt)->Old.Expression); break;
case kStrip:
yyt = & ((* yyt)->Strip.List); break;
case klist:
gettTree (& ((* yyt)->list.Manifest_constant))
yyt = & ((* yyt)->list.List); break;
case kCh:
getint ((* yyt)->Ch.ch)
gettPosition ((* yyt)->Ch.pos)
return;
case kTrue:
gettPosition ((* yyt)->True.pos)
return;
case kFalse:
gettPosition ((* yyt)->False.pos)
return;
case kInt:
getlong ((* yyt)->Int.value)
gettPosition ((* yyt)->Int.pos)
yyt = & ((* yyt)->Int.Sign); break;
case kReal:
getdouble ((* yyt)->Real.value)
gettPosition ((* yyt)->Real.pos)
yyt = & ((* yyt)->Real.Sign); break;
case k_CHARACTER:
gettPosition ((* yyt)->_CHARACTER.pos)
return;
case k_INTEGER:
gettPosition ((* yyt)->_INTEGER.pos)
return;
case k_REAL:
gettPosition ((* yyt)->_REAL.pos)
return;
case k_DOUBLE:
gettPosition ((* yyt)->_DOUBLE.pos)
return;
case k_BOOLEAN:
gettPosition ((* yyt)->_BOOLEAN.pos)
return;
case k_STRING:
gettPosition ((* yyt)->_STRING.pos)
return;
case k_BIT:
gettPosition ((* yyt)->_BIT.pos)
return;
case k_NONE:
gettPosition ((* yyt)->_NONE.pos)
return;
case kBitseq:
gettStringRef ((* yyt)->Bitseq.literal)
gettPosition ((* yyt)->Bitseq.pos)
return;
case kString:
gettStringRef ((* yyt)->String.string)
gettPosition ((* yyt)->String.pos)
return;
case kCurrent:
gettPosition ((* yyt)->Current.pos)
return;
case kResult:
gettPosition ((* yyt)->Result.pos)
return;
case kId:
gettIdent ((* yyt)->Id.ident)
gettPosition ((* yyt)->Id.pos)
return;
  default: return;
  }
 }
}

tTree GetTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf)
# else
 (yyyf) FILE * yyyf;
# endif
{
 tTree yyt;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyGetTree (& yyt);
 yyRecursionLevel --;
 return yyt;
}

static tTree yyChild;

static void yyReleaseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) return;
 switch (yyt->Kind) {
case kEiffel:
closetTree (yyt->Eiffel.Classes)
break;
case kClasses1:
closetTree (yyt->Classes1.Class_declaration)
closetTree (yyt->Classes1.Classes)
break;
case kClass_declaration:
closetTree (yyt->Class_declaration.Indexing)
closetTree (yyt->Class_declaration.Class_header)
closetTree (yyt->Class_declaration.Formal_generics)
closetTree (yyt->Class_declaration.Obsolete)
closetTree (yyt->Class_declaration.Inheritance)
closetTree (yyt->Class_declaration.Creators)
closetTree (yyt->Class_declaration.Features)
closetTree (yyt->Class_declaration.Invariant)
break;
case kIndex_list1:
closetTree (yyt->Index_list1.Index_clause)
closetTree (yyt->Index_list1.Index_list)
break;
case kIndex_clause:
closetTree (yyt->Index_clause.Index)
closetTree (yyt->Index_clause.Index_terms)
break;
case kClass:
closetTree (yyt->Class.Name)
break;
case kExpanded_class:
closetTree (yyt->Expanded_class.Name)
break;
case kDeferred_class:
closetTree (yyt->Deferred_class.Name)
break;
case kFeatures1:
closetTree (yyt->Features1.Feature_clause)
closetTree (yyt->Features1.Features)
break;
case kFeature_clause:
closetTree (yyt->Feature_clause.Clients)
closetTree (yyt->Feature_clause.Feature_decls)
break;
case kClients1:
closetTree (yyt->Clients1.List)
break;
case kFeature_decls1:
closetTree (yyt->Feature_decls1.Feature_decl)
closetTree (yyt->Feature_decls1.Feature_decls)
break;
case kFeature_decl:
closetTree (yyt->Feature_decl.New_feature_list)
closetTree (yyt->Feature_decl.Declaration_body)
break;
case kDeclaration_body:
closetTree (yyt->Declaration_body.Formal_args)
closetTree (yyt->Declaration_body.Type_mark)
closetTree (yyt->Declaration_body.Const_or_routine)
break;
case kM_const:
closetTree (yyt->M_const.Manifest_constant)
break;
case kRoutine:
closetTree (yyt->Routine.Obsolete)
closetTree (yyt->Routine.Precondition)
closetTree (yyt->Routine.Local_decls)
closetTree (yyt->Routine.Routine_body)
closetTree (yyt->Routine.Postcondition)
closetTree (yyt->Routine.Rescue)
break;
case kParent_list1:
closetTree (yyt->Parent_list1.Parent)
closetTree (yyt->Parent_list1.Parent_list)
break;
case kParent:
closetTree (yyt->Parent.Class_type)
closetTree (yyt->Parent.Feature_adaptation)
break;
case kFeature_adaptation1:
closetTree (yyt->Feature_adaptation1.Rename)
closetTree (yyt->Feature_adaptation1.New_export)
closetTree (yyt->Feature_adaptation1.Undefine)
closetTree (yyt->Feature_adaptation1.Redefine)
closetTree (yyt->Feature_adaptation1.Select)
break;
case kRename_list1:
closetTree (yyt->Rename_list1.Rename_pair)
closetTree (yyt->Rename_list1.Rename_list)
break;
case kRename_pair:
closetTree (yyt->Rename_pair.Name1)
closetTree (yyt->Rename_pair.Name2)
break;
case kCreators1:
closetTree (yyt->Creators1.Creation_clause)
closetTree (yyt->Creators1.Creators)
break;
case kCreation_clause:
closetTree (yyt->Creation_clause.Clients)
closetTree (yyt->Creation_clause.Feature_list)
break;
case kNew_feature_list1:
closetTree (yyt->New_feature_list1.Feature_name)
closetTree (yyt->New_feature_list1.New_feature_list)
break;
case kFrozen:
closetTree (yyt->Frozen.Feature_name)
break;
case kIdent_name:
closetTree (yyt->Ident_name.Id)
break;
case kPrefix:
closetTree (yyt->Prefix.Op_name)
break;
case kInfix:
closetTree (yyt->Infix.Op_name)
break;
case kNew_export_list1:
closetTree (yyt->New_export_list1.New_export_item)
closetTree (yyt->New_export_list1.New_export_list)
break;
case kNew_export_item:
closetTree (yyt->New_export_item.Clients)
closetTree (yyt->New_export_item.Feature_set)
break;
case kFeature_list1:
closetTree (yyt->Feature_list1.Feature_name)
closetTree (yyt->Feature_list1.Feature_list)
break;
case kFormal_args1:
closetTree (yyt->Formal_args1.Entity_decl_group)
closetTree (yyt->Formal_args1.Formal_args)
break;
case kDo_body:
closetTree (yyt->Do_body.Compound)
break;
case kOnce_body:
closetTree (yyt->Once_body.Compound)
break;
case kExternal:
closetTree (yyt->External.Lang1)
closetTree (yyt->External.Lang2)
break;
case kEntity_decl_group:
closetTree (yyt->Entity_decl_group.Id_list)
closetTree (yyt->Entity_decl_group.Type_mark)
break;
case kFormal_generics1:
closetTree (yyt->Formal_generics1.Formal_generic)
closetTree (yyt->Formal_generics1.Formal_generics)
break;
case kFormal_generic:
closetTree (yyt->Formal_generic.Id)
closetTree (yyt->Formal_generic.Constraint)
break;
case kConstraint1:
closetTree (yyt->Constraint1.Class_type)
break;
case kCompound1:
closetTree (yyt->Compound1.Instruction)
closetTree (yyt->Compound1.Compound)
break;
case kThen_part_list1:
closetTree (yyt->Then_part_list1.Then_part)
closetTree (yyt->Then_part_list1.Then_part_list)
break;
case kThen_part:
closetTree (yyt->Then_part.Guard)
closetTree (yyt->Then_part.Compound)
break;
case kWhen_part_list1:
closetTree (yyt->When_part_list1.When_part)
closetTree (yyt->When_part_list1.When_part_list)
break;
case kWhen_part:
closetTree (yyt->When_part.Choices)
closetTree (yyt->When_part.Compound)
break;
case kChoices1:
closetTree (yyt->Choices1.Choice)
closetTree (yyt->Choices1.Choices)
break;
case kInterval:
closetTree (yyt->Interval.From)
closetTree (yyt->Interval.To)
break;
case kVal:
closetTree (yyt->Val.Manifest_constant)
break;
case kCreation:
closetTree (yyt->Creation.Type)
closetTree (yyt->Creation.Entity)
closetTree (yyt->Creation.Unqual_call)
break;
case kCall_instruct:
closetTree (yyt->Call_instruct.Call)
break;
case kAssign:
closetTree (yyt->Assign.Addr)
closetTree (yyt->Assign.Expression)
break;
case kRev_assign:
closetTree (yyt->Rev_assign.Addr)
closetTree (yyt->Rev_assign.Expression)
break;
case kConditional:
closetTree (yyt->Conditional.Then_part)
closetTree (yyt->Conditional.Else_part)
break;
case kMulti_branch:
closetTree (yyt->Multi_branch.Guard)
closetTree (yyt->Multi_branch.When_part_list)
closetTree (yyt->Multi_branch.Else_part)
break;
case kLoop:
closetTree (yyt->Loop.Initialization)
closetTree (yyt->Loop.Invariant)
closetTree (yyt->Loop.Variant)
closetTree (yyt->Loop.Loop_body)
break;
case kCheck:
closetTree (yyt->Check.Assertion)
break;
case kDebug:
closetTree (yyt->Debug.Debug_keys)
closetTree (yyt->Debug.Compound)
break;
case kLoop_body1:
closetTree (yyt->Loop_body1.Exit)
closetTree (yyt->Loop_body1.Compound)
break;
case kClass_type:
closetTree (yyt->Class_type.Id)
closetTree (yyt->Class_type.Actual_generics)
break;
case kClass_type_expanded:
closetTree (yyt->Class_type_expanded.Id)
closetTree (yyt->Class_type_expanded.Actual_generics)
break;
case kBit_type:
closetTree (yyt->Bit_type.Manifest_constant)
break;
case kSimple_type:
closetTree (yyt->Simple_type.Manifest_constant)
break;
case kAnchored:
closetTree (yyt->Anchored.Entity)
break;
case kActual_generics1:
closetTree (yyt->Actual_generics1.Type_list)
break;
case kCondition1:
closetTree (yyt->Condition1.Assertion)
break;
case kAssertion1:
closetTree (yyt->Assertion1.Assertion_clause)
closetTree (yyt->Assertion1.Assertion)
break;
case kAssertion_clause1:
closetTree (yyt->Assertion_clause1.Tag)
closetTree (yyt->Assertion_clause1.Expression)
break;
case kType_list1:
closetTree (yyt->Type_list1.Type)
closetTree (yyt->Type_list1.Type_list)
break;
case kCall_chain1:
closetTree (yyt->Call_chain1.Unqual_call)
closetTree (yyt->Call_chain1.Call_chain)
break;
case kUnqual_call1:
closetTree (yyt->Unqual_call1.Entity)
closetTree (yyt->Unqual_call1.Actuals)
break;
case kActuals1:
closetTree (yyt->Actuals1.Actual_list)
break;
case kActual_list1:
closetTree (yyt->Actual_list1.Actual)
closetTree (yyt->Actual_list1.Actual_list)
break;
case kAddr:
closetTree (yyt->Addr.Entity)
break;
case kSimple_expr:
closetTree (yyt->Simple_expr.Manifest_constant)
break;
case kCall:
closetTree (yyt->Call.Qual)
closetTree (yyt->Call.Call_chain)
break;
case kBin_expr:
closetTree (yyt->Bin_expr.Lop)
closetTree (yyt->Bin_expr.Op)
closetTree (yyt->Bin_expr.Rop)
break;
case kUn_expr:
closetTree (yyt->Un_expr.Op)
closetTree (yyt->Un_expr.Expression)
break;
case kParenth:
closetTree (yyt->Parenth.Expression)
break;
case kManifest_array1:
closetTree (yyt->Manifest_array1.Expression)
closetTree (yyt->Manifest_array1.Manifest_array)
break;
case kOld:
closetTree (yyt->Old.Expression)
break;
case kStrip:
closetTree (yyt->Strip.List)
break;
case klist:
closetTree (yyt->list.Manifest_constant)
closetTree (yyt->list.List)
break;
case kInt:
closetTree (yyt->Int.Sign)
break;
case kReal:
closetTree (yyt->Real.Sign)
break;
 default: ;
 }

 if (-- yyt->yyHead.yyMark == 0) {
  switch (yyt->Kind) {
case kClass_declaration:
closetStringRef (yyt->Class_declaration.comment)
break;
case kFeature_clause:
closetStringRef (yyt->Feature_clause.comment)
break;
case kUnique:
closetPosition (yyt->Unique.pos)
break;
case kRoutine:
closetStringRef (yyt->Routine.comment)
closetStringRef (yyt->Routine.end_comment)
break;
case kCreation_clause:
closetStringRef (yyt->Creation_clause.comment)
break;
case kOp_name:
closetPosition (yyt->Op_name.pos)
break;
case kFree_op:
closetPosition (yyt->Free_op.pos)
closetIdent (yyt->Free_op.ident)
break;
case kOper:
closetPosition (yyt->Oper.pos)
closeint (yyt->Oper.op)
break;
case kDeferred:
closetPosition (yyt->Deferred.pos)
break;
case kRetry:
closetPosition (yyt->Retry.pos)
break;
case kCondition1:
closeint (yyt->Condition1.extension)
break;
case kComment:
closetStringRef (yyt->Comment.comment)
break;
case kCh:
closeint (yyt->Ch.ch)
closetPosition (yyt->Ch.pos)
break;
case kTrue:
closetPosition (yyt->True.pos)
break;
case kFalse:
closetPosition (yyt->False.pos)
break;
case kInt:
closelong (yyt->Int.value)
closetPosition (yyt->Int.pos)
break;
case kReal:
closedouble (yyt->Real.value)
closetPosition (yyt->Real.pos)
break;
case k_CHARACTER:
closetPosition (yyt->_CHARACTER.pos)
break;
case k_INTEGER:
closetPosition (yyt->_INTEGER.pos)
break;
case k_REAL:
closetPosition (yyt->_REAL.pos)
break;
case k_DOUBLE:
closetPosition (yyt->_DOUBLE.pos)
break;
case k_BOOLEAN:
closetPosition (yyt->_BOOLEAN.pos)
break;
case k_STRING:
closetPosition (yyt->_STRING.pos)
break;
case k_BIT:
closetPosition (yyt->_BIT.pos)
break;
case k_NONE:
closetPosition (yyt->_NONE.pos)
break;
case kBitseq:
closetStringRef (yyt->Bitseq.literal)
closetPosition (yyt->Bitseq.pos)
break;
case kString:
closetStringRef (yyt->String.string)
closetPosition (yyt->String.pos)
break;
case kCurrent:
closetPosition (yyt->Current.pos)
break;
case kResult:
closetPosition (yyt->Result.pos)
break;
case kId:
closetIdent (yyt->Id.ident)
closetPosition (yyt->Id.pos)
break;
  default: ;
  }
  yyFREE (yyt, Tree_NodeSize [yyt->Kind])
 }
}

void ReleaseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyMark (yyt);
 yyReleaseTree (yyt);
}

void ReleaseTreeModule ()
{
 yytBlockPtr yyBlockPtr;
 while (yyBlockList != (yytBlockPtr) NoTree) {
  yyBlockPtr = yyBlockList;
  yyBlockList = yyBlockList->yySuccessor;
  Free (sizeof (yytBlock), (char *) yyBlockPtr);
 }
 Tree_PoolFreePtr = (char *) NoTree;
 Tree_PoolMaxPtr = (char *) NoTree;
 Tree_HeapUsed = 0;
}

static Tree_tProcTree yyProc;

static void yyTraverseTreeTD
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || yyt->yyHead.yyMark == 0) return;
  yyt->yyHead.yyMark = 0;
  yyProc (yyt);

  switch (yyt->Kind) {
case kEiffel:
yyt = yyt->Eiffel.Classes; break;
case kClasses1:
yyTraverseTreeTD (yyt->Classes1.Class_declaration);
yyt = yyt->Classes1.Classes; break;
case kClass_declaration:
yyTraverseTreeTD (yyt->Class_declaration.Indexing);
yyTraverseTreeTD (yyt->Class_declaration.Class_header);
yyTraverseTreeTD (yyt->Class_declaration.Formal_generics);
yyTraverseTreeTD (yyt->Class_declaration.Obsolete);
yyTraverseTreeTD (yyt->Class_declaration.Inheritance);
yyTraverseTreeTD (yyt->Class_declaration.Creators);
yyTraverseTreeTD (yyt->Class_declaration.Features);
yyt = yyt->Class_declaration.Invariant; break;
case kIndex_list1:
yyTraverseTreeTD (yyt->Index_list1.Index_clause);
yyt = yyt->Index_list1.Index_list; break;
case kIndex_clause:
yyTraverseTreeTD (yyt->Index_clause.Index);
yyt = yyt->Index_clause.Index_terms; break;
case kClass:
yyt = yyt->Class.Name; break;
case kExpanded_class:
yyt = yyt->Expanded_class.Name; break;
case kDeferred_class:
yyt = yyt->Deferred_class.Name; break;
case kFeatures1:
yyTraverseTreeTD (yyt->Features1.Feature_clause);
yyt = yyt->Features1.Features; break;
case kFeature_clause:
yyTraverseTreeTD (yyt->Feature_clause.Clients);
yyt = yyt->Feature_clause.Feature_decls; break;
case kClients1:
yyt = yyt->Clients1.List; break;
case kFeature_decls1:
yyTraverseTreeTD (yyt->Feature_decls1.Feature_decl);
yyt = yyt->Feature_decls1.Feature_decls; break;
case kFeature_decl:
yyTraverseTreeTD (yyt->Feature_decl.New_feature_list);
yyt = yyt->Feature_decl.Declaration_body; break;
case kDeclaration_body:
yyTraverseTreeTD (yyt->Declaration_body.Formal_args);
yyTraverseTreeTD (yyt->Declaration_body.Type_mark);
yyt = yyt->Declaration_body.Const_or_routine; break;
case kM_const:
yyt = yyt->M_const.Manifest_constant; break;
case kRoutine:
yyTraverseTreeTD (yyt->Routine.Obsolete);
yyTraverseTreeTD (yyt->Routine.Precondition);
yyTraverseTreeTD (yyt->Routine.Local_decls);
yyTraverseTreeTD (yyt->Routine.Routine_body);
yyTraverseTreeTD (yyt->Routine.Postcondition);
yyt = yyt->Routine.Rescue; break;
case kParent_list1:
yyTraverseTreeTD (yyt->Parent_list1.Parent);
yyt = yyt->Parent_list1.Parent_list; break;
case kParent:
yyTraverseTreeTD (yyt->Parent.Class_type);
yyt = yyt->Parent.Feature_adaptation; break;
case kFeature_adaptation1:
yyTraverseTreeTD (yyt->Feature_adaptation1.Rename);
yyTraverseTreeTD (yyt->Feature_adaptation1.New_export);
yyTraverseTreeTD (yyt->Feature_adaptation1.Undefine);
yyTraverseTreeTD (yyt->Feature_adaptation1.Redefine);
yyt = yyt->Feature_adaptation1.Select; break;
case kRename_list1:
yyTraverseTreeTD (yyt->Rename_list1.Rename_pair);
yyt = yyt->Rename_list1.Rename_list; break;
case kRename_pair:
yyTraverseTreeTD (yyt->Rename_pair.Name1);
yyt = yyt->Rename_pair.Name2; break;
case kCreators1:
yyTraverseTreeTD (yyt->Creators1.Creation_clause);
yyt = yyt->Creators1.Creators; break;
case kCreation_clause:
yyTraverseTreeTD (yyt->Creation_clause.Clients);
yyt = yyt->Creation_clause.Feature_list; break;
case kNew_feature_list1:
yyTraverseTreeTD (yyt->New_feature_list1.Feature_name);
yyt = yyt->New_feature_list1.New_feature_list; break;
case kFrozen:
yyt = yyt->Frozen.Feature_name; break;
case kIdent_name:
yyt = yyt->Ident_name.Id; break;
case kPrefix:
yyt = yyt->Prefix.Op_name; break;
case kInfix:
yyt = yyt->Infix.Op_name; break;
case kNew_export_list1:
yyTraverseTreeTD (yyt->New_export_list1.New_export_item);
yyt = yyt->New_export_list1.New_export_list; break;
case kNew_export_item:
yyTraverseTreeTD (yyt->New_export_item.Clients);
yyt = yyt->New_export_item.Feature_set; break;
case kFeature_list1:
yyTraverseTreeTD (yyt->Feature_list1.Feature_name);
yyt = yyt->Feature_list1.Feature_list; break;
case kFormal_args1:
yyTraverseTreeTD (yyt->Formal_args1.Entity_decl_group);
yyt = yyt->Formal_args1.Formal_args; break;
case kDo_body:
yyt = yyt->Do_body.Compound; break;
case kOnce_body:
yyt = yyt->Once_body.Compound; break;
case kExternal:
yyTraverseTreeTD (yyt->External.Lang1);
yyt = yyt->External.Lang2; break;
case kEntity_decl_group:
yyTraverseTreeTD (yyt->Entity_decl_group.Id_list);
yyt = yyt->Entity_decl_group.Type_mark; break;
case kFormal_generics1:
yyTraverseTreeTD (yyt->Formal_generics1.Formal_generic);
yyt = yyt->Formal_generics1.Formal_generics; break;
case kFormal_generic:
yyTraverseTreeTD (yyt->Formal_generic.Id);
yyt = yyt->Formal_generic.Constraint; break;
case kConstraint1:
yyt = yyt->Constraint1.Class_type; break;
case kCompound1:
yyTraverseTreeTD (yyt->Compound1.Instruction);
yyt = yyt->Compound1.Compound; break;
case kThen_part_list1:
yyTraverseTreeTD (yyt->Then_part_list1.Then_part);
yyt = yyt->Then_part_list1.Then_part_list; break;
case kThen_part:
yyTraverseTreeTD (yyt->Then_part.Guard);
yyt = yyt->Then_part.Compound; break;
case kWhen_part_list1:
yyTraverseTreeTD (yyt->When_part_list1.When_part);
yyt = yyt->When_part_list1.When_part_list; break;
case kWhen_part:
yyTraverseTreeTD (yyt->When_part.Choices);
yyt = yyt->When_part.Compound; break;
case kChoices1:
yyTraverseTreeTD (yyt->Choices1.Choice);
yyt = yyt->Choices1.Choices; break;
case kInterval:
yyTraverseTreeTD (yyt->Interval.From);
yyt = yyt->Interval.To; break;
case kVal:
yyt = yyt->Val.Manifest_constant; break;
case kCreation:
yyTraverseTreeTD (yyt->Creation.Type);
yyTraverseTreeTD (yyt->Creation.Entity);
yyt = yyt->Creation.Unqual_call; break;
case kCall_instruct:
yyt = yyt->Call_instruct.Call; break;
case kAssign:
yyTraverseTreeTD (yyt->Assign.Addr);
yyt = yyt->Assign.Expression; break;
case kRev_assign:
yyTraverseTreeTD (yyt->Rev_assign.Addr);
yyt = yyt->Rev_assign.Expression; break;
case kConditional:
yyTraverseTreeTD (yyt->Conditional.Then_part);
yyt = yyt->Conditional.Else_part; break;
case kMulti_branch:
yyTraverseTreeTD (yyt->Multi_branch.Guard);
yyTraverseTreeTD (yyt->Multi_branch.When_part_list);
yyt = yyt->Multi_branch.Else_part; break;
case kLoop:
yyTraverseTreeTD (yyt->Loop.Initialization);
yyTraverseTreeTD (yyt->Loop.Invariant);
yyTraverseTreeTD (yyt->Loop.Variant);
yyt = yyt->Loop.Loop_body; break;
case kCheck:
yyt = yyt->Check.Assertion; break;
case kDebug:
yyTraverseTreeTD (yyt->Debug.Debug_keys);
yyt = yyt->Debug.Compound; break;
case kLoop_body1:
yyTraverseTreeTD (yyt->Loop_body1.Exit);
yyt = yyt->Loop_body1.Compound; break;
case kClass_type:
yyTraverseTreeTD (yyt->Class_type.Id);
yyt = yyt->Class_type.Actual_generics; break;
case kClass_type_expanded:
yyTraverseTreeTD (yyt->Class_type_expanded.Id);
yyt = yyt->Class_type_expanded.Actual_generics; break;
case kBit_type:
yyt = yyt->Bit_type.Manifest_constant; break;
case kSimple_type:
yyt = yyt->Simple_type.Manifest_constant; break;
case kAnchored:
yyt = yyt->Anchored.Entity; break;
case kActual_generics1:
yyt = yyt->Actual_generics1.Type_list; break;
case kCondition1:
yyt = yyt->Condition1.Assertion; break;
case kAssertion1:
yyTraverseTreeTD (yyt->Assertion1.Assertion_clause);
yyt = yyt->Assertion1.Assertion; break;
case kAssertion_clause1:
yyTraverseTreeTD (yyt->Assertion_clause1.Tag);
yyt = yyt->Assertion_clause1.Expression; break;
case kType_list1:
yyTraverseTreeTD (yyt->Type_list1.Type);
yyt = yyt->Type_list1.Type_list; break;
case kCall_chain1:
yyTraverseTreeTD (yyt->Call_chain1.Unqual_call);
yyt = yyt->Call_chain1.Call_chain; break;
case kUnqual_call1:
yyTraverseTreeTD (yyt->Unqual_call1.Entity);
yyt = yyt->Unqual_call1.Actuals; break;
case kActuals1:
yyt = yyt->Actuals1.Actual_list; break;
case kActual_list1:
yyTraverseTreeTD (yyt->Actual_list1.Actual);
yyt = yyt->Actual_list1.Actual_list; break;
case kAddr:
yyt = yyt->Addr.Entity; break;
case kSimple_expr:
yyt = yyt->Simple_expr.Manifest_constant; break;
case kCall:
yyTraverseTreeTD (yyt->Call.Qual);
yyt = yyt->Call.Call_chain; break;
case kBin_expr:
yyTraverseTreeTD (yyt->Bin_expr.Lop);
yyTraverseTreeTD (yyt->Bin_expr.Op);
yyt = yyt->Bin_expr.Rop; break;
case kUn_expr:
yyTraverseTreeTD (yyt->Un_expr.Op);
yyt = yyt->Un_expr.Expression; break;
case kParenth:
yyt = yyt->Parenth.Expression; break;
case kManifest_array1:
yyTraverseTreeTD (yyt->Manifest_array1.Expression);
yyt = yyt->Manifest_array1.Manifest_array; break;
case kOld:
yyt = yyt->Old.Expression; break;
case kStrip:
yyt = yyt->Strip.List; break;
case klist:
yyTraverseTreeTD (yyt->list.Manifest_constant);
yyt = yyt->list.List; break;
case kInt:
yyt = yyt->Int.Sign; break;
case kReal:
yyt = yyt->Real.Sign; break;
  default: return;
  }
 }
}

void TraverseTreeTD
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, Tree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tTree yyt; Tree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseTreeTD (yyt);
}

static void yyTraverseTreeBU
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree || yyt->yyHead.yyMark == 0) return;
 yyt->yyHead.yyMark = 0;

 switch (yyt->Kind) {
case kEiffel:
yyTraverseTreeBU (yyt->Eiffel.Classes); break;
case kClasses1:
yyTraverseTreeBU (yyt->Classes1.Class_declaration);
yyTraverseTreeBU (yyt->Classes1.Classes); break;
case kClass_declaration:
yyTraverseTreeBU (yyt->Class_declaration.Indexing);
yyTraverseTreeBU (yyt->Class_declaration.Class_header);
yyTraverseTreeBU (yyt->Class_declaration.Formal_generics);
yyTraverseTreeBU (yyt->Class_declaration.Obsolete);
yyTraverseTreeBU (yyt->Class_declaration.Inheritance);
yyTraverseTreeBU (yyt->Class_declaration.Creators);
yyTraverseTreeBU (yyt->Class_declaration.Features);
yyTraverseTreeBU (yyt->Class_declaration.Invariant); break;
case kIndex_list1:
yyTraverseTreeBU (yyt->Index_list1.Index_clause);
yyTraverseTreeBU (yyt->Index_list1.Index_list); break;
case kIndex_clause:
yyTraverseTreeBU (yyt->Index_clause.Index);
yyTraverseTreeBU (yyt->Index_clause.Index_terms); break;
case kClass:
yyTraverseTreeBU (yyt->Class.Name); break;
case kExpanded_class:
yyTraverseTreeBU (yyt->Expanded_class.Name); break;
case kDeferred_class:
yyTraverseTreeBU (yyt->Deferred_class.Name); break;
case kFeatures1:
yyTraverseTreeBU (yyt->Features1.Feature_clause);
yyTraverseTreeBU (yyt->Features1.Features); break;
case kFeature_clause:
yyTraverseTreeBU (yyt->Feature_clause.Clients);
yyTraverseTreeBU (yyt->Feature_clause.Feature_decls); break;
case kClients1:
yyTraverseTreeBU (yyt->Clients1.List); break;
case kFeature_decls1:
yyTraverseTreeBU (yyt->Feature_decls1.Feature_decl);
yyTraverseTreeBU (yyt->Feature_decls1.Feature_decls); break;
case kFeature_decl:
yyTraverseTreeBU (yyt->Feature_decl.New_feature_list);
yyTraverseTreeBU (yyt->Feature_decl.Declaration_body); break;
case kDeclaration_body:
yyTraverseTreeBU (yyt->Declaration_body.Formal_args);
yyTraverseTreeBU (yyt->Declaration_body.Type_mark);
yyTraverseTreeBU (yyt->Declaration_body.Const_or_routine); break;
case kM_const:
yyTraverseTreeBU (yyt->M_const.Manifest_constant); break;
case kRoutine:
yyTraverseTreeBU (yyt->Routine.Obsolete);
yyTraverseTreeBU (yyt->Routine.Precondition);
yyTraverseTreeBU (yyt->Routine.Local_decls);
yyTraverseTreeBU (yyt->Routine.Routine_body);
yyTraverseTreeBU (yyt->Routine.Postcondition);
yyTraverseTreeBU (yyt->Routine.Rescue); break;
case kParent_list1:
yyTraverseTreeBU (yyt->Parent_list1.Parent);
yyTraverseTreeBU (yyt->Parent_list1.Parent_list); break;
case kParent:
yyTraverseTreeBU (yyt->Parent.Class_type);
yyTraverseTreeBU (yyt->Parent.Feature_adaptation); break;
case kFeature_adaptation1:
yyTraverseTreeBU (yyt->Feature_adaptation1.Rename);
yyTraverseTreeBU (yyt->Feature_adaptation1.New_export);
yyTraverseTreeBU (yyt->Feature_adaptation1.Undefine);
yyTraverseTreeBU (yyt->Feature_adaptation1.Redefine);
yyTraverseTreeBU (yyt->Feature_adaptation1.Select); break;
case kRename_list1:
yyTraverseTreeBU (yyt->Rename_list1.Rename_pair);
yyTraverseTreeBU (yyt->Rename_list1.Rename_list); break;
case kRename_pair:
yyTraverseTreeBU (yyt->Rename_pair.Name1);
yyTraverseTreeBU (yyt->Rename_pair.Name2); break;
case kCreators1:
yyTraverseTreeBU (yyt->Creators1.Creation_clause);
yyTraverseTreeBU (yyt->Creators1.Creators); break;
case kCreation_clause:
yyTraverseTreeBU (yyt->Creation_clause.Clients);
yyTraverseTreeBU (yyt->Creation_clause.Feature_list); break;
case kNew_feature_list1:
yyTraverseTreeBU (yyt->New_feature_list1.Feature_name);
yyTraverseTreeBU (yyt->New_feature_list1.New_feature_list); break;
case kFrozen:
yyTraverseTreeBU (yyt->Frozen.Feature_name); break;
case kIdent_name:
yyTraverseTreeBU (yyt->Ident_name.Id); break;
case kPrefix:
yyTraverseTreeBU (yyt->Prefix.Op_name); break;
case kInfix:
yyTraverseTreeBU (yyt->Infix.Op_name); break;
case kNew_export_list1:
yyTraverseTreeBU (yyt->New_export_list1.New_export_item);
yyTraverseTreeBU (yyt->New_export_list1.New_export_list); break;
case kNew_export_item:
yyTraverseTreeBU (yyt->New_export_item.Clients);
yyTraverseTreeBU (yyt->New_export_item.Feature_set); break;
case kFeature_list1:
yyTraverseTreeBU (yyt->Feature_list1.Feature_name);
yyTraverseTreeBU (yyt->Feature_list1.Feature_list); break;
case kFormal_args1:
yyTraverseTreeBU (yyt->Formal_args1.Entity_decl_group);
yyTraverseTreeBU (yyt->Formal_args1.Formal_args); break;
case kDo_body:
yyTraverseTreeBU (yyt->Do_body.Compound); break;
case kOnce_body:
yyTraverseTreeBU (yyt->Once_body.Compound); break;
case kExternal:
yyTraverseTreeBU (yyt->External.Lang1);
yyTraverseTreeBU (yyt->External.Lang2); break;
case kEntity_decl_group:
yyTraverseTreeBU (yyt->Entity_decl_group.Id_list);
yyTraverseTreeBU (yyt->Entity_decl_group.Type_mark); break;
case kFormal_generics1:
yyTraverseTreeBU (yyt->Formal_generics1.Formal_generic);
yyTraverseTreeBU (yyt->Formal_generics1.Formal_generics); break;
case kFormal_generic:
yyTraverseTreeBU (yyt->Formal_generic.Id);
yyTraverseTreeBU (yyt->Formal_generic.Constraint); break;
case kConstraint1:
yyTraverseTreeBU (yyt->Constraint1.Class_type); break;
case kCompound1:
yyTraverseTreeBU (yyt->Compound1.Instruction);
yyTraverseTreeBU (yyt->Compound1.Compound); break;
case kThen_part_list1:
yyTraverseTreeBU (yyt->Then_part_list1.Then_part);
yyTraverseTreeBU (yyt->Then_part_list1.Then_part_list); break;
case kThen_part:
yyTraverseTreeBU (yyt->Then_part.Guard);
yyTraverseTreeBU (yyt->Then_part.Compound); break;
case kWhen_part_list1:
yyTraverseTreeBU (yyt->When_part_list1.When_part);
yyTraverseTreeBU (yyt->When_part_list1.When_part_list); break;
case kWhen_part:
yyTraverseTreeBU (yyt->When_part.Choices);
yyTraverseTreeBU (yyt->When_part.Compound); break;
case kChoices1:
yyTraverseTreeBU (yyt->Choices1.Choice);
yyTraverseTreeBU (yyt->Choices1.Choices); break;
case kInterval:
yyTraverseTreeBU (yyt->Interval.From);
yyTraverseTreeBU (yyt->Interval.To); break;
case kVal:
yyTraverseTreeBU (yyt->Val.Manifest_constant); break;
case kCreation:
yyTraverseTreeBU (yyt->Creation.Type);
yyTraverseTreeBU (yyt->Creation.Entity);
yyTraverseTreeBU (yyt->Creation.Unqual_call); break;
case kCall_instruct:
yyTraverseTreeBU (yyt->Call_instruct.Call); break;
case kAssign:
yyTraverseTreeBU (yyt->Assign.Addr);
yyTraverseTreeBU (yyt->Assign.Expression); break;
case kRev_assign:
yyTraverseTreeBU (yyt->Rev_assign.Addr);
yyTraverseTreeBU (yyt->Rev_assign.Expression); break;
case kConditional:
yyTraverseTreeBU (yyt->Conditional.Then_part);
yyTraverseTreeBU (yyt->Conditional.Else_part); break;
case kMulti_branch:
yyTraverseTreeBU (yyt->Multi_branch.Guard);
yyTraverseTreeBU (yyt->Multi_branch.When_part_list);
yyTraverseTreeBU (yyt->Multi_branch.Else_part); break;
case kLoop:
yyTraverseTreeBU (yyt->Loop.Initialization);
yyTraverseTreeBU (yyt->Loop.Invariant);
yyTraverseTreeBU (yyt->Loop.Variant);
yyTraverseTreeBU (yyt->Loop.Loop_body); break;
case kCheck:
yyTraverseTreeBU (yyt->Check.Assertion); break;
case kDebug:
yyTraverseTreeBU (yyt->Debug.Debug_keys);
yyTraverseTreeBU (yyt->Debug.Compound); break;
case kLoop_body1:
yyTraverseTreeBU (yyt->Loop_body1.Exit);
yyTraverseTreeBU (yyt->Loop_body1.Compound); break;
case kClass_type:
yyTraverseTreeBU (yyt->Class_type.Id);
yyTraverseTreeBU (yyt->Class_type.Actual_generics); break;
case kClass_type_expanded:
yyTraverseTreeBU (yyt->Class_type_expanded.Id);
yyTraverseTreeBU (yyt->Class_type_expanded.Actual_generics); break;
case kBit_type:
yyTraverseTreeBU (yyt->Bit_type.Manifest_constant); break;
case kSimple_type:
yyTraverseTreeBU (yyt->Simple_type.Manifest_constant); break;
case kAnchored:
yyTraverseTreeBU (yyt->Anchored.Entity); break;
case kActual_generics1:
yyTraverseTreeBU (yyt->Actual_generics1.Type_list); break;
case kCondition1:
yyTraverseTreeBU (yyt->Condition1.Assertion); break;
case kAssertion1:
yyTraverseTreeBU (yyt->Assertion1.Assertion_clause);
yyTraverseTreeBU (yyt->Assertion1.Assertion); break;
case kAssertion_clause1:
yyTraverseTreeBU (yyt->Assertion_clause1.Tag);
yyTraverseTreeBU (yyt->Assertion_clause1.Expression); break;
case kType_list1:
yyTraverseTreeBU (yyt->Type_list1.Type);
yyTraverseTreeBU (yyt->Type_list1.Type_list); break;
case kCall_chain1:
yyTraverseTreeBU (yyt->Call_chain1.Unqual_call);
yyTraverseTreeBU (yyt->Call_chain1.Call_chain); break;
case kUnqual_call1:
yyTraverseTreeBU (yyt->Unqual_call1.Entity);
yyTraverseTreeBU (yyt->Unqual_call1.Actuals); break;
case kActuals1:
yyTraverseTreeBU (yyt->Actuals1.Actual_list); break;
case kActual_list1:
yyTraverseTreeBU (yyt->Actual_list1.Actual);
yyTraverseTreeBU (yyt->Actual_list1.Actual_list); break;
case kAddr:
yyTraverseTreeBU (yyt->Addr.Entity); break;
case kSimple_expr:
yyTraverseTreeBU (yyt->Simple_expr.Manifest_constant); break;
case kCall:
yyTraverseTreeBU (yyt->Call.Qual);
yyTraverseTreeBU (yyt->Call.Call_chain); break;
case kBin_expr:
yyTraverseTreeBU (yyt->Bin_expr.Lop);
yyTraverseTreeBU (yyt->Bin_expr.Op);
yyTraverseTreeBU (yyt->Bin_expr.Rop); break;
case kUn_expr:
yyTraverseTreeBU (yyt->Un_expr.Op);
yyTraverseTreeBU (yyt->Un_expr.Expression); break;
case kParenth:
yyTraverseTreeBU (yyt->Parenth.Expression); break;
case kManifest_array1:
yyTraverseTreeBU (yyt->Manifest_array1.Expression);
yyTraverseTreeBU (yyt->Manifest_array1.Manifest_array); break;
case kOld:
yyTraverseTreeBU (yyt->Old.Expression); break;
case kStrip:
yyTraverseTreeBU (yyt->Strip.List); break;
case klist:
yyTraverseTreeBU (yyt->list.Manifest_constant);
yyTraverseTreeBU (yyt->list.List); break;
case kInt:
yyTraverseTreeBU (yyt->Int.Sign); break;
case kReal:
yyTraverseTreeBU (yyt->Real.Sign); break;
 default: ;
 }
 yyProc (yyt);
}

void TraverseTreeBU
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, Tree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tTree yyt; Tree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseTreeBU (yyt);
}

tTree ReverseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register tTree yyNew, yyNext, yyTail;
 yyNew = yyOld;
 yyTail = yyOld;
 for (;;) {
  switch (yyOld->Kind) {
case kClasses1: yyNext = yyOld->Classes1.Classes; yyOld->Classes1.Classes = yyNew; break;
case kIndex_list1: yyNext = yyOld->Index_list1.Index_list; yyOld->Index_list1.Index_list = yyNew; break;
case kFeatures1: yyNext = yyOld->Features1.Features; yyOld->Features1.Features = yyNew; break;
case kFeature_decls1: yyNext = yyOld->Feature_decls1.Feature_decls; yyOld->Feature_decls1.Feature_decls = yyNew; break;
case kParent_list1: yyNext = yyOld->Parent_list1.Parent_list; yyOld->Parent_list1.Parent_list = yyNew; break;
case kRename_list1: yyNext = yyOld->Rename_list1.Rename_list; yyOld->Rename_list1.Rename_list = yyNew; break;
case kCreators1: yyNext = yyOld->Creators1.Creators; yyOld->Creators1.Creators = yyNew; break;
case kNew_feature_list1: yyNext = yyOld->New_feature_list1.New_feature_list; yyOld->New_feature_list1.New_feature_list = yyNew; break;
case kNew_export_list1: yyNext = yyOld->New_export_list1.New_export_list; yyOld->New_export_list1.New_export_list = yyNew; break;
case kNew_export_item: yyNext = yyOld->New_export_item.Feature_set; yyOld->New_export_item.Feature_set = yyNew; break;
case kFeature_list1: yyNext = yyOld->Feature_list1.Feature_list; yyOld->Feature_list1.Feature_list = yyNew; break;
case kFormal_args1: yyNext = yyOld->Formal_args1.Formal_args; yyOld->Formal_args1.Formal_args = yyNew; break;
case kFormal_generics1: yyNext = yyOld->Formal_generics1.Formal_generics; yyOld->Formal_generics1.Formal_generics = yyNew; break;
case kCompound1: yyNext = yyOld->Compound1.Compound; yyOld->Compound1.Compound = yyNew; break;
case kThen_part_list1: yyNext = yyOld->Then_part_list1.Then_part_list; yyOld->Then_part_list1.Then_part_list = yyNew; break;
case kWhen_part_list1: yyNext = yyOld->When_part_list1.When_part_list; yyOld->When_part_list1.When_part_list = yyNew; break;
case kChoices1: yyNext = yyOld->Choices1.Choices; yyOld->Choices1.Choices = yyNew; break;
case kType_list1: yyNext = yyOld->Type_list1.Type_list; yyOld->Type_list1.Type_list = yyNew; break;
case kCall_chain1: yyNext = yyOld->Call_chain1.Call_chain; yyOld->Call_chain1.Call_chain = yyNew; break;
case kActual_list1: yyNext = yyOld->Actual_list1.Actual_list; yyOld->Actual_list1.Actual_list = yyNew; break;
case kManifest_array1: yyNext = yyOld->Manifest_array1.Manifest_array; yyOld->Manifest_array1.Manifest_array = yyNew; break;
case klist: yyNext = yyOld->list.List; yyOld->list.List = yyNew; break;
  default: goto yyExit;
  }
  yyNew = yyOld;
  yyOld = yyNext;
 }
yyExit:
 switch (yyTail->Kind) {
case kClasses1: yyTail->Classes1.Classes = yyOld; break;
case kIndex_list1: yyTail->Index_list1.Index_list = yyOld; break;
case kFeatures1: yyTail->Features1.Features = yyOld; break;
case kFeature_decls1: yyTail->Feature_decls1.Feature_decls = yyOld; break;
case kParent_list1: yyTail->Parent_list1.Parent_list = yyOld; break;
case kRename_list1: yyTail->Rename_list1.Rename_list = yyOld; break;
case kCreators1: yyTail->Creators1.Creators = yyOld; break;
case kNew_feature_list1: yyTail->New_feature_list1.New_feature_list = yyOld; break;
case kNew_export_list1: yyTail->New_export_list1.New_export_list = yyOld; break;
case kNew_export_item: yyTail->New_export_item.Feature_set = yyOld; break;
case kFeature_list1: yyTail->Feature_list1.Feature_list = yyOld; break;
case kFormal_args1: yyTail->Formal_args1.Formal_args = yyOld; break;
case kFormal_generics1: yyTail->Formal_generics1.Formal_generics = yyOld; break;
case kCompound1: yyTail->Compound1.Compound = yyOld; break;
case kThen_part_list1: yyTail->Then_part_list1.Then_part_list = yyOld; break;
case kWhen_part_list1: yyTail->When_part_list1.When_part_list = yyOld; break;
case kChoices1: yyTail->Choices1.Choices = yyOld; break;
case kType_list1: yyTail->Type_list1.Type_list = yyOld; break;
case kCall_chain1: yyTail->Call_chain1.Call_chain = yyOld; break;
case kActual_list1: yyTail->Actual_list1.Actual_list = yyOld; break;
case kManifest_array1: yyTail->Manifest_array1.Manifest_array = yyOld; break;
case klist: yyTail->list.List = yyOld; break;
 default: ;
 }
 return yyNew;
}

# define yyInitOldToNewStoreSize 32

typedef struct { tTree yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld, tTree yyNew)
# else
 (yyOld, yyNew) tTree yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tTree yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
}

static tTree yyCopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tTree yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoTree) { * yyNew = NoTree; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, Tree_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kEiffel: (* yyNew)->Eiffel = yyt->Eiffel;
yyt = yyt->Eiffel.Classes;
yyNew = & (* yyNew)->Eiffel.Classes; break;
case kClasses: (* yyNew)->Classes = yyt->Classes;
return;
case kClasses0: (* yyNew)->Classes0 = yyt->Classes0;
return;
case kClasses1: (* yyNew)->Classes1 = yyt->Classes1;
copytTree ((* yyNew)->Classes1.Class_declaration, yyt->Classes1.Class_declaration)
yyt = yyt->Classes1.Classes;
yyNew = & (* yyNew)->Classes1.Classes; break;
case kClass_declaration: (* yyNew)->Class_declaration = yyt->Class_declaration;
copytTree ((* yyNew)->Class_declaration.Indexing, yyt->Class_declaration.Indexing)
copytTree ((* yyNew)->Class_declaration.Class_header, yyt->Class_declaration.Class_header)
copytTree ((* yyNew)->Class_declaration.Formal_generics, yyt->Class_declaration.Formal_generics)
copytTree ((* yyNew)->Class_declaration.Obsolete, yyt->Class_declaration.Obsolete)
copytTree ((* yyNew)->Class_declaration.Inheritance, yyt->Class_declaration.Inheritance)
copytTree ((* yyNew)->Class_declaration.Creators, yyt->Class_declaration.Creators)
copytTree ((* yyNew)->Class_declaration.Features, yyt->Class_declaration.Features)
copytStringRef ((* yyNew)->Class_declaration.comment, yyt->Class_declaration.comment)
yyt = yyt->Class_declaration.Invariant;
yyNew = & (* yyNew)->Class_declaration.Invariant; break;
case kIndex_list: (* yyNew)->Index_list = yyt->Index_list;
return;
case kIndex_list0: (* yyNew)->Index_list0 = yyt->Index_list0;
return;
case kIndex_list1: (* yyNew)->Index_list1 = yyt->Index_list1;
copytTree ((* yyNew)->Index_list1.Index_clause, yyt->Index_list1.Index_clause)
yyt = yyt->Index_list1.Index_list;
yyNew = & (* yyNew)->Index_list1.Index_list; break;
case kIndex_clause: (* yyNew)->Index_clause = yyt->Index_clause;
copytTree ((* yyNew)->Index_clause.Index, yyt->Index_clause.Index)
yyt = yyt->Index_clause.Index_terms;
yyNew = & (* yyNew)->Index_clause.Index_terms; break;
case kClass_header: (* yyNew)->Class_header = yyt->Class_header;
return;
case kClass_header0: (* yyNew)->Class_header0 = yyt->Class_header0;
return;
case kClass: (* yyNew)->Class = yyt->Class;
yyt = yyt->Class.Name;
yyNew = & (* yyNew)->Class.Name; break;
case kExpanded_class: (* yyNew)->Expanded_class = yyt->Expanded_class;
yyt = yyt->Expanded_class.Name;
yyNew = & (* yyNew)->Expanded_class.Name; break;
case kDeferred_class: (* yyNew)->Deferred_class = yyt->Deferred_class;
yyt = yyt->Deferred_class.Name;
yyNew = & (* yyNew)->Deferred_class.Name; break;
case kFeatures: (* yyNew)->Features = yyt->Features;
return;
case kFeatures0: (* yyNew)->Features0 = yyt->Features0;
return;
case kFeatures1: (* yyNew)->Features1 = yyt->Features1;
copytTree ((* yyNew)->Features1.Feature_clause, yyt->Features1.Feature_clause)
yyt = yyt->Features1.Features;
yyNew = & (* yyNew)->Features1.Features; break;
case kFeature_clause: (* yyNew)->Feature_clause = yyt->Feature_clause;
copytTree ((* yyNew)->Feature_clause.Clients, yyt->Feature_clause.Clients)
copytStringRef ((* yyNew)->Feature_clause.comment, yyt->Feature_clause.comment)
yyt = yyt->Feature_clause.Feature_decls;
yyNew = & (* yyNew)->Feature_clause.Feature_decls; break;
case kClients: (* yyNew)->Clients = yyt->Clients;
return;
case kClients0: (* yyNew)->Clients0 = yyt->Clients0;
return;
case kClients1: (* yyNew)->Clients1 = yyt->Clients1;
yyt = yyt->Clients1.List;
yyNew = & (* yyNew)->Clients1.List; break;
case kFeature_decls: (* yyNew)->Feature_decls = yyt->Feature_decls;
return;
case kFeature_decls0: (* yyNew)->Feature_decls0 = yyt->Feature_decls0;
return;
case kFeature_decls1: (* yyNew)->Feature_decls1 = yyt->Feature_decls1;
copytTree ((* yyNew)->Feature_decls1.Feature_decl, yyt->Feature_decls1.Feature_decl)
yyt = yyt->Feature_decls1.Feature_decls;
yyNew = & (* yyNew)->Feature_decls1.Feature_decls; break;
case kFeature_decl: (* yyNew)->Feature_decl = yyt->Feature_decl;
copytTree ((* yyNew)->Feature_decl.New_feature_list, yyt->Feature_decl.New_feature_list)
yyt = yyt->Feature_decl.Declaration_body;
yyNew = & (* yyNew)->Feature_decl.Declaration_body; break;
case kDeclaration_body: (* yyNew)->Declaration_body = yyt->Declaration_body;
copytTree ((* yyNew)->Declaration_body.Formal_args, yyt->Declaration_body.Formal_args)
copytTree ((* yyNew)->Declaration_body.Type_mark, yyt->Declaration_body.Type_mark)
yyt = yyt->Declaration_body.Const_or_routine;
yyNew = & (* yyNew)->Declaration_body.Const_or_routine; break;
case kConst_or_routine: (* yyNew)->Const_or_routine = yyt->Const_or_routine;
return;
case kConst_or_routine0: (* yyNew)->Const_or_routine0 = yyt->Const_or_routine0;
return;
case kM_const: (* yyNew)->M_const = yyt->M_const;
yyt = yyt->M_const.Manifest_constant;
yyNew = & (* yyNew)->M_const.Manifest_constant; break;
case kUnique: (* yyNew)->Unique = yyt->Unique;
copytPosition ((* yyNew)->Unique.pos, yyt->Unique.pos)
return;
case kRoutine: (* yyNew)->Routine = yyt->Routine;
copytTree ((* yyNew)->Routine.Obsolete, yyt->Routine.Obsolete)
copytStringRef ((* yyNew)->Routine.comment, yyt->Routine.comment)
copytTree ((* yyNew)->Routine.Precondition, yyt->Routine.Precondition)
copytTree ((* yyNew)->Routine.Local_decls, yyt->Routine.Local_decls)
copytTree ((* yyNew)->Routine.Routine_body, yyt->Routine.Routine_body)
copytTree ((* yyNew)->Routine.Postcondition, yyt->Routine.Postcondition)
copytStringRef ((* yyNew)->Routine.end_comment, yyt->Routine.end_comment)
yyt = yyt->Routine.Rescue;
yyNew = & (* yyNew)->Routine.Rescue; break;
case kParent_list: (* yyNew)->Parent_list = yyt->Parent_list;
return;
case kParent_list0: (* yyNew)->Parent_list0 = yyt->Parent_list0;
return;
case kParent_list1: (* yyNew)->Parent_list1 = yyt->Parent_list1;
copytTree ((* yyNew)->Parent_list1.Parent, yyt->Parent_list1.Parent)
yyt = yyt->Parent_list1.Parent_list;
yyNew = & (* yyNew)->Parent_list1.Parent_list; break;
case kParent: (* yyNew)->Parent = yyt->Parent;
copytTree ((* yyNew)->Parent.Class_type, yyt->Parent.Class_type)
yyt = yyt->Parent.Feature_adaptation;
yyNew = & (* yyNew)->Parent.Feature_adaptation; break;
case kFeature_adaptation: (* yyNew)->Feature_adaptation = yyt->Feature_adaptation;
return;
case kFeature_adaptation0: (* yyNew)->Feature_adaptation0 = yyt->Feature_adaptation0;
return;
case kFeature_adaptation1: (* yyNew)->Feature_adaptation1 = yyt->Feature_adaptation1;
copytTree ((* yyNew)->Feature_adaptation1.Rename, yyt->Feature_adaptation1.Rename)
copytTree ((* yyNew)->Feature_adaptation1.New_export, yyt->Feature_adaptation1.New_export)
copytTree ((* yyNew)->Feature_adaptation1.Undefine, yyt->Feature_adaptation1.Undefine)
copytTree ((* yyNew)->Feature_adaptation1.Redefine, yyt->Feature_adaptation1.Redefine)
yyt = yyt->Feature_adaptation1.Select;
yyNew = & (* yyNew)->Feature_adaptation1.Select; break;
case kRename_list: (* yyNew)->Rename_list = yyt->Rename_list;
return;
case kRename_list0: (* yyNew)->Rename_list0 = yyt->Rename_list0;
return;
case kRename_list1: (* yyNew)->Rename_list1 = yyt->Rename_list1;
copytTree ((* yyNew)->Rename_list1.Rename_pair, yyt->Rename_list1.Rename_pair)
yyt = yyt->Rename_list1.Rename_list;
yyNew = & (* yyNew)->Rename_list1.Rename_list; break;
case kRename_pair: (* yyNew)->Rename_pair = yyt->Rename_pair;
copytTree ((* yyNew)->Rename_pair.Name1, yyt->Rename_pair.Name1)
yyt = yyt->Rename_pair.Name2;
yyNew = & (* yyNew)->Rename_pair.Name2; break;
case kCreators: (* yyNew)->Creators = yyt->Creators;
return;
case kCreators0: (* yyNew)->Creators0 = yyt->Creators0;
return;
case kCreators1: (* yyNew)->Creators1 = yyt->Creators1;
copytTree ((* yyNew)->Creators1.Creation_clause, yyt->Creators1.Creation_clause)
yyt = yyt->Creators1.Creators;
yyNew = & (* yyNew)->Creators1.Creators; break;
case kCreation_clause: (* yyNew)->Creation_clause = yyt->Creation_clause;
copytTree ((* yyNew)->Creation_clause.Clients, yyt->Creation_clause.Clients)
copytStringRef ((* yyNew)->Creation_clause.comment, yyt->Creation_clause.comment)
yyt = yyt->Creation_clause.Feature_list;
yyNew = & (* yyNew)->Creation_clause.Feature_list; break;
case kNew_feature_list: (* yyNew)->New_feature_list = yyt->New_feature_list;
return;
case kNew_feature_list0: (* yyNew)->New_feature_list0 = yyt->New_feature_list0;
return;
case kNew_feature_list1: (* yyNew)->New_feature_list1 = yyt->New_feature_list1;
copytTree ((* yyNew)->New_feature_list1.Feature_name, yyt->New_feature_list1.Feature_name)
yyt = yyt->New_feature_list1.New_feature_list;
yyNew = & (* yyNew)->New_feature_list1.New_feature_list; break;
case kFeature_name: (* yyNew)->Feature_name = yyt->Feature_name;
return;
case kFrozen: (* yyNew)->Frozen = yyt->Frozen;
yyt = yyt->Frozen.Feature_name;
yyNew = & (* yyNew)->Frozen.Feature_name; break;
case kIdent_name: (* yyNew)->Ident_name = yyt->Ident_name;
yyt = yyt->Ident_name.Id;
yyNew = & (* yyNew)->Ident_name.Id; break;
case kOp: (* yyNew)->Op = yyt->Op;
return;
case kPrefix: (* yyNew)->Prefix = yyt->Prefix;
yyt = yyt->Prefix.Op_name;
yyNew = & (* yyNew)->Prefix.Op_name; break;
case kInfix: (* yyNew)->Infix = yyt->Infix;
yyt = yyt->Infix.Op_name;
yyNew = & (* yyNew)->Infix.Op_name; break;
case kOp_name: (* yyNew)->Op_name = yyt->Op_name;
copytPosition ((* yyNew)->Op_name.pos, yyt->Op_name.pos)
return;
case kFree_op: (* yyNew)->Free_op = yyt->Free_op;
copytPosition ((* yyNew)->Free_op.pos, yyt->Free_op.pos)
copytIdent ((* yyNew)->Free_op.ident, yyt->Free_op.ident)
return;
case kOper: (* yyNew)->Oper = yyt->Oper;
copytPosition ((* yyNew)->Oper.pos, yyt->Oper.pos)
copyint ((* yyNew)->Oper.op, yyt->Oper.op)
return;
case kNew_export_list: (* yyNew)->New_export_list = yyt->New_export_list;
return;
case kNew_export_list0: (* yyNew)->New_export_list0 = yyt->New_export_list0;
return;
case kNew_export_list1: (* yyNew)->New_export_list1 = yyt->New_export_list1;
copytTree ((* yyNew)->New_export_list1.New_export_item, yyt->New_export_list1.New_export_item)
yyt = yyt->New_export_list1.New_export_list;
yyNew = & (* yyNew)->New_export_list1.New_export_list; break;
case kNew_export_item: (* yyNew)->New_export_item = yyt->New_export_item;
copytTree ((* yyNew)->New_export_item.Clients, yyt->New_export_item.Clients)
yyt = yyt->New_export_item.Feature_set;
yyNew = & (* yyNew)->New_export_item.Feature_set; break;
case kFeature_list: (* yyNew)->Feature_list = yyt->Feature_list;
return;
case kAll: (* yyNew)->All = yyt->All;
return;
case kFeature_list0: (* yyNew)->Feature_list0 = yyt->Feature_list0;
return;
case kFeature_list1: (* yyNew)->Feature_list1 = yyt->Feature_list1;
copytTree ((* yyNew)->Feature_list1.Feature_name, yyt->Feature_list1.Feature_name)
yyt = yyt->Feature_list1.Feature_list;
yyNew = & (* yyNew)->Feature_list1.Feature_list; break;
case kFormal_args: (* yyNew)->Formal_args = yyt->Formal_args;
return;
case kFormal_args0: (* yyNew)->Formal_args0 = yyt->Formal_args0;
return;
case kFormal_args1: (* yyNew)->Formal_args1 = yyt->Formal_args1;
copytTree ((* yyNew)->Formal_args1.Entity_decl_group, yyt->Formal_args1.Entity_decl_group)
yyt = yyt->Formal_args1.Formal_args;
yyNew = & (* yyNew)->Formal_args1.Formal_args; break;
case kRoutine_body: (* yyNew)->Routine_body = yyt->Routine_body;
return;
case kRoutine_body0: (* yyNew)->Routine_body0 = yyt->Routine_body0;
return;
case kEffective: (* yyNew)->Effective = yyt->Effective;
return;
case kInternal: (* yyNew)->Internal = yyt->Internal;
return;
case kDo_body: (* yyNew)->Do_body = yyt->Do_body;
yyt = yyt->Do_body.Compound;
yyNew = & (* yyNew)->Do_body.Compound; break;
case kOnce_body: (* yyNew)->Once_body = yyt->Once_body;
yyt = yyt->Once_body.Compound;
yyNew = & (* yyNew)->Once_body.Compound; break;
case kExternal: (* yyNew)->External = yyt->External;
copytTree ((* yyNew)->External.Lang1, yyt->External.Lang1)
yyt = yyt->External.Lang2;
yyNew = & (* yyNew)->External.Lang2; break;
case kDeferred: (* yyNew)->Deferred = yyt->Deferred;
copytPosition ((* yyNew)->Deferred.pos, yyt->Deferred.pos)
return;
case kEntity_decl_group: (* yyNew)->Entity_decl_group = yyt->Entity_decl_group;
copytTree ((* yyNew)->Entity_decl_group.Id_list, yyt->Entity_decl_group.Id_list)
yyt = yyt->Entity_decl_group.Type_mark;
yyNew = & (* yyNew)->Entity_decl_group.Type_mark; break;
case kFormal_generics: (* yyNew)->Formal_generics = yyt->Formal_generics;
return;
case kFormal_generics0: (* yyNew)->Formal_generics0 = yyt->Formal_generics0;
return;
case kFormal_generics1: (* yyNew)->Formal_generics1 = yyt->Formal_generics1;
copytTree ((* yyNew)->Formal_generics1.Formal_generic, yyt->Formal_generics1.Formal_generic)
yyt = yyt->Formal_generics1.Formal_generics;
yyNew = & (* yyNew)->Formal_generics1.Formal_generics; break;
case kFormal_generic: (* yyNew)->Formal_generic = yyt->Formal_generic;
copytTree ((* yyNew)->Formal_generic.Id, yyt->Formal_generic.Id)
yyt = yyt->Formal_generic.Constraint;
yyNew = & (* yyNew)->Formal_generic.Constraint; break;
case kConstraint: (* yyNew)->Constraint = yyt->Constraint;
return;
case kConstraint0: (* yyNew)->Constraint0 = yyt->Constraint0;
return;
case kConstraint1: (* yyNew)->Constraint1 = yyt->Constraint1;
yyt = yyt->Constraint1.Class_type;
yyNew = & (* yyNew)->Constraint1.Class_type; break;
case kCompound: (* yyNew)->Compound = yyt->Compound;
return;
case kCompound0: (* yyNew)->Compound0 = yyt->Compound0;
return;
case kCompound1: (* yyNew)->Compound1 = yyt->Compound1;
copytTree ((* yyNew)->Compound1.Instruction, yyt->Compound1.Instruction)
yyt = yyt->Compound1.Compound;
yyNew = & (* yyNew)->Compound1.Compound; break;
case kThen_part_list: (* yyNew)->Then_part_list = yyt->Then_part_list;
return;
case kThen_part_list0: (* yyNew)->Then_part_list0 = yyt->Then_part_list0;
return;
case kThen_part_list1: (* yyNew)->Then_part_list1 = yyt->Then_part_list1;
copytTree ((* yyNew)->Then_part_list1.Then_part, yyt->Then_part_list1.Then_part)
yyt = yyt->Then_part_list1.Then_part_list;
yyNew = & (* yyNew)->Then_part_list1.Then_part_list; break;
case kThen_part: (* yyNew)->Then_part = yyt->Then_part;
copytTree ((* yyNew)->Then_part.Guard, yyt->Then_part.Guard)
yyt = yyt->Then_part.Compound;
yyNew = & (* yyNew)->Then_part.Compound; break;
case kWhen_part_list: (* yyNew)->When_part_list = yyt->When_part_list;
return;
case kWhen_part_list0: (* yyNew)->When_part_list0 = yyt->When_part_list0;
return;
case kWhen_part_list1: (* yyNew)->When_part_list1 = yyt->When_part_list1;
copytTree ((* yyNew)->When_part_list1.When_part, yyt->When_part_list1.When_part)
yyt = yyt->When_part_list1.When_part_list;
yyNew = & (* yyNew)->When_part_list1.When_part_list; break;
case kWhen_part: (* yyNew)->When_part = yyt->When_part;
copytTree ((* yyNew)->When_part.Choices, yyt->When_part.Choices)
yyt = yyt->When_part.Compound;
yyNew = & (* yyNew)->When_part.Compound; break;
case kChoices: (* yyNew)->Choices = yyt->Choices;
return;
case kChoices0: (* yyNew)->Choices0 = yyt->Choices0;
return;
case kChoices1: (* yyNew)->Choices1 = yyt->Choices1;
copytTree ((* yyNew)->Choices1.Choice, yyt->Choices1.Choice)
yyt = yyt->Choices1.Choices;
yyNew = & (* yyNew)->Choices1.Choices; break;
case kChoice: (* yyNew)->Choice = yyt->Choice;
return;
case kInterval: (* yyNew)->Interval = yyt->Interval;
copytTree ((* yyNew)->Interval.From, yyt->Interval.From)
yyt = yyt->Interval.To;
yyNew = & (* yyNew)->Interval.To; break;
case kVal: (* yyNew)->Val = yyt->Val;
yyt = yyt->Val.Manifest_constant;
yyNew = & (* yyNew)->Val.Manifest_constant; break;
case kInstruction: (* yyNew)->Instruction = yyt->Instruction;
return;
case kInstruction0: (* yyNew)->Instruction0 = yyt->Instruction0;
return;
case kCreation: (* yyNew)->Creation = yyt->Creation;
copytTree ((* yyNew)->Creation.Type, yyt->Creation.Type)
copytTree ((* yyNew)->Creation.Entity, yyt->Creation.Entity)
yyt = yyt->Creation.Unqual_call;
yyNew = & (* yyNew)->Creation.Unqual_call; break;
case kCall_instruct: (* yyNew)->Call_instruct = yyt->Call_instruct;
yyt = yyt->Call_instruct.Call;
yyNew = & (* yyNew)->Call_instruct.Call; break;
case kAssign: (* yyNew)->Assign = yyt->Assign;
copytTree ((* yyNew)->Assign.Addr, yyt->Assign.Addr)
yyt = yyt->Assign.Expression;
yyNew = & (* yyNew)->Assign.Expression; break;
case kRev_assign: (* yyNew)->Rev_assign = yyt->Rev_assign;
copytTree ((* yyNew)->Rev_assign.Addr, yyt->Rev_assign.Addr)
yyt = yyt->Rev_assign.Expression;
yyNew = & (* yyNew)->Rev_assign.Expression; break;
case kConditional: (* yyNew)->Conditional = yyt->Conditional;
copytTree ((* yyNew)->Conditional.Then_part, yyt->Conditional.Then_part)
yyt = yyt->Conditional.Else_part;
yyNew = & (* yyNew)->Conditional.Else_part; break;
case kMulti_branch: (* yyNew)->Multi_branch = yyt->Multi_branch;
copytTree ((* yyNew)->Multi_branch.Guard, yyt->Multi_branch.Guard)
copytTree ((* yyNew)->Multi_branch.When_part_list, yyt->Multi_branch.When_part_list)
yyt = yyt->Multi_branch.Else_part;
yyNew = & (* yyNew)->Multi_branch.Else_part; break;
case kLoop: (* yyNew)->Loop = yyt->Loop;
copytTree ((* yyNew)->Loop.Initialization, yyt->Loop.Initialization)
copytTree ((* yyNew)->Loop.Invariant, yyt->Loop.Invariant)
copytTree ((* yyNew)->Loop.Variant, yyt->Loop.Variant)
yyt = yyt->Loop.Loop_body;
yyNew = & (* yyNew)->Loop.Loop_body; break;
case kCheck: (* yyNew)->Check = yyt->Check;
yyt = yyt->Check.Assertion;
yyNew = & (* yyNew)->Check.Assertion; break;
case kDebug: (* yyNew)->Debug = yyt->Debug;
copytTree ((* yyNew)->Debug.Debug_keys, yyt->Debug.Debug_keys)
yyt = yyt->Debug.Compound;
yyNew = & (* yyNew)->Debug.Compound; break;
case kRetry: (* yyNew)->Retry = yyt->Retry;
copytPosition ((* yyNew)->Retry.pos, yyt->Retry.pos)
return;
case kLoop_body: (* yyNew)->Loop_body = yyt->Loop_body;
return;
case kLoop_body0: (* yyNew)->Loop_body0 = yyt->Loop_body0;
return;
case kLoop_body1: (* yyNew)->Loop_body1 = yyt->Loop_body1;
copytTree ((* yyNew)->Loop_body1.Exit, yyt->Loop_body1.Exit)
yyt = yyt->Loop_body1.Compound;
yyNew = & (* yyNew)->Loop_body1.Compound; break;
case kType: (* yyNew)->Type = yyt->Type;
return;
case kType0: (* yyNew)->Type0 = yyt->Type0;
return;
case kClass_type: (* yyNew)->Class_type = yyt->Class_type;
copytTree ((* yyNew)->Class_type.Id, yyt->Class_type.Id)
yyt = yyt->Class_type.Actual_generics;
yyNew = & (* yyNew)->Class_type.Actual_generics; break;
case kClass_type_expanded: (* yyNew)->Class_type_expanded = yyt->Class_type_expanded;
copytTree ((* yyNew)->Class_type_expanded.Id, yyt->Class_type_expanded.Id)
yyt = yyt->Class_type_expanded.Actual_generics;
yyNew = & (* yyNew)->Class_type_expanded.Actual_generics; break;
case kBit_type: (* yyNew)->Bit_type = yyt->Bit_type;
yyt = yyt->Bit_type.Manifest_constant;
yyNew = & (* yyNew)->Bit_type.Manifest_constant; break;
case kSimple_type: (* yyNew)->Simple_type = yyt->Simple_type;
yyt = yyt->Simple_type.Manifest_constant;
yyNew = & (* yyNew)->Simple_type.Manifest_constant; break;
case kAnchored: (* yyNew)->Anchored = yyt->Anchored;
yyt = yyt->Anchored.Entity;
yyNew = & (* yyNew)->Anchored.Entity; break;
case kActual_generics: (* yyNew)->Actual_generics = yyt->Actual_generics;
return;
case kActual_generics0: (* yyNew)->Actual_generics0 = yyt->Actual_generics0;
return;
case kActual_generics1: (* yyNew)->Actual_generics1 = yyt->Actual_generics1;
yyt = yyt->Actual_generics1.Type_list;
yyNew = & (* yyNew)->Actual_generics1.Type_list; break;
case kCondition: (* yyNew)->Condition = yyt->Condition;
return;
case kCondition0: (* yyNew)->Condition0 = yyt->Condition0;
return;
case kCondition1: (* yyNew)->Condition1 = yyt->Condition1;
copyint ((* yyNew)->Condition1.extension, yyt->Condition1.extension)
yyt = yyt->Condition1.Assertion;
yyNew = & (* yyNew)->Condition1.Assertion; break;
case kAssertion: (* yyNew)->Assertion = yyt->Assertion;
return;
case kAssertion0: (* yyNew)->Assertion0 = yyt->Assertion0;
return;
case kAssertion1: (* yyNew)->Assertion1 = yyt->Assertion1;
copytTree ((* yyNew)->Assertion1.Assertion_clause, yyt->Assertion1.Assertion_clause)
yyt = yyt->Assertion1.Assertion;
yyNew = & (* yyNew)->Assertion1.Assertion; break;
case kAssertion_clause: (* yyNew)->Assertion_clause = yyt->Assertion_clause;
return;
case kAssertion_clause0: (* yyNew)->Assertion_clause0 = yyt->Assertion_clause0;
return;
case kAssertion_clause1: (* yyNew)->Assertion_clause1 = yyt->Assertion_clause1;
copytTree ((* yyNew)->Assertion_clause1.Tag, yyt->Assertion_clause1.Tag)
yyt = yyt->Assertion_clause1.Expression;
yyNew = & (* yyNew)->Assertion_clause1.Expression; break;
case kType_list: (* yyNew)->Type_list = yyt->Type_list;
return;
case kType_list0: (* yyNew)->Type_list0 = yyt->Type_list0;
return;
case kType_list1: (* yyNew)->Type_list1 = yyt->Type_list1;
copytTree ((* yyNew)->Type_list1.Type, yyt->Type_list1.Type)
yyt = yyt->Type_list1.Type_list;
yyNew = & (* yyNew)->Type_list1.Type_list; break;
case kCall_chain: (* yyNew)->Call_chain = yyt->Call_chain;
return;
case kCall_chain0: (* yyNew)->Call_chain0 = yyt->Call_chain0;
return;
case kCall_chain1: (* yyNew)->Call_chain1 = yyt->Call_chain1;
copytTree ((* yyNew)->Call_chain1.Unqual_call, yyt->Call_chain1.Unqual_call)
yyt = yyt->Call_chain1.Call_chain;
yyNew = & (* yyNew)->Call_chain1.Call_chain; break;
case kUnqual_call: (* yyNew)->Unqual_call = yyt->Unqual_call;
return;
case kUnqual_call0: (* yyNew)->Unqual_call0 = yyt->Unqual_call0;
return;
case kUnqual_call1: (* yyNew)->Unqual_call1 = yyt->Unqual_call1;
copytTree ((* yyNew)->Unqual_call1.Entity, yyt->Unqual_call1.Entity)
yyt = yyt->Unqual_call1.Actuals;
yyNew = & (* yyNew)->Unqual_call1.Actuals; break;
case kActuals: (* yyNew)->Actuals = yyt->Actuals;
return;
case kActuals0: (* yyNew)->Actuals0 = yyt->Actuals0;
return;
case kActuals1: (* yyNew)->Actuals1 = yyt->Actuals1;
yyt = yyt->Actuals1.Actual_list;
yyNew = & (* yyNew)->Actuals1.Actual_list; break;
case kActual_list: (* yyNew)->Actual_list = yyt->Actual_list;
return;
case kActual_list0: (* yyNew)->Actual_list0 = yyt->Actual_list0;
return;
case kActual_list1: (* yyNew)->Actual_list1 = yyt->Actual_list1;
copytTree ((* yyNew)->Actual_list1.Actual, yyt->Actual_list1.Actual)
yyt = yyt->Actual_list1.Actual_list;
yyNew = & (* yyNew)->Actual_list1.Actual_list; break;
case kActual: (* yyNew)->Actual = yyt->Actual;
return;
case kAddr: (* yyNew)->Addr = yyt->Addr;
yyt = yyt->Addr.Entity;
yyNew = & (* yyNew)->Addr.Entity; break;
case kExpression: (* yyNew)->Expression = yyt->Expression;
return;
case kExpression0: (* yyNew)->Expression0 = yyt->Expression0;
return;
case kComment: (* yyNew)->Comment = yyt->Comment;
copytStringRef ((* yyNew)->Comment.comment, yyt->Comment.comment)
return;
case kSimple_expr: (* yyNew)->Simple_expr = yyt->Simple_expr;
yyt = yyt->Simple_expr.Manifest_constant;
yyNew = & (* yyNew)->Simple_expr.Manifest_constant; break;
case kCall: (* yyNew)->Call = yyt->Call;
copytTree ((* yyNew)->Call.Qual, yyt->Call.Qual)
yyt = yyt->Call.Call_chain;
yyNew = & (* yyNew)->Call.Call_chain; break;
case kBin_expr: (* yyNew)->Bin_expr = yyt->Bin_expr;
copytTree ((* yyNew)->Bin_expr.Lop, yyt->Bin_expr.Lop)
copytTree ((* yyNew)->Bin_expr.Op, yyt->Bin_expr.Op)
yyt = yyt->Bin_expr.Rop;
yyNew = & (* yyNew)->Bin_expr.Rop; break;
case kUn_expr: (* yyNew)->Un_expr = yyt->Un_expr;
copytTree ((* yyNew)->Un_expr.Op, yyt->Un_expr.Op)
yyt = yyt->Un_expr.Expression;
yyNew = & (* yyNew)->Un_expr.Expression; break;
case kParenth: (* yyNew)->Parenth = yyt->Parenth;
yyt = yyt->Parenth.Expression;
yyNew = & (* yyNew)->Parenth.Expression; break;
case kManifest_array: (* yyNew)->Manifest_array = yyt->Manifest_array;
return;
case kManifest_array0: (* yyNew)->Manifest_array0 = yyt->Manifest_array0;
return;
case kManifest_array1: (* yyNew)->Manifest_array1 = yyt->Manifest_array1;
copytTree ((* yyNew)->Manifest_array1.Expression, yyt->Manifest_array1.Expression)
yyt = yyt->Manifest_array1.Manifest_array;
yyNew = & (* yyNew)->Manifest_array1.Manifest_array; break;
case kOld: (* yyNew)->Old = yyt->Old;
yyt = yyt->Old.Expression;
yyNew = & (* yyNew)->Old.Expression; break;
case kStrip: (* yyNew)->Strip = yyt->Strip;
yyt = yyt->Strip.List;
yyNew = & (* yyNew)->Strip.List; break;
case kList: (* yyNew)->List = yyt->List;
return;
case knolist: (* yyNew)->nolist = yyt->nolist;
return;
case klist: (* yyNew)->list = yyt->list;
copytTree ((* yyNew)->list.Manifest_constant, yyt->list.Manifest_constant)
yyt = yyt->list.List;
yyNew = & (* yyNew)->list.List; break;
case kManifest_constant: (* yyNew)->Manifest_constant = yyt->Manifest_constant;
return;
case kManifest_constant0: (* yyNew)->Manifest_constant0 = yyt->Manifest_constant0;
return;
case kCh: (* yyNew)->Ch = yyt->Ch;
copyint ((* yyNew)->Ch.ch, yyt->Ch.ch)
copytPosition ((* yyNew)->Ch.pos, yyt->Ch.pos)
return;
case kTrue: (* yyNew)->True = yyt->True;
copytPosition ((* yyNew)->True.pos, yyt->True.pos)
return;
case kFalse: (* yyNew)->False = yyt->False;
copytPosition ((* yyNew)->False.pos, yyt->False.pos)
return;
case kInt: (* yyNew)->Int = yyt->Int;
copylong ((* yyNew)->Int.value, yyt->Int.value)
copytPosition ((* yyNew)->Int.pos, yyt->Int.pos)
yyt = yyt->Int.Sign;
yyNew = & (* yyNew)->Int.Sign; break;
case kReal: (* yyNew)->Real = yyt->Real;
copydouble ((* yyNew)->Real.value, yyt->Real.value)
copytPosition ((* yyNew)->Real.pos, yyt->Real.pos)
yyt = yyt->Real.Sign;
yyNew = & (* yyNew)->Real.Sign; break;
case k_CHARACTER: (* yyNew)->_CHARACTER = yyt->_CHARACTER;
copytPosition ((* yyNew)->_CHARACTER.pos, yyt->_CHARACTER.pos)
return;
case k_INTEGER: (* yyNew)->_INTEGER = yyt->_INTEGER;
copytPosition ((* yyNew)->_INTEGER.pos, yyt->_INTEGER.pos)
return;
case k_REAL: (* yyNew)->_REAL = yyt->_REAL;
copytPosition ((* yyNew)->_REAL.pos, yyt->_REAL.pos)
return;
case k_DOUBLE: (* yyNew)->_DOUBLE = yyt->_DOUBLE;
copytPosition ((* yyNew)->_DOUBLE.pos, yyt->_DOUBLE.pos)
return;
case k_BOOLEAN: (* yyNew)->_BOOLEAN = yyt->_BOOLEAN;
copytPosition ((* yyNew)->_BOOLEAN.pos, yyt->_BOOLEAN.pos)
return;
case k_STRING: (* yyNew)->_STRING = yyt->_STRING;
copytPosition ((* yyNew)->_STRING.pos, yyt->_STRING.pos)
return;
case k_BIT: (* yyNew)->_BIT = yyt->_BIT;
copytPosition ((* yyNew)->_BIT.pos, yyt->_BIT.pos)
return;
case k_NONE: (* yyNew)->_NONE = yyt->_NONE;
copytPosition ((* yyNew)->_NONE.pos, yyt->_NONE.pos)
return;
case kBitseq: (* yyNew)->Bitseq = yyt->Bitseq;
copytStringRef ((* yyNew)->Bitseq.literal, yyt->Bitseq.literal)
copytPosition ((* yyNew)->Bitseq.pos, yyt->Bitseq.pos)
return;
case kString: (* yyNew)->String = yyt->String;
copytStringRef ((* yyNew)->String.string, yyt->String.string)
copytPosition ((* yyNew)->String.pos, yyt->String.pos)
return;
case kString0: (* yyNew)->String0 = yyt->String0;
return;
case kEntity: (* yyNew)->Entity = yyt->Entity;
return;
case kEntity0: (* yyNew)->Entity0 = yyt->Entity0;
return;
case kCurrent: (* yyNew)->Current = yyt->Current;
copytPosition ((* yyNew)->Current.pos, yyt->Current.pos)
return;
case kResult: (* yyNew)->Result = yyt->Result;
copytPosition ((* yyNew)->Result.pos, yyt->Result.pos)
return;
case kId: (* yyNew)->Id = yyt->Id;
copytIdent ((* yyNew)->Id.ident, yyt->Id.ident)
copytPosition ((* yyNew)->Id.pos, yyt->Id.pos)
return;
  default: ;
  }
 }
}

tTree CopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 tTree yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyTree (yyt, & yyNew);
 return yyNew;
}

static bool yyCheckTree ARGS((tTree yyt));

bool CheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyMark (yyt);
 return yyCheckTree (yyt);
}

static bool yyCheckChild
# if defined __STDC__ | defined __cplusplus
 (tTree yyParent, tTree yyyChild, Tree_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tTree yyParent, yyyChild;
 Tree_tKind yyType;
 char * yySelector;
# endif
{
 bool yySuccess = Tree_IsType (yyyChild, yyType);
 if (! yySuccess) {
  (void) fputs ("CheckTree: parent = ", stderr);
  WriteTreeNode (stderr, yyParent);
  (void) fprintf (stderr, "\nselector: %s child = ", yySelector);
  WriteTreeNode (stderr, yyyChild);
  (void) fputc ('\n', stderr);
 }
 return yyCheckTree (yyyChild) && yySuccess;
}

static bool yyCheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 bool yyResult;
 if (yyt == NoTree) return false;
 else if (yyt->yyHead.yyMark == 0) return true;
 yyt->yyHead.yyMark = 0;

 yyResult = true;
 switch (yyt->Kind) {
case kEiffel:
yyResult = yyCheckChild (yyt, yyt->Eiffel.Classes, kClasses, "Classes") && yyResult;
break;
case kClasses1:
yyResult = yyCheckChild (yyt, yyt->Classes1.Class_declaration, kClass_declaration, "Class_declaration") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Classes1.Classes, kClasses, "Classes") && yyResult;
break;
case kClass_declaration:
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Indexing, kIndex_list, "Indexing") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Class_header, kClass_header, "Class_header") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Formal_generics, kFormal_generics, "Formal_generics") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Obsolete, kManifest_constant, "Obsolete") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Inheritance, kParent_list, "Inheritance") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Creators, kCreators, "Creators") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Features, kFeatures, "Features") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_declaration.Invariant, kCondition, "Invariant") && yyResult;
break;
case kIndex_list1:
yyResult = yyCheckChild (yyt, yyt->Index_list1.Index_clause, kIndex_clause, "Index_clause") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Index_list1.Index_list, kIndex_list, "Index_list") && yyResult;
break;
case kIndex_clause:
yyResult = yyCheckChild (yyt, yyt->Index_clause.Index, kManifest_constant, "Index") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Index_clause.Index_terms, kList, "Index_terms") && yyResult;
break;
case kClass:
yyResult = yyCheckChild (yyt, yyt->Class.Name, kManifest_constant, "Name") && yyResult;
break;
case kExpanded_class:
yyResult = yyCheckChild (yyt, yyt->Expanded_class.Name, kManifest_constant, "Name") && yyResult;
break;
case kDeferred_class:
yyResult = yyCheckChild (yyt, yyt->Deferred_class.Name, kManifest_constant, "Name") && yyResult;
break;
case kFeatures1:
yyResult = yyCheckChild (yyt, yyt->Features1.Feature_clause, kFeature_clause, "Feature_clause") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Features1.Features, kFeatures, "Features") && yyResult;
break;
case kFeature_clause:
yyResult = yyCheckChild (yyt, yyt->Feature_clause.Clients, kClients, "Clients") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_clause.Feature_decls, kFeature_decls, "Feature_decls") && yyResult;
break;
case kClients1:
yyResult = yyCheckChild (yyt, yyt->Clients1.List, kList, "List") && yyResult;
break;
case kFeature_decls1:
yyResult = yyCheckChild (yyt, yyt->Feature_decls1.Feature_decl, kFeature_decl, "Feature_decl") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_decls1.Feature_decls, kFeature_decls, "Feature_decls") && yyResult;
break;
case kFeature_decl:
yyResult = yyCheckChild (yyt, yyt->Feature_decl.New_feature_list, kNew_feature_list, "New_feature_list") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_decl.Declaration_body, kDeclaration_body, "Declaration_body") && yyResult;
break;
case kDeclaration_body:
yyResult = yyCheckChild (yyt, yyt->Declaration_body.Formal_args, kFormal_args, "Formal_args") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Declaration_body.Type_mark, kType, "Type_mark") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Declaration_body.Const_or_routine, kConst_or_routine, "Const_or_routine") && yyResult;
break;
case kM_const:
yyResult = yyCheckChild (yyt, yyt->M_const.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
break;
case kRoutine:
yyResult = yyCheckChild (yyt, yyt->Routine.Obsolete, kManifest_constant, "Obsolete") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Routine.Precondition, kCondition, "Precondition") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Routine.Local_decls, kFormal_args, "Local_decls") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Routine.Routine_body, kRoutine_body, "Routine_body") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Routine.Postcondition, kCondition, "Postcondition") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Routine.Rescue, kCompound, "Rescue") && yyResult;
break;
case kParent_list1:
yyResult = yyCheckChild (yyt, yyt->Parent_list1.Parent, kParent, "Parent") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Parent_list1.Parent_list, kParent_list, "Parent_list") && yyResult;
break;
case kParent:
yyResult = yyCheckChild (yyt, yyt->Parent.Class_type, kClass_type, "Class_type") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Parent.Feature_adaptation, kFeature_adaptation, "Feature_adaptation") && yyResult;
break;
case kFeature_adaptation1:
yyResult = yyCheckChild (yyt, yyt->Feature_adaptation1.Rename, kRename_list, "Rename") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_adaptation1.New_export, kNew_export_list, "New_export") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_adaptation1.Undefine, kFeature_list, "Undefine") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_adaptation1.Redefine, kFeature_list, "Redefine") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_adaptation1.Select, kFeature_list, "Select") && yyResult;
break;
case kRename_list1:
yyResult = yyCheckChild (yyt, yyt->Rename_list1.Rename_pair, kRename_pair, "Rename_pair") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Rename_list1.Rename_list, kRename_list, "Rename_list") && yyResult;
break;
case kRename_pair:
yyResult = yyCheckChild (yyt, yyt->Rename_pair.Name1, kFeature_name, "Name1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Rename_pair.Name2, kFeature_name, "Name2") && yyResult;
break;
case kCreators1:
yyResult = yyCheckChild (yyt, yyt->Creators1.Creation_clause, kCreation_clause, "Creation_clause") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Creators1.Creators, kCreators, "Creators") && yyResult;
break;
case kCreation_clause:
yyResult = yyCheckChild (yyt, yyt->Creation_clause.Clients, kClients, "Clients") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Creation_clause.Feature_list, kFeature_list, "Feature_list") && yyResult;
break;
case kNew_feature_list1:
yyResult = yyCheckChild (yyt, yyt->New_feature_list1.Feature_name, kFeature_name, "Feature_name") && yyResult;
yyResult = yyCheckChild (yyt, yyt->New_feature_list1.New_feature_list, kNew_feature_list, "New_feature_list") && yyResult;
break;
case kFrozen:
yyResult = yyCheckChild (yyt, yyt->Frozen.Feature_name, kFeature_name, "Feature_name") && yyResult;
break;
case kIdent_name:
yyResult = yyCheckChild (yyt, yyt->Ident_name.Id, kId, "Id") && yyResult;
break;
case kPrefix:
yyResult = yyCheckChild (yyt, yyt->Prefix.Op_name, kOp_name, "Op_name") && yyResult;
break;
case kInfix:
yyResult = yyCheckChild (yyt, yyt->Infix.Op_name, kOp_name, "Op_name") && yyResult;
break;
case kNew_export_list1:
yyResult = yyCheckChild (yyt, yyt->New_export_list1.New_export_item, kNew_export_item, "New_export_item") && yyResult;
yyResult = yyCheckChild (yyt, yyt->New_export_list1.New_export_list, kNew_export_list, "New_export_list") && yyResult;
break;
case kNew_export_item:
yyResult = yyCheckChild (yyt, yyt->New_export_item.Clients, kClients, "Clients") && yyResult;
yyResult = yyCheckChild (yyt, yyt->New_export_item.Feature_set, kFeature_list, "Feature_set") && yyResult;
break;
case kFeature_list1:
yyResult = yyCheckChild (yyt, yyt->Feature_list1.Feature_name, kFeature_name, "Feature_name") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Feature_list1.Feature_list, kFeature_list, "Feature_list") && yyResult;
break;
case kFormal_args1:
yyResult = yyCheckChild (yyt, yyt->Formal_args1.Entity_decl_group, kEntity_decl_group, "Entity_decl_group") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Formal_args1.Formal_args, kFormal_args, "Formal_args") && yyResult;
break;
case kDo_body:
yyResult = yyCheckChild (yyt, yyt->Do_body.Compound, kCompound, "Compound") && yyResult;
break;
case kOnce_body:
yyResult = yyCheckChild (yyt, yyt->Once_body.Compound, kCompound, "Compound") && yyResult;
break;
case kExternal:
yyResult = yyCheckChild (yyt, yyt->External.Lang1, kString, "Lang1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->External.Lang2, kManifest_constant, "Lang2") && yyResult;
break;
case kEntity_decl_group:
yyResult = yyCheckChild (yyt, yyt->Entity_decl_group.Id_list, kList, "Id_list") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Entity_decl_group.Type_mark, kType, "Type_mark") && yyResult;
break;
case kFormal_generics1:
yyResult = yyCheckChild (yyt, yyt->Formal_generics1.Formal_generic, kFormal_generic, "Formal_generic") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Formal_generics1.Formal_generics, kFormal_generics, "Formal_generics") && yyResult;
break;
case kFormal_generic:
yyResult = yyCheckChild (yyt, yyt->Formal_generic.Id, kManifest_constant, "Id") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Formal_generic.Constraint, kConstraint, "Constraint") && yyResult;
break;
case kConstraint1:
yyResult = yyCheckChild (yyt, yyt->Constraint1.Class_type, kClass_type, "Class_type") && yyResult;
break;
case kCompound1:
yyResult = yyCheckChild (yyt, yyt->Compound1.Instruction, kInstruction, "Instruction") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Compound1.Compound, kCompound, "Compound") && yyResult;
break;
case kThen_part_list1:
yyResult = yyCheckChild (yyt, yyt->Then_part_list1.Then_part, kThen_part, "Then_part") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Then_part_list1.Then_part_list, kThen_part_list, "Then_part_list") && yyResult;
break;
case kThen_part:
yyResult = yyCheckChild (yyt, yyt->Then_part.Guard, kExpression, "Guard") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Then_part.Compound, kCompound, "Compound") && yyResult;
break;
case kWhen_part_list1:
yyResult = yyCheckChild (yyt, yyt->When_part_list1.When_part, kWhen_part, "When_part") && yyResult;
yyResult = yyCheckChild (yyt, yyt->When_part_list1.When_part_list, kWhen_part_list, "When_part_list") && yyResult;
break;
case kWhen_part:
yyResult = yyCheckChild (yyt, yyt->When_part.Choices, kChoices, "Choices") && yyResult;
yyResult = yyCheckChild (yyt, yyt->When_part.Compound, kCompound, "Compound") && yyResult;
break;
case kChoices1:
yyResult = yyCheckChild (yyt, yyt->Choices1.Choice, kChoice, "Choice") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Choices1.Choices, kChoices, "Choices") && yyResult;
break;
case kInterval:
yyResult = yyCheckChild (yyt, yyt->Interval.From, kManifest_constant, "From") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Interval.To, kManifest_constant, "To") && yyResult;
break;
case kVal:
yyResult = yyCheckChild (yyt, yyt->Val.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
break;
case kCreation:
yyResult = yyCheckChild (yyt, yyt->Creation.Type, kType, "Type") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Creation.Entity, kEntity, "Entity") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Creation.Unqual_call, kUnqual_call, "Unqual_call") && yyResult;
break;
case kCall_instruct:
yyResult = yyCheckChild (yyt, yyt->Call_instruct.Call, kCall, "Call") && yyResult;
break;
case kAssign:
yyResult = yyCheckChild (yyt, yyt->Assign.Addr, kEntity, "Addr") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Assign.Expression, kExpression, "Expression") && yyResult;
break;
case kRev_assign:
yyResult = yyCheckChild (yyt, yyt->Rev_assign.Addr, kEntity, "Addr") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Rev_assign.Expression, kExpression, "Expression") && yyResult;
break;
case kConditional:
yyResult = yyCheckChild (yyt, yyt->Conditional.Then_part, kThen_part_list, "Then_part") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Conditional.Else_part, kCompound, "Else_part") && yyResult;
break;
case kMulti_branch:
yyResult = yyCheckChild (yyt, yyt->Multi_branch.Guard, kExpression, "Guard") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Multi_branch.When_part_list, kWhen_part_list, "When_part_list") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Multi_branch.Else_part, kCompound, "Else_part") && yyResult;
break;
case kLoop:
yyResult = yyCheckChild (yyt, yyt->Loop.Initialization, kCompound, "Initialization") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Loop.Invariant, kCondition, "Invariant") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Loop.Variant, kAssertion_clause, "Variant") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Loop.Loop_body, kLoop_body, "Loop_body") && yyResult;
break;
case kCheck:
yyResult = yyCheckChild (yyt, yyt->Check.Assertion, kAssertion, "Assertion") && yyResult;
break;
case kDebug:
yyResult = yyCheckChild (yyt, yyt->Debug.Debug_keys, kList, "Debug_keys") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Debug.Compound, kCompound, "Compound") && yyResult;
break;
case kLoop_body1:
yyResult = yyCheckChild (yyt, yyt->Loop_body1.Exit, kExpression, "Exit") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Loop_body1.Compound, kCompound, "Compound") && yyResult;
break;
case kClass_type:
yyResult = yyCheckChild (yyt, yyt->Class_type.Id, kId, "Id") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_type.Actual_generics, kActual_generics, "Actual_generics") && yyResult;
break;
case kClass_type_expanded:
yyResult = yyCheckChild (yyt, yyt->Class_type_expanded.Id, kId, "Id") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Class_type_expanded.Actual_generics, kActual_generics, "Actual_generics") && yyResult;
break;
case kBit_type:
yyResult = yyCheckChild (yyt, yyt->Bit_type.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
break;
case kSimple_type:
yyResult = yyCheckChild (yyt, yyt->Simple_type.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
break;
case kAnchored:
yyResult = yyCheckChild (yyt, yyt->Anchored.Entity, kEntity, "Entity") && yyResult;
break;
case kActual_generics1:
yyResult = yyCheckChild (yyt, yyt->Actual_generics1.Type_list, kType_list, "Type_list") && yyResult;
break;
case kCondition1:
yyResult = yyCheckChild (yyt, yyt->Condition1.Assertion, kAssertion, "Assertion") && yyResult;
break;
case kAssertion1:
yyResult = yyCheckChild (yyt, yyt->Assertion1.Assertion_clause, kAssertion_clause, "Assertion_clause") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Assertion1.Assertion, kAssertion, "Assertion") && yyResult;
break;
case kAssertion_clause1:
yyResult = yyCheckChild (yyt, yyt->Assertion_clause1.Tag, kManifest_constant, "Tag") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Assertion_clause1.Expression, kExpression, "Expression") && yyResult;
break;
case kType_list1:
yyResult = yyCheckChild (yyt, yyt->Type_list1.Type, kType, "Type") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Type_list1.Type_list, kType_list, "Type_list") && yyResult;
break;
case kCall_chain1:
yyResult = yyCheckChild (yyt, yyt->Call_chain1.Unqual_call, kUnqual_call, "Unqual_call") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Call_chain1.Call_chain, kCall_chain, "Call_chain") && yyResult;
break;
case kUnqual_call1:
yyResult = yyCheckChild (yyt, yyt->Unqual_call1.Entity, kEntity, "Entity") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Unqual_call1.Actuals, kActuals, "Actuals") && yyResult;
break;
case kActuals1:
yyResult = yyCheckChild (yyt, yyt->Actuals1.Actual_list, kActual_list, "Actual_list") && yyResult;
break;
case kActual_list1:
yyResult = yyCheckChild (yyt, yyt->Actual_list1.Actual, kActual, "Actual") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Actual_list1.Actual_list, kActual_list, "Actual_list") && yyResult;
break;
case kAddr:
yyResult = yyCheckChild (yyt, yyt->Addr.Entity, kEntity, "Entity") && yyResult;
break;
case kSimple_expr:
yyResult = yyCheckChild (yyt, yyt->Simple_expr.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
break;
case kCall:
yyResult = yyCheckChild (yyt, yyt->Call.Qual, kExpression, "Qual") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Call.Call_chain, kCall_chain, "Call_chain") && yyResult;
break;
case kBin_expr:
yyResult = yyCheckChild (yyt, yyt->Bin_expr.Lop, kExpression, "Lop") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Bin_expr.Op, kOp, "Op") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Bin_expr.Rop, kExpression, "Rop") && yyResult;
break;
case kUn_expr:
yyResult = yyCheckChild (yyt, yyt->Un_expr.Op, kOp, "Op") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Un_expr.Expression, kExpression, "Expression") && yyResult;
break;
case kParenth:
yyResult = yyCheckChild (yyt, yyt->Parenth.Expression, kExpression, "Expression") && yyResult;
break;
case kManifest_array1:
yyResult = yyCheckChild (yyt, yyt->Manifest_array1.Expression, kExpression, "Expression") && yyResult;
yyResult = yyCheckChild (yyt, yyt->Manifest_array1.Manifest_array, kManifest_array, "Manifest_array") && yyResult;
break;
case kOld:
yyResult = yyCheckChild (yyt, yyt->Old.Expression, kExpression, "Expression") && yyResult;
break;
case kStrip:
yyResult = yyCheckChild (yyt, yyt->Strip.List, kList, "List") && yyResult;
break;
case klist:
yyResult = yyCheckChild (yyt, yyt->list.Manifest_constant, kManifest_constant, "Manifest_constant") && yyResult;
yyResult = yyCheckChild (yyt, yyt->list.List, kList, "List") && yyResult;
break;
case kInt:
yyResult = yyCheckChild (yyt, yyt->Int.Sign, kOper, "Sign") && yyResult;
break;
case kReal:
yyResult = yyCheckChild (yyt, yyt->Real.Sign, kOper, "Sign") && yyResult;
break;
 default: ;
 }
 return yyResult;
}

# define yyyWrite	1
# define yyyRead	2
# define yyyQuit	3

static char yyyString [32], yyCh;
static int yyLength, yyState;

static bool yyyIsEqual
# if defined __STDC__ | defined __cplusplus
 (char * yya)
# else
 (yya) char * yya;
# endif
{
 register int yyi;
 if (yyLength >= 0 && yyyString [yyLength] == ' ') {
  if (yyLength != strlen (yya)) return false;
  for (yyi = 0; yyi < yyLength; yyi ++)
   if (yyyString [yyi] != yya [yyi]) return false;
 } else {
  if (yyLength >= strlen (yya)) return false;
  for (yyi = 0; yyi <= yyLength; yyi ++)
   if (yyyString [yyi] != yya [yyi]) return false;
 }
 return true;
}

void QueryTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyState = yyyWrite;
 for (;;) {
  switch (yyState) {
  case yyyQuit : return;
  case yyyWrite: WriteTreeNode (stdout, yyt); yyState = yyyRead;
  case yyyRead : (void) printf ("? "); yyLength = -1; yyCh = getc (stdin);
   while (yyCh != '\n' && yyCh > 0)
    { yyyString [++ yyLength] = yyCh; yyCh = getc (stdin); }
   if (yyCh < 0) { (void) fputs ("QueryTree: eof reached\n", stderr);
    yyState = yyyQuit; return; }
   if      (yyyIsEqual ("parent")) { yyState = yyyWrite; return; }
   else if (yyyIsEqual ("quit"  )) { yyState = yyyQuit ; return; }
   else if (yyt != NoTree) {
    switch (yyt->Kind) {
case kEiffel: if (false) ;
else if (yyyIsEqual ("Classes")) QueryTree (yyt->Eiffel.Classes);
break;
case kClasses1: if (false) ;
else if (yyyIsEqual ("Class_declaration")) QueryTree (yyt->Classes1.Class_declaration);
else if (yyyIsEqual ("Classes")) QueryTree (yyt->Classes1.Classes);
break;
case kClass_declaration: if (false) ;
else if (yyyIsEqual ("Indexing")) QueryTree (yyt->Class_declaration.Indexing);
else if (yyyIsEqual ("Class_header")) QueryTree (yyt->Class_declaration.Class_header);
else if (yyyIsEqual ("Formal_generics")) QueryTree (yyt->Class_declaration.Formal_generics);
else if (yyyIsEqual ("Obsolete")) QueryTree (yyt->Class_declaration.Obsolete);
else if (yyyIsEqual ("Inheritance")) QueryTree (yyt->Class_declaration.Inheritance);
else if (yyyIsEqual ("Creators")) QueryTree (yyt->Class_declaration.Creators);
else if (yyyIsEqual ("Features")) QueryTree (yyt->Class_declaration.Features);
else if (yyyIsEqual ("Invariant")) QueryTree (yyt->Class_declaration.Invariant);
break;
case kIndex_list1: if (false) ;
else if (yyyIsEqual ("Index_clause")) QueryTree (yyt->Index_list1.Index_clause);
else if (yyyIsEqual ("Index_list")) QueryTree (yyt->Index_list1.Index_list);
break;
case kIndex_clause: if (false) ;
else if (yyyIsEqual ("Index")) QueryTree (yyt->Index_clause.Index);
else if (yyyIsEqual ("Index_terms")) QueryTree (yyt->Index_clause.Index_terms);
break;
case kClass: if (false) ;
else if (yyyIsEqual ("Name")) QueryTree (yyt->Class.Name);
break;
case kExpanded_class: if (false) ;
else if (yyyIsEqual ("Name")) QueryTree (yyt->Expanded_class.Name);
break;
case kDeferred_class: if (false) ;
else if (yyyIsEqual ("Name")) QueryTree (yyt->Deferred_class.Name);
break;
case kFeatures1: if (false) ;
else if (yyyIsEqual ("Feature_clause")) QueryTree (yyt->Features1.Feature_clause);
else if (yyyIsEqual ("Features")) QueryTree (yyt->Features1.Features);
break;
case kFeature_clause: if (false) ;
else if (yyyIsEqual ("Clients")) QueryTree (yyt->Feature_clause.Clients);
else if (yyyIsEqual ("Feature_decls")) QueryTree (yyt->Feature_clause.Feature_decls);
break;
case kClients1: if (false) ;
else if (yyyIsEqual ("List")) QueryTree (yyt->Clients1.List);
break;
case kFeature_decls1: if (false) ;
else if (yyyIsEqual ("Feature_decl")) QueryTree (yyt->Feature_decls1.Feature_decl);
else if (yyyIsEqual ("Feature_decls")) QueryTree (yyt->Feature_decls1.Feature_decls);
break;
case kFeature_decl: if (false) ;
else if (yyyIsEqual ("New_feature_list")) QueryTree (yyt->Feature_decl.New_feature_list);
else if (yyyIsEqual ("Declaration_body")) QueryTree (yyt->Feature_decl.Declaration_body);
break;
case kDeclaration_body: if (false) ;
else if (yyyIsEqual ("Formal_args")) QueryTree (yyt->Declaration_body.Formal_args);
else if (yyyIsEqual ("Type_mark")) QueryTree (yyt->Declaration_body.Type_mark);
else if (yyyIsEqual ("Const_or_routine")) QueryTree (yyt->Declaration_body.Const_or_routine);
break;
case kM_const: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->M_const.Manifest_constant);
break;
case kRoutine: if (false) ;
else if (yyyIsEqual ("Obsolete")) QueryTree (yyt->Routine.Obsolete);
else if (yyyIsEqual ("Precondition")) QueryTree (yyt->Routine.Precondition);
else if (yyyIsEqual ("Local_decls")) QueryTree (yyt->Routine.Local_decls);
else if (yyyIsEqual ("Routine_body")) QueryTree (yyt->Routine.Routine_body);
else if (yyyIsEqual ("Postcondition")) QueryTree (yyt->Routine.Postcondition);
else if (yyyIsEqual ("Rescue")) QueryTree (yyt->Routine.Rescue);
break;
case kParent_list1: if (false) ;
else if (yyyIsEqual ("Parent")) QueryTree (yyt->Parent_list1.Parent);
else if (yyyIsEqual ("Parent_list")) QueryTree (yyt->Parent_list1.Parent_list);
break;
case kParent: if (false) ;
else if (yyyIsEqual ("Class_type")) QueryTree (yyt->Parent.Class_type);
else if (yyyIsEqual ("Feature_adaptation")) QueryTree (yyt->Parent.Feature_adaptation);
break;
case kFeature_adaptation1: if (false) ;
else if (yyyIsEqual ("Rename")) QueryTree (yyt->Feature_adaptation1.Rename);
else if (yyyIsEqual ("New_export")) QueryTree (yyt->Feature_adaptation1.New_export);
else if (yyyIsEqual ("Undefine")) QueryTree (yyt->Feature_adaptation1.Undefine);
else if (yyyIsEqual ("Redefine")) QueryTree (yyt->Feature_adaptation1.Redefine);
else if (yyyIsEqual ("Select")) QueryTree (yyt->Feature_adaptation1.Select);
break;
case kRename_list1: if (false) ;
else if (yyyIsEqual ("Rename_pair")) QueryTree (yyt->Rename_list1.Rename_pair);
else if (yyyIsEqual ("Rename_list")) QueryTree (yyt->Rename_list1.Rename_list);
break;
case kRename_pair: if (false) ;
else if (yyyIsEqual ("Name1")) QueryTree (yyt->Rename_pair.Name1);
else if (yyyIsEqual ("Name2")) QueryTree (yyt->Rename_pair.Name2);
break;
case kCreators1: if (false) ;
else if (yyyIsEqual ("Creation_clause")) QueryTree (yyt->Creators1.Creation_clause);
else if (yyyIsEqual ("Creators")) QueryTree (yyt->Creators1.Creators);
break;
case kCreation_clause: if (false) ;
else if (yyyIsEqual ("Clients")) QueryTree (yyt->Creation_clause.Clients);
else if (yyyIsEqual ("Feature_list")) QueryTree (yyt->Creation_clause.Feature_list);
break;
case kNew_feature_list1: if (false) ;
else if (yyyIsEqual ("Feature_name")) QueryTree (yyt->New_feature_list1.Feature_name);
else if (yyyIsEqual ("New_feature_list")) QueryTree (yyt->New_feature_list1.New_feature_list);
break;
case kFrozen: if (false) ;
else if (yyyIsEqual ("Feature_name")) QueryTree (yyt->Frozen.Feature_name);
break;
case kIdent_name: if (false) ;
else if (yyyIsEqual ("Id")) QueryTree (yyt->Ident_name.Id);
break;
case kPrefix: if (false) ;
else if (yyyIsEqual ("Op_name")) QueryTree (yyt->Prefix.Op_name);
break;
case kInfix: if (false) ;
else if (yyyIsEqual ("Op_name")) QueryTree (yyt->Infix.Op_name);
break;
case kNew_export_list1: if (false) ;
else if (yyyIsEqual ("New_export_item")) QueryTree (yyt->New_export_list1.New_export_item);
else if (yyyIsEqual ("New_export_list")) QueryTree (yyt->New_export_list1.New_export_list);
break;
case kNew_export_item: if (false) ;
else if (yyyIsEqual ("Clients")) QueryTree (yyt->New_export_item.Clients);
else if (yyyIsEqual ("Feature_set")) QueryTree (yyt->New_export_item.Feature_set);
break;
case kFeature_list1: if (false) ;
else if (yyyIsEqual ("Feature_name")) QueryTree (yyt->Feature_list1.Feature_name);
else if (yyyIsEqual ("Feature_list")) QueryTree (yyt->Feature_list1.Feature_list);
break;
case kFormal_args1: if (false) ;
else if (yyyIsEqual ("Entity_decl_group")) QueryTree (yyt->Formal_args1.Entity_decl_group);
else if (yyyIsEqual ("Formal_args")) QueryTree (yyt->Formal_args1.Formal_args);
break;
case kDo_body: if (false) ;
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Do_body.Compound);
break;
case kOnce_body: if (false) ;
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Once_body.Compound);
break;
case kExternal: if (false) ;
else if (yyyIsEqual ("Lang1")) QueryTree (yyt->External.Lang1);
else if (yyyIsEqual ("Lang2")) QueryTree (yyt->External.Lang2);
break;
case kEntity_decl_group: if (false) ;
else if (yyyIsEqual ("Id_list")) QueryTree (yyt->Entity_decl_group.Id_list);
else if (yyyIsEqual ("Type_mark")) QueryTree (yyt->Entity_decl_group.Type_mark);
break;
case kFormal_generics1: if (false) ;
else if (yyyIsEqual ("Formal_generic")) QueryTree (yyt->Formal_generics1.Formal_generic);
else if (yyyIsEqual ("Formal_generics")) QueryTree (yyt->Formal_generics1.Formal_generics);
break;
case kFormal_generic: if (false) ;
else if (yyyIsEqual ("Id")) QueryTree (yyt->Formal_generic.Id);
else if (yyyIsEqual ("Constraint")) QueryTree (yyt->Formal_generic.Constraint);
break;
case kConstraint1: if (false) ;
else if (yyyIsEqual ("Class_type")) QueryTree (yyt->Constraint1.Class_type);
break;
case kCompound1: if (false) ;
else if (yyyIsEqual ("Instruction")) QueryTree (yyt->Compound1.Instruction);
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Compound1.Compound);
break;
case kThen_part_list1: if (false) ;
else if (yyyIsEqual ("Then_part")) QueryTree (yyt->Then_part_list1.Then_part);
else if (yyyIsEqual ("Then_part_list")) QueryTree (yyt->Then_part_list1.Then_part_list);
break;
case kThen_part: if (false) ;
else if (yyyIsEqual ("Guard")) QueryTree (yyt->Then_part.Guard);
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Then_part.Compound);
break;
case kWhen_part_list1: if (false) ;
else if (yyyIsEqual ("When_part")) QueryTree (yyt->When_part_list1.When_part);
else if (yyyIsEqual ("When_part_list")) QueryTree (yyt->When_part_list1.When_part_list);
break;
case kWhen_part: if (false) ;
else if (yyyIsEqual ("Choices")) QueryTree (yyt->When_part.Choices);
else if (yyyIsEqual ("Compound")) QueryTree (yyt->When_part.Compound);
break;
case kChoices1: if (false) ;
else if (yyyIsEqual ("Choice")) QueryTree (yyt->Choices1.Choice);
else if (yyyIsEqual ("Choices")) QueryTree (yyt->Choices1.Choices);
break;
case kInterval: if (false) ;
else if (yyyIsEqual ("From")) QueryTree (yyt->Interval.From);
else if (yyyIsEqual ("To")) QueryTree (yyt->Interval.To);
break;
case kVal: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->Val.Manifest_constant);
break;
case kCreation: if (false) ;
else if (yyyIsEqual ("Type")) QueryTree (yyt->Creation.Type);
else if (yyyIsEqual ("Entity")) QueryTree (yyt->Creation.Entity);
else if (yyyIsEqual ("Unqual_call")) QueryTree (yyt->Creation.Unqual_call);
break;
case kCall_instruct: if (false) ;
else if (yyyIsEqual ("Call")) QueryTree (yyt->Call_instruct.Call);
break;
case kAssign: if (false) ;
else if (yyyIsEqual ("Addr")) QueryTree (yyt->Assign.Addr);
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Assign.Expression);
break;
case kRev_assign: if (false) ;
else if (yyyIsEqual ("Addr")) QueryTree (yyt->Rev_assign.Addr);
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Rev_assign.Expression);
break;
case kConditional: if (false) ;
else if (yyyIsEqual ("Then_part")) QueryTree (yyt->Conditional.Then_part);
else if (yyyIsEqual ("Else_part")) QueryTree (yyt->Conditional.Else_part);
break;
case kMulti_branch: if (false) ;
else if (yyyIsEqual ("Guard")) QueryTree (yyt->Multi_branch.Guard);
else if (yyyIsEqual ("When_part_list")) QueryTree (yyt->Multi_branch.When_part_list);
else if (yyyIsEqual ("Else_part")) QueryTree (yyt->Multi_branch.Else_part);
break;
case kLoop: if (false) ;
else if (yyyIsEqual ("Initialization")) QueryTree (yyt->Loop.Initialization);
else if (yyyIsEqual ("Invariant")) QueryTree (yyt->Loop.Invariant);
else if (yyyIsEqual ("Variant")) QueryTree (yyt->Loop.Variant);
else if (yyyIsEqual ("Loop_body")) QueryTree (yyt->Loop.Loop_body);
break;
case kCheck: if (false) ;
else if (yyyIsEqual ("Assertion")) QueryTree (yyt->Check.Assertion);
break;
case kDebug: if (false) ;
else if (yyyIsEqual ("Debug_keys")) QueryTree (yyt->Debug.Debug_keys);
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Debug.Compound);
break;
case kLoop_body1: if (false) ;
else if (yyyIsEqual ("Exit")) QueryTree (yyt->Loop_body1.Exit);
else if (yyyIsEqual ("Compound")) QueryTree (yyt->Loop_body1.Compound);
break;
case kClass_type: if (false) ;
else if (yyyIsEqual ("Id")) QueryTree (yyt->Class_type.Id);
else if (yyyIsEqual ("Actual_generics")) QueryTree (yyt->Class_type.Actual_generics);
break;
case kClass_type_expanded: if (false) ;
else if (yyyIsEqual ("Id")) QueryTree (yyt->Class_type_expanded.Id);
else if (yyyIsEqual ("Actual_generics")) QueryTree (yyt->Class_type_expanded.Actual_generics);
break;
case kBit_type: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->Bit_type.Manifest_constant);
break;
case kSimple_type: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->Simple_type.Manifest_constant);
break;
case kAnchored: if (false) ;
else if (yyyIsEqual ("Entity")) QueryTree (yyt->Anchored.Entity);
break;
case kActual_generics1: if (false) ;
else if (yyyIsEqual ("Type_list")) QueryTree (yyt->Actual_generics1.Type_list);
break;
case kCondition1: if (false) ;
else if (yyyIsEqual ("Assertion")) QueryTree (yyt->Condition1.Assertion);
break;
case kAssertion1: if (false) ;
else if (yyyIsEqual ("Assertion_clause")) QueryTree (yyt->Assertion1.Assertion_clause);
else if (yyyIsEqual ("Assertion")) QueryTree (yyt->Assertion1.Assertion);
break;
case kAssertion_clause1: if (false) ;
else if (yyyIsEqual ("Tag")) QueryTree (yyt->Assertion_clause1.Tag);
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Assertion_clause1.Expression);
break;
case kType_list1: if (false) ;
else if (yyyIsEqual ("Type")) QueryTree (yyt->Type_list1.Type);
else if (yyyIsEqual ("Type_list")) QueryTree (yyt->Type_list1.Type_list);
break;
case kCall_chain1: if (false) ;
else if (yyyIsEqual ("Unqual_call")) QueryTree (yyt->Call_chain1.Unqual_call);
else if (yyyIsEqual ("Call_chain")) QueryTree (yyt->Call_chain1.Call_chain);
break;
case kUnqual_call1: if (false) ;
else if (yyyIsEqual ("Entity")) QueryTree (yyt->Unqual_call1.Entity);
else if (yyyIsEqual ("Actuals")) QueryTree (yyt->Unqual_call1.Actuals);
break;
case kActuals1: if (false) ;
else if (yyyIsEqual ("Actual_list")) QueryTree (yyt->Actuals1.Actual_list);
break;
case kActual_list1: if (false) ;
else if (yyyIsEqual ("Actual")) QueryTree (yyt->Actual_list1.Actual);
else if (yyyIsEqual ("Actual_list")) QueryTree (yyt->Actual_list1.Actual_list);
break;
case kAddr: if (false) ;
else if (yyyIsEqual ("Entity")) QueryTree (yyt->Addr.Entity);
break;
case kSimple_expr: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->Simple_expr.Manifest_constant);
break;
case kCall: if (false) ;
else if (yyyIsEqual ("Qual")) QueryTree (yyt->Call.Qual);
else if (yyyIsEqual ("Call_chain")) QueryTree (yyt->Call.Call_chain);
break;
case kBin_expr: if (false) ;
else if (yyyIsEqual ("Lop")) QueryTree (yyt->Bin_expr.Lop);
else if (yyyIsEqual ("Op")) QueryTree (yyt->Bin_expr.Op);
else if (yyyIsEqual ("Rop")) QueryTree (yyt->Bin_expr.Rop);
break;
case kUn_expr: if (false) ;
else if (yyyIsEqual ("Op")) QueryTree (yyt->Un_expr.Op);
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Un_expr.Expression);
break;
case kParenth: if (false) ;
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Parenth.Expression);
break;
case kManifest_array1: if (false) ;
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Manifest_array1.Expression);
else if (yyyIsEqual ("Manifest_array")) QueryTree (yyt->Manifest_array1.Manifest_array);
break;
case kOld: if (false) ;
else if (yyyIsEqual ("Expression")) QueryTree (yyt->Old.Expression);
break;
case kStrip: if (false) ;
else if (yyyIsEqual ("List")) QueryTree (yyt->Strip.List);
break;
case klist: if (false) ;
else if (yyyIsEqual ("Manifest_constant")) QueryTree (yyt->list.Manifest_constant);
else if (yyyIsEqual ("List")) QueryTree (yyt->list.List);
break;
case kInt: if (false) ;
else if (yyyIsEqual ("Sign")) QueryTree (yyt->Int.Sign);
break;
case kReal: if (false) ;
else if (yyyIsEqual ("Sign")) QueryTree (yyt->Real.Sign);
break;
    default: ;
    }
   }
  }
 }
}

bool IsEqualTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt1, tTree yyt2)
# else
 (yyt1, yyt2) tTree yyt1, yyt2;
# endif
{
 if (yyt1 == NoTree && yyt2 == NoTree) return true;
 if (yyt1 == NoTree || yyt2 == NoTree || yyt1->Kind != yyt2->Kind) return false;
 switch (yyt1->Kind) {
case kEiffel: return true
&& equaltTree (yyt1->Eiffel.Classes, yyt2->Eiffel.Classes)
;
case kClasses1: return true
&& equaltTree (yyt1->Classes1.Class_declaration, yyt2->Classes1.Class_declaration)
&& equaltTree (yyt1->Classes1.Classes, yyt2->Classes1.Classes)
;
case kClass_declaration: return true
&& equaltTree (yyt1->Class_declaration.Indexing, yyt2->Class_declaration.Indexing)
&& equaltTree (yyt1->Class_declaration.Class_header, yyt2->Class_declaration.Class_header)
&& equaltTree (yyt1->Class_declaration.Formal_generics, yyt2->Class_declaration.Formal_generics)
&& equaltTree (yyt1->Class_declaration.Obsolete, yyt2->Class_declaration.Obsolete)
&& equaltTree (yyt1->Class_declaration.Inheritance, yyt2->Class_declaration.Inheritance)
&& equaltTree (yyt1->Class_declaration.Creators, yyt2->Class_declaration.Creators)
&& equaltTree (yyt1->Class_declaration.Features, yyt2->Class_declaration.Features)
&& equaltTree (yyt1->Class_declaration.Invariant, yyt2->Class_declaration.Invariant)
&& (equaltStringRef (yyt1->Class_declaration.comment, yyt2->Class_declaration.comment))
;
case kIndex_list1: return true
&& equaltTree (yyt1->Index_list1.Index_clause, yyt2->Index_list1.Index_clause)
&& equaltTree (yyt1->Index_list1.Index_list, yyt2->Index_list1.Index_list)
;
case kIndex_clause: return true
&& equaltTree (yyt1->Index_clause.Index, yyt2->Index_clause.Index)
&& equaltTree (yyt1->Index_clause.Index_terms, yyt2->Index_clause.Index_terms)
;
case kClass: return true
&& equaltTree (yyt1->Class.Name, yyt2->Class.Name)
;
case kExpanded_class: return true
&& equaltTree (yyt1->Expanded_class.Name, yyt2->Expanded_class.Name)
;
case kDeferred_class: return true
&& equaltTree (yyt1->Deferred_class.Name, yyt2->Deferred_class.Name)
;
case kFeatures1: return true
&& equaltTree (yyt1->Features1.Feature_clause, yyt2->Features1.Feature_clause)
&& equaltTree (yyt1->Features1.Features, yyt2->Features1.Features)
;
case kFeature_clause: return true
&& equaltTree (yyt1->Feature_clause.Clients, yyt2->Feature_clause.Clients)
&& (equaltStringRef (yyt1->Feature_clause.comment, yyt2->Feature_clause.comment))
&& equaltTree (yyt1->Feature_clause.Feature_decls, yyt2->Feature_clause.Feature_decls)
;
case kClients1: return true
&& equaltTree (yyt1->Clients1.List, yyt2->Clients1.List)
;
case kFeature_decls1: return true
&& equaltTree (yyt1->Feature_decls1.Feature_decl, yyt2->Feature_decls1.Feature_decl)
&& equaltTree (yyt1->Feature_decls1.Feature_decls, yyt2->Feature_decls1.Feature_decls)
;
case kFeature_decl: return true
&& equaltTree (yyt1->Feature_decl.New_feature_list, yyt2->Feature_decl.New_feature_list)
&& equaltTree (yyt1->Feature_decl.Declaration_body, yyt2->Feature_decl.Declaration_body)
;
case kDeclaration_body: return true
&& equaltTree (yyt1->Declaration_body.Formal_args, yyt2->Declaration_body.Formal_args)
&& equaltTree (yyt1->Declaration_body.Type_mark, yyt2->Declaration_body.Type_mark)
&& equaltTree (yyt1->Declaration_body.Const_or_routine, yyt2->Declaration_body.Const_or_routine)
;
case kM_const: return true
&& equaltTree (yyt1->M_const.Manifest_constant, yyt2->M_const.Manifest_constant)
;
case kUnique: return true
&& (equaltPosition (yyt1->Unique.pos, yyt2->Unique.pos))
;
case kRoutine: return true
&& equaltTree (yyt1->Routine.Obsolete, yyt2->Routine.Obsolete)
&& (equaltStringRef (yyt1->Routine.comment, yyt2->Routine.comment))
&& equaltTree (yyt1->Routine.Precondition, yyt2->Routine.Precondition)
&& equaltTree (yyt1->Routine.Local_decls, yyt2->Routine.Local_decls)
&& equaltTree (yyt1->Routine.Routine_body, yyt2->Routine.Routine_body)
&& equaltTree (yyt1->Routine.Postcondition, yyt2->Routine.Postcondition)
&& equaltTree (yyt1->Routine.Rescue, yyt2->Routine.Rescue)
&& (equaltStringRef (yyt1->Routine.end_comment, yyt2->Routine.end_comment))
;
case kParent_list1: return true
&& equaltTree (yyt1->Parent_list1.Parent, yyt2->Parent_list1.Parent)
&& equaltTree (yyt1->Parent_list1.Parent_list, yyt2->Parent_list1.Parent_list)
;
case kParent: return true
&& equaltTree (yyt1->Parent.Class_type, yyt2->Parent.Class_type)
&& equaltTree (yyt1->Parent.Feature_adaptation, yyt2->Parent.Feature_adaptation)
;
case kFeature_adaptation1: return true
&& equaltTree (yyt1->Feature_adaptation1.Rename, yyt2->Feature_adaptation1.Rename)
&& equaltTree (yyt1->Feature_adaptation1.New_export, yyt2->Feature_adaptation1.New_export)
&& equaltTree (yyt1->Feature_adaptation1.Undefine, yyt2->Feature_adaptation1.Undefine)
&& equaltTree (yyt1->Feature_adaptation1.Redefine, yyt2->Feature_adaptation1.Redefine)
&& equaltTree (yyt1->Feature_adaptation1.Select, yyt2->Feature_adaptation1.Select)
;
case kRename_list1: return true
&& equaltTree (yyt1->Rename_list1.Rename_pair, yyt2->Rename_list1.Rename_pair)
&& equaltTree (yyt1->Rename_list1.Rename_list, yyt2->Rename_list1.Rename_list)
;
case kRename_pair: return true
&& equaltTree (yyt1->Rename_pair.Name1, yyt2->Rename_pair.Name1)
&& equaltTree (yyt1->Rename_pair.Name2, yyt2->Rename_pair.Name2)
;
case kCreators1: return true
&& equaltTree (yyt1->Creators1.Creation_clause, yyt2->Creators1.Creation_clause)
&& equaltTree (yyt1->Creators1.Creators, yyt2->Creators1.Creators)
;
case kCreation_clause: return true
&& equaltTree (yyt1->Creation_clause.Clients, yyt2->Creation_clause.Clients)
&& (equaltStringRef (yyt1->Creation_clause.comment, yyt2->Creation_clause.comment))
&& equaltTree (yyt1->Creation_clause.Feature_list, yyt2->Creation_clause.Feature_list)
;
case kNew_feature_list1: return true
&& equaltTree (yyt1->New_feature_list1.Feature_name, yyt2->New_feature_list1.Feature_name)
&& equaltTree (yyt1->New_feature_list1.New_feature_list, yyt2->New_feature_list1.New_feature_list)
;
case kFrozen: return true
&& equaltTree (yyt1->Frozen.Feature_name, yyt2->Frozen.Feature_name)
;
case kIdent_name: return true
&& equaltTree (yyt1->Ident_name.Id, yyt2->Ident_name.Id)
;
case kPrefix: return true
&& equaltTree (yyt1->Prefix.Op_name, yyt2->Prefix.Op_name)
;
case kInfix: return true
&& equaltTree (yyt1->Infix.Op_name, yyt2->Infix.Op_name)
;
case kOp_name: return true
&& (equaltPosition (yyt1->Op_name.pos, yyt2->Op_name.pos))
;
case kFree_op: return true
&& (equaltPosition (yyt1->Free_op.pos, yyt2->Free_op.pos))
&& (equaltIdent (yyt1->Free_op.ident, yyt2->Free_op.ident))
;
case kOper: return true
&& (equaltPosition (yyt1->Oper.pos, yyt2->Oper.pos))
&& (equalint (yyt1->Oper.op, yyt2->Oper.op))
;
case kNew_export_list1: return true
&& equaltTree (yyt1->New_export_list1.New_export_item, yyt2->New_export_list1.New_export_item)
&& equaltTree (yyt1->New_export_list1.New_export_list, yyt2->New_export_list1.New_export_list)
;
case kNew_export_item: return true
&& equaltTree (yyt1->New_export_item.Clients, yyt2->New_export_item.Clients)
&& equaltTree (yyt1->New_export_item.Feature_set, yyt2->New_export_item.Feature_set)
;
case kFeature_list1: return true
&& equaltTree (yyt1->Feature_list1.Feature_name, yyt2->Feature_list1.Feature_name)
&& equaltTree (yyt1->Feature_list1.Feature_list, yyt2->Feature_list1.Feature_list)
;
case kFormal_args1: return true
&& equaltTree (yyt1->Formal_args1.Entity_decl_group, yyt2->Formal_args1.Entity_decl_group)
&& equaltTree (yyt1->Formal_args1.Formal_args, yyt2->Formal_args1.Formal_args)
;
case kDo_body: return true
&& equaltTree (yyt1->Do_body.Compound, yyt2->Do_body.Compound)
;
case kOnce_body: return true
&& equaltTree (yyt1->Once_body.Compound, yyt2->Once_body.Compound)
;
case kExternal: return true
&& equaltTree (yyt1->External.Lang1, yyt2->External.Lang1)
&& equaltTree (yyt1->External.Lang2, yyt2->External.Lang2)
;
case kDeferred: return true
&& (equaltPosition (yyt1->Deferred.pos, yyt2->Deferred.pos))
;
case kEntity_decl_group: return true
&& equaltTree (yyt1->Entity_decl_group.Id_list, yyt2->Entity_decl_group.Id_list)
&& equaltTree (yyt1->Entity_decl_group.Type_mark, yyt2->Entity_decl_group.Type_mark)
;
case kFormal_generics1: return true
&& equaltTree (yyt1->Formal_generics1.Formal_generic, yyt2->Formal_generics1.Formal_generic)
&& equaltTree (yyt1->Formal_generics1.Formal_generics, yyt2->Formal_generics1.Formal_generics)
;
case kFormal_generic: return true
&& equaltTree (yyt1->Formal_generic.Id, yyt2->Formal_generic.Id)
&& equaltTree (yyt1->Formal_generic.Constraint, yyt2->Formal_generic.Constraint)
;
case kConstraint1: return true
&& equaltTree (yyt1->Constraint1.Class_type, yyt2->Constraint1.Class_type)
;
case kCompound1: return true
&& equaltTree (yyt1->Compound1.Instruction, yyt2->Compound1.Instruction)
&& equaltTree (yyt1->Compound1.Compound, yyt2->Compound1.Compound)
;
case kThen_part_list1: return true
&& equaltTree (yyt1->Then_part_list1.Then_part, yyt2->Then_part_list1.Then_part)
&& equaltTree (yyt1->Then_part_list1.Then_part_list, yyt2->Then_part_list1.Then_part_list)
;
case kThen_part: return true
&& equaltTree (yyt1->Then_part.Guard, yyt2->Then_part.Guard)
&& equaltTree (yyt1->Then_part.Compound, yyt2->Then_part.Compound)
;
case kWhen_part_list1: return true
&& equaltTree (yyt1->When_part_list1.When_part, yyt2->When_part_list1.When_part)
&& equaltTree (yyt1->When_part_list1.When_part_list, yyt2->When_part_list1.When_part_list)
;
case kWhen_part: return true
&& equaltTree (yyt1->When_part.Choices, yyt2->When_part.Choices)
&& equaltTree (yyt1->When_part.Compound, yyt2->When_part.Compound)
;
case kChoices1: return true
&& equaltTree (yyt1->Choices1.Choice, yyt2->Choices1.Choice)
&& equaltTree (yyt1->Choices1.Choices, yyt2->Choices1.Choices)
;
case kInterval: return true
&& equaltTree (yyt1->Interval.From, yyt2->Interval.From)
&& equaltTree (yyt1->Interval.To, yyt2->Interval.To)
;
case kVal: return true
&& equaltTree (yyt1->Val.Manifest_constant, yyt2->Val.Manifest_constant)
;
case kCreation: return true
&& equaltTree (yyt1->Creation.Type, yyt2->Creation.Type)
&& equaltTree (yyt1->Creation.Entity, yyt2->Creation.Entity)
&& equaltTree (yyt1->Creation.Unqual_call, yyt2->Creation.Unqual_call)
;
case kCall_instruct: return true
&& equaltTree (yyt1->Call_instruct.Call, yyt2->Call_instruct.Call)
;
case kAssign: return true
&& equaltTree (yyt1->Assign.Addr, yyt2->Assign.Addr)
&& equaltTree (yyt1->Assign.Expression, yyt2->Assign.Expression)
;
case kRev_assign: return true
&& equaltTree (yyt1->Rev_assign.Addr, yyt2->Rev_assign.Addr)
&& equaltTree (yyt1->Rev_assign.Expression, yyt2->Rev_assign.Expression)
;
case kConditional: return true
&& equaltTree (yyt1->Conditional.Then_part, yyt2->Conditional.Then_part)
&& equaltTree (yyt1->Conditional.Else_part, yyt2->Conditional.Else_part)
;
case kMulti_branch: return true
&& equaltTree (yyt1->Multi_branch.Guard, yyt2->Multi_branch.Guard)
&& equaltTree (yyt1->Multi_branch.When_part_list, yyt2->Multi_branch.When_part_list)
&& equaltTree (yyt1->Multi_branch.Else_part, yyt2->Multi_branch.Else_part)
;
case kLoop: return true
&& equaltTree (yyt1->Loop.Initialization, yyt2->Loop.Initialization)
&& equaltTree (yyt1->Loop.Invariant, yyt2->Loop.Invariant)
&& equaltTree (yyt1->Loop.Variant, yyt2->Loop.Variant)
&& equaltTree (yyt1->Loop.Loop_body, yyt2->Loop.Loop_body)
;
case kCheck: return true
&& equaltTree (yyt1->Check.Assertion, yyt2->Check.Assertion)
;
case kDebug: return true
&& equaltTree (yyt1->Debug.Debug_keys, yyt2->Debug.Debug_keys)
&& equaltTree (yyt1->Debug.Compound, yyt2->Debug.Compound)
;
case kRetry: return true
&& (equaltPosition (yyt1->Retry.pos, yyt2->Retry.pos))
;
case kLoop_body1: return true
&& equaltTree (yyt1->Loop_body1.Exit, yyt2->Loop_body1.Exit)
&& equaltTree (yyt1->Loop_body1.Compound, yyt2->Loop_body1.Compound)
;
case kClass_type: return true
&& equaltTree (yyt1->Class_type.Id, yyt2->Class_type.Id)
&& equaltTree (yyt1->Class_type.Actual_generics, yyt2->Class_type.Actual_generics)
;
case kClass_type_expanded: return true
&& equaltTree (yyt1->Class_type_expanded.Id, yyt2->Class_type_expanded.Id)
&& equaltTree (yyt1->Class_type_expanded.Actual_generics, yyt2->Class_type_expanded.Actual_generics)
;
case kBit_type: return true
&& equaltTree (yyt1->Bit_type.Manifest_constant, yyt2->Bit_type.Manifest_constant)
;
case kSimple_type: return true
&& equaltTree (yyt1->Simple_type.Manifest_constant, yyt2->Simple_type.Manifest_constant)
;
case kAnchored: return true
&& equaltTree (yyt1->Anchored.Entity, yyt2->Anchored.Entity)
;
case kActual_generics1: return true
&& equaltTree (yyt1->Actual_generics1.Type_list, yyt2->Actual_generics1.Type_list)
;
case kCondition1: return true
&& (equalint (yyt1->Condition1.extension, yyt2->Condition1.extension))
&& equaltTree (yyt1->Condition1.Assertion, yyt2->Condition1.Assertion)
;
case kAssertion1: return true
&& equaltTree (yyt1->Assertion1.Assertion_clause, yyt2->Assertion1.Assertion_clause)
&& equaltTree (yyt1->Assertion1.Assertion, yyt2->Assertion1.Assertion)
;
case kAssertion_clause1: return true
&& equaltTree (yyt1->Assertion_clause1.Tag, yyt2->Assertion_clause1.Tag)
&& equaltTree (yyt1->Assertion_clause1.Expression, yyt2->Assertion_clause1.Expression)
;
case kType_list1: return true
&& equaltTree (yyt1->Type_list1.Type, yyt2->Type_list1.Type)
&& equaltTree (yyt1->Type_list1.Type_list, yyt2->Type_list1.Type_list)
;
case kCall_chain1: return true
&& equaltTree (yyt1->Call_chain1.Unqual_call, yyt2->Call_chain1.Unqual_call)
&& equaltTree (yyt1->Call_chain1.Call_chain, yyt2->Call_chain1.Call_chain)
;
case kUnqual_call1: return true
&& equaltTree (yyt1->Unqual_call1.Entity, yyt2->Unqual_call1.Entity)
&& equaltTree (yyt1->Unqual_call1.Actuals, yyt2->Unqual_call1.Actuals)
;
case kActuals1: return true
&& equaltTree (yyt1->Actuals1.Actual_list, yyt2->Actuals1.Actual_list)
;
case kActual_list1: return true
&& equaltTree (yyt1->Actual_list1.Actual, yyt2->Actual_list1.Actual)
&& equaltTree (yyt1->Actual_list1.Actual_list, yyt2->Actual_list1.Actual_list)
;
case kAddr: return true
&& equaltTree (yyt1->Addr.Entity, yyt2->Addr.Entity)
;
case kComment: return true
&& (equaltStringRef (yyt1->Comment.comment, yyt2->Comment.comment))
;
case kSimple_expr: return true
&& equaltTree (yyt1->Simple_expr.Manifest_constant, yyt2->Simple_expr.Manifest_constant)
;
case kCall: return true
&& equaltTree (yyt1->Call.Qual, yyt2->Call.Qual)
&& equaltTree (yyt1->Call.Call_chain, yyt2->Call.Call_chain)
;
case kBin_expr: return true
&& equaltTree (yyt1->Bin_expr.Lop, yyt2->Bin_expr.Lop)
&& equaltTree (yyt1->Bin_expr.Op, yyt2->Bin_expr.Op)
&& equaltTree (yyt1->Bin_expr.Rop, yyt2->Bin_expr.Rop)
;
case kUn_expr: return true
&& equaltTree (yyt1->Un_expr.Op, yyt2->Un_expr.Op)
&& equaltTree (yyt1->Un_expr.Expression, yyt2->Un_expr.Expression)
;
case kParenth: return true
&& equaltTree (yyt1->Parenth.Expression, yyt2->Parenth.Expression)
;
case kManifest_array1: return true
&& equaltTree (yyt1->Manifest_array1.Expression, yyt2->Manifest_array1.Expression)
&& equaltTree (yyt1->Manifest_array1.Manifest_array, yyt2->Manifest_array1.Manifest_array)
;
case kOld: return true
&& equaltTree (yyt1->Old.Expression, yyt2->Old.Expression)
;
case kStrip: return true
&& equaltTree (yyt1->Strip.List, yyt2->Strip.List)
;
case klist: return true
&& equaltTree (yyt1->list.Manifest_constant, yyt2->list.Manifest_constant)
&& equaltTree (yyt1->list.List, yyt2->list.List)
;
case kCh: return true
&& (equalint (yyt1->Ch.ch, yyt2->Ch.ch))
&& (equaltPosition (yyt1->Ch.pos, yyt2->Ch.pos))
;
case kTrue: return true
&& (equaltPosition (yyt1->True.pos, yyt2->True.pos))
;
case kFalse: return true
&& (equaltPosition (yyt1->False.pos, yyt2->False.pos))
;
case kInt: return true
&& equaltTree (yyt1->Int.Sign, yyt2->Int.Sign)
&& (equallong (yyt1->Int.value, yyt2->Int.value))
&& (equaltPosition (yyt1->Int.pos, yyt2->Int.pos))
;
case kReal: return true
&& equaltTree (yyt1->Real.Sign, yyt2->Real.Sign)
&& (equaldouble (yyt1->Real.value, yyt2->Real.value))
&& (equaltPosition (yyt1->Real.pos, yyt2->Real.pos))
;
case k_CHARACTER: return true
&& (equaltPosition (yyt1->_CHARACTER.pos, yyt2->_CHARACTER.pos))
;
case k_INTEGER: return true
&& (equaltPosition (yyt1->_INTEGER.pos, yyt2->_INTEGER.pos))
;
case k_REAL: return true
&& (equaltPosition (yyt1->_REAL.pos, yyt2->_REAL.pos))
;
case k_DOUBLE: return true
&& (equaltPosition (yyt1->_DOUBLE.pos, yyt2->_DOUBLE.pos))
;
case k_BOOLEAN: return true
&& (equaltPosition (yyt1->_BOOLEAN.pos, yyt2->_BOOLEAN.pos))
;
case k_STRING: return true
&& (equaltPosition (yyt1->_STRING.pos, yyt2->_STRING.pos))
;
case k_BIT: return true
&& (equaltPosition (yyt1->_BIT.pos, yyt2->_BIT.pos))
;
case k_NONE: return true
&& (equaltPosition (yyt1->_NONE.pos, yyt2->_NONE.pos))
;
case kBitseq: return true
&& (equaltStringRef (yyt1->Bitseq.literal, yyt2->Bitseq.literal))
&& (equaltPosition (yyt1->Bitseq.pos, yyt2->Bitseq.pos))
;
case kString: return true
&& (equaltStringRef (yyt1->String.string, yyt2->String.string))
&& (equaltPosition (yyt1->String.pos, yyt2->String.pos))
;
case kCurrent: return true
&& (equaltPosition (yyt1->Current.pos, yyt2->Current.pos))
;
case kResult: return true
&& (equaltPosition (yyt1->Result.pos, yyt2->Result.pos))
;
case kId: return true
&& (equaltIdent (yyt1->Id.ident, yyt2->Id.ident))
&& (equaltPosition (yyt1->Id.pos, yyt2->Id.pos))
;
 default: return true;
 }
}

void BeginTree ()
{
}

void CloseTree ()
{
}
