-- From B.Meyer, Eiffel - The Language

class ACCOUNT creation

  make

feature
-- feature comment

  balance: INTEGER;
  owner: PERSON;
  minimum_balance: INTEGER is 1000;

  open(who: PERSON) is
      -- Assign the account to owner who
    do
      owner := who
    end -- open
    

  deposit(sum: INTEGER) is
      -- Deposit sum into account
    require
      sum >= 0
    do
      add(sum)
    ensure
      balance = old balance + sum
    end; -- deposit
  
  withdraw(sum: INTEGER) is
      -- Withdraw sum from the account
    require
      sum >= 0;
      sum <= balance - minimum_balance
    do
      add(-sum)
    ensure
      balance = old balance - sum
    end; -- withdraw

  may_withdraw(sum: INTEGER): BOOLEAN is
      -- Is there enough to withdraw sum?
    do
      Result := (balance >= sum + minimum_balance)
    end -- may_withdraw

feature { NONE }
  
  add(sum: INTEGER) is
      -- Add sum to the balance
      -- (Secret procedure)
    do
      balance := balance + sum
    end; -- add

  make(initial: INTEGER) is
      -- Initialize account with balance initial.
    require
      initial >= minimum_balance
    do
      balance := initial
    end -- make

invariant
  balance >= minimum_balance
end -- class ACCOUNT
 
  
