#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include "ParserDrv.h"
#include "ParserMEY.h"
#include "ParserISE.h"
#include "ParserSIG.h"
#include "Time.h"
#include "ratc.h"

extern char scan_errors;

bool compatibility;
bool error_out;
bool tree_handling;
bool tree_out;
bool terse;
bool bench_mark;
bool filter;

char in_file[MAXPATHLEN], 
     ascii_out_file[MAXPATHLEN],
     binary_out_file[MAXPATHLEN],
     lst_file[MAXPATHLEN], 
     err_file[MAXPATHLEN],
     *command;


void p_usage() 
{
	fprintf(stderr,"Usage: ep [-MEY|-ISE|-SIG] [-t|-ibfiq] filenames\n");
	exit(1);
}


void init_val() 
{
	if (terse) {
	  if (!(!error_out && !filter && !tree_handling && !tree_handling))
	    p_usage();
	}
	else terse = OFF;
	if (!compatibility) compatibility = MEY;
	if (!error_out) error_out = SEPARATE_ERROR;
	if (!tree_handling) tree_handling = WRITETREE;
	if (!tree_out) tree_out = ASCII;
}



void put_tree()
{
	FILE *fp;	
	
	  switch (tree_handling) {
	  case WRITETREE:
	    if (tree_out == ASCII) {
	      if (!filter) {
                if ((fp = fopen(ascii_out_file, "w")) == NULL ) {
                  fprintf(stderr, "%s: can't open %s\n", command, ascii_out_file);
                  exit(1);
                }
	      }
	      else 
		fp = stdout;
	      WriteTree(fp, TreeRoot);
	      if (!filter)
                fclose(fp);
            }
            else { 
	      if (!filter) {
                if ((fp = fopen(binary_out_file, "w")) == NULL ) {
                  fprintf(stderr, "%s: can't open %s\n", command, binary_out_file);
                  exit(1);
                }
	      }
	      else 
		fp = stdout;
	      PutTree(fp, TreeRoot);
	      if (!filter)
                fclose(fp);
            }
	    break;
	  case QUERYTREE:
	    QueryTree(TreeRoot);
	    break;
	  case CHECKTREE:
	    CheckTree(TreeRoot);
	    break;
	  default:
	    p_usage();
	  }
}  
			 


void handle_err(error_count)
int error_count;
{
	if (!error_count && !scan_errors) { 
	  if (terse == OFF) 
	    put_tree();
	  else 
	    fprintf(stderr,"no errors occured!\n");
	}
	else { 
          fprintf(stderr, "%d scan error(s) occured!\n", scan_errors);
          fprintf(stderr, "%d parse error(s) occured!\n", error_count);
	  if (error_out == INTEGRATED_ERROR) {
	    fprintf(stderr," Generating Listing: %s\n", lst_file);
	    gen_lst();
	  }
	}
}


void Parser() {
int error_count;
	if (error_out == INTEGRATED_ERROR)
	  StoreMessages(ON);
	if (!filter)
	  fprintf(stderr, "Analysing %s.\n", in_file);
	switch (compatibility) {
	case MEY:
		 error_count = ParserMEY();
		 break;
	case ISE: 
		 error_count = ParserISE();
		 break;
	case SIG:
		 error_count = ParserSIG();
		 break;

	default :
		 p_usage();
        }
	handle_err(error_count);
}

void inout_files(fname)
char *fname;
{
	bzero(lst_file, MAXPATHLEN);
	bzero(err_file, MAXPATHLEN);
	bzero(in_file, MAXPATHLEN);
	bzero(ascii_out_file, MAXPATHLEN);
	bzero(binary_out_file, MAXPATHLEN);
	if (!strcmp(fname+(strlen(fname)-2), ".e")) {
	  strcpy(in_file, fname);
	  strcat(strncpy(lst_file, in_file, strlen(in_file)-1), "lst");
	  strcat(strncpy(err_file, in_file, strlen(in_file)-1), "err");
	  strcat(strncpy(ascii_out_file, in_file, strlen(in_file)-1), "atr");
	  strcat(strncpy(binary_out_file, in_file, strlen(in_file)-1), "btr");
	}
	else {
	  strcpy(in_file, fname);
	  strcat(in_file, ".e");
	  strcat(strcat(lst_file, fname), ".lst");
	  strcat(strcat(err_file, fname), ".err");
	  strcat(strcat(ascii_out_file, fname), ".atr");
	  strcat(strcat(binary_out_file, fname), ".btr");
	}
}


int main(argc, argv) 
int argc;
char **argv;
{
	int i = 0;
	char *opt_ptr;

	command = argv[0];
	while ( (++i < argc) && (*(argv[i]) == '-') ) {
	  if (strcmp(argv[i]+1, "MEY") == 0)
	    if (!compatibility) compatibility = MEY;	
	    else  p_usage();
	  else 
            if (strcmp(argv[i]+1, "ISE") == 0)
	      if (!compatibility) compatibility = ISE;
	      else p_usage();
	    else 
              if (strcmp(argv[i]+1, "SIG") == 0)
		if (!compatibility) compatibility = SIG;
		else p_usage();
	      else {
		opt_ptr = argv[i]+1;
		opt_ptr--;
		while (*(++opt_ptr) ) {
		  switch (*opt_ptr) {
		  case 't':
                    	   terse = ON;
			   break;
		  case 'i':
			   error_out = INTEGRATED_ERROR;
			   break;
		  case 'q':
			   tree_handling = QUERYTREE;
			   break;
		  case 'c':
			   tree_handling = CHECKTREE;
			   break;
		  case 'b': 
			   tree_out = BIN;
			   break;
		  case 'f' :
			   filter = ON;
		   	   break;
		  case 'B':
			   bench_mark = ON;
		  	   break;
		  default :
			   p_usage();
		  }
	        }
	      } 
           }
	init_val();
	i--;
	while ( ++i < argc ) {
	  inout_files(argv[i]);
	  if (bench_mark)
	    (void) StepTime();
	  ReleaseTreeModule();
	  Parser();
	  if (bench_mark)
	    WriteStepTime("milliseconds:");
	}
	return 0;
}
