#include <stdio.h>
#include <fcntl.h>
#include <limits.h>
#include <sys/param.h>

#define TRUE		1
#define FALSE		0

#define PERMS 		0644
#define ERR_LINE 	1024	
#define IN_LINE 	1024

#define ERROR		1
#define WARNING		2
#define INFORMATION	3
#define NOTE		4
#define FATAL		5
#define REP_RES		6
#define UNKOWN_CLASS	9
#define UNKOWN_ERR	99	

typedef struct {
	int line;
	int col;
	int type;
} t_errline;
	
extern char in_file[MAXPATHLEN],
     	    lst_file[MAXPATHLEN],
     	    err_file[MAXPATHLEN],
     	    *command;

char last_line;


void write_err(fp)
FILE *fp;
{
        if ((fp = fopen(err_file, "w")) == NULL ) {
          fprintf(stderr, "%s: can't open %s\n", command, err_file);
          exit(1);
        }
        else {
          WriteMessages(fp);
	  fclose(fp);
	}
}

void cp_lines(from, to, n)
FILE *from, *to;
int n;
{
	int i = 0;
	char buf[IN_LINE];

	while (i++ < n && !last_line) {
	  if (fgets(buf, IN_LINE, from) == NULL) {
	    last_line = TRUE;
	  }
	  if (!last_line)
	    if (fputs(buf, to) == EOF) {
	      fprintf(stderr,"%s: internal error, please report: cp_lines(), fputs()\n", command);
	      exit(1);
	    }
	}
}
	 

void analyse_line(buf, info)
char *buf;
t_errline *info;
{
	char type[256];

	if(sscanf(buf,"  %d, %d:  %s ", &info->line, &info->col, type) == 3) {
	  switch (type[0]) {
	    case 'E' : info->type = ERROR; break;
	    case 'W' : info->type = WARNING; break;
	    case 'I' : info->type = INFORMATION; break;
	    case 'N' : info->type = NOTE; break;
	    case 'F' : info->type = FATAL; break;
	    case 'R' : info->type = REP_RES; break;
	    default  : info->type = UNKOWN_CLASS;
	  }
	}
	else {
	  fprintf(stderr, "sscanf error\n");
	  info->type = UNKOWN_ERR;
	}
}

void put_line(fp, buf) 
FILE *fp;
char *buf;
{
	if (fputs(buf, fp) == EOF) {
	  fprintf(stderr,"%s: internal error, please report: put_err_line(), fputs()\n", command);
	  exit(1);
	 }
}


void make_ptr(buf, col)
char *buf;
int col;
{
	int i;

	bzero(buf, IN_LINE);
	for(i = 0; i <= (col-2); i++) {
	  buf[i] = ' ';
	}
	buf[col-1] = '^';
	buf[col] = '\n';
}

void put_err_line(fp, buf, info) 
FILE *fp;
char *buf;
t_errline *info;
{
	char ptr_buf[IN_LINE];
	
	switch (info->type) {
	  case (ERROR) 		: 
	  case (WARNING)	:
		make_ptr(ptr_buf, info->col);
		put_line(fp, ptr_buf);
		put_line(fp, buf);
		break;
	  case (UNKOWN_ERR)	:
	  default : put_line(fp, buf);
	}
}
	
		

	
void gen_lst() 
{
	char err_buf[ERR_LINE],
     	     in_buf[IN_LINE];
	FILE *in_fp, *lst_fp, *err_fp;
	t_errline line_info;	
	int last = 0;

	write_err(err_fp);
	last_line = FALSE;
	if ((in_fp = fopen(in_file, "r")) == NULL) {
	  fprintf(stderr, "%s: can't open %s\n", command, in_file);
	  exit(1);
	}
	if ((lst_fp = fopen(lst_file, "w")) == NULL) {
	  fprintf(stderr, "%s: can't open %s\n", command, lst_file);
	  exit(1);
	}
	if ((err_fp = fopen(err_file, "r")) == NULL) {
	  fprintf(stderr, "%s: can't open %s\n", command, err_file);
	  exit(1);
	}
	while ((fgets(err_buf, ERR_LINE, err_fp)) != NULL ) {
	  analyse_line(err_buf, &line_info);
	  if (line_info.line == last) {
	    put_err_line(lst_fp, err_buf, &line_info); 
	  }
	  else {
	    cp_lines(in_fp, lst_fp, line_info.line - last);
	    last = line_info.line;
	    put_err_line(lst_fp, err_buf, &line_info); 
	  }
	}
	cp_lines(in_fp, lst_fp, INT_MAX);
 
	fclose(in_fp);
	fclose(lst_fp);
	fclose(err_fp);
	unlink(err_file);
}
