/************************************************************************/
/* 									*/
/* 	The New Features of an Eiffel-3 class are printed.		*/
/* 	This is an example of how the abstract syntax tree generated	*/
/* 	by ep can be accessed.						*/
/*									*/
/*	Burghardt Groeber 12/92						*/
/************************************************************************/


#include <stdio.h>
#include "../Tree.h"


bool new_feature;


/*	"find_New_feature" prints out the identifier, Operator or	*/
/*	Free Operator if they are in the New_feature_list branch	*/
/*	of the tree.							*/

void find_New_features(tree_node)
tTree tree_node;
{
	switch (tree_node->Kind) {
	  case kNew_feature_list1:
		new_feature = true;
		break;
	  case kNew_feature_list0:
		new_feature = false;
		break;
	  case kId		 :
		if (new_feature) {
		  fprintf(stdout, "Identifier: ");
		  WriteIdent(stdout, tree_node->Id.ident);
		  fprintf(stdout, " at Position:");
		  WritePosition(stdout, tree_node->Id.pos);
	  	  fprintf(stdout,"\n");
	   	}
		break;
	  case kFree_op		 :
		if (new_feature) {
		  fprintf(stdout, "Free Operator: ");
		  WriteIdent(stdout, tree_node->Free_op.ident);
		  fprintf(stdout, " at Position:");
		  WritePosition(stdout, tree_node->Free_op.pos);
	  	  fprintf(stdout,"\n");
	   	}
		break;
	  case kOper		 :
		if (new_feature) {
		  fprintf(stdout, "Operator: ");
		  fprintf(stdout, "%d",tree_node->Oper.op);
		  fprintf(stdout, " at Position:");
		  WritePosition(stdout, tree_node->Oper.pos);
	  	  fprintf(stdout,"\n");
	   	}
		break;
	}
} 




int main (argc, argv)
int argc;
char **argv;
{ 
	tTree tree;
	FILE *fp;
	
	/* Initialisation of memory to hold identifier, strings, ...	*/
	InitStringMemory();

	/* Where do we have to read from, file (argv[1]) or stdin?	*/
	switch (argc) {
	  case (1) :
		fp = stdin;
		break;
	  case (2) :
	  	if ((fp = fopen(argv[1], "r")) == NULL ) {
            	  fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
                  exit(1);
          	}
		break;
	  default  :
		fprintf(stderr,"Usage: gett [filename]\n");
		exit(1);
	}

	/* Read in the binary tree					*/
	tree = GetTree(fp);	

	fprintf(stdout, "New Features:\n");

	/* Traverse tree and apply find_new_features to every node	*/
	TraverseTreeTD(tree, find_New_features);

	return 0;
}
