/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** lltok.c
*/

# include "lclintMacros.nf"
# include "basic.h"
# include "cgrammar.h"
/*@ignore@*/
# include "cgrammar_tokens.h"
/*@end@*/

bool
lltok_isSemi (lltok tok)
{
  return (tok.tok == TSEMI);
}

cstring
lltok_unparse (lltok tok)
{
  char *lit;

  switch (tok.tok)
    {
    case BREAK:      lit = "break"; break;
    case CASE:       lit = "case"; break;
    case CONTINUE:   lit = "continue"; break;
    case DEFAULT:    lit = "default"; break;
    case DO:         lit = "do"; break;
    case CDOUBLE:    lit = "double"; break;
    case CELSE:      lit = "else"; break;
    case CFOR:       lit = "for"; break;
    case GOTO:       lit = "goto"; break;
    case CIF:        lit = "if"; break;
    case RETURN:     lit = "return"; break;
    case CSIZEOF:    lit = "sizeof"; break;
    case SWITCH:     lit = "switch"; break;
    case WHILE:      lit = "while"; break;
    case CSTRUCT:    lit = "struct"; break;
    case CTYPEDEF:   lit = "typedef"; break;
    case CUNION:     lit = "union"; break;
    case CENUM:      lit = "enum"; break;
    case QEXTERN:     lit = "extern"; break;
    case QAUTO:       lit = "auto"; break;
    case QSTATIC:     lit = "static"; break;
    case RIGHT_ASSIGN: lit = ">>="; break;
    case LEFT_ASSIGN:  lit = "<<="; break;
    case ADD_ASSIGN: lit = "+="; break;
    case SUB_ASSIGN: lit = "-="; break;
    case MUL_ASSIGN: lit = "*="; break;
    case DIV_ASSIGN: lit = "/="; break;
    case MOD_ASSIGN: lit = "%="; break;
    case AND_ASSIGN: lit = "&="; break;
    case XOR_ASSIGN: lit = "^="; break;
    case OR_ASSIGN:  lit = "|="; break;
    case RIGHT_OP:   lit = ">>"; break;
    case LEFT_OP:    lit = "<<"; break;
    case INC_OP:     lit = "++"; break; 
    case DEC_OP:     lit = "--"; break;
    case ARROW_OP:   lit = "->"; break;
    case AND_OP:     lit = "&&"; break;
    case OR_OP:      lit = "||"; break;
    case LE_OP:      lit = "<="; break;
    case GE_OP:      lit = ">="; break;
    case CTOK_EQOP:      lit = "=="; break;
    case NE_OP:      lit = "!="; break;
    case TSEMI:      lit = ";"; break;
    case TLBRACE:    lit = "{"; break;
    case TRBRACE:    lit = "}"; break;
    case TCOMMA:     lit = ","; break;
    case TCOLON:     lit = ":"; break;
    case TEQ:        lit = "="; break;
    case TLPAREN:    lit = "("; break;
    case TRPAREN:    lit = ")"; break;
    case TLSQBR:     lit = "["; break;
    case TRSQBR:     lit = "]"; break;
    case TDOT:       lit = "."; break;
    case TAMPERSAND: lit = "&"; break;
    case TEXCL:      lit = "!"; break;
    case TTILDE:     lit = "~"; break;
    case TMINUS:     lit = "-"; break;
    case TPLUS:      lit = "+"; break;
    case TMULT:      lit = "*"; break;
    case TDIV:       lit = "/"; break;
    case TPERCENT:   lit = "%"; break;
    case TLT:        lit = "<"; break;
    case TGT:        lit = ">"; break;
    case TCIRC:      lit = "^"; break;
    case TBAR:       lit = "|"; break;
    case TQUEST:     lit = "?"; break;  
    case QOUT:       lit = "out"; break;
    case QONLY:      lit = "only"; break;
    case QKEEP:      lit = "keep"; break;
    case QKEPT:      lit = "kept"; break;
    case QTEMP:      lit = "temp"; break;
    case QSHARED:    lit = "shared"; break;
    case QUNIQUE:    lit = "unique"; break;
    case QREF:       lit = "ref"; break;
    case QCHECKED:   lit = "checked"; break;
    case QCHECKEDSTRICT: lit = "checkedstrict"; break;
    case QCHECKMOD:  lit = "checkmod"; break;
    case QUNCHECKED: lit = "unchecked"; break;
    case QTRUENULL:  lit = "truenull"; break;
    case QFALSENULL: lit = "falsenull"; break;
    case QRETURNED:  lit = "returned"; break;
    case QEXPOSED:   lit = "exposed"; break;
    case QNULL:      lit = "null"; break;
    case QRELNULL:   lit = "refnull"; break;
    case QOBSERVER:  lit = "observer"; break;
    case QPARTIAL:   lit = "partial"; break;
    case QSPECIAL:   lit = "special"; break;
    case QUSES:      lit = "uses"; break;
    case QDEFINES:   lit = "defines"; break;
    case QALLOCATES: lit = "allocates"; break;
    case QSETS:      lit = "sets"; break;
    case QRELEASES:  lit = "releases"; break;
    BADDEFAULT;
    }
 
  return cstring_makeLiteralTemp (lit);
}

lltok
lltok_create (int tok, fileloc loc)
{
  lltok l;

  l.tok = tok;
  l.loc = loc;

  return (l);
}

void lltok_release (lltok t) 
{
  fileloc_free (t.loc);
}
