/*
**          Copyright (c) Massachusetts Institute of Technology 1994.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** aliasStack.c
**
** based on sRefSetStack
*/


# include "basic.h"

aliasStack
aliasStack_new ()
{
   aliasStack s = (aliasStack) dmalloc (sizeof (_aliasStack));
  
  s->elements = aliasTableNULL;
  s->thisbranch = aliasStackNULL;
  s->lastbranch = aliasStackNULL;
  s->parent = aliasStackNULL;
  s->lexlevel = fileScope;
  return (s);
}

aliasStack
aliasStack_branch (aliasStack s)
{
  aliasStack t = (aliasStack) dmalloc (sizeof (_aliasStack));
  
  dprintf (("branch"));
  t->elements = s->elements;
  t->thisbranch = aliasStackNULL;
  t->lastbranch = aliasStackNULL;
  t->parent = s;
  t->lexlevel = s->lexlevel + 1;

  s->thisbranch = t;

  return t;
}

aliasStack
aliasStack_trueBranch (aliasStack s)
{
  aliasStack t = (aliasStack) dmalloc (sizeof (_aliasStack));
  
  dprintf (("true branch"));

  t->elements = aliasTable_copy (s->elements);
  t->thisbranch = aliasStackNULL;
  t->lastbranch = aliasStackNULL;
  t->parent = s;
  t->lexlevel = s->lexlevel;

  s->thisbranch = t;
  return t;
}

aliasStack
aliasStack_altBranch (aliasStack s)
{
  aliasStack t = (aliasStack) dmalloc (sizeof (_aliasStack));
  aliasStack p = s->parent;

  dprintf (("alt branch"));

  llassert (p != aliasStackNULL);
  llassert (p->thisbranch == s);
  llassert (p->lastbranch == aliasStackNULL);

  t->elements = aliasTable_copy (p->elements);
  t->thisbranch = aliasStackNULL;
  t->lastbranch = aliasStackNULL;
  t->parent = p;
  t->lexlevel = p->lexlevel;

  p->lastbranch = s;
  p->thisbranch = t;

  return t;
}

aliasStack
aliasStack_pop (aliasStack s)
{
  aliasStack p = s->parent;

  dprintf (("pop branch"));

  llassert (p != aliasStackNULL);
  llassert (p->thisbranch == s);

  p->thisbranch = aliasStackNULL;
  
  if (p->lexlevel <= paramsScope) /* global or parameter scope */
    {
      p->elements = aliasTableNULL;
    }
  else
    {
      if (p->elements != s->elements)
	{
	  if (p->elements != aliasTableNULL)
	    {
	      aliasTable_free (p->elements);
	    }
	  
	  p->elements = s->elements;
	}

      aliasTable_levelPrune (p->elements, p->lexlevel);
    }

  aliasStack_free (s);  
  return p;
}

aliasStack
aliasStack_popBranches (aliasStack alt)
{
  aliasStack p = alt->parent;
  aliasStack this = p->lastbranch;

  llassert (p != aliasStackNULL);
  llassert (p->thisbranch == alt);
  llassert (this != aliasStackNULL);

  dprintf (("pop branches"));

  dprintf (("popBranches: %d %s %s\n",
	    p->lexlevel, aliasTable_unparse (this->elements), 
	    aliasTable_unparse (alt->elements)));

  /*
  ** was levelUnionFixParams
  */

  p->elements = aliasTable_levelUnion (this->elements, alt->elements, p->lexlevel);  

  p->thisbranch = aliasStackNULL;
  p->lastbranch = aliasStackNULL;

  aliasStack_free (this);
  aliasStack_free (alt);

  return p;
}

aliasStack
aliasStack_popTrueBranch (aliasStack s)
{
  aliasStack p = s->parent;

  llassert (p != aliasStackNULL);
  llassert (p->thisbranch == s);
  llassert (p->lastbranch == aliasStackNULL);

  dprintf (("pop true branch"));

  p->elements = aliasTable_levelUnion (p->elements, s->elements, p->lexlevel);

  if (p->elements == s->elements)
    {
      llbug (message ("aliasStack_popTrueBranch: p->elements == s->elements (%d)",
		    (long)s->elements));
    }
  else
    aliasStack_freeAll (s);

  return p;
}

/*
** el alias al, and everything al aliases
*/

void aliasStack_newAlias (aliasStack s, sRef el, sRef al)
{
  if (aliasTable_isNull (s->elements ))
    {
      s->elements = aliasTable_new ();
    }

  (void) aliasTable_insert (s->elements, el, al);
}

void aliasStack_clearAlias (aliasStack s, sRef el)
{
  (void) aliasTable_clear (s->elements, el);
}

sRefSet aliasStack_canAlias (aliasStack s, sRef sr)
{
  return (aliasTable_canAlias (s->elements, sr));
}

sRefSet aliasStack_aliasedBy (aliasStack s, sRef sr)
{
  return (aliasTable_aliasedBy (s->elements, sr));
}

cstring
aliasStack_unparse (aliasStack s)
{
   return (aliasTable_unparse (s->elements));
}

void
aliasStack_free (aliasStack s)
{
  free (s);
}

void
aliasStack_freeAll (aliasStack s)
{
  aliasTable_freeAll (s->elements); 
  free (s);
}

void
aliasStack_checkGlobs (aliasStack s)
{
  aliasTable_checkGlobs (s->elements);
}
