/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef VARDECLARATIONNODELIST_H
# define VARDECLARATIONNODELIST_H

typedef /*@only@*/ varDeclarationNode o_varDeclarationNode;

abst_typedef struct _varDeclarationNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_varDeclarationNode  *elements;
} *varDeclarationNodeList ;

/*@iter varDeclarationNodeList_elements (sef varDeclarationNodeList x, yield exposed varDeclarationNode el); @*/
# define varDeclarationNodeList_elements(x, m_el) \
   { int m_ind; varDeclarationNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { varDeclarationNode m_el = *(m_elements++); 

# define end_varDeclarationNodeList_elements }}

extern /*@only@*/ varDeclarationNodeList varDeclarationNodeList_new (void) /*@*/ ;
extern void 
  varDeclarationNodeList_addh (varDeclarationNodeList p_s, 
			       /*@keep@*/ varDeclarationNode p_el) 
  /*@modifies p_s@*/ ;

extern /*@only@*/ cstring varDeclarationNodeList_unparse (varDeclarationNodeList p_s)  /*@*/ ;
extern void varDeclarationNodeList_free (/*@only@*/ varDeclarationNodeList p_s) ;

/*@constant int varDeclarationNodeListBASESIZE;@*/
# define varDeclarationNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




