/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef TYPENAMENODELIST_H
# define TYPENAMENODELIST_H

typedef /*@only@*/ typeNameNode o_typeNameNode;

abst_typedef struct _typeNameNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_typeNameNode  *elements;
} *typeNameNodeList ;

/*@iter typeNameNodeList_elements (sef typeNameNodeList x, yield exposed typeNameNode el); @*/
# define typeNameNodeList_elements(x, m_el) \
   { int m_ind; typeNameNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { typeNameNode m_el = *(m_elements++);

# define end_typeNameNodeList_elements }}

extern int typeNameNodeList_size (typeNameNodeList);
# define typeNameNodeList_size(s) ((s)->nelements)   

extern bool typeNameNodeList_empty (typeNameNodeList);
# define typeNameNodeList_empty(s) (typeNameNodeList_size(s) == 0)

extern /*@only@*/ typeNameNodeList typeNameNodeList_new(void);

extern typeNameNodeList 
  typeNameNodeList_add (/*@returned@*/ typeNameNodeList p_s, /*@only@*/ typeNameNode p_el) ;

extern /*@only@*/ cstring typeNameNodeList_unparse (typeNameNodeList p_s) ;
extern void typeNameNodeList_free (/*@only@*/ typeNameNodeList p_s) ;

/*@constant int typeNameNodeListBASESIZE;@*/
# define typeNameNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




