/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef STOREREFNODELIST_H
# define STOREREFNODELIST_H

typedef /*@only@*/ storeRefNode o_storeRefNode;

abst_typedef struct _storeRefNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_storeRefNode  *elements;
} *storeRefNodeList ;

/*@iter storeRefNodeList_elements (sef storeRefNodeList x, yield exposed storeRefNode el); @*/
# define storeRefNodeList_elements(x, m_el) \
   { int m_ind; storeRefNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { storeRefNode m_el = *(m_elements++); 

# define end_storeRefNodeList_elements }}

extern /*@only@*/ storeRefNodeList storeRefNodeList_new(void);
extern storeRefNodeList 
  storeRefNodeList_add (/*@returned@*/ storeRefNodeList p_s, /*@only@*/ storeRefNode p_el);

extern /*@only@*/ cstring storeRefNodeList_unparse (storeRefNodeList p_s) ;
extern void storeRefNodeList_free (/*@only@*/ storeRefNodeList p_s) ;

extern /*@only@*/ storeRefNodeList storeRefNodeList_copy (storeRefNodeList p_s) ; 
/*@constant int storeRefNodeListBASESIZE;@*/
# define storeRefNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




