/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef STRUCTDECLNODELIST_H
# define STRUCTDECLNODELIST_H

typedef /*@only@*/ stDeclNode o_stDeclNode;

abst_typedef struct _stDeclNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_stDeclNode  *elements;
} *stDeclNodeList ;

/*@iter stDeclNodeList_elements (sef stDeclNodeList x, yield exposed stDeclNode el); @*/
# define stDeclNodeList_elements(x, m_el) \
   { int m_ind; stDeclNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { stDeclNode m_el = *(m_elements++);

# define end_stDeclNodeList_elements }}

extern int stDeclNodeList_size (stDeclNodeList);

# define stDeclNodeList_size(s) ((s)->nelements)   

extern /*@only@*/ stDeclNodeList stDeclNodeList_new(void);
extern stDeclNodeList 
  stDeclNodeList_add (/*@returned@*/ stDeclNodeList p_s, /*@only@*/ stDeclNode p_el);

extern /*@only@*/ cstring stDeclNodeList_unparse (stDeclNodeList p_s) ;
extern void stDeclNodeList_free (/*@only@*/ stDeclNodeList p_s) ;

extern /*@only@*/ stDeclNodeList stDeclNodeList_copy (stDeclNodeList p_s) ; 

/*@constant int stDeclNodeListBASESIZE;@*/
# define stDeclNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




