/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** source.h
*/

# ifndef TSOURCE_H
# define TSOURCE_H

/*@constant int STUBMAXRECORDSIZE; @*/
# define STUBMAXRECORDSIZE 800

typedef struct {
    char	*name;
    /*@dependent@*/ /*@null@*/ FILE *file;
    char	 buffer[STUBMAXRECORDSIZE+1];
    unsigned int lineNo;
    bool	 echo, fromString;
    /*@owned@*/ /*@null@*/ char *stringSource;
    /*@null@*/ /*@dependent@*/ char *stringSourceTail;
} tsource; /* renamed from "source" to avoid cc parse bug on lex.yy.c */

extern void tsource_free (/*@null@*/ /*@only@*/ tsource *p_s);
extern bool tsource_close (/*@only@*/ tsource *p_s) 
   /*@modifies *p_s, fileSystem@*/ ; 
extern tsource *
  tsource_create (/*@temp@*/ char *p_name, char *p_suffix, bool p_echo) /*@*/ ;
extern tsource *tsource_fromString (char *p_name, char *p_str) /*@*/ ;
extern /*@dependent@*/ /*@null@*/ char *tsource_nextLine(tsource *p_s) 
   /*@modifies *p_s@*/ ;
extern bool tsource_open (tsource *p_s) /*@modifies p_s, fileSystem@*/ ;
extern bool tsource_getPath (char *p_path, tsource *p_s, ltoken p_t)
   /*@modifies *p_s@*/ ;

extern /*@observer@*/ char *tsource_fileName (tsource *p_s) /*@*/ ;
# define tsource_fileName(pS) ((pS)->name)

extern bool tsource_isOpen (/*@sef@*/ tsource *p_s) /*@*/ ;
# define tsource_isOpen(pS)  ((pS)->file != 0 || (pS)->fromString)

extern unsigned int tsource_thisLineNumber(tsource *p_s) /*@*/ ;
# define tsource_thisLineNumber(pS)	((pS)->lineNo)

extern char *specFullName (char *p_specfile, /*@out@*/ char **p_inpath) 
   /*@modifies *p_inpath@*/ ;

# else
# error "Multiple include"
# endif





