/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef SORTLIST_H
# define SORTLIST_H

abst_typedef struct _sortList
{
  int nelements;
  int nspace;
  int current;
  /*@reldef@*/ /*@relnull@*/ sort  *elements;
} *sortList ;

extern /*@only@*/ sortList sortList_new (void);
extern void sortList_addh (sortList p_s, sort p_el) ;

extern void sortList_reset (sortList p_s) ;   
extern void sortList_advance (sortList p_s) ; /* was "list_pointToNext" */

extern /*@only@*/ cstring sortList_unparse (sortList p_s) ;
extern void sortList_free (/*@only@*/ sortList p_s) ;

extern sort sortList_current (sortList p_s) ;

/*@constant int sortListBASESIZE;@*/
# define sortListBASESIZE SMALLBASESIZE
# else
# error "Multiple include"
# endif




