/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** scanline.h
*/

# ifndef SCANLINE_H
# define SCANLINE_H

/*@constant int LASTCHAR; @*/
# define LASTCHAR 255

/*@constant char CHAREXTENDER; @*/
# define CHAREXTENDER '\\'

typedef enum {
    CHC_NULL,
    IDCHAR,
    OPCHAR,
    SLASHCHAR,
    WHITECHAR,
    CHC_EXTENSION,
    SINGLECHAR,
    PERMCHAR
} charCode;

typedef struct {
  charCode code;
  bool endCommentChar;
} charClassData;

extern void lscanLine (char *);
extern ltoken LSLScanEofToken (void);
extern void LSLReportEolTokens (bool p_setting);

extern void lscanLineInit (void);
extern void lscanLineReset (void);
extern void lscanLineCleanup (void);

/* 
** The following function prototypes are for use by lslinit.c, which
** customizes subsequent actions of scanline.c.
*/

extern charCode lscanCharClass (char p_c);
# define lscanCharClass(c) \
  (charClass[(int)(c)].code)

extern bool LSLIsEndComment (char p_c);
# define LSLIsEndComment(c) \
  (charClass[(int)(c)].endCommentChar)

extern void lsetCharClass (char p_c, charCode p_cod);
# define lsetCharClass(c, cod) \
  (charClass[(int)(c)].code = (cod))

extern void lsetEndCommentChar (char p_c, bool p_flag);
# define lsetEndCommentChar(c, flag) \
  (charClass[(int)(c)].endCommentChar = (flag))

extern charClassData charClass[LASTCHAR + 1];

# else
# error "Multiple include"
# endif
