/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef replaceNodeLIST_H
# define replaceNodeLIST_H

typedef /*@only@*/ replaceNode o_replaceNode;

abst_typedef struct _replaceNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_replaceNode  *elements;
} *replaceNodeList ;

/*@iter replaceNodeList_elements (sef replaceNodeList x, yield exposed replaceNode el); @*/
# define replaceNodeList_elements(x, m_el) \
   { int m_ind; replaceNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { replaceNode m_el = *(m_elements++); 

# define end_replaceNodeList_elements }}

extern int replaceNodeList_size (replaceNodeList);

# define replaceNodeList_size(s)  ((s)->nelements)   

extern bool replaceNodeList_isDefined (replaceNodeList);
# define replaceNodeList_isDefined(s) ((s) != (replaceNodeList)0)

extern /*@only@*/ replaceNodeList replaceNodeList_new(void);

extern replaceNodeList 
  replaceNodeList_add (/*@returned@*/ replaceNodeList p_s, /*@only@*/ replaceNode p_el) ;

extern /*@only@*/ cstring replaceNodeList_unparse (replaceNodeList p_s) ;
extern void replaceNodeList_free (/*@only@*/ replaceNodeList p_s) ;

/*@constant int replaceNodeListBASESIZE;@*/
# define replaceNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




