/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef QUANTIFIERNODELIST_H
# define QUANTIFIERNODELIST_H

typedef /*@only@*/ quantifierNode o_quantifierNode;

abst_typedef struct _quantifierNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_quantifierNode  *elements;
} *quantifierNodeList ;

/*@iter quantifierNodeList_elements (sef quantifierNodeList x, yield exposed quantifierNode el); @*/
# define quantifierNodeList_elements(x, m_el) \
   { int m_ind; quantifierNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { quantifierNode m_el = *(m_elements++); 

# define end_quantifierNodeList_elements }}

extern /*@only@*/ quantifierNodeList quantifierNodeList_new(void);

extern quantifierNodeList 
  quantifierNodeList_add (/*@returned@*/ quantifierNodeList p_s, /*@only@*/ quantifierNode p_el);

extern /*@only@*/ cstring quantifierNodeList_unparse (quantifierNodeList p_s) ;
extern /*@unused@*/ void quantifierNodeList_free (/*@only@*/ quantifierNodeList p_s) ;

extern /*@only@*/ quantifierNodeList quantifierNodeList_copy (quantifierNodeList p_s) ; 

/*@constant int quantifierNodeListBASESIZE;@*/
# define quantifierNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




