/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** osd.h
*/

# ifndef OSD_H
# define OSD_H

/* Macro to substitute for ## because VAX C currently doesn't allow it. */
# ifdef __STDC__
    /* Use an intermediate paste macro so PASTE macro arguments will get    */
    /* evaluated.  Therefore, PASTE(PASTE(a,b),c) will work. */
/*@notfunction@*/
# define IPASTE(L,R)	    L ## R
/*@notfunction@*/
# define PASTE(L,R)         IPASTE(L,R)
# else
/*@notfunction@*/
# define PASTE(L,R )	    L/**/R
# endif

/* Macro to substitute for # because VAX C currently doesn't allow it. */
# ifdef __STDC__
/*@notfunction@*/
#  define ISTR(x)	# x
/*@notfunction@*/
#  define STR(x)         ISTR(x)
# else
/*@notfunction@*/
#  define ISTR(x)	"x"
/*@notfunction@*/
#  define STR(x)		ISTR(x)
# endif

/*
** MAXPATHLEN defines the longest permissable path length.
** Is defined in <sys/param.h> in MIPS/Ultrix, but it not defined on the VAX.
** Define here so available on both systems.
*/

/*@constant int MAXPATHLEN; @*/
# define MAXPATHLEN      1024

# if defined(VMS)
#  define SUCCESS 1
#  define FAILURE 0
# else
#  define SUCCESS 0
#  define FAILURE 1
# endif

# define OSD_H

/*
**
**  TYPEDEFS
**
*/

typedef enum {
  OSD_FILEFOUND,
  OSD_FILENOTFOUND,
  OSD_PATHTOOLONG } filestatus;


/*
**
**  FUNCTION PROTOTYPES
**
*/

extern /*@observer@*/ char *getLarchPath (void) /*@globals internalState;@*/ ;
extern /*@only@*/ char *LSLRootName (char *p_filespec) /*@*/ ;
extern filestatus   
  osd_getPath (char *p_path, char *p_file, /*@out@*/ char **p_returnPath)
  /*@modifies *p_returnPath@*/ ;

extern filestatus   
  osd_getExePath (char *p_path, char *p_file, /*@out@*/ char **p_returnPath)
  /*@modifies *p_returnPath@*/ ;

extern bool unixFileExists (char *p_filespec) /*@*/ ;
extern /*@observer@*/ char *
  osd_getEnvironment (char *p_env, /*@returned@*/ char *p_def) /*@*/ ;

extern filestatus osd_getLarchPath (char *p_file, /*@out@*/ char **p_returnPath) 
  /*@modifies *p_returnPath@*/ ;

extern /*@observer@*/ /*@null@*/ char *osd_getHomeDir (void) /*@*/ ;

# else
# error "Multiple include"
# endif



