/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef LSYMBOL_H
# define LSYMBOL_H

/*
** Offset entries by 1, so 0 is available.
*/

/*@constant null lsymbol lsymbol_undefined; @*/
# define lsymbol_undefined ((lsymbol) 0)

extern bool lsymbol_isDefined (lsymbol p_s);
# define lsymbol_isDefined(s) ((s) != lsymbol_undefined)

extern bool lsymbol_isUndefined (lsymbol p_s);
# define lsymbol_isUndefined(s) ((s) == lsymbol_undefined)

extern lsymbol lsymbol_fromChars (/*@temp@*/ char *) /*@*/ ;
extern lsymbol lsymbol_fromString (/*@temp@*/ cstring p_s) /*@*/ ;
extern /*@exposed@*/ /*@null@*/ char *lsymbol_toChars (lsymbol) /*@*/ ;
extern /*@exposed@*/ char *lsymbol_toCharsSafe (lsymbol) /*@*/ ;
extern /*@observer@*/ cstring lsymbol_toString(lsymbol) /*@*/ ;

extern bool lsymbol_equal (lsymbol p_s1, lsymbol p_s2) /*@*/ ;
# define lsymbol_equal(s1, s2) ((s1) == (s2))

extern /*@unused@*/ void lsymbol_printStats (void);

extern void lsymbol_initMod (void) /*@modifies internalState@*/ ;
extern void lsymbol_destroyMod (void) /*@modifies internalState@*/ ;

# else
# error "Multiple include"
# endif
