/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef LETDECLNODELIST_H
# define LETDECLNODELIST_H

typedef /*@only@*/ letDeclNode o_letDeclNode;

abst_typedef struct _letDeclNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_letDeclNode  *elements;
} *letDeclNodeList ;

/*@iter letDeclNodeList_elements (sef letDeclNodeList x, yield exposed letDeclNode el); @*/
# define letDeclNodeList_elements(x, m_el) \
   { int m_ind; letDeclNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { letDeclNode m_el = *(m_elements++); 

# define end_letDeclNodeList_elements }}

extern /*@only@*/ letDeclNodeList letDeclNodeList_new(void);
extern letDeclNodeList 
  letDeclNodeList_add (/*@returned@*/ letDeclNodeList p_s, /*@only@*/ letDeclNode p_el);

extern /*@only@*/ cstring letDeclNodeList_unparse (letDeclNodeList p_s) ;
extern void letDeclNodeList_free (/*@only@*/ letDeclNodeList p_s) ;

/*@constant int letDeclNodeListBASESIZE;@*/
# define letDeclNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




