/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

typedef enum 
{
  LTS_TYPE, LTS_STRUCTUNION,
  LTS_ENUM, LTS_CONJ
} lclTypeSpecKind;

typedef lclTypeSpecNode lcltsp;

typedef struct _lclconj
{
  lcltsp a;
  lcltsp b;
} *lclconj;

struct _lclTypeSpecNode {
  lclTypeSpecKind kind;
  qualList quals;
  union {
    /*@null@*/ CTypesNode type;
    /*@null@*/ strOrUnionNode structorunion;
    /*@null@*/ enumSpecNode enumspec;
    lclconj conj;
  } content;
  int pointers;
} ;

/*@constant null lclTypeSpecNode lclTypeSpecNode_undefined; @*/
# define lclTypeSpecNode_undefined ((lclTypeSpecNode) 0)

extern /*@falsenull@*/ bool lclTypeSpecNode_isDefined (lclTypeSpecNode p_x) /*@*/ ;
# define lclTypeSpecNode_isDefined(x) ((x) != lclTypeSpecNode_undefined)

extern /*@null@*/ /*@only@*/ lclTypeSpecNode
  lclTypeSpecNode_copy (/*@null@*/ lclTypeSpecNode p_n) /*@*/ ;

extern /*@only@*/ cstring 
  lclTypeSpecNode_unparse (/*@null@*/ lclTypeSpecNode p_n) /*@*/ ;

extern /*@only@*/ cstring 
  lclTypeSpecNode_unparseComments (/*@null@*/ lclTypeSpecNode p_typespec) /*@*/ ;






