/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef INITDECLNODELIST_H
# define INITDECLNODELIST_H

typedef /*@only@*/ initDeclNode o_initDeclNode;

abst_typedef struct _initDeclNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_initDeclNode  *elements;
} *initDeclNodeList ;

/*@iter initDeclNodeList_elements (sef initDeclNodeList x, yield exposed initDeclNode el); @*/
# define initDeclNodeList_elements(x, m_el) \
   { int m_ind; initDeclNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	 { initDeclNode m_el = *(m_elements++); 

# define end_initDeclNodeList_elements }}

extern /*@only@*/ initDeclNodeList initDeclNodeList_new(void);
extern initDeclNodeList 
  initDeclNodeList_add (/*@returned@*/ initDeclNodeList p_s, 
			/*@only@*/ initDeclNode p_el) ;

extern /*@only@*/ cstring initDeclNodeList_unparse (initDeclNodeList p_s) ;
extern void initDeclNodeList_free (/*@only@*/ initDeclNodeList p_s) ;

/*@constant int initDeclNodeListBASESIZE;@*/
# define initDeclNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




