/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef GLOBALS_H
# define GLOBALS_H

extern /*@owned@*/ fileloc currentloc;
extern /*@only@*/ cstring localIncludePath;
extern /*@only@*/ cstring includePath;
extern /*@observer@*/ char *localSpecPath;
extern /*@only@*/ cstring currentSpec;
extern /*@null@*/ /*@only@*/ char *currentSpecName;

/*@-redecl@*/
/*@-incondefs@*/ 
extern /*@dependent@*/ FILE *yyin;
/*@=incondefs@*/ 

extern int yydebug;
/*@=redecl@*/

extern /*@observer@*/ cstring codeFile;
extern int codeLine;

extern /*@observer@*/ cstring prevCodeFile;
extern int prevCodeLine;

extern void setCodePoint (void);
# define setCodePoint() \
  (prevCodeFile = codeFile, prevCodeLine = codeLine, \
   codeFile = cstring_makeLiteralTemp (__FILE__), codeLine = __LINE__)

extern void printCodePoint (void);

extern fileId currentFile (void) /*@globals currentloc; @*/ ;
# define currentFile()               (fileloc_fileId (currentloc))

extern int currentColumn (void) /*@globals currentloc; @*/ ;
# define currentColumn()             (fileloc_column(currentloc))

extern void incColumn (void) 
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc@*/ ;
# define incColumn()                  (fileloc_incColumn(currentloc)) 

extern void decColumn (void)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc@*/ ;
# define decColumn()                  (fileloc_addColumn(currentloc, -1))

extern void incLine (void)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define incLine()                    (fileloc_nextLine(currentloc))

extern void decLine (void)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define decLine()                    (fileloc_addLine (currentloc, -1))

extern void beginLine (void)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define beginLine()                  (fileloc_setColumn(currentloc, 1))

extern void addColumn (int p_n)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define addColumn(n)                 (fileloc_addColumn(currentloc, n))

extern void setLine (int p_n)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define setLine(n)                   (fileloc_setLineno(currentloc, n))

extern void setSpecFileId (fileId p_s)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define setSpecFileId(s) \
  (fileloc_reallyFree (currentloc), currentloc = fileloc_createSpec (s, 1, 1))

extern void setFileLine (fileId p_s, int p_line)
   /*@globals fileloc currentloc; @*/ 
   /*@modifies currentloc; @*/ ;
# define setFileLine(s, line) \
  (context_setFilename(s, line))

# else
# error "Multiple include"
# endif






