/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** filestack.h
*/

# ifndef FILESTACK_H
# define FILESTACK_H

typedef struct _fentry
{
  /*@null@*/ /*@dependent@*/ FILE  *fin;
  /*@null@*/ /*@dependent@*/ FILE  *fout;
  /*@null@*/ /*@dependent@*/ FILE  *fdef;
  fileId curfile;
  int curline;
} *fentry;

typedef /*@only@*/ fentry o_fentry;

abst_typedef struct __fileStack
{
  int       nentries;
  int       nfree;
  int       oentries;
  int       ofree;
  /*@reldef@*/ /*@only@*/ o_fentry *entries;
  /*@reldef@*/ /*@only@*/ fileId   *oldentries;
} *fileStack;

/*@constant int FILESTACKBASESIZE; @*/
# define FILESTACKBASESIZE 16

extern /*@only@*/ fileStack fileStack_create (void) /*@*/ ;
extern void fileStack_push (fileStack p_f, /*@null@*/ /*@dependent@*/ FILE *p_in, 
			    /*@null@*/ /*@dependent@*/  FILE *p_out, 
			    fileId p_curf, int p_curline,
			    /*@null@*/ /*@dependent@*/ FILE *p_def);

typedef /*@dependent@*/ FILE *dFILE;

extern fileId fileStack_pop (fileStack p_f, 
			     /*@out@*/ dFILE *p_in, /*@out@*/ dFILE *p_out,
			     /*@out@*/ dFILE *p_def)
   /*@modifies p_f, *p_in, *p_out, *p_def; @*/ ; 

extern /*@unused@*/ void fileStack_print (fileStack p_f);
extern void fileStack_annihilate (/*@only@*/ fileStack p_f);
extern bool fileStack_contains (fileStack p_f, fileId p_fn);
extern void fileStack_pushOld (fileStack p_f, fileId p_curf);

# else
# error "Multiple include"
# endif










