/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** fileId.h
*/

# ifndef fileId_H
# define fileId_H

immut_typedef int fileId;

/*@constant fileId fileId_invalid; @*/
# define fileId_invalid -1

extern bool fileId_isValid (fileId) /*@*/ ;
# define fileId_isValid(f) ((f) > fileId_invalid)

extern bool fileId_isInvalid (fileId) /*@*/ ;
# define fileId_isInvalid(f) ((f) == fileId_invalid)

extern bool fileId_equal (fileId p_t1, fileId p_t2) /*@*/ ;
# define fileId_equal(t1,t2) ((t1) == (t2))

extern bool fileId_baseEqual (/*@sef@*/ fileId p_t1, /*@sef@*/ fileId p_t2) /*@*/ ;
# define fileId_baseEqual(t1,t2) \
  (fileId_equal (t1, t2) || fileTable_sameBase (context_fileTable (), t1, t2))

extern /*@unused@*/ int 
  fileId_compare (/*@sef@*/ fileId p_t1, /*@sef@*/ fileId p_t2) /*@*/ ;
# define fileId_compare(t1,t2) (int_compare (t1, t2))

extern int fileId_toInt (fileId p_f) /*@*/ ;
# define fileId_toInt(f) ((int) (f))

extern fileId fileId_fromInt (int p_i) /*@*/ ;
# define fileId_fromInt(i) ((fileId) (i))

# else
# error "Multiple include"
# endif
