/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef FCNNODELIST_H
# define FCNNODELIST_H

typedef /*@only@*/ fcnNode o_fcnNode;

abst_typedef /*@null@*/ struct _fcnNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_fcnNode  *elements;
} *fcnNodeList;

/*@iter fcnNodeList_elements (sef fcnNodeList x, yield exposed fcnNode el); @*/
# define fcnNodeList_elements(x, m_el) \
   if (fcnNodeList_isDefined (x)) \
     { int m_ind; fcnNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	  { fcnNode m_el = *(m_elements++); 

# define end_fcnNodeList_elements }}

/*@constant null fcnNodeList fcnNodeList_undefined; @*/
# define fcnNodeList_undefined ((fcnNodeList)0)

extern /*@falsenull@*/ bool fcnNodeList_isDefined (fcnNodeList p_f);
# define fcnNodeList_isDefined(f) ((f) != fcnNodeList_undefined)

extern /*@unused@*/ /*@truenull@*/ bool 
  fcnNodeList_isUndefined (fcnNodeList p_f);
# define fcnNodeList_isUndefined(f) ((f) == fcnNodeList_undefined)

extern int fcnNodeList_size (/*@sef@*/ fcnNodeList p_f);
extern bool fcnNodeList_isEmpty (/*@sef@*/ fcnNodeList p_f);

# define fcnNodeList_size(s)  (fcnNodeList_isDefined(s) ? (s)->nelements : 0)
# define fcnNodeList_isEmpty(s) (fcnNodeList_size(s) == 0)

extern /*@only@*/ fcnNodeList fcnNodeList_new(void);
extern fcnNodeList fcnNodeList_add (/*@returned@*/ fcnNodeList p_s, /*@keep@*/ fcnNode p_el) ;


extern /*@unused@*/ /*@only@*/ cstring fcnNodeList_unparse (fcnNodeList p_s) ;
extern void fcnNodeList_free (/*@null@*/ /*@only@*/ fcnNodeList p_s) ;

/*@constant int fcnNodeListBASESIZE;@*/
# define fcnNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




