/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef ctypeLIST_H
# define ctypeLIST_H

/*
** there is a special ctypeList used to represent the () argument list
** this has nelements = -1
**
** (that is, not void, so any number of arguments is okay.)
*/

abst_typedef /*@null@*/ struct _ctypeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ ctype  *elements;
} *ctypeList ;

extern int ctypeList_size (/*@sef@*/ ctypeList p_s) /*@*/ ;
# define ctypeList_size(s)  (ctypeList_isDefined(s) ? (s)->nelements : 0)   

extern /*@only@*/ ctypeList ctypeList_new(void);
extern void ctypeList_addh (ctypeList p_s, ctype p_el) /*@modifies p_s@*/;

extern /*@unused@*/ /*@only@*/ cstring ctypeList_unparse (ctypeList) /*@*/ ;
extern void ctypeList_free (/*@only@*/ /*@only@*/ ctypeList p_s) /*@modifies p_s@*/;

extern /*@falsenull@*/ bool ctypeList_isDefined (/*@null@*/ ctypeList p_ct) /*@*/ ;
extern /*@unused@*/ /*@truenull@*/ bool 
  ctypeList_isUndefined (/*@null@*/ ctypeList p_ct) /*@*/ ;

/*@constant null ctypeList ctypeList_undefined; @*/
# define ctypeList_undefined       ((ctypeList) NULL)

# define ctypeList_isDefined(ct)   ((ct) != ctypeList_undefined)
# define ctypeList_isUndefined(ct) ((ct) == ctypeList_undefined)

/*@constant int ctypeListBASESIZE;@*/
# define ctypeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




