#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include "bb_threads.h"


#define FALSE 0
#define TRUE 1

void fnn(void *data, size_t len)
{
  signal(SIGHUP, SIG_IGN);
  sleep (30);
}



int main(void)
{
  int holdit;
  pid_t parentid, childid;

  parentid = getpid();
  
  srandom(0);
  holdit = 1;

  bb_threads_stacksize(65536);
  bb_threads_shared_sighandlers(FALSE);
  bb_threads_mutexcreate(0);

  bb_threads_lock(0);
  printf("Spawned thread pid= %d\n", childid = bb_threads_newthread(fnn, NULL));
  printf("If, in the next thirty seconds, you issue a 'kill -HUP %d' it will\n", childid);
  printf("go to the child, and be ignored. If you issue a 'kill -HUP %d' it will\n", parentid);
  printf("go to the parent and kill it. The child will become an orphan process\n");
  printf("under the control of init(8), and will disappear at the end of the\n");
  printf("time interval.\n");
  bb_threads_unlock(0);

  while (holdit) {
    childid = bb_threads_cleanup(wait(NULL));
    bb_threads_lock(0);
    printf("thread %d returned.\n", childid);
    bb_threads_unlock(0);
    holdit--;
  }

  fflush(stdout);
  return 0;
}
