#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "bb_threads.h"


static float junk;
static int holdit;


void fnn(void *data, size_t len)
{
  int i;
  float mystuff;
  float rannum;

  for (i = 0; i < 50000; i++) {

    bb_threads_lock(0);
    
    rannum = (random() / (float) RAND_MAX) - 0.5;

    junk += rannum;
    
    bb_threads_unlock(0);

/*    usleep(200);  */

    mystuff += rannum;
  }

  bb_threads_lock(1);

  printf("Process %d accumulated : %f\n", getpid(), mystuff);
  fflush(stdout);
  

  bb_threads_unlock(1);

}



int main(void)
{
  pid_t retthrd;
  
  srandom(0);
  junk = 0.0;
  holdit = 4;

  bb_threads_stacksize(65536);
  bb_threads_shared_sighandlers(0);
  bb_threads_mutexcreate(0);
  bb_threads_mutexcreate(1);

  bb_threads_lock(1);
  printf("Spawned thread pid= %d\n", bb_threads_newthread(fnn, NULL));
  printf("Spawned thread pid= %d\n", bb_threads_newthread(fnn, NULL));
  printf("Spawned thread pid= %d\n", bb_threads_newthread(fnn, NULL));
  printf("Spawned thread pid= %d\n", bb_threads_newthread(fnn, NULL));
  bb_threads_unlock(1);

  while (holdit) {
    retthrd = bb_threads_cleanup(wait(NULL));
    bb_threads_lock(1);
    printf("thread %d returned.\n", retthrd);
    bb_threads_unlock(1);
    holdit--;
  }

  printf("Grand total= %f\n", junk);
  fflush(stdout);
  return 0;
}
