REM t2r v2.02 - Convert LaTeX to rtf format
REM Cast by Mario Stipcevic, Rudjer Boskovic Institute, Zagreb, Croatia
REM E-mail: stipcevi@rudjer.irb.hr URL: http://faust.irb.hr/~stipy
REM This is a QB2C code. Translate it with: qb2c -C -b, or compile with bcc
REM For more info about QB2C look at: http://faust.irb.hr/~stipy/qb2c/qb2c.html
REM Equations work only inline, not completely good
REM Tables and figures work only rudimentary.
REM Referencing to Equations, Tables and Figures implemented eg. \ref{label}.
DECLARE SUB argument(h$, arg$, k%, star%)
CM  char *pc;
CONST TMAX =  10: REM Max dimension of tmp$() in tokenix
CONST FLMX = 100: REM Max number of each floating environment: fig, table...
DIM Table$(FLMX, 1,|80): REM Table of tables references (0=number, 1=key)
DIM Figure$(FLMX, 3,|256): REM Table of figures references (0=num, 1=key, 2=file,3=caption)
DIM Equation$(FLMX, 1,|80): REM Table of equations references (0=number, 1=key)
DIM tmp$(TMAX): REM Used in tokenix

    Version$ = "2.02 13.May 1999"
    ime$="": REM Input file name
    Lang$ = "CRO"

    c$ = command$
    COLOR

   if n_arg% = 0 then
C   helpm();
   endif
   if argv$(1) = "-?" OR argv$(1) = "-h" then
C   helpm();
   endif

   z% = 0: REM Start of names
   for i% = 1 to n_arg%
     if argv$(i%) = "-lang" then i%=i%+1: Lang$ = argv$(i%): goto 19
     if argv$(i%) = "-se" then seqfl% = 1: goto 19
     if argv$(i%) = "-st" then stblfl% = 1: goto 19
     if argv$(i%) = "-sf" then sfigfl% = 1: goto 19
     if argv$(i%) = "-rm" then rmfl% = 1: goto 19
     if argv$(i%) = "-v" then: eprint "t2r Version: "; Version$: end
     if left$(argv$(i%),1)="-" then eprint "Unknown option, exiting: "; argv$(i%): end
     if z% = 0 then z% = i%
rem  ime$ = argv$(i%)
19 next

   IF z% = 0 THEN
    eprint "No names given !!": end(1)
   END IF
REM Loop over files:
   FOR jj% = z% TO n_arg%

    ime$ = argv$(jj%)

REM Global for one file:
    d$="": arg$="": star% = 0: REM various temporary
    Pass% = 1: REM First pass flag - to resolve references
    PassMax% = 2: REM Max number of passes
    Tablefl% = 0: REM Set when in "table" environment
REM Global counters:
    ntabl% = 0: itabl% = 0
    nfigu% = 0: ifigu% = 0
    nequat%= 0: iequat%= 0

    IF ime$ = "" THEN
     PRINT "Missing file name."
     CALL helpm
    END IF
    bime$ = ime$
    IF len(ime$) > 4 THEN
     IF right$(ime$, 4) = ".tex" THEN
      bime$ = left$(ime$, len(ime$)-4)
     END IF
    END IF
    infile$ = bime$ + ".tex"
    outfile$= bime$ + ".rtf"

    IF Lang$ = "CRO" THEN
REM  Croatian:
     Chap$ = "Poglavlje "
     lang$ = "\lang1050": REM Appendix to font name (font language?)
    ELSE
REM  English:
     Chap$ = "Chapter "
     lang$ = ""
    END IF

    DO WHILE Pass% <= PassMax%

REM Counters:
    Chap% = 0
    Sect% = 0
    SubSect% = 0
    SubSubSect% = 0
    Equat% = 0
    Eqnarr% = 0
    Fig% = 0
    Table% = 0
    
    Tim$  = "\f53\fs"
    TimI$ = "\i\f53\fs"
    TimB$ = "\b\f53\fs"
    TimBI$= "\b\i\f53\fs"
    TimU$= ""
    ttfn$= ""
    Sym$ = "\f1\fs"

REM Flags:
    newpfl% = 0: REM Set if not a first page in the document
    seqfl% = 0: stblfl% = 0: sfigfl% = 0: REM strip flags
    mathfl% = 0: REM Set if in line math mode
    eqfl% = 0:   REM Set if in equation, eqnarray math mode
    eqnfl% = 0:  REM Set if in equation, eqnarray math mode
    figfl% = 0:  REM Set if in figure
    rmfl% = 0:   REM Set if math in roman mode
    verbatfl%=0: REM Set in verbatim mode
    verbfl%=0:   REM Set if in \verb mode
CH  static char verbc='\0'; /* verbc reserved for \verb character */

REM Current font values:
    Curfnf$ = Tim$                       :REM Font family
    Cursiz$ = "24"                       :REM Size (2 x pt)
    Curfnt$ = Tim$ + "24" + lang$        :REM Complete normal font name
    Symfnt$ = "{" + Sym$ + "24" + lang$  :REM Complete math font name

    IF Pass% = 2 then
     ntabl% = itabl%
     nfigu% = ifigu%
     nequat% = iequat%
     IF ntabl% OR nfigu% OR nequat% THEN
      ? "         "; "number", "file", "key"
      for i% = 1 to nfigu%
       ? "Figure   "; Figure$(i%, 0), Figure$(i%, 2), Figure$(i%, 1)
      next
      for i% = 1 to ntabl%
       ? "Table    "; Table$(i%, 0), Table$(i%, 2), Table$(i%, 1)
      next
      for i% = 1 to nequat%
       ? "Equation "; Equation$(i%, 0), Equation$(i%, 2), Equation$(i%, 1)
      next
      ? "Rerunning to get cross-references right..."
     ELSE
      GOTO 10000
C     exit(0);
     END IF
    END IF

    OPEN infile$ FOR INPUT as #1
    OPEN outfile$ FOR OUTPUT as #2
    PRINT "Translating ";infile$;" --> ";outfile$
    LINE INPUT #1, line$: CALL gulix(line$): line$ = line$ + " "
    DO WHILE NOT eof(1) AND line$ <> "\begin{document} "
     LINE INPUT #1, line$: CALL gulix(line$): line$ = line$ + " "
    LOOP
    IF eof(1) THEN
     ? "Error: can't find line \begin{document}..."
C    exit(-1);
    ELSE
REM  Preamble to rft file:
     CALL RTFpreamble
     PRINT #2, Curfnt$
    END IF
    DO WHILE NOT eof(1)
     LINE INPUT #1, line$: CALL gulix(line$): line$ = line$ + " "
C    if (line_S[0] == '%') goto Lab_9999;
     IF line$="\ " THEN PRINT #2, "\par ": GOTO 9999
     IF line$="\\ " THEN PRINT #2, "\par \par": GOTO 9999
C    if (line_S[0] == '\\') {
      IF left$(line$,8) = "\chapter" THEN
       REM Reset various per/chapter counters
       Equat% = 0
       Eqnarr% = 0
       Table% = 0
       Fig% = 0
       n% = 0
       CALL argument(line$, prt$, n%, star%)
       CALL slovix(prt$)
       if star% then
        Num$ = ""
       else
        Chap% = Chap% + 1
        Num$ = mid$(str$(Chap%),2)
       endif
       if newpfl% then PRINT #2, "\par \page": REM newpage to start a chapter
       if not newpfl% then newpfl% = 1
       PRINT #2, "\par \par \par \par \par \par \par \par"
       PRINT #2, "{" + TimB$ + "48" + lang$ + " " + Chap$ + " " + Num$
       PRINT #2, "\par \par " + prt$ + "}"
       PRINT #2, "\par \par \par \par"
       GOTO 9999
      END IF
      IF left$(line$,8) = "\section" THEN
       n% = 0
       CALL argument(line$, prt$, n%, star%)
       CALL slovix(prt$)
       if star% then
        Num$ = ""
       else
        chapn$ = mid$(str$(Chap%),2) + "."
        if Chap% = 0 then chapn$ = ""
        Sect% = Sect% + 1
        Num$ = chapn$ + mid$(str$(Sect%),2)
       endif
       PRINT #2, "\par \par"
       PRINT #2, "{" + TimB$ + "34" + lang$ + " " + Num$ + "  " + prt$ + "}"
       PRINT #2, "\par"
       GOTO 9999
      END IF
      IF left$(line$,11)= "\subsection" THEN
       n% = 0
       CALL argument(line$, prt$, n%, star%)
       CALL slovix(prt$)
       if star% then
        Num$ = ""
       else
        chapn$ = mid$(str$(Chap%),2) + "."
        if Chap% = 0 then chapn$ = ""
        SubSect% = SubSect% + 1
        Num$ = chapn$ + mid$(str$(Sect%),2) + "." + mid$(str$(SubSect%),2)
       endif
       PRINT #2, "\par \par"
       PRINT #2, "{" + TimB$ + "28" + lang$ + " " + Num$ + "  " + prt$ + "}"
       PRINT #2, "\par"
       GOTO 9999
      END IF
      IF left$(line$,14)= "\subsubsection" THEN
       n% = 0
       CALL argument(line$, prt$, n%, star%)
       CALL slovix(prt$)
       if star% then
        Num$ = ""
       else
        chapn$ = mid$(str$(Chap%),2) + "."
        if Chap% = 0 then chapn$ = ""
        SubSubSect% = SubSubSect% + 1
        Num$ = chapn$ + mid$(str$(Sect%),2) + "." + mid$(str$(SubSect%),2) + "." + mid$(str$(SubSubSect%),2)
       endif
       PRINT #2, "\par \par"
       PRINT #2, "{" + TimB$ + "28" + lang$ + " " + Num$ + "  " + prt$ + "}"
       PRINT #2, "\par"
       GOTO 9999
      END IF
REM   SYNTAX: \begin{...}
      IF left$(line$, 6) = "\begin" THEN
       n% = 0: CALL argument(line$, arg$, n%, star%)
       if n% = 0 then ? "LATEX ERROR: missing argument to \begin... in line:": ? line$
       IF arg$ = "figure" THEN
        if not star% then Fig% = Fig% + 1
        Fig$ = mid$(str$(Fig%),2)
        Chapt$ = "": if Chap% > 0 then Chapt$ = mid$(str$(Chap%),2) + "."
        Num$ = " (" + Chapt$ + Fig$ + ")"
        if star% then Num$ = ""
        PRINT #2, "\par"
        PRINT #2, "\par {" + TimB$ + Cursiz$ + lang$ + " (Figure" + Num$ + ")} \par "
        file$ = ""
        WHILE NOT (left$(line$, 12) = "\end{figure}")
         LINE INPUT #1, line$: CALL gulix(line$): tline$ = line$ + " "
C        if (! sfigfl_int && line_S[0] != '%') {
          if left$(line$,6) = "\label" then
           n% = 5: CALL argument(line$, arg$, n%, star%)
           if Num$ <> "" and Pass% = 1 then
            ifigu% = 1+ifigu%: Figure$(ifigu%, 0)=Num$: Figure$(ifigu%, 1)=arg$:Figure$(ifigu%, 2) = ""
rem ? "Figure "; Num$, arg$
           endif
          else
           leng% = len(tline$): i% = 0: j% = 0: d$=""
C          for (i_int=0; i_int<leng_int-8; i_int++) {
C           if (tline_S[i_int]=='\\') {
C            if (strncmp(&tline_S[i_int],"\\epsffile",9)==0) {
              CALL argument(tline$, d$, i%, star%)
              if i% then
               file$ = d$
               PRINT #2, "file=" + file$ + "\par "
              endif
C            }
C            if (strncmp(&tline_S[i_int],"\\epsfig",7)==0) {
              CALL argument(tline$, d$, i%, star%)
              if i% then
               i% = 0
C              while(strncmp(&tline_S[i_int],"file",4)!=0 && tline_S[i_int]!='\0') i_int++;
C              if(tline_S[i_int] != '\0') {
C               strcpy(d_S, &tline_S[i_int]);
                CALL tokenix(d$, i%, "=", ",")
                if i% > 0 then
                 file$ = tmp$(2)
                 j% = LEN(file$)
C                if(file_S[j_int-1]=='}') file_S[j_int-1]='\0';
                 PRINT #2, "file=" + file$ + "\par "
                endif
C              }
              endif
C            }
C            if (strncmp(&tline_S[i_int],"\\caption",8)==0) {
              CALL argument(tline$, d$, i%, star%)
              Figure$(ifigu%, 3) = d$
              CALL slovix(d$)
              PRINT #2, "caption=" + d$ + "\par "
rem ? "Caption:", d$
C            }
C           }
C          }
          endif
C        }
209
        WEND
        IF file$ <> "" THEN Figure$(ifigu%, 2) = file$
        PRINT #2, "\par"
        GOTO 9999
       END IF
       IF arg$ = "table" THEN
        if not star% then Table% = Table% + 1
        Tab$ = mid$(str$(Table%),2)
        Chapt$ = "": if Chap% > 0 then Chapt$ = mid$(str$(Chap%),2) + "."
        Num$ = " (" + Chapt$ + Tab$ + ")"
        if star% then Num$ = ""
        caption$ = "": Tablefl% = 1
       END IF
       IF arg$ = "tabular" THEN
        argu$ = ""
        PRINT #2, "\par"
        LINE INPUT #1, line$: CALL gulix(line$)
        WHILE NOT (left$(line$, 13) = "\end{tabular}")
         CALL tablix(line$)
         tline$ = line$ + " "
         CALL slovix(tline$)
         PRINT #2, tline$
         LINE INPUT #1, line$: CALL gulix(line$)
        WEND
        PRINT #2, "\par \par"
        GOTO 9999
       END IF
       IF arg$ = "equation" OR arg$ = "eqnarray" THEN
        mathfl% = 1: eqfl% = 1: eqnfl% = 0
        IF arg$ = "eqnarray" THEN eqnfl% = 1
        Chapt$ = "": if Chap% > 0 then Chapt$ = mid$(str$(Chap%),2) + "."
        Num$ = " (" + Chapt$ + mid$(str$(Equat% + 1),2) + ")": REM Trashy
rem     z$ = "\par {" + TimB$ + Cursiz$ + lang$ + " (Equation" + Num$ + ")} \par {" + Curfnt$ + " {\i "
        z$ = "\par\par {" + Curfnt$ + " {\i "
        PRINT #2, z$
        Eq$ = "": line$ = "": tline$ = line$ + " "
        WHILE NOT (left$(line$, 14) = "\end{equation}" OR left$(line$, 14) = "\end{eqnarray}" OR eof(1))
C        if (! seqfl_int && line_S[0] != '%') {
          if left$(line$,6) = "\label" then
           n% = 5: CALL argument(line$, arg$, n%, star%)
           if Num$ <> "" and Pass% = 1 then
            iequat% = 1 + iequat%: Equation$(iequat%, 0)=Num$: Equation$(iequat%, 1)=arg$
? "Equation: "; Num$, arg$
           endif
          else
           Eq$ = Eq$ + tline$
           if right$(tline$, 3) = "\\ " then
C           Eq_S[strlen(Eq_S)-3] = '\0';
            CALL slovix(Eq$)
            if nonumb% then
             Num$ = "\par\par "
            else
             Equat% = Equat% + 1
             Equat$ = mid$(str$(Equat%),2)
             Num$ = " (" + Chapt$ + Equat$ + ")"
            endif
            PRINT #2, Eq$ + "\par \qr {\b" + Num$ + " \par }"
            Eq$ = ""
           endif
          endif
C        }
         LINE INPUT #1, line$: CALL gulix(line$): tline$ = line$ + " "
        WEND
        CALL slovix(Eq$): REM Translate complete equation at once
        CALL gulix(Eq$)
        IF Eq$ <> "" THEN
         Equat% = Equat% + 1
         Equat$ = mid$(str$(Equat%),2)
         Num$ = "\par \qr {\b (" + Chapt$ + Equat$ + ") \par }"
         PRINT #2, Eq$ + Num$
        END IF
        PRINT #2, "\par }} "
        mathfl%=0: eqfl%=0: eqnfl%=0
rem     PRINT #2, "\par"
        GOTO 9999
       END IF
       IF arg$ = "verbatim" THEN
        PRINT #2, "\par {\f21\fs" + Cursiz$ + lang$ + " "
        LINE INPUT #1, line$: CALL gulix(line$)
        WHILE NOT (left$(line$, 14) = "\end{verbatim}")
         CALL VerbatimProcess(line$)
         PRINT #2, line$ + "\par"
         LINE INPUT #1, line$: CALL gulix(line$)
        WEND
        PRINT #2, "}"
        GOTO 9999
       END IF
      END IF
      IF LEFT$(line$, 11) = "\end{table}" THEN
rem ? "Table "; Num$, argu$
       Tablefl% = 0
       PRINT #2, "\par"
       PRINT #2, "\par {" + TimB$ + Cursiz$ + lang$ + " (Table" + Num$ + ")} {" + Tim$ + Cursiz$ + lang$ + " " + caption$ + "} \par "
      END IF
C     if (! stblfl_int && line_S[0] != '%' && Tablefl_int) {
       if left$(line$,6) = "\label" then
        n% = 5: CALL argument(line$, argu$, n%, star%)
        if Num$ <> "" and Pass% = 1 then
         itabl% = 1 + itabl%: Table$(itabl%, 0)=Num$: Table$(itabl%, 1)=argu$
        endif
       endif
       if left$(line$,8) = "\caption" then
        n% = 7: CALL argument(line$, caption$, n%, star%)
        CALL slovix(caption$)
        GOTO 9999
       endif
C     }
C    }
     CALL slovix(line$)
     PRINT #2, line$
9999
    LOOP 
    PRINT #2, "\par }": REM End of the document
    CLOSE #1
    CLOSE #2

    Pass% = Pass% + 1
    LOOP
REM End of loop over names
10000
   NEXT jj%


END

SUB helpm
    eprint "t2r - a LaTeX to RTF converter. By Mario Stipcevic (stipcevi@rudjer.irb.hr)."
    eprint "Usage:"
    eprint "      t2r [-h][-se][-st][-sf] file[.tex]"
    eprint "Options:"
    eprint "-h          Print this help"
    eprint "-lang       Language: CRO, ENG. Default = CRO"
    eprint "-se         Do not show contents of equations"
    eprint "-st         Do not show contents of tables"
    eprint "-sf         Do not show contents of figures"
    eprint "-rm         Write math in roman font NOT OPERATIONAL"
    eprint "-v          Print version and exit"
C   exit(-1);
END SUB


SUB RTFpreamble
REM  Print pramble to the output rtf file:
     preamble$ = "/usr/local/src/preamble.rtf"
     IF NOT EXISTS(preamble$) THEN preamble$ = "preamble.rtf"
     OPEN preamble$ FOR INPUT AS #3
     while not eof(3)
      line input #3, a$
      PRINT #2, a$
     wend
     CLOSE #3
END SUB


SUB gulix (h$)
REM Strip off leading and trailing spaces
  leng% = LEN(h$)
  IF leng% <> 0 THEN
   i% = 0
C  while(h_S[i_int] == ' ' && i_int < leng_int) ++i_int;
   IF i% = leng% THEN h$ = "": GOTO 99
   j% = leng% - 1
C  while(h_S[j_int] == ' ' && j_int > 0) --j_int;
C  memmove(h_S,&h_S[i_int],(leng_int=j_int-i_int+1)); h_S[leng_int]='\0';
  END IF
99
END SUB


SUB argument(h$, arg$, k%, star%)
REM Finds argument of the function in h$ and puts in arg$ (without braces).
REM ......\function{argument}..........
REM On input k% contains the position of the function (c numeration).
REM On exit k% contains position (in C numeration) of the right brace "}"
REM of the argument. If k% = 0 argument not found. h$ is not changed.
REM star% is set if there was a star '*' before the argument: *{argument}
     leng% = 0: j% = k%: n% = 0: brace% = 0: arg$="": star% = 0
C    brace_int=1; leng_int = strlen(h_S);
C    while (h_S[j_int] != '{' && j_int < leng_int) {
C     if(h_S[j_int] == '*') { *star_int = 1; } j_int++;
C    }
C    n_int=++j_int;
C    while (brace_int != 0 && n_int < leng_int) {
C     if(h_S[n_int] == '{') brace_int++;
C     if(h_S[n_int] == '}') brace_int--;
C     n_int++;
C    }; n_int--;
C    strncpy(arg_S,&h_S[j_int],n_int-j_int); *k_int=n_int;
C    arg_S[n_int-j_int]='\0';
END SUB


FUNCTION Special$(num%)
REM Special characters (mainly math)
    num$ = mid$(str$(num%),2)
    Special$ = "{\f52\fs24\lang1050 {\field{\*\fldinst SYMBOL " + num$ + " \\f " + chr$(34) + "Symbol" + chr$(34) + " \\s 12}{\fldrslt\f1\fs24}}}"
rem    Special$ = "d"
END FUNCTION


SUB CountVariables(var$, n%)
C    char c;
     n% = 1: i% = 0: j% = 1
C    while ((c=var_S[i_int]) != '\0') {
C     if (c == ' ') j_int++;
C     if (c == '+') j_int++;
C     if (c == '-') j_int++;
C     i_int++;
C    }
C    if (var_S[0] == '\0') j_int = 0;
     n% = j%
rem ? "CountVariables"; var$, n%
END SUB


SUB slovix(hh$)
C  char c;
SHARED Tim$, TimI$, TimB$, TimBI$, TimU$, Sym$
SHARED Chap%, Sect%, SubSect%, SubSubSect%, Equat%, Eqnarr%, Fig%, Table%
SHARED mathfl%, eqfl%, eqnfl%, figfl%, nonumb%, verbfl%
SHARED Curfnf$, Curfnt$, Cursiz$, Symfnt$, lang$
SHARED seqfl%, stblfl%, sfigfl%
SHARED Pass%, ntabl%, nfigu%, nequat%
SHARED Table$(), Figure$(), Equation$()
REM Scan a line and translate it
REM Broj je nesto sto je od samih znamenaka a odvojeno je od ostatka
REM jednim ili vise od " \+-({". Brojevi se u math modu pisu uspravno.
REM Temporary variables:
    togfl%=0: brcnt%=0: brace% = 0: i%=0: d$="": z$="": n%=0: p%=0
    var$="": var1$="": var2$="": scrpt$="": star%=0: nonumb% = 0
REM Global variables for this routine:
    Gbrace% = 0: Root%=0: Frac%=0
    h$ = " " + hh$
C for(i_int=0; i_int<strlen(h_S); ++i_int) 
C {
C   n_int=0; z_S[1]='\0';
C   if(verbfl_int) {
C    if(h_S[i_int] == verbc) {
C     verbc='\0'; verbfl_int=0; n_int = 1; strcpy(z_S, "}"); goto Lab_100;
C    }
C    if(h_S[i_int] == '\\') {
      n% = 1: z$ = "\\": goto 100
C    }
C    if(h_S[i_int] == '{') {
      n% = 1: z$ = "\{": goto 100
C    }
C    if(h_S[i_int] == '}') {
      n% = 1: z$ = "\}": goto 100
C    }
C    goto Lab_100;
C   }
C   if(h_S[i_int] == '~') {
     n% = 1: z$ = " ": goto 100
C   }
C   if(h_S[i_int] == '{' && h_S[i_int-1] != '\\') ++brace_int;
C   if(h_S[i_int] == '}' && h_S[i_int-1] != '\\') --brace_int;
C   if(strncmp(&h_S[i_int],"\\~",2)==0) {n_int=2; strcpy(z_S,"~"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v c",4)==0) {n_int=4; strcpy(z_S,"\\'e8"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v C",4)==0) {n_int=4; strcpy(z_S,"\\'c8"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v s",4)==0) {n_int=4; strcpy(z_S,"\\'9a"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v S",4)==0) {n_int=4; strcpy(z_S,"\\'8a"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v z",4)==0) {n_int=4; strcpy(z_S,"\\'9e"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v Z",4)==0) {n_int=4; strcpy(z_S,"\\'8e"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\' c",4)==0) {n_int=4; strcpy(z_S,"\\'e6"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\' C",4)==0) {n_int=4; strcpy(z_S,"\\'c6"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\dj ",4)==0) {n_int=4; strcpy(z_S,"\\'f0"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\Dj ",4)==0) {n_int=4; strcpy(z_S,"\\'d0"); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\v{c}",5)==0) {n_int=5; strcpy(z_S,"\\'e8"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\v{C}",5)==0) {n_int=5; strcpy(z_S,"\\'c8"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\v{s}",5)==0) {n_int=5; strcpy(z_S,"\\'9a"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\v{S}",5)==0) {n_int=5; strcpy(z_S,"\\'8a"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\v{z}",5)==0) {n_int=5; strcpy(z_S,"\\'9e"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\v{Z}",5)==0) {n_int=5; strcpy(z_S,"\\'8e"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\'{c}",5)==0) {n_int=5; strcpy(z_S,"\\'e6"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\'{C}",5)==0) {n_int=5; strcpy(z_S,"\\'c6"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\%",2)==0) {n_int=2; strcpy(z_S,"%"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"--",2)==0) {n_int=2; strcpy(z_S,"-"); goto Lab_100;} 
C   if(strncmp(&h_S[i_int],"\\circ",5)==0) {
     n%=5: z$ = Special$(194): goto 100
C   }
C   if(strncmp(&h_S[i_int],"\\\\",2)==0) { n_int=2;
C    if (eqfl_int) {strcpy(z_S,"\\par ");} else {strcpy(z_S,"\\par \\par ");}
C   goto Lab_100;}
C   if(strncmp(&h_S[i_int],"\\vspace",7)==0) {
     j%=i%: CALL argument(h$, var$, j%, star%): n%=j%-i%+1: z$="\par \par ": goto 100
C   }
C   if(strncmp(&h_S[i_int],"\\hspace",7)==0) {
     j%=i%: CALL argument(h$, var$, j%, star%): n%=j%-i%+1: z$="  ": goto 100
C   }
C   if(strncmp(&h_S[i_int],"\\hfill",6)==0) {
     n% = 6: h$ = h$ + "}": z$ = "{\qr ": goto 100
C   }

C   if (!mathfl_int && h_S[i_int]=='$') {mathfl_int=1; n_int=1; strcpy(z_S,"{\\i"); strcat(z_S,Curfnt_S); strcat(z_S, " "); goto Lab_100;}
C   if ( mathfl_int && h_S[i_int]=='$') {mathfl_int=0; n_int=1; strcpy(z_S,"}"); goto Lab_100;}
C   if (mathfl_int) {
C    if(strncmp(&h_S[i_int],"\\mathrm",7)==0) {
      j% = i%: CALL argument(h$, arg$, j%, star%)
      if j% > 0 then
       CALL MathSymb(arg$, 0, 0)
       n% = j% - i% + 1
       n% = 7
       z$ = "}{" + Tim$ + Cursiz$ + lang$ + " " + arg$ + "}{\i "
      else
       print "Error in \mathrm in: "; h$
      endif
C    }
C    /* Text math mode */
C    if(eqnfl_int && h_S[i_int]=='&') {n_int=1; z_S[0]='\0'; goto Lab_100;}
REM Numbers (roman):
C    if('0'<=h_S[i_int] && h_S[i_int]<='9') {
C     c=h_S[i_int-1];
rem C     if(c==' ' || c=='+' || c=='-' || c=='/' || c=='(') {
C     if(!(('a'<=c && c<='z') || ('A'<=c && c<='Z'))) {
C      c=h_S[i_int]; j_int = i_int;
C      while('0'<=c && c<='9' || c=='.') c=h_S[++j_int];
rem C      if(c==' ' || c=='+' || c=='-' || c=='/' || c==')') {
       n%=j%-i%: z$ = "}" + mid$(h$, i%+1, j%-i%) + "{\i "
rem ? "Broj:"+z$+":", h$
        goto 100
rem C      }
C     }
C    }
REM Greek Letters:
C    if(strncmp(&h_S[i_int],"\\alpha",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," a}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\beta",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," b}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\chi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," c}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\delta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," d}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\epsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," e}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\varepsilon",11)==0) {n_int=11; strcpy(z_S,Symfnt_S); strcat(z_S," e}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\phi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," f}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\gamma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," g}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\eta",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," h}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\iota",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," i}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\imath",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," i}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\varphi",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," j}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\kappa",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," k}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\lambda",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," l}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\mu",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," m}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\nu",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," n}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\pi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," p}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\theta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," q}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\vartheta",9)==0) {n_int=9; strcpy(z_S,Symfnt_S); strcat(z_S," q}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\rho",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," r}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\sigma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," s}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\tau",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," t}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\upsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," u}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\varpi",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," v}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\omega",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," w}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\xi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," x}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\zeta",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," y}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\psi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," z}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Gamma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," G}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Delta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," D}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Theta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," Q}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Lambda",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," L}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Xi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," X}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Pi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," P}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Sigma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," S}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Upsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," U}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Phi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," f}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Psi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," Y}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Omega",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," W}"); goto Lab_100;}
C    if(strncmp(&h_S[i_int],"\\Im",3)==0) {
      n%=3: z$ = Special$(193): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\Re",3)==0) {
      n%=3: z$ = Special$(194): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\pm",3)==0) {
      n%=3: z$ = Special$(177): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\approx",7)==0) {
      n%=7: z$ = Special$(187): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\parallel",9)==0) {
      n%=9: z$ = Special$(124): z$ = z$ + z$ 
      goto 100
      z$ = "}{" + Tim$ + Cursiz$ + lang$ + " " + z$ + "}{\i" + Tim$ + Cursiz$ + lang$ + " "
      goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\mid",4)==0) {
      n%=4: z$ = Special$(124): goto 100
C    }
REM Math Functions:
C    if(strncmp(&h_S[i_int],"\\sin",4)==0) {
      n% = 4: z$ = "}sin{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\cos",4)==0) {
      n% = 4: z$ = "}cos{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\exp",4)==0) {
      n% = 4: z$ = "}exp{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\log",4)==0) {
      n% = 4: z$ = "}log{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\ln",3)==0) {
      n% = 3: z$ = "}ln{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\tan",4)==0) {
      n% = 4: z$ = "}tan{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\sinh",5)==0) {
      n% = 5: z$ = "}sinh{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\cosh",5)==0) {
      n% = 5: z$ = "}cosh{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\tanh",5)==0) {
      n% = 5: z$ = "}tanh{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\arcsin",7)==0) {
      n% = 7: z$ = "}arcsin{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\arccos",7)==0) {
      n% = 7: z$ = "}arccos{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\arctan",7)==0) {
      n% = 7: z$ = "}arctan{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\sqrt",5)==0) {
      j% = i%
      CALL argument(h$, var$, j%, star%)
      if j% <> 0 then
rem ? "sqrt prije:";h$
       z$ = "}" + Special$(214) + "{\i "
       h$ = left$(h$, i%) + "}" + Special$(214) + "{\i " + var$ + mid$(h$, j% + 2)
       n% = 0: i% = i% + len(z$) - 1
rem ? "sqrt pslje:";h$
      else
       n% = 5: z$ = "} sqrt{\i ": goto 100
      endif
      goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\frac",5)==0) {
      j% = i%
      CALL argument(h$, var1$, j%, star%)
      if j% then
       CALL argument(h$, var2$, j%, star%)
      else
       n% = 5: z$ = "} frac{\i ": goto 100
      endif
      if j% then
REM Denominator:
       single% = 1
       CALL gulix(var1$)
       CALL CountVariables(var1$, n%)
       if n% > 1 then
        if mid$(str$(val(var1$)),2) <> var1$ then single% = 0
       endif
       if not single% then
        var1$ = "(" + var1$ + ")"
       endif
REM Nominator:
       single% = 1
       CALL gulix(var2$)
       CALL CountVariables(var2$, n%)
       if n% > 1 then
        if mid$(str$(val(var2$)),2) <> var2$ then single% = 0
       endif
       if not single% then
        var2$ = "(" + var2$ + ")"
       endif
       h$ = left$(h$,i%)+var1$+"/"+var2$+mid$(h$,j%+2): n%=0: i%=i%-1
rem ? "frac:"; h$, var1$, var2$
      else
       n% = 5: z$ = "} frac{\i ": goto 100
      endif
      goto 100
C    }
REM Various math commands:
C    if(strncmp(&h_S[i_int],"\\nonumber",9)==0) {
      n% = 9: z$ = "": nonumb% = 1: goto 100
C    }
REM Garbage:
C    if(strncmp(&h_S[i_int],"\\int",4)==0) {
      n% = 4: z$ = Special$(242): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\sum",4)==0) {
      n% = 4: z$ = "}" + Special$(229) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\prod",5)==0) {
      n% = 5: z$ = "}" + Special$(213) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\rightarrow",11)==0) {
      n% = 11: z$ = "}" + Special$(174) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\leftarrow",10)==0) {
      n% = 10: z$ = "}" + Special$(172) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\Rightarrow",11)==0) {
      n% = 11: z$ = Special$(222): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\Leftarrow",10)==0) {
      n% = 10: z$ = Special$(220): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\Leftrightarrow",15)==0) {
      n%=15: z$ = Special$(219): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\equiv",6)==0) {
      n% = 6: z$ = Special$(219): goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\geq",4)==0) {
      n% = 4: z$ = "}" + Special$(179) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\leq",4)==0) {
      n% = 4: z$ = "}" + Special$(163) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\times",6)==0) {
      n% = 6: z$ = "}" + Special$(180) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\propto",7)==0) {
      n% = 7: z$ = "}" + Special$(181) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\partial",8)==0) {
      n% = 8: z$ = "}" + Special$(182) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\bullet",7)==0) {
      n% = 7: z$ = "}" + Special$(183) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\forall",7)==0) {
      n% = 7: z$ = "}" + Special$(34) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\exists",7)==0) {
      n% = 7: z$ = "}" + Special$(36) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\Box",4)==0) {
      n% = 4: z$ = "}" + Special$(127) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\circ",5)==0) {
      n% = 5: z$ = "}" + Special$(176) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\nabla",6)==0) {
      n% = 6: z$ = "}" + Special$(209) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\surd",5)==0) {
      n% = 5: z$ = "}" + Special$(214) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\cdot",5)==0) {
      n% = 5: z$ = "}" + Special$(215) + "{\i ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\left",5)==0) {
      n% = 5: z$ = " ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\right",6)==0) {
      n% = 6: z$ = " ": goto 100
C    }
C   }

REM Various escaped commands (not necessarily in math mode):
C   if (h_S[i_int] == '\\') {
C    if(strncmp(&h_S[i_int],"\\backslash ",11)==0) {
rem   n% = 11: z$ = "{\fs" + Cursiz$ + "\lang1033 \\}": goto 100
      n% = 11: z$ = "\\}": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\verb",5)==0) { verbc = h_S[i_int+5];
      n% = 6: verbfl% = 1: z$ = "{\f21\fs" + Cursiz$ + lang$ + " ": goto 100
C    }
C   /* Reference labels */
C    if(Pass_int == 2 && strncmp(&h_S[i_int],"\\ref",4)==0) {
      j% = i%: CALL argument(h$, arg$, j%, star%)
      Num$ = " (??)"
      for k% = 1 to ntabl%
       if Table$(k%, 1) = arg$ then Num$ = Table$(k%, 0): goto 79
      next
      for k% = 1 to nfigu%
       if Figure$(k%, 1) = arg$ then Num$ = Figure$(k%, 0): goto 79
      next
      for k% = 1 to nequat%
       if Equation$(k%, 1) = arg$ then Num$ = Equation$(k%, 0): goto 79
      next
79    n% = j% - i% + 1: Num$ = mid$(Num$, 3): z$ = left$(Num$, len(Num$)-1)
rem ? z$
      goto 100
C    }
C   /* Font size */
C    if(strncmp(&h_S[i_int],"\\tiny",5)==0) { n_int=5; strcpy(z_S,Curfnf_S); strcat(z_S, "8"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\scriptsize",11)==0) { n_int=11; strcpy(z_S,Curfnf_S); strcat(z_S, "12"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\footnotesize",13)==0) { n_int=13; strcpy(z_S,Curfnf_S); strcat(z_S, "16"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\small",6)==0) { n_int=6; strcpy(z_S,Curfnf_S); strcat(z_S, "20"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\normalsize",11)==0) { n_int=11; strcpy(z_S,Curfnf_S); strcat(z_S, "24"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\large",6)==0) { n_int=6; strcpy(z_S,Curfnf_S); strcat(z_S, "30"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\Large",6)==0) { n_int=6; strcpy(z_S,Curfnf_S); strcat(z_S, "36"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\LARGE",6)==0) { n_int=6; strcpy(z_S,Curfnf_S); strcat(z_S, "44"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\huge",5)==0) { n_int=5; strcpy(z_S,Curfnf_S); strcat(z_S, "52"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\Huge",5)==0) { n_int=5; strcpy(z_S,Curfnf_S); strcat(z_S, "60"); strcat(z_S, lang_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\bf",3)==0) { n_int=3; strcpy(z_S,"\\b"); strcat(z_S,Curfnt_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\em",3)==0) { n_int=3; strcpy(z_S,"\\i"); strcat(z_S,Curfnt_S); if (!brace_int) strcpy(Curfnt_S,z_S); goto Lab_100; }
C    if(strncmp(&h_S[i_int],"\\tt",3)==0) {
      n% = 3: z$ = "\f21\fs" + Cursiz$ + lang$
C     if (!brace_int) strcpy(Curfnt_S,z_S);
      goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\[",2)==0) {
      n% = 2: mathfl% = 1: z$ = "{\par\par \i" + Curfnt$ + " ": goto 100
C    }
C    if(strncmp(&h_S[i_int],"\\]",2)==0) {
rem   n% = 2: mathfl% = 0: z$ = "\par \pard \qj\widctlpar " + Curfnt$ + " ": goto 100
      n% = 2: mathfl% = 0: z$ = "\par\par } ": goto 100
C    }
C   }

C   if(strncmp(&h_S[i_int],"\\noindent",9)==0) { n_int=9; strcpy(z_S," "); goto Lab_100; } 
C   if(strncmp(&h_S[i_int],"\\pagebreak",10)==0) { n_int=10; strcpy(z_S,"\\page"); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\newpage",8)==0) { n_int=8; strcpy(z_S,"\\page"); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\linebreak",10)==0) { n_int=10; strcpy(z_S,"\\par "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\newline",8)==0) { n_int=8; strcpy(z_S,"\\par "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\footnote",9)==0) { n_int=9; strcpy(z_S," "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\begin{center}",14)==0) { n_int=14; strcpy(z_S,"\\par \\pard \\qc\\widctlpar {"); strcat(z_S,Curfnt_S); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\end{center}",12)==0) { n_int=12; strcpy(z_S,"\\par } \\pard \\qj\\widctlpar"); goto Lab_100; }
C   if(mathfl_int || eqfl_int) {
C    c = h_S[i_int];
C    if(c == '_' || c == '^') {
C     n_int=i_int; while(n_int > 0 && h_S[n_int] != ' ') n_int--;
      var$ = mid$(h$, n% + 2, i% - n% - 1): j% = n% + 1
rem ? "var$="; "-"+var$+"-"
C     if(h_S[i_int+1] != '{') {
       scrpt$ = mid$(h$, i% + 2, 1)
       n% = i% + 1
C     } else {
C      brace_int=1; n_int=i_int+2; 
C      while (brace_int != 0 && n_int < strlen(h_S)) {
C       if(h_S[n_int] == '{') brace_int++;
C       if(h_S[n_int] == '}') brace_int--;
C       n_int++;
C      }; n_int--;
       scrpt$ = mid$(h$, i% + 3, n% - i% - 2)
C     }
rem ? "1:scrpt$="; "-"+scrpt$+"-"
      tp$ = "$" + scrpt$ + "$"
REM   CALL slovix(tp$)
      CALL MathSymb(scrpt$, 0, 0)
rem ? "2:scrpt$="; "-"+scrpt$+"-"
      n% = n% - j% + 1: i% = j%
C     if(c == '_') strcpy(d_S, "\\sub ");
C     if(c == '^') strcpy(d_S, "\\super ");
C     if(atof(scrpt_S)!=0 || scrpt_S[0]=='0') {
       z$ = var$ + "}{" + Curfnt$ + d$ + scrpt$ + "}{\i "
C     } else {
       z$ = var$ + "{" + Curfnt$ + d$ + scrpt$ + "}"
C     }
      goto 100
C    }
C   }


C   if(strncmp(&h_S[i_int],"\\vspace",7)==0) { 
C    n_int=8; while (h_S[i_int+n_int] != '}')  ++n_int;
C    ++n_int; strcpy(z_S," "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\hspace",7)==0) {
C    n_int=8; while (h_S[i_int+n_int] != '}')  ++n_int;
C    ++n_int; strcpy(z_S,"       "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\sloppy",7)==0) { 
C    n_int=8; while (h_S[i_int+n_int] != '}')  ++n_int;
C    ++n_int; strcpy(z_S," "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\begin",6)==0) { 
C    n_int=7; while (h_S[i_int+n_int] != '}')  ++n_int;
C    ++n_int; strcpy(z_S," "); goto Lab_100; }
C   if(strncmp(&h_S[i_int],"\\end",4)==0) {
C    if(strncmp(&h_S[i_int],"\\end{document}",14)==0) { n_int=14; strcpy(z_S," "); goto Lab_100;}
C    n_int=5; while (h_S[i_int+n_int] != '}')  ++n_int;
C    ++n_int; strcpy(z_S," "); goto Lab_100; }
REM C   if(strncmp(&h_S[i_int],"\\bf",3)==0)
REM C   { brcnt_int=0; n_int=i_int;
REM C     while (n_int >= 0 && brcnt_int==0) {
REM C     if(h_S[n_int] == '{') brcnt_int=brcnt_int+1;
REM C     --n_int; }
REM C     p_int=n_int+7;
REM C     brcnt_int=1; n_int=i_int;
REM C     while (n_int <= strlen(h_S) && brcnt_int!=0) {
REM C     if(h_S[n_int] == '{') brcnt_int=brcnt_int+1;
REM C     if(h_S[n_int] == '}') brcnt_int=brcnt_int-1;
REM C     ++n_int; }
REM C     n_int=n_int-p_int-1;
REM ? h$, p%+5, n%-p%-1
REM ? mid$(h$,p%,n%): end
REM C   }
REM Remove any undefined escape sequence of the type \foo{blah} NOT YET!
rem C   if(h_S[i_int] == '\\' && h_S[i_int+1] != ' ' && h_S[i_int+1] != '\0') {
rem C   }
100 
C   if(n_int!=0)
C   {
C     strcpy(d_S,h_S);
C     h_S[i_int]='\0';
C     strcat(h_S,z_S);
C     strcat(h_S,&d_S[i_int+n_int]);
C     i_int=i_int+strlen(z_S)-1;
C   }
C }
  hh$ = mid$(h$, 2)
END SUB

SUB VerbatimProcess(h$)
C   char c;
SHARED Cursiz$
REM Substitute all literal backslashes and braces with true ones in rtf
REM For use in verbatim mode
    i% = 0
    back$   = "\\": lback% =  len(back$)
    lbrace$ = "\{": lbrace% = len(lbrace$)
    rbrace$ = "\}": rbrace% = len(rbrace$)
C   while((c=h_S[i_int]) != '\0') {
C    if (c == '\\') {
      h$ = left$(h$, i%) + back$ + mid$(h$, i% + 2)
      i% = i% + lback% - 1
C    }
C    if (c == '{') {
      h$ = left$(h$, i%) + lbrace$ + mid$(h$, i% + 2)
      i% = i% + lbrace% - 1
C    }
C    if (c == '}') {
      h$ = left$(h$, i%) + rbrace$ + mid$(h$, i% + 2)
      i% = i% + rbrace% - 1
C    }
C    i_int++;
C   }
END SUB

SUB tokenix (h$, ntok%, sep$, sep2$)
SHARED tmp$()
C     char b;
REM   Tokenizes h$ with respect to separators sep$, sep2$.
REM   Returns list of ntok% bare (gulix !) tokens in tmp$(), h$ unchanged.
      ntok% = 0: brfl% = 0: togfl% = 0: z$ = h$ + sep$: leng% = LEN(z$): b$ = ""
      IF h$ = "" THEN GOTO 169
      i% = 0: j% = 1
C     while (i_int < leng_int)
C     {
C      b = z_S[i_int];
C      if (b == 34) { togfl_int = 1 - togfl_int; goto Lab_168; }
C      if (! togfl_int)
C      {
C       if (b == '(') { brfl_int++; goto Lab_168; }
C       if (b == ')') { brfl_int--; goto Lab_168; }
C      }
C      if((b==sep_S[0] || b==sep2_S[0]) && !brfl_int && !togfl_int)
C      {
        IF i% + 1 - j% > 0 THEN
         b$ = MID$(z$, j%, i% + 1 - j%): CALL gulix(b$)
         ntok% = ntok% + 1: tmp$(ntok%) = b$
         IF ntok% > TMAX THEN
          PRINT "t2r: tokenix: Dimension of tmp$() too small. Enlarge TMAX and recompile t2r!"
C         exit(1);
         END IF
        END IF
        j% = i% + 2
C      }
168    i% = i% + 1
C     }
169 REM
END SUB

SUB MathSymb(h$, start%, stop%)
REM Check if there is a math symbol in h$ at places start%..stop% inclusive
REM in C numbering. If stop% = 0 go till the end of h$.

  i% = start%: z$ = "": d$ = "": n% = 0
  stoj% = stop%
  if stop% = 0 then stoj% = LEN(h$) - 1

C for (i_int=*start_int; i_int<=stoj_int; i_int++)
C {
     n% = 0
C    if(strncmp(&h_S[i_int],"\\alpha",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," a}}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\beta",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," b}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\chi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," c}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\delta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," d}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\epsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," e}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\varepsilon",11)==0) {n_int=11; strcpy(z_S,Symfnt_S); strcat(z_S," e}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\phi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," f}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\gamma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," g}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\eta",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," h}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\iota",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," i}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\imath",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," i}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\varphi",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," j}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\kappa",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," k}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\lambda",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," l}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\mu",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," m}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\nu",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," n}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\pi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," p}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\theta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," q}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\vartheta",9)==0) {n_int=9; strcpy(z_S,Symfnt_S); strcat(z_S," q}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\rho",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," r}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\sigma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," s}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\tau",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," t}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\upsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," u}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\varpi",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," v}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\omega",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," w}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\xi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," x}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\zeta",5)==0) {n_int=5; strcpy(z_S,Symfnt_S); strcat(z_S," y}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\psi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," z}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Gamma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," G}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Delta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," D}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Theta",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," Q}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Lambda",7)==0) {n_int=7; strcpy(z_S,Symfnt_S); strcat(z_S," L}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Xi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," X}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Pi",3)==0) {n_int=3; strcpy(z_S,Symfnt_S); strcat(z_S," P}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Sigma",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," S}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Upsilon",8)==0) {n_int=8; strcpy(z_S,Symfnt_S); strcat(z_S," U}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Phi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," f}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Psi",4)==0) {n_int=4; strcpy(z_S,Symfnt_S); strcat(z_S," Y}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Omega",6)==0) {n_int=6; strcpy(z_S,Symfnt_S); strcat(z_S," W}"); goto Lab_200;}
C    if(strncmp(&h_S[i_int],"\\Im",3)==0) {
      n%=3: z$ = Special$(193): goto 200
C    }
C    if(strncmp(&h_S[i_int],"\\Re",3)==0) {
      n%=3: z$ = Special$(194): goto 200
C    }
C    if(strncmp(&h_S[i_int],"\\pm",3)==0) {
      n%=3: z$ = Special$(177): goto 200
C    }
C    if(strncmp(&h_S[i_int],"\\approx",7)==0) {
      n%=7: z$ = Special$(187): goto 200
C    }
200
C   if(n_int!=0)
C   {
C     strcpy(d_S,h_S);
C     h_S[i_int]='\0';
C     strcat(h_S,z_S);
C     strcat(h_S,&d_S[i_int+n_int]);
C     i_int=i_int+strlen(z_S)-1;
C     stoj_int=stoj_int-n_int+strlen(z_S);
C   }
C }
END SUB

SUB tablix(h$)
REM Convert & -> \t
    IF LEN(h$) > 2 THEN
     IF RIGHT$(h$, 2) = "\\" THEN h$ = LEFT$(h$, LEN(h$) - 2) + "\par"
    END IF
    FOR i% = 1 TO LEN(h$) - 1
C    if(memcmp(&h_S[i_int-1], "\\&", 2)==0) {h_S[i_int-1]=' '; i_int++;}
C    if(h_S[i_int-1]=='&') h_S[i_int-1]='\t';
    NEXT
END SUB
