/*    syscalls.c                27.06.96              */
/* Routines for stbasic  Structured-BASIC-Interpreter */
/*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation (any version).

* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*   additional functions for stbasic         */
#include <stdio.h>  /* scanf, printf          */
#include <ctype.h>  /* toupper                */
#include <string.h> /* strcpy(), strstr()     */
#include <time.h>   /* clock(),time(),gmtime()*/                       
#include <stdlib.h> /* random, RAND_MAX       */
#include <sys/stat.h>  /* stat()              */
/* ------------------------------------------ */
  time_t timval;
  struct tm *time_ptr;
  char scdstr[25];

/*   SYSTEM command$     ======   system-call */
int
sys_system (char *s)
{
  int retcode;
  retcode = system(s);
  return retcode;
}

/*   RND(dummy)      ====== random-function */
double
sys_random (int seed)
{
  double rndval;
  if(seed != 0)
     { srand(seed); }
  rndval = (double) rand() / (double) RAND_MAX;
  return rndval;
}

/*   TIMER          ====== timer functions  */
double
sys_timer ()
{
  clock_t clkval;
  double cputime;
  clkval = clock();
  cputime = (double) clkval / (double) CLOCKS_PER_SEC;
  return cputime;
}

/*   DATE$         ======  date:  dd.mm.yyyy   */
char
*sys_date ()
{
  timval = time (NULL);
  time_ptr = gmtime (&timval);
  sprintf(scdstr,"%.2d.%.2d.%.4d\0",1+time_ptr->tm_mday,\
          1+time_ptr->tm_mon,1900+time_ptr->tm_year);
  return scdstr; 
}

/*   TIME$         ====== wall time:  hh:mm:ss   */ 
char
*sys_time ()
{
  timval = time (NULL);
  time_ptr = gmtime (&timval);
  sprintf(scdstr,"%.2d:%.2d:%.2d\0",time_ptr->tm_hour,\
          time_ptr->tm_min,time_ptr->tm_sec);
  return scdstr; 
}

/*   INSTR(string1$,string2$)     ====== instring   */
int
sys_instring (char *s1, char *s2)
{
  char *s4;
  int leng;
  s4 = strstr (s1, s2);
  if(s4==NULL)
    { leng = 0; }
    else
    { leng = strlen(s1)-strlen(s4)+1; }
  return leng;
}

/*   EXIST(filename$)  shows, if file with full pathname exists */
int
sys_exist (char *filename)
{
  int retc;
  struct stat fstats;
  retc = stat (filename, &fstats);
  return retc;
}

