$ sysprog, ucsd, heap_dispose, partial_eval $
$ debug$

program stbasic(input, output);

(*  stbasic.p V 0.9                                 03.12.1996 *)
(*  last mod. (parse, snerror, DEFFN, FUNCTION)     13.02.1997 *)
(*  stbasic Structured-BASIC-Interpreter                       *)
(*  Author: Wilfried Waetzig                                   *)
(*  Author's address: waetzig@hrz.uni-kassel.de                *)
(*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation (any version).

* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*)

CONST
  bastitle = 'stbasic 0.9 - Structured-BASIC-Interpreter (02/97)';
  checking = true;
  varnamelen = 19; (*20*)
  toknamelen = 9; 
  polyarrlen = 100;
  maxdims = 4;
  ctrll = 12; (* FF FOR CLS       *)
  comedit = 'vi -c "set nu" ';
  comerase = 'rm ';
  comprint = ' | gawk ''{ print "   ", $0, "\r" }'' | lpr - ';
  comcat = 'cat ';
  comsleep = 'sleep ';

TYPE
  varnamestring = string[varnamelen];
  toknamestring = string[toknamelen];
  string255 = string[255];
  string255ptr = ^string255;
  tokenkinds = (tokrvar, tokivar, tokbvar, toksvar, tokrnum,
              tokinum, tokbnum, tokstrg, tokpname, tokfname,
              tokdefnam, toklbldef, toklabel, tokunit, tokarrtype,
              tokvartype, toklettype, tokloctype,
              tokfn, tokfdef, tokstmterr, toksnerr,
              tokplus, tokminus, toktimes, tokdivide, tokup,
              toklp, tokrp, tokcomma, toksemi, tokcolon,
              tokeq, toklt, tokgt, tokle, tokge, tokne,
              tokand, tokor, tokxor, tokmod, toknot,
              toksqa, toksqrt, toksin, tokcos, toktan, tokatn,
              toklog, toklog10, tokexp, tokabs, tokint, toksgn,
              tokfrac, tokodd, toktrunc, tokrandom, 
              tokadd, toksub, tokmul, tokdiv, tokinc, tokdec,
              tokclr, tokarray, tokswap, tokpi, toktrue, tokfalse,
              tokmin, tokmax, tokinstr, 
              toktimer, tokdate_, toktime_, tokexist, tokstr_,
              tokval, tokchr_, tokasc, toklen, tokmid_, tokleft_,
              tokright_, tokupper_, toklower_, tokspace_, tokstring_,
              tokrem, tokremp, tokremx, toklet, toklset, tokrset, 
              tokprint, tokat, tokusing, tokinput,
              tokopen, tokclose, tokgoto, tokdeffn,
              tokfunc, tokfreturn, tokproc, toklocal, tokreturn, 
              tokif, tokendif, tokexitif, tokelseif, 
              tokstop, tokfor, toknext, tokwhile, tokwend, tokdo,
              tokloop, tokrepeat, tokuntil, tokgosub,
              tokread, tokdata, tokrestore,
              tokon, tokdim, tokerase, toktest, tokedit, toklist,
              tokllist, tokhelp, tokrun, toknew, tokload, toksave,
              tokbye, tokexit, toksystem, tokpause, tokeof,
              toktron, toktroff, tokthen, tokelse,
              tokto, tokdownto, tokstep, tokcls,
              toktitlew, tokinfow, tokopenw, tokclearw, tokclosew,
              tokcolor, toksetcolor, tokgraphmode, tokdeffill,
              tokdefline, tokdefmark, tokdeftext,
              tokplot, tokline, tokdraw, toktext, tokfill,
              tokbox, tokpbox, tokrbox, tokprbox,
              tokcircle, tokpcircle, tokellipse, tokpellipse,
              tokdefmouse, tokhidem, tokshowm, tokmouse,
              tokmousex, tokmousey, tokmousek,
              tokpolyline, tokpolyfill, tokpolymark,
              tokalert, tokfileselect, tokmenu, tokonmenu,
              tokend);

  vartype = (typglobal, typlocal, typformal, typdeffn, typfunct);

  realptr = ^real;
  intptr = ^integer;
  boolptr = ^boolean;
  basicstring = string255ptr;
  stringptr = ^basicstring;
  rnumarray = array[0..maxint] of real;
  rarrayptr = ^rnumarray;
  inumarray = array[0..maxint] of integer; 
  iarrayptr = ^inumarray;
  bnumarray = array[0..maxint] of boolean; 
  barrayptr = ^bnumarray;
  strarray = array[0..maxint] of basicstring;
  strarrayptr = ^strarray;

  tokenptr = ^tokenrec;
  lineptr  = ^linerec;
  varptr   = ^varrec;
  lablptr  = ^lablrec;
  loopptr  = ^looprec;

  tokenrec =
    record
      next : tokenptr;
      case kind : tokenkinds of
         tokrvar, tokivar, tokbvar, toksvar: (varp: varptr);
         tokpname, tokfname, toklbldef, toklabel,
         tokdefnam: (linp: lablptr);
         tokrnum : (rval : real);
         tokinum : (ival : integer);
         tokstrg, tokrem, tokremp, tokremx, tokdata, tokstmterr :
          (sval : basicstring; spnr : integer);
         tokunit : (unit : integer);
         tokif, tokelse, tokelseif, tokendif, tokthen,
           tokwhile, tokwend, tokrepeat, tokuntil,
           tokexitif, tokfor, toknext, 
           tokreturn : (goln: lineptr; lopr: loopptr);
         tokproc, tokfunc, tokdeffn : (fvar : varptr);
         toksnerr : (snbs: basicstring; sncx : integer);
    END;

  linerec =
    RECORD
      num : integer;
      txt : tokenptr;
      next : lineptr;
    END;

  varrec =
    RECORD
      next : varptr;
      name : varnamestring;
      dims : array [1..maxdims] of integer;
      numdims : 0..maxdims;
      numtype : vartype;
      CASE varkind : tokenkinds of
        tokrvar: (rarr : rarrayptr;  rval : realptr;  rv : real);
        tokivar: (iarr : iarrayptr;  ival : intptr;  iv : integer);
        tokbvar: (barr : barrayptr;  bval : boolptr;  bv : boolean);
        toksvar: (sarr: strarrayptr; sval: stringptr; sv: basicstring);
        tokfn  : (defn : lineptr);
    END;

  lablrec =
    RECORD
      next : lablptr;
      lnpt : lineptr;
      name : varnamestring;
      ltyp : tokenkinds;
    END;

  valrec =
    RECORD
      case valkind : tokenkinds of
        tokrnum : (rval : real);
        tokinum : (ival : integer);
        tokbnum : (bval : boolean); 
        tokstrg : (sval : basicstring);
    END;
  
  looprec =
    RECORD
      next : loopptr;
      homeline : lineptr;
      CASE loopkind : tokenkinds of
        tokfor, toknext: (vp : varptr; max, step : real );
        tokgosub, tokproc, tokreturn, tokfreturn, tokdeffn:
          (rtad: lineptr; rtok: tokenptr);
    END;

  polyarray = ARRAY [0..polyarrlen] OF integer; (* for POLYFILL, POLYMARK *)
  errstring = string[40];

(* ---------------------------------------------------------- *)

var
  inbuf : string255ptr;
  linebase, linelast : lineptr;
  varbase : varptr;
  loopbase : loopptr;
  lablbase : lablptr;

  curline : integer;
  indentline : integer; 
  stmtline, dataline : lineptr;
  stmttok, buf : tokenptr;
  proctokp, functokp, deffntokp : tokenptr;
  dataidx: integer;
  datastring : string255;

  exitflag, runflag, traceflag, directcom : boolean;
  gotoflag, elseflag, xtifflag, loopflag : boolean;
  debug3flag, debug2flag, runtstflag : boolean;
  tracemode : integer;
  tracechar : char;
 
  excp_line ['EXCP_LINE'] : integer;

  tokenname : ARRAY [tokenkinds] OF varnamestring; 
  tokenfunc : ARRAY [tokenkinds] OF toknamestring; 
  tfu : ARRAY [0..100] of text;
  tfm : ARRAY [0..100] of char;
  dunit : integer;
  basprogname, printname, auxfill : string255;
  grfgmode : integer;
  grfopenw : boolean;   (* indicator, IF window#0 is open *)
  grflocator : integer; (* indicator, IF locator (mouse) is enabled *)
  menuindex : integer;
  menuprocp : lineptr;  (* PROCEDURE FOR ONMENU-execution *)

(* ---p2c-MACROS------------------------------------------------ *)

PROCEDURE misc_getioerrmsg(var s : string; io : integer);
  EXTERNAL;
PROCEDURE misc_printerror(er, io : integer);
  EXTERNAL;
FUNCTION asm_iand(a, b : integer) : integer;
  EXTERNAL;
FUNCTION asm_ior(a, b : integer) : integer;
  EXTERNAL;
PROCEDURE hpm_new(var p : anyptr; size : integer);
  EXTERNAL;
PROCEDURE hpm_dispose(var p : anyptr; size : integer);
  EXTERNAL;

(* ---EXTERNAL graphic routines--------------------------------- *)

PROCEDURE grf_titlew (n: integer; t: string);
  EXTERNAL;
PROCEDURE grf_infow (n: integer; i: string);
  EXTERNAL;
PROCEDURE grf_openw (n, x, y: integer);
  EXTERNAL;
PROCEDURE grf_clearw (n: integer);
  EXTERNAL;
PROCEDURE grf_closew (n: integer);
  EXTERNAL;
PROCEDURE grf_fullw (n: integer);
  EXTERNAL;
PROCEDURE grf_color (cd, cb : integer);
  EXTERNAL;
PROCEDURE grf_setcolor (i, r, g, b: integer);
  EXTERNAL;
PROCEDURE grf_graphmode (n: integer);
  EXTERNAL;
PROCEDURE grf_deffill (c, a, b: integer);
  EXTERNAL;
PROCEDURE grf_defline (s, b: integer);
  EXTERNAL;
PROCEDURE grf_defmark (c, a, g: integer);
  EXTERNAL;
PROCEDURE grf_deftext (c, s, r, g: integer);
  EXTERNAL;
PROCEDURE grf_line (x0, y0, x1, y1: integer);
  EXTERNAL;
PROCEDURE grf_plot (x, y: integer);
  EXTERNAL;
PROCEDURE grf_text (x, y: integer; s: string);
  EXTERNAL;
PROCEDURE grf_fill (x, y: integer);
  EXTERNAL;
PROCEDURE grf_box (x0, y0, x1, y1: integer);
  EXTERNAL;
PROCEDURE grf_pbox (x0, y0, x1, y1: integer);
  EXTERNAL;
PROCEDURE grf_rbox (x0, y0, x1, y1: integer);
  EXTERNAL;
PROCEDURE grf_prbox (x0, y0, x1, y1: integer);
  EXTERNAL;
PROCEDURE grf_circle (x, y, r, p0, p1: integer);
  EXTERNAL;
PROCEDURE grf_pcircle (x, y, r, p0, p1: integer);
  EXTERNAL;
PROCEDURE grf_ellipse (x, y, rx, ry, p0, p1: integer);
  EXTERNAL;
PROCEDURE grf_pellipse (x, y, rx, ry, p0, p1: integer);
  EXTERNAL;
PROCEDURE grf_defmouse (VAR mode: integer; n: integer);
  EXTERNAL;
PROCEDURE grf_mouse (VAR x, y, k: integer);
  EXTERNAL;
PROCEDURE grf_polyfill (n: integer; x, y: polyarray);
  EXTERNAL;
PROCEDURE grf_polyline (n: integer; x, y: polyarray);
  EXTERNAL;
PROCEDURE grf_polymark (n: integer; x, y: polyarray);
  EXTERNAL;
PROCEDURE grf_alert (a: integer; ms: string255; b: integer;
                     bs: string255; VAR v: integer);
  EXTERNAL;
PROCEDURE grf_fileselect (s, n: string255; VAR x: string255);
  EXTERNAL;
PROCEDURE grf_menu (mode: integer; VAR res: integer; arr: strarrayptr);
  EXTERNAL;

(* ---system calls-------------------------------------------- *)

FUNCTION sys_system (cstsys : basicstring): integer;
  EXTERNAL;
FUNCTION sys_random (seed: integer): real;
  EXTERNAL;
FUNCTION sys_timer(i : integer): real;
  EXTERNAL;
FUNCTION sys_date (i : integer): string255ptr;
  EXTERNAL;
FUNCTION sys_time (i : integer): string255ptr;
  EXTERNAL;
FUNCTION sys_instring (st1, st2: basicstring): integer;
  EXTERNAL;
FUNCTION sys_exist (st: basicstring): integer;
  EXTERNAL;

(* ------------------------------------------------------------- *)

PROCEDURE grftestwin;
BEGIN
  grfgmode := 0;
  IF NOT grfopenw
    THEN
      BEGIN
        grf_openw (0,0,0);
        writeln('==> OPENW 0,0,0   added');
        grfopenw := true;
      END;
END;   

PROCEDURE testival (VAR x: integer; lo, hi: integer);
BEGIN
  IF (x < lo) THEN x := lo;
  IF (x > hi) THEN x := hi;
END;

(* ------------------------------------------------------------- *)

(*  initialize tokenname/tokenfunc    *)
(* tokenfunc[1]:  type of token:      *)
(*  '0'  Types                        *)
(*  '1'  Operations                   *)
(*  '2'  Functions                    *)
(*  '3'  Arithmetic                   *)
(*  '4'  Structure                    *)
(*  '5'  Instructions                 *)
(*  '6'  direct commands              *)
(*  '7'  I/O-Instructions             *)
(*  '8'  System Commands              *)
(*  '9'  Graphic Instr.               *)
(* tokenfunc[2]:  spaces FOR listing: *)
(*  '0'  no spaces                    *)
(*  '1'  leading space                *)
(*  '2'  trailing space               *)
(*  '3'  leading + trailing spaces    *)
PROCEDURE inittoktable;
BEGIN
  tokenname[tokrvar]     := 'rvar ';
  tokenfunc[tokrvar]     := '00 rvar';
  tokenname[tokivar]     := 'ivar%';
  tokenfunc[tokivar]     := '00 ivar';
  tokenname[tokbvar]     := 'bvar!';
  tokenfunc[tokbvar]     := '00 bvar';
  tokenname[toksvar]     := 'svar$';
  tokenfunc[toksvar]     := '00 svar';
  tokenname[tokrnum]     := 'r.num';
  tokenfunc[tokrnum]     := '00 rnum';
  tokenname[tokinum]     := 'inum ';
  tokenfunc[tokinum]     := '00 inum';
  tokenname[tokstrg]     := 'string';
  tokenfunc[tokstrg]     := '00 str';
  tokenname[toklabel]    := 'label';
  tokenfunc[toklabel]    := '00 label';
  tokenname[tokpname]    := 'proc-name';
  tokenfunc[tokpname]    := '00 p-name';
  tokenname[tokfname]    := 'func-name';
  tokenfunc[tokfname]    := '00 f-name';
  tokenname[tokdefnam]   := 'def-name';
  tokenfunc[tokdefnam]   := '00 d-name';
  tokenname[toklbldef]   := 'lbldef:';
  tokenfunc[toklbldef]   := '00 lbldef';
  tokenname[tokunit]     := '#unit';
  tokenfunc[tokunit]     := '00 #unit';
  tokenname[tokarrtype]  := '()';
  tokenfunc[tokarrtype]  := '00 arrtyp';
  tokenname[tokvartype]  := '&';
  tokenfunc[tokvartype]  := '00 vartyp';
  tokenname[toklettype]  := '~let';
  tokenfunc[toklettype]  := '00 letvar';
  tokenname[tokloctype]  := '~local';
  tokenfunc[tokloctype]  := '00 loctyp';
  tokenname[tokfn]       := '~fn';
  tokenfunc[tokfn]       := '00 inline';
  tokenname[tokfdef]     := '~fdef';
  tokenfunc[tokfdef]     := '00 funct';
  tokenname[tokstmterr]  := '==>';
  tokenfunc[tokstmterr]  := '03 err ';
  tokenname[toksnerr]    := 'error';
  tokenfunc[toksnerr]    := '00 err ';
  tokenname[tokplus]     := '+';
  tokenfunc[tokplus]     := '10 op-sgn';
  tokenname[tokminus]    := '-';
  tokenfunc[tokminus]    := '10 op-sgn';
  tokenname[toktimes]    := '*';
  tokenfunc[toktimes]    := '10 op-sgn';
  tokenname[tokdivide]   := '/';
  tokenfunc[tokdivide]   := '10 op-sgn';
  tokenname[tokup]       := '^';
  tokenfunc[tokup]       := '10 op-s-e';
  tokenname[toklp]       := '(';
  tokenfunc[toklp]       := '00 parant';
  tokenname[tokrp]       := ')';
  tokenfunc[tokrp]       := '00 parant'; 
  tokenname[tokcomma]    := ',';
  tokenfunc[tokcomma]    := '00 comma';
  tokenname[toksemi]     := ';
  tokenfunc[toksemi]     := '00 semcol';
  tokenname[tokcolon]    := ':';
  tokenfunc[tokcolon]    := '03 colon';
  tokenname[tokeq]       := '=';
  tokenfunc[tokeq]       := '13 operat';
  tokenname[toklt]       := '<';
  tokenfunc[toklt]       := '13 operat';
  tokenname[tokgt]       := '>';
  tokenfunc[tokgt]       := '13 operat';
  tokenname[tokle]       := '<=';
  tokenfunc[tokle]       := '13 operat';
  tokenname[tokge]       := '>=';
  tokenfunc[tokge]       := '13 operat';
  tokenname[tokne]       := '<>';
  tokenfunc[tokne]       := '13 operat';
  tokenname[tokand]      := 'AND';
  tokenfunc[tokand]      := '13 operat';
  tokenname[tokor]       := 'OR';
  tokenfunc[tokor]       := '13 operat';
  tokenname[tokxor]      := 'XOR';
  tokenfunc[tokxor]      := '13 operat';
  tokenname[tokmod]      := 'MOD';
  tokenfunc[tokmod]      := '13 operat';
  tokenname[toknot]      := 'NOT';
  tokenfunc[toknot]      := '12 operat';
  tokenname[toksqa]      := 'SQA';
  tokenfunc[toksqa]      := '20 funct.';
  tokenname[toksqrt]     := 'SQR';
  tokenfunc[toksqrt]     := '20 funct.';
  tokenname[toksin]      := 'SIN';
  tokenfunc[toksin]      := '20 funct.';
  tokenname[tokcos]      := 'COS';
  tokenfunc[tokcos]      := '20 funct.';
  tokenname[toktan]      := 'TAN';
  tokenfunc[toktan]      := '20 funct.';
  tokenname[tokatn]      := 'ATN';
  tokenfunc[tokatn]      := '20 funct.';
  tokenname[toklog]      := 'LOG';
  tokenfunc[toklog]      := '20 funct.';
  tokenname[toklog10]    := 'LOG10';
  tokenfunc[toklog10]    := '20 funct.';
  tokenname[tokexp]      := 'EXP';
  tokenfunc[tokexp]      := '20 funct.';
  tokenname[tokabs]      := 'ABS';
  tokenfunc[tokabs]      := '20 funct.';
  tokenname[tokint]      := 'INT';
  tokenfunc[tokint]      := '20 funct.';
  tokenname[toksgn]      := 'SGN';
  tokenfunc[toksgn]      := '20 funct.';
  tokenname[tokfrac]     := 'FRAC';
  tokenfunc[tokfrac]     := '20 funct.';
  tokenname[tokodd]      := 'ODD';
  tokenfunc[tokodd]      := '20 funct.';
  tokenname[toktrunc]    := 'TRUNC';
  tokenfunc[toktrunc]    := '20 funct.';
  tokenname[tokrandom]   := 'RANDOM';
  tokenfunc[tokrandom]   := '80 funct.';
  tokenname[tokadd]      := 'ADD';
  tokenfunc[tokadd]      := '32 funct.';
  tokenname[toksub]      := 'SUB';
  tokenfunc[toksub]      := '32 funct.';
  tokenname[tokmul]      := 'MUL';
  tokenfunc[tokmul]      := '32 funct.';
  tokenname[tokdiv]      := 'DIV';
  tokenfunc[tokdiv]      := '32 funct.';
  tokenname[tokinc]      := 'INC';
  tokenfunc[tokinc]      := '32 funct.';
  tokenname[tokdec]      := 'DEC';
  tokenfunc[tokdec]      := '32 funct.';
  tokenname[tokarray]    := 'ARRAYFILL';
  tokenfunc[tokarray]    := '32 operat';
  tokenname[tokswap]     := 'SWAP';
  tokenfunc[tokswap]     := '32 operat';
  tokenname[tokclr]      := 'CLR';
  tokenfunc[tokclr]      := '32 operat';
  tokenname[tokpi]       := 'PI';
  tokenfunc[tokpi]       := '20 PI';
  tokenname[toktrue]     := 'TRUE';
  tokenfunc[toktrue]     := '23 value';
  tokenname[tokfalse]    := 'FALSE';
  tokenfunc[tokfalse]    := '23 value';
  tokenname[tokmin]      := 'MIN';
  tokenfunc[tokmin]      := '20 funct.';
  tokenname[tokmax]      := 'MAX';
  tokenfunc[tokmax]      := '20 funct.';
  tokenname[tokinstr]    := 'INSTR';
  tokenfunc[tokinstr]    := '80 funct.';
  tokenname[toktimer]    := 'TIMER';
  tokenfunc[toktimer]    := '80 funct.';
  tokenname[tokdate_]    := 'DATE$';
  tokenfunc[tokdate_]    := '80 funct.';
  tokenname[toktime_]    := 'TIME$';
  tokenfunc[toktime_]    := '80 funct.';
  tokenname[tokexist]    := 'EXIST';
  tokenfunc[tokexist]    := '80 funct.';
  tokenname[tokstr_]     := 'STR$';
  tokenfunc[tokstr_]     := '20 funct.';
  tokenname[tokval]      := 'VAL';
  tokenfunc[tokval]      := '22 funct.';
  tokenname[tokchr_]     := 'CHR$';
  tokenfunc[tokchr_]     := '20 funct.';
  tokenname[tokasc]      := 'ASC';
  tokenfunc[tokasc]      := '20 funct.';
  tokenname[toklen]      := 'LEN';
  tokenfunc[toklen]      := '20 funct.';
  tokenname[tokmid_]     := 'MID$';
  tokenfunc[tokmid_]     := '20 funct.';
  tokenname[tokleft_]    := 'LEFT$';
  tokenfunc[tokleft_]    := '20 funct.';
  tokenname[tokright_]   := 'RIGHT$';
  tokenfunc[tokright_]   := '20 funct.';
  tokenname[tokupper_]   := 'UPPER$';
  tokenfunc[tokupper_]   := '20 funct.';
  tokenname[toklower_]   := 'LOWER$';
  tokenfunc[toklower_]   := '20 funct.';
  tokenname[tokspace_]   := 'SPACE$';
  tokenfunc[tokspace_]   := '20 funct.';
  tokenname[tokstring_]  := 'STRING$';
  tokenfunc[tokstring_]  := '20 funct.';
  tokenname[tokrem]      := 'REM';
  tokenfunc[tokrem]      := '04 coment';
  tokenname[tokremp]     := '''';
  tokenfunc[tokremp]     := '04 comm-p';
  tokenname[tokremx]     := '!';
  tokenfunc[tokremx]     := '01 comm-p';
  tokenname[toklet]      := 'LET';
  tokenfunc[toklet]      := '52 modif.';
  tokenname[toklset]     := 'LSET';
  tokenfunc[toklset]     := '52 modif.';
  tokenname[tokrset]     := 'RSET';
  tokenfunc[tokrset]     := '52 modif.';
  tokenname[tokprint]    := 'PRINT';
  tokenfunc[tokprint]    := '72 i/o-p.';
  tokenname[tokat]       := 'AT';
  tokenfunc[tokat]       := '72 i/o-p.';
  tokenname[tokusing]    := 'USING';
  tokenfunc[tokusing]    := '72 format';
  tokenname[tokinput]    := 'INPUT';
  tokenfunc[tokinput]    := '72 i/o-p.';
  tokenname[tokopen]     := 'OPEN';
  tokenfunc[tokopen]     := '72 i/o-p.';
  tokenname[tokclose]    := 'CLOSE';
  tokenfunc[tokclose]    := '72 i/o-p.';
  tokenname[tokgoto]     := 'GOTO';
  tokenfunc[tokgoto]     := '42 struct';
  tokenname[tokdeffn]     := 'DEFFN';
  tokenfunc[tokdeffn]     := '42 inline';
  tokenname[tokproc]     := 'PROCEDURE';
  tokenfunc[tokproc]     := '42 struct';
  tokenname[toklocal]    := 'LOCAL';
  tokenfunc[toklocal]    := '42 struct';
  tokenname[tokreturn]   := 'RETURN';
  tokenfunc[tokreturn]   := '40 struct';
  tokenname[tokfunc]     := 'FUNCTION';
  tokenfunc[tokfunc]     := '42 struct';
  tokenname[tokfreturn]  := 'RETURN';
  tokenfunc[tokfreturn]  := '42 struct';
  tokenname[tokif]       := 'IF';
  tokenfunc[tokif]       := '42 struct';
  tokenname[tokendif]    := 'ENDIF';
  tokenfunc[tokendif]    := '40 struct';
  tokenname[tokexitif]   := 'EXITIF';
  tokenfunc[tokexitif]   := '42 struct';
  tokenname[tokelseif]   := 'ELSEIF';
  tokenfunc[tokelseif]   := '42 struct';
  tokenname[tokstop]     := 'STOP';
  tokenfunc[tokstop]     := '40 struct';
  tokenname[tokfor]      := 'FOR';
  tokenfunc[tokfor]      := '42 struct';
  tokenname[toknext]     := 'NEXT';
  tokenfunc[toknext]     := '42 struct';
  tokenname[tokwhile]    := 'WHILE';
  tokenfunc[tokwhile]    := '42 struct';
  tokenname[tokwend]     := 'WEND';
  tokenfunc[tokwend]     := '40 struct';
  tokenname[tokdo]       := 'DO';
  tokenfunc[tokdo]       := '42 struct';
  tokenname[tokloop]     := 'LOOP';
  tokenfunc[tokloop]     := '40 struct';
  tokenname[tokrepeat]   := 'REPEAT';
  tokenfunc[tokrepeat]   := '40 struct';
  tokenname[tokuntil]    := 'UNTIL';
  tokenfunc[tokuntil]    := '42 struct';
  tokenname[tokgosub]    := 'GOSUB';
  tokenfunc[tokgosub]    := '42 struct';
  tokenname[tokread]     := 'READ';
  tokenfunc[tokread]     := '52 comand';
  tokenname[tokdata]     := 'DATA';
  tokenfunc[tokdata]     := '52 comand';
  tokenname[tokrestore]  := 'RESTORE';
  tokenfunc[tokrestore]  := '52 comand';
  tokenname[tokon]       := 'ON';
  tokenfunc[tokon]       := '52 comand';
  tokenname[tokdim]      := 'DIM';
  tokenfunc[tokdim]      := '52 comand';
  tokenname[tokerase]    := 'ERASE';
  tokenfunc[tokerase]    := '52 comand';
  tokenname[toktest]     := 'TEST';
  tokenfunc[toktest]     := '60 comand';
  tokenname[tokedit]     := 'EDIT';
  tokenfunc[tokedit]     := '60 comand';
  tokenname[toklist]     := 'LIST';
  tokenfunc[toklist]     := '60 i/o-p.';
  tokenname[tokllist]    := 'LLIST';
  tokenfunc[tokllist]    := '60 i/o-p.';
  tokenname[tokhelp]     := 'HELP';
  tokenfunc[tokhelp]     := '60 comand';
  tokenname[tokrun]      := 'RUN';
  tokenfunc[tokrun]      := '60 comand';
  tokenname[toknew]      := 'NEW';
  tokenfunc[toknew]      := '60 comand';
  tokenname[tokload]     := 'LOAD';
  tokenfunc[tokload]     := '60 i/o-c.';
  tokenname[toksave]     := 'SAVE';
  tokenfunc[toksave]     := '60 i/o-c.';
  tokenname[tokbye]      := 'BYE';
  tokenfunc[tokbye]      := '60 exit';
  tokenname[tokexit]     := 'EXIT';
  tokenfunc[tokexit]     := '60 exit';
  tokenname[toksystem]   := 'SYSTEM';
  tokenfunc[toksystem]   := '82 comand';
  tokenname[tokpause]    := 'PAUSE';
  tokenfunc[tokpause]    := '82 comand';
  tokenname[tokeof]      := 'EOF';
  tokenfunc[tokeof]      := '70 funct.';
  tokenname[toktron]     := 'TRON';
  tokenfunc[toktron]     := '52 comand';
  tokenname[toktroff]    := 'TROFF';
  tokenfunc[toktroff]    := '52 comand';
  tokenname[tokthen]     := 'THEN';
  tokenfunc[tokthen]     := '43 struct';
  tokenname[tokelse]     := 'ELSE';
  tokenfunc[tokelse]     := '40 struct';
  tokenname[tokto]       := 'TO'; 
  tokenfunc[tokto]       := '43 struct';
  tokenname[tokdownto]   := 'DOWNTO'; 
  tokenfunc[tokdownto]   := '43 struct';
  tokenname[tokstep]     := 'STEP';
  tokenfunc[tokstep]     := '43 struct';
  tokenname[tokcls]      := 'CLS';
  tokenfunc[tokcls]      := '50 comand';
  tokenname[toktitlew]   := 'TITLEW';
  tokenfunc[toktitlew]   := '92 grafic';
  tokenname[tokinfow]    := 'INFOW';
  tokenfunc[tokinfow]    := '92 grafic';
  tokenname[tokopenw]    := 'OPENW';
  tokenfunc[tokopenw]    := '92 grafic';
  tokenname[tokclearw]   := 'CLEARW';
  tokenfunc[tokclearw]   := '92 grafic';
  tokenname[tokclosew]   := 'CLOSEW';
  tokenfunc[tokclosew]   := '92 grafic';
  tokenname[tokcolor]    := 'COLOR';
  tokenfunc[tokcolor]    := '92 grafic';
  tokenname[toksetcolor] := 'SETCOLOR';
  tokenfunc[toksetcolor] := '92 grafic';
  tokenname[tokgraphmode] := 'GRAPHMODE';
  tokenfunc[tokgraphmode] := '92 grafic';
  tokenname[tokdeffill]  := 'DEFFILL';
  tokenfunc[tokdeffill]  := '92 grafic';
  tokenname[tokdefline]  := 'DEFLINE';
  tokenfunc[tokdefline]  := '92 grafic';
  tokenname[tokdefmark]  := 'DEFMARK';
  tokenfunc[tokdefmark]  := '92 grafic';
  tokenname[tokdeftext]  := 'DEFTEXT';
  tokenfunc[tokdeftext]  := '92 grafic';
  tokenname[tokplot]     := 'PLOT';
  tokenfunc[tokplot]     := '92 grafic';
  tokenname[tokline]     := 'LINE';
  tokenfunc[tokline]     := '92 grafic';
  tokenname[tokdraw]     := 'DRAW';
  tokenfunc[tokdraw]     := '92 grafic';
  tokenname[toktext]     := 'TEXT';
  tokenfunc[toktext]     := '92 grafic';
  tokenname[tokfill]     := 'FILL';
  tokenfunc[tokfill]     := '92 grafic';
  tokenname[tokbox]      := 'BOX';
  tokenfunc[tokbox]      := '92 grafic';
  tokenname[tokpbox]     := 'PBOX';
  tokenfunc[tokpbox]     := '92 grafic';
  tokenname[tokrbox]     := 'RBOX';
  tokenfunc[tokrbox]     := '92 grafic';
  tokenname[tokprbox]    := 'PRBOX';
  tokenfunc[tokprbox]    := '92 grafic';
  tokenname[tokcircle]   := 'CIRCLE';
  tokenfunc[tokcircle]   := '92 grafic';
  tokenname[tokpcircle]  := 'PCIRCLE';
  tokenfunc[tokpcircle]  := '92 grafic';
  tokenname[tokellipse]  := 'ELLIPSE';
  tokenfunc[tokellipse]  := '92 grafic';
  tokenname[tokpellipse] := 'PELLIPSE';
  tokenfunc[tokpellipse] := '92 grafic';
  tokenname[tokdefmouse] := 'DEFMOUSE';
  tokenfunc[tokdefmouse] := '92 grafic';
  tokenname[tokhidem]    := 'HIDEM';
  tokenfunc[tokhidem]    := '92 grafic';
  tokenname[tokshowm]    := 'SHOWM';
  tokenfunc[tokshowm]    := '92 grafic';
  tokenname[tokmouse]    := 'MOUSE';
  tokenfunc[tokmouse]    := '92 grafic';
  tokenname[tokmousex]   := 'MOUSEX';
  tokenfunc[tokmousex]   := '90 grafic';
  tokenname[tokmousey]   := 'MOUSEY';
  tokenfunc[tokmousey]   := '90 grafic';
  tokenname[tokmousek]   := 'MOUSEK';
  tokenfunc[tokmousek]   := '90 grafic';
  tokenname[tokpolyline] := 'POLYLINE';
  tokenfunc[tokpolyline] := '92 grafic';
  tokenname[tokpolyfill] := 'POLYFILL';
  tokenfunc[tokpolyfill] := '92 grafic';
  tokenname[tokpolymark] := 'POLYMARK';
  tokenfunc[tokpolymark] := '92 grafic';
  tokenname[tokalert]    := 'ALERT';
  tokenfunc[tokalert]    := '92 grafic';
  tokenname[tokfileselect] := 'FILESELECT';
  tokenfunc[tokfileselect] := '92 grafic';
  tokenname[tokmenu]     := 'MENU';
  tokenfunc[tokmenu]     := '92 grafic';
  tokenname[tokonmenu]   := 'ONMENU';
  tokenfunc[tokonmenu]   := '92 grafic';
  tokenname[tokend]      := 'END';
  tokenfunc[tokend]      := '40 struct'; 
END;

PROCEDURE printlfile (VAR filnam: string255; pmode: boolean);
VAR answer: string[3];
    iret : integer;
BEGIN
  IF filnam <> '' THEN
    BEGIN
      writeln ('Output the file "', filnam, '" on the printer [N]/Y');
      readln (answer);
      IF ((answer = 'y') OR (answer = 'Y')) THEN
        (* => cat filnam | lpr - *) 
        iret := sys_system (comcat + filnam + comprint);
      IF pmode THEN
        BEGIN
          (* => rm filnam *)
          iret := sys_system (comerase + filnam);
          filnam := '';
        END;
    END
END;

PROCEDURE initdevtable (mode: boolean);
(* init. device-table / close all device-files *)
(* print listing-file on CLOSE                 *)
var ku : integer;
    f : text;
BEGIN
  FOR ku := 1 to 99 do
    BEGIN
      IF mode and ((tfm[ku] = 'I') or (tfm[ku] = 'O')
         OR (tfm[ku] = 'P')) THEN
        BEGIN
          f := tfu[ku];
          close (f);
        END;
      IF tfm[ku] = 'P' THEN
        printlfile (printname, TRUE);  
      tfu[ku] := output;
      tfm[ku] := ' ';
    END;
  tfu[100] := input;
  tfm[100] := 'I';
  tfu[0]   := output;
  tfm[0]   := 'O';
  printname := ''; 
END;

(* ----------------------------------------------------------------- *)

PROCEDURE restoredata;
BEGIN
  dataline := linebase;
  dataidx := 0;
  datastring := '';
  menuprocp := NIL;
END;

PROCEDURE pntloops;
var ll: loopptr;
BEGIN
  ll := loopbase;
  write('loops');
  while ll <> NIL do
    BEGIN
      write(ll^.homeline^.num:5,':',tokenname[ll^.loopkind]);
      ll := ll^.next;
    END;
  writeln;
END;

PROCEDURE delloop;
VAR lp: loopptr;
BEGIN
  lp := loopbase^.next;
  dispose(loopbase);
  loopbase := lp;
  xtifflag := false;
  IF debug2flag THEN pntloops;
END;

PROCEDURE clearloops;
BEGIN
   while loopbase <> NIL do
      delloop;
END;

PROCEDURE savestmt (deftok: tokenkinds);
VAR l: loopptr;
BEGIN
  new(l);
  l^.next := loopbase;
  loopbase := l;
  loopbase^.loopkind := deftok;
  loopbase^.homeline := stmtline; (* RETURN-line *)
  IF debug2flag THEN pntloops;
END;

(* ----------------------------------------------------------- *)

PROCEDURE arraysize (VAR vr: varrec; VAR vdim, vsize: integer);
VAR i : integer;
BEGIN
  with vr do
    BEGIN
      IF numdims = 0 THEN
        vdim := 0
      ELSE
        vdim := 1;
      FOR i := 1 to numdims do
        vdim := vdim * dims[i];
      CASE varkind of       
        tokrvar : vsize := vdim*8;
        tokivar : vsize := vdim*4;
        tokbvar : vsize := vdim*1;
        toksvar : vsize := vdim*4;
      END;
      IF (numtype <> typglobal) AND (numtype <> typlocal) THEN
        vsize := 0;
    END;
END;

PROCEDURE clearvar (v : varptr);
(*  clear one variable: dispose the allocated space *)
VAR i, adim, asize: integer;
BEGIN
  with v^ do
    BEGIN
      arraysize (v^, adim, asize);
      (** writeln('clearvar1 ',name,numdims:2,adim);  *)
      CASE varkind of
        tokrvar: BEGIN
                   IF asize > 0 THEN
                     hpm_dispose(rarr, asize);
                   rv := 0;
                   rval := addr(rv);
                 END;
        tokivar: BEGIN
                   IF asize > 0 THEN
                     hpm_dispose(iarr, asize);
                   iv := 0;
                   ival := addr(iv);
                 END;
        tokbvar: BEGIN
                   IF asize > 0 THEN
                     hpm_dispose(barr, asize);
                   bv := false;
                   bval := addr(bv);
                 END;
        toksvar: BEGIN
                   IF asize > 0 THEN
                     BEGIN  (* erase all basicstrings *)
                       FOR i := 0 to adim-1 do
                         IF sarr^[i] <> NIL THEN
                           dispose (sarr^[i]);
                       hpm_dispose(sarr, asize);
                     END; 
                   IF sv <> NIL THEN dispose(sv);
                   sv := NIL;
                   sval := addr(sv);
                 END;
      END;  (* case *)
      numdims := 0;
      (** writeln('clearvar2 ',name,numdims:2,arraysize(v)); *) 
    END;
END;

PROCEDURE clearvars (VAR vbase: varptr);
var
   v : varptr;
BEGIN
   v := vbase;
   while v <> NIL do
      BEGIN
         clearvar (v);
         v := v^.next;
      END;
END;

PROCEDURE delvarbase (VAR vbase: varptr);
VAR 
    p : varptr;
BEGIN
  while vbase <> NIL do
    BEGIN
      p := vbase^.next;
      IF (vbase^.varkind = toksvar) THEN
        IF vbase^.sval^ <> NIL THEN
          dispose(vbase^.sval^);
      dispose(vbase);
      vbase := p;
    END;
END;

PROCEDURE clrprocvar (VAR pv: varptr);
BEGIN
  clearvars (pv);
  delvarbase (pv);
END;

PROCEDURE delprocvars;
VAR
    l: lineptr;
    lt: tokenptr;
BEGIN
  l := linebase;
  WHILE l <> NIL DO
    BEGIN
      lt := l^.txt;
      IF (lt <> NIL) AND ((lt^.kind = tokproc)
         OR (lt^.kind = tokdeffn)) THEN
        clrprocvar (lt^.fvar);
      IF l <> NIL THEN
        l := l^.next;
    END;
END;

PROCEDURE dellabels;
VAR ll: lablptr;
BEGIN
  WHILE lablbase <> NIL DO
    BEGIN
      ll := lablbase^.next;
      dispose (lablbase);
      lablbase := ll;
    END;
END;

(* ----------------------------------------------------------- *)

PROCEDURE disposetokens(var tok : tokenptr);
var
   tok1 : tokenptr;
BEGIN
  while tok <> NIL do
    BEGIN
      tok1 := tok^.next;
      IF (tok^.kind in [tokstrg, tokrem, tokremp, tokremx,
          tokdata, tokstmterr, toksnerr])
         AND (tok^.sval <> NIL) THEN
        dispose(tok^.sval);
      dispose(tok);
      tok := tok1;
    END;
END;

PROCEDURE dellinebase (VAR lnbase: lineptr);
VAR 
    p : lineptr;
BEGIN
  while lnbase <> NIL do
    BEGIN
      p := lnbase^.next;
      disposetokens (lnbase^.txt);
      dispose (lnbase);
      lnbase := p;
    END;
END;

(* ----------------------------------------------------------- *)

FUNCTION numtostr(rn : real) : string255;
var
   s : string255;
   i : integer;
BEGIN
  setstrlen (s, 255);
  IF (rn <> 0) and (abs(rn) < 1.0e-2) or (abs(rn) >= 1.0e12) THEN
    BEGIN
      strwrite (s, 1, i, rn);
      (* setstrlen (s, i-1); *)
      s[i] := chr(0);
      numtostr := s;
    END
  ELSE
    BEGIN
      strwrite (s, 1, i, rn:30:10);
      repeat 
        i := i - 1;
      until s[i] <> '0';
      IF s[i] = '.' THEN
        i := i - 1;
      (* setstrlen (s, i); *)
      s[i+1] := chr(0);
      numtostr := strltrim (s);
    END;
END;

FUNCTION inumtostr(iw : integer) : string255;
var
   s : string255;
   i : integer;
BEGIN
   setstrlen(s, 255);
   strwrite(s, 1, i, iw);
   (* setstrlen(s, i-1); *)
   s[i] := chr(0);
   inumtostr := strltrim(s);
END;

PROCEDURE upperstring (var tok : string255); 
 var
   itok : integer;
BEGIN
  FOR itok:=1 to length(tok) do
    IF tok[itok] IN ['a'..'z'] THEN
       tok[itok] := chr(ord(tok[itok])-ord('a')+ord('A'));
END;

PROCEDURE lowerstring (var tok : string255); 
 var
   itok : integer;
BEGIN
  FOR itok:=1 to length(tok) do
    IF tok[itok] IN ['A'..'Z'] THEN
       tok[itok] := chr(ord(tok[itok])-ord('A')+ord('a'));
END;

PROCEDURE fillchars (var t: string255; k: integer; cfill: char);
var i : integer;
BEGIN
  testival (k, 0, 255);
  FOR i := 1 to k do
    t[i] := cfill;
  t[i+1] := chr(0);
END;

PROCEDURE strlrncpy (VAR t, s: string255; nrl: boolean);
(*  copy string s into t at the left/right side       *)
var i, lt, ls, nl, nr : integer;
BEGIN
  lt := strlen (t);
  ls := strlen (s);
  nl := 0;
  nr := lt;
  testival (ls, 0, lt);
  IF nrl
    THEN nr := ls
    ELSE nl := lt-ls;
  FOR i := 1 to nl do
    t[i] := ' ';
  FOR i := nl+1 to nr do
    t[i] := s[i-nl];
  FOR i := nr+1 to lt do
    t[i] := ' ';
END; 
  
(* -------------------------------------------------------------- *)

PROCEDURE listonetok (dunit: integer; VAR jtok: tokenrec);
var
   jfunc : char;
   jtoken : tokenkinds;
BEGIN
  jtoken := jtok.kind;
  case jtoken of
    tokrvar, tokivar, tokbvar, toksvar:
             write (tfu[dunit], jtok.varp^.name);
    tokrnum: write (tfu[dunit], numtostr(jtok.rval));
    tokinum: write (tfu[dunit], inumtostr(jtok.ival));
    tokstrg: write (tfu[dunit], '"', jtok.sval^, '"');
    tokrem, tokremp, tokdata, tokstmterr:
             write (tfu[dunit], tokenname[jtoken], jtok.sval^);
    tokremx: BEGIN
               fillchars (auxfill, jtok.spnr, ' ');
               write (tfu[dunit], auxfill, tokenname[jtoken], jtok.sval^);
             END; 
    tokpname, tokfname, toklabel, tokdefnam:
             write (tfu[dunit], jtok.linp^.name);
    toklbldef: write (tfu[dunit], jtok.linp^.name, ':');
    tokunit: write (tfu[dunit], "#", inumtostr(jtok.unit));
    toksnerr:  write (tfu[dunit], '{', chr(jtok.sncx), '}');
    tokfn, tokfdef: ;
    otherwise
      BEGIN
       jfunc := tokenfunc[jtoken,2];
        case jfunc of
          '0': write (tfu[dunit], tokenname[jtoken]);
          '1': write (tfu[dunit], ' ', tokenname[jtoken]);
          '2': write (tfu[dunit], tokenname[jtoken], ' ');
          '3': write (tfu[dunit], ' ', tokenname[jtoken], ' ');
          otherwise write (tfu[dunit], '===error===');
        END; (* case jfunc *)
      END; (* otherwise *)
   END; (* case jtoken *)
END;

PROCEDURE listtokens (dunit: integer; buf : tokenptr);
var ongo: boolean;
BEGIN
   ongo := false;
   while buf <> NIL do
      BEGIN
        IF buf^.kind = tokon THEN
          ongo := true;
        IF ongo and
           ((buf^.kind = tokgoto) or (buf^.kind = tokgosub)) THEN
          write(tfu[dunit], ' ');
        listonetok (dunit, buf^);
        IF (buf^.kind = tokstmterr) THEN
          buf := NIL (* suppress printing rest of line if error *)
        ELSE
          buf := buf^.next;
      END;
END;

PROCEDURE listline (dunit: integer; lbuf : lineptr);
var buf: tokenptr;
BEGIN
  IF (lbuf <> NIL) THEN
    BEGIN
      write (tfu[dunit], lbuf^.num:6, ' ');
      buf := lbuf^.txt;
      listtokens (dunit, buf);
      writeln(tfu[dunit]);
    END;
END;

(* --------------------------------------------------------- *)

PROCEDURE printvars (VAR nvar: varptr);
var numd : integer;
    ckb : char;
BEGIN
  IF nvar <> NIL THEN
    WITH nvar^ DO
      BEGIN
        fillchars (auxfill, varnamelen-length(name), ' ');
        write (name, auxfill, tokenname[varkind]);
        CASE numtype OF
          typglobal: write (' global ');
          typlocal : write (' local  ');
          typformal: write (' formal ');
          typdeffn : write (' deffn  ');
          typfunct : write (' funct  ');
        END;
        write (' DIM=', numdims:2, ' ');
        IF numdims > 0 THEN
          BEGIN
            ckb := '(';
            FOR numd := 1 to numdims do
              BEGIN
                write(ckb, inumtostr(dims[numd]));
                IF numd = 1 THEN
                  ckb := ','; 
              END;
            write (') ');
          END;  
        CASE varkind OF
          tokrvar: write (rval^);
          tokivar: write (ival^);
          tokbvar: IF bval^ THEN write ('TRUE')
                            ELSE write ('FALSE');
          toksvar: IF sval^ <> NIL THEN write (sval^^);
        END;
      END;
END;

PROCEDURE printvals (VAR dval: valrec);
BEGIN
  WITH dval DO
  BEGIN
    write (tokenname[valkind], ' ');
      CASE valkind OF
        tokrnum: write (rval);
        tokinum: write (ival);
        tokbnum: IF bval THEN write ('TRUE')
                         ELSE write ('FALSE');
        tokstrg: IF sval <> NIL THEN write (sval^);
      END;
  END;
END;

(* print line #n with tokens    === TROFF n  *)
PROCEDURE pntlwtok (n1: integer);
var
   l : lineptr;
   buf : tokenptr; 
BEGIN
  l := linebase;   (* scan lines => linerec *)
  while (l <> NIL) and (l^.num <= maxint) do
    BEGIN
      IF (l^.num = n1) THEN
        BEGIN
          listline (0,l);
          buf := l^.txt;
          while buf <> NIL do
            BEGIN
              write (l^.num:6, ord(buf^.kind):4);
              write (' ',tokenname[buf^.kind],' - ');
              listonetok (0, buf^);
              writeln;
              buf := buf^.next;
            END;
        END;
      l := l^.next;
    END;
END; 

(* ------------------------------------------------------------- *)

PROCEDURE wstatement;
BEGIN
  IF stmtline <> NIL THEN
    BEGIN
      writeln (' at line', stmtline^.num:6, ' ');
      listtokens (0, stmtline^.txt);
      writeln;
    END;
END;

PROCEDURE snerror (err: errstring);
BEGIN
  writeln (chr(7), '###ERROR: ', err);
  wstatement;
  escape (42);
END;

PROCEDURE srequired (ks: tokenkinds);
BEGIN
  writeln (chr(7), '###REQUIRED: ', tokenname[ks]);
  wstatement;
  escape (42);
END;

PROCEDURE xrequired (ks: tokenkinds);
BEGIN
  writeln ('###REQUIRED: ', tokenname[ks]);
  wstatement;
  runtstflag := true;
END;

(* ---------------------------------------------------------- *)

PROCEDURE debugp1 (ntxt: varnamestring; VAR ins: string255ptr);
BEGIN
  write ('|', ntxt);
  IF ins <> NIL THEN 
    write (ins^);
  writeln;
END;

PROCEDURE debugp2 (ntxt: varnamestring; VAR tbuf: tokenptr);
VAR tbkind: tokenkinds;
BEGIN
  write ('|', ntxt, ' ');
  IF tbuf <> NIL THEN
    BEGIN
      tbkind := tbuf^.kind;
      write (tokenname[tbkind], ' ');
      IF tbkind IN [tokpname, toklabel, tokdefnam] THEN
        write (tbuf^.linp^.name, ' ');
      IF tbkind = tokrnum THEN write (tbuf^.rval);
      IF tbkind = tokinum THEN write (tbuf^.ival);
      IF tbkind IN [tokstrg, tokrem, tokremp, tokremx, tokdata, tokstmterr]
        THEN write (tbuf^.sval^);
      IF tbkind IN [tokrvar, tokivar, tokbvar, toksvar] THEN
        printvars (tbuf^.varp);
    END;
  writeln;
END;

PROCEDURE debugp3 (ntxt: varnamestring; VAR dval: valrec);
BEGIN
  write ('|', ntxt, ' ');
  printvals (dval);
  writeln;
END;

PROCEDURE debugp4 (ntxt: varnamestring; VAR nvar: varptr);
BEGIN
  write ('|', ntxt, ' ');
  printvars (nvar); 
  writeln;
END;

(* ----------------------------------------------------------------- *)

PROCEDURE storelabel (VAR ltoken: varnamestring;
                      VAR tl: tokenptr;
                      ltokind: tokenkinds);
(* store label with type: defined label => toklbldef  *)
(*       following: GOTO, RESTORE       => toklabel   *)
(*       following: GOSUB, PROCEDURE    => tokpname   *)
VAR vl : lablptr;
BEGIN
  new(vl);
  vl^.name := ltoken;
  vl^.lnpt := NIL;
  vl^.next := lablbase;
  vl^.ltyp := ltokind;
  lablbase := vl;
  tl^.linp := vl;
  tl^.kind := ltokind;
(** writeln('storelabel ',tokenname[tl^.kind],' ',ltoken); *)
END;

PROCEDURE searchvar (VAR vtoken: varnamestring;
                     VAR vbase, vx, v: varptr);
(* look, if variable-name exists *)
BEGIN
  v := vbase;
  vx := NIL;
  while (v <> NIL) and (v^.name <> vtoken) do
    BEGIN
      vx := v;
      v := v^.next;
    END;
END;

PROCEDURE storevar (VAR vtoken: varnamestring;
                    VAR tv: tokenptr;
                    VAR vbase: varptr;
                    variabletyp : vartype);
(* store variables with type-indicator:           *)
(* ending with:  '$' for string,          real    *)
(*               '%' for integer, '!' for boolean *)
VAR v, vx : varptr;
    termch : char;
BEGIN
  termch := vtoken[strlen(vtoken)];
  searchvar (vtoken, vbase, vx, v);
  IF v = NIL THEN (* string/integer/boolean/real *)
    BEGIN
      new(v);
      v^.next := NIL;
      IF vbase = NIL THEN
        vbase := v
      ELSE
        vx^.next := v;
      v^.name := vtoken;
      v^.numdims := 0;
      v^.numtype := variabletyp;
      IF termch = '$' THEN  (*  vartype: STRING$  *)
        BEGIN
          v^.varkind := toksvar;
          v^.sv := NIL;
          v^.sval := addr(v^.sv);
          v^.sarr := NIL; 
        END
      ELSE
      IF termch = '%' THEN  (*  vartype: INTEGER  *)
        BEGIN
          v^.varkind := tokivar;
          v^.iv := 0;
          v^.ival := addr(v^.iv);
          v^.iarr := NIL;
        END
      ELSE
      IF termch = '!' THEN  (*  vartype: BOOLEAN! *) 
        BEGIN
          v^.varkind := tokbvar;
          v^.bv := FALSE;
          v^.bval := addr(v^.bv);
          v^.barr := NIL;
        END
      ELSE
        BEGIN              (*  vartype: REAL     *)
          v^.varkind := tokrvar;
          v^.rv := 0.0;
          v^.rval := addr(v^.rv);
          v^.rarr := NIL;
        END;
     END; (* IF v = NIL *)
   tv^.kind := v^.varkind;
   tv^.varp := v;
(**   writeln('storevar ',tokenname[tv^.kind],' ',vtoken); *) 
END;

FUNCTION varexists (VAR vtok: varnamestring;
                    VAR vbase: varptr): boolean;
VAR
    v: varptr;
BEGIN
  v := vbase;
  WHILE (v <> NIL) AND (v^.name <> vtok) DO
    v := v^.next;
  varexists := (v <> NIL);
END;

(* ----------------------------------------------------------------- *)

PROCEDURE readstring (VAR stval: basicstring;
                      VAR buffer: string255;
                      VAR index: integer;
                      ch: char);
VAR j: integer;
BEGIN
  new (stval);
  setstrlen (stval^, 255);
  j := 0;
  while (index <= strlen(buffer)) and
        (buffer[index] <> ch) do
     BEGIN
       IF (buffer[index] = '\') AND (index < strlen(buffer)) THEN
         index := index + 1;
       j := j + 1;
       stval^[j] := buffer[index];
       index := index + 1;
     END;
  (* setstrlen (stval^, j); *)
  stval^[j+1] := chr(0);
  index := index + 1;
END; 

PROCEDURE readcomment (VAR stval: basicstring;
                      VAR buffer: string255;
                      VAR index: integer);
VAR j: integer;
BEGIN
  new (stval);
  j := strlen(buffer)+1;
  stval^ := str(buffer, index, j-index);
  index := j;
END; 

(* ----------------------------------------------------------------- *)

PROCEDURE readreal (VAR nr: real;
                    VAR buffer: string255;
                    VAR ix: integer;
                    VAR d1: real;
                    fsign: boolean);
VAR d: real;
    jx, k, bufflen : integer;
    rsign: boolean;
BEGIN
  bufflen := strlen(buffer);
  nr := 0.0;
  d := 1.0;
  d1 := 1.0;
  rsign := false;
  IF fsign THEN
    BEGIN
      IF (ix <= bufflen) and
         (buffer[ix] in ['+','-']) THEN
         BEGIN
           IF buffer[ix] = '-' THEN
             rsign := true;
           ix := ix + 1;
         END;
    END
  ELSE
    ix := ix - 1;
  while (ix <= bufflen) and ((buffer[ix] in ['0'..'9'])
              or ((buffer[ix] = '.') and (d1 = 1.0))) do
     BEGIN   (* read MANTISSA *)
        IF buffer[ix] = '.' THEN
           d1 := 10.0
        ELSE
           BEGIN
              nr := nr * 10.0 + ord(buffer[ix]) - ord('0');
              d := d * d1;
           END;
        ix := ix + 1;
     END;
  nr := nr / d;
  IF (ix <= bufflen) and (buffer[ix] in ['e','E']) THEN
    BEGIN
      ix := ix + 1;
      d1 := 10.0;
      IF (ix <= bufflen) and
         (buffer[ix] in ['+','-']) THEN
         BEGIN
           IF buffer[ix] = '-' THEN
             d1 := 0.1;
             ix := ix + 1;
         END;
      jx := 0;  (* read EXPONENT *)
      while (ix <= bufflen) and (buffer[ix] in ['0'..'9']) do
        BEGIN
          jx := jx * 10 + ord(buffer[ix]) - ord('0');
          ix := ix + 1;
        END;
      FOR k := 1 to jx do
        nr := nr * d1;
   END;
  IF rsign THEN
    nr := - nr;
END;

(* ----------------------------------------------------------------- *)

PROCEDURE skipblank (VAR ch: char;
                     VAR buffer: string255;
                     VAR ix: integer,
                     VAR spcnt: integer);
BEGIN 
   spcnt := 0;  (* count spaces for in-line comment *)
   while ((ix <= strlen(buffer)) and (ch <= ' ')) do
    BEGIN
      ch := buffer[ix];
      ix := ix + 1;
      spcnt := spcnt + 1;
    END;
END;

PROCEDURE skipsporcm (VAR ch: char;
                      VAR buffer: string255;
                      VAR ix: integer);
VAR bufflen: integer;
BEGIN
  bufflen := strlen(buffer); 
  REPEAT
    IF (ix <= bufflen) THEN
      ch := buffer[ix]
    ELSE
      ch := ' ';
    IF (ch = ' ') OR (ch = ',') THEN
      ix := ix + 1;
  UNTIL (ch <> ' ') OR (ch <> ',') OR (ix > bufflen);
  IF ix > bufflen THEN
    ix := 0;
END;

(* ---------------------------------------------------------- *)

PROCEDURE storevalue (VAR v: varptr;
                      VAR s: string255;
                      VAR idx: integer,
                      mode: boolean);
(* storevalue:  stores values for INPUT, DATA and LINE INPUT  *)
(*              mode = TRUE:  store whole line in string-var. *)
var
      rw, dw : real;
      chb : char;
      sb : basicstring;
      vr : varrec;
BEGIN
   vr := v^;
   IF debug3flag THEN debugp4 ('storevalue1 ', v); 
   CASE vr.varkind OF
   tokrvar: BEGIN
              readreal (rw, s, idx, dw, true);
              vr.rval^ := rw;
            END;                             
   tokivar: BEGIN
              readreal (rw, s, idx, dw, true);
              vr.ival^ := round(rw);
            END;                             
   tokbvar: BEGIN
              idx := idx - 1;
              readstring (sb, s, idx, ',');
              chb := sb^[1];
              IF (chb = 't') or (chb = 'T') THEN
                vr.bval^ := true
              ELSE
              IF (chb = 'f') or (chb = 'F') THEN
                vr.bval^ := false
              ELSE
                snerror('(storevalue) ill. bool-value ');
              dispose (sb);
            END;
   toksvar: BEGIN (* read string up to ',' or string included in '"' *)
              IF mode THEN
                BEGIN  (*  for LINE INPUT  *)
                  new (sb);
                  sb^ := s;
                  idx := strlen(s) + 1;
                END
              ELSE
                BEGIN  (*  for INPUT       *)
                  chb := ',';
                  IF (idx < strlen(s)) and (s[idx] = '"') THEN
                     BEGIN
                       chb := '"';
                       idx := idx + 1;
                     END;
                  readstring (sb, s, idx, chb);
                END;
              IF vr.sval^ = NIL THEN
                new(vr.sval^);
              vr.sval^^ := sb^;
              dispose (sb);
            END;
    END; (* CASE *)
   IF debug3flag THEN debugp4 ('storevalue2 ', v); 
END;

PROCEDURE stmterr (VAR rbuf: tokenptr; inbuf: string255ptr);
(*      Statement-Error: store input-line as comment  *)
VAR
    rt: tokenptr;
BEGIN
  IF (rbuf <> NIL) AND (rbuf^.kind <> tokstmterr) THEN
    BEGIN
      new (rt); (* insert error-token at the BEGIN of the line-list *)
      rt^.next := rbuf;
      rbuf := rt;
      rt^.kind := tokstmterr;
      new (rt^.sval);
      rt^.sval^ := inbuf^;
    END;
  writeln (' ==> ERROR in statement: ', inbuf^);
END;

(* --------------------------------------------------------------------- *)

PROCEDURE storepfvar (VAR vtoken: varnamestring;
                      VAR tv : tokenptr;
                      VAR procp, funcp : tokenptr,
                      varnumtyp : vartype);
BEGIN
  (** writeln('storxvar ',vtoken, ord(tv), ord(procp)); *)
  IF (procp <> NIL) THEN          
    BEGIN
      IF varexists (vtoken, procp^.fvar) THEN
        storevar (vtoken, tv, procp^.fvar, varnumtyp)
      ELSE
        storevar (vtoken, tv, varbase, varnumtyp);
    END
  ELSE
    IF (funcp <> NIL) THEN          
      BEGIN
        IF varexists (vtoken, funcp^.fvar) THEN
          storevar (vtoken, tv, funcp^.fvar, varnumtyp)
        ELSE
          storevar (vtoken, tv, varbase, varnumtyp);
      END
    ELSE
      storevar (vtoken, tv, varbase, varnumtyp);
END;

PROCEDURE nexttoken (VAR buf, t, tptr: tokenptr; 
                     xtok: tokenkinds);
BEGIN
  new(t);
  IF tptr = NIL THEN
    buf := t
  ELSE
    tptr^.next := t;
  tptr := t;
  t^.next := NIL;
  t^.sval := NIL;
  t^.kind := xtok;
END;
 
(* ---------------------------------------------------------- *)
(* PROCEDURE parse  parses the input-line                     *)
(* recognizes label-names after GOTO, GOSUB, RESTORE          *)
(* and also after  ON expr GOTO/GOSUB label1,label2,..        *)
(* store label with type: defined label => toklbldef          *)
(*       following: GOTO, RESTORE       => toklabel           *)
(*       following: GOSUB, PROCEDURE    => tokpname           *)
(* Terminators for names : '$' for strings,  ':' for labels   *)
(*                         '%' for integers, '!' for booleans *)
(* for PROCEDURE: stores formal parameter list                *)
(*                at PROCEDURE-token                          *)
(*   PROCEDURE pname (parlist)                                *)
(*   FUNCTION pname (parlist)                                 *)
(*   LOCAL varlist                                            *)
(* global: proctokp pointer for list with formal paramters    *)
(*         and local variables for PROCEDURE                  *)
(*  special considerations given to the key-tokens:           *)
(*    REM  string                                             *)
(*    DATA  string                                            *)
(*    LET  var = expr                                         *)
(*    RESTORE label                                           *)
(*    GOTO  label                                             *)
(*    GOSUB  label [(parlist)]                                *)
(*    PROCEDURE  label  [(parlist)]                           *)
(*    RETURN                                                  *)
(*    FUNCTION  label  [(parlist)]                            *)
(*    RETURN                                                  *)
(*    LOCAL  varlist                                          *)
(*    DEFFN label (parlist) = expression                      *)
(*    EXIT IF  =>  EXITIF                                     *)
(*    ON MENU  =>  ONMENU                                     *)
(*    ON expr GOTO labellist                                  *)
(*    ON expr GOSUB labellist                                 *)
PROCEDURE parse (inbuf : string255ptr;
                 var buf : tokenptr);
TYPE
   chset = set of char;
CONST
   idchars = chset ['A'..'Z','a'..'z','0'..'9','_','$',':','%','!'];
   kdchars = chset ['A'..'Z','a'..'z'];
VAR
   token, ttoken : varnamestring;
   t, tptr : tokenptr;
   n, d, d1 : real;
   ch : char;
   equalsign : boolean;
   jtoken, lasttokn, firsttok : tokenkinds;
   i, j, cntbrack, cntspace, inbuflen : integer;
BEGIN  (* ------------ parse --------------------- *)
  IF debug3flag THEN debugp1 ('>parse     ', inbuf); 
  tptr := NIL;
  buf := NIL;
  deffntokp := NIL;
  equalsign := false;
  i := 1;
  firsttok := toksnerr;
  cntbrack := 0;
  cntspace := 0;
  inbuflen := strlen (inbuf^);
  REPEAT (* ------------- processing-loop --------------- *)
    ch := ' ';
    skipblank (ch, inbuf^, i, cntspace);
    IF ch <> ' ' THEN
      BEGIN
        nexttoken (buf, t, tptr, toksnerr); (* make new token *)
        IF equalsign AND (buf^.kind = tokdeffn) THEN
          firsttok := toksnerr; 
        IF ch IN kdchars THEN (* =================================== *)
          BEGIN
            (** writeln ('parse0 ',tokenname[firsttok],tokenname[lasttokn]); *)
            i := i - 1;
            j := 0;
            token := '';
            while (i <= inbuflen) and (inbuf^[i] in idchars) do
              BEGIN
                IF j < varnamelen THEN
                  token := token + inbuf^[i];
                i := i + 1;
                j := j + 1;
              END;
            (** writeln ('parse1 ',token,j); *)
            lasttokn := toksnerr;
            (* LET: check if a name (possibly a token) was defined before *)
            IF (buf^.kind <> toksnerr) AND (
              ((proctokp <> NIL) AND varexists (token, proctokp^.fvar)) OR
              ((functokp <> NIL) AND varexists (token, functokp^.fvar))
              OR varexists (token, varbase)) THEN
              t^.kind := toksnerr
            ELSE
              BEGIN
                (* ========= look through token-table *)
                ttoken := token;
                upperstring (ttoken);
                FOR jtoken := tokand to tokend DO
                  IF ttoken = tokenname[jtoken] THEN
                    t^.kind := jtoken;
              END;
            lowerstring (token);
            lasttokn := t^.kind;
            IF (firsttok = toksnerr) AND (lasttokn IN
              [toklet, tokon, tokgoto, tokgosub, tokrestore, tokproc,
               tokfunc, tokreturn, tokfreturn, toklocal, tokexit,
               tokrem, tokdata, tokonmenu, tokdeffn]) THEN
              firsttok := lasttokn;
            (** writeln('parse2 ',tokenname[firsttok],' ',tokenname[lasttokn]); *)
            CASE firsttok OF (* =================================== *)
              toksnerr :
                IF lasttokn = toksnerr THEN
                  BEGIN  (* no token-name found means a variable found *)
                    IF token[strlen(token)] = ':' THEN
                      BEGIN  (* store label-name without ":" *)
                        (* setstrlen (token, strlen(token)-1); *)
                        token[strlen(token)] := chr(0);
                        storelabel (token, t, toklbldef);
                      END
                    ELSE
                      IF (buf^.kind = tokdeffn) THEN
                        storepfvar (token, t, deffntokp, NIL, typlocal)
                      ELSE
                        storepfvar (token, t, proctokp, functokp, typglobal);
                  END;
              tokrem, tokdata: readcomment (t^.sval, inbuf^, i);
              tokexit:
                BEGIN (*  combine  EXIT IF => EXITIF   *) 
                  IF ((i+3 <= inbuflen) and
                     ((str(inbuf^, i, 3) = ' if') or
                     (str(inbuf^, i, 3) = ' IF'))) THEN
                    BEGIN
                      i := i + 3;
                      t^.kind := tokexitif;
                      firsttok := tokexitif;
                    END;
                END;
            tokon:
              BEGIN (*  combine  ON MENU => ONMENU   *) 
                IF ((i+5 <= inbuflen) and
                   ((str(inbuf^, i, 5) = ' menu') or
                   (str(inbuf^, i, 5) = ' MENU'))) THEN
                  BEGIN
                    i := i + 5;
                    t^.kind := tokonmenu;
                    firsttok := tokonmenu;
                  END
                ELSE
                  IF t^.kind = tokgoto THEN
                    firsttok := toklbldef
                  ELSE
                    IF t^.kind = tokgosub THEN
                      firsttok := toklabel
                    ELSE
                      IF t^.kind = toksnerr THEN 
                        storepfvar (token, t, proctokp, functokp, typglobal);
              END;
            tokonmenu : IF t^.kind = tokgosub THEN
                          firsttok := toklabel;
            toklet: firsttok := toklettype;
            toklettype :
              BEGIN (*  LET is active only on first variable *) 
                storepfvar (token, t, proctokp, functokp, typglobal);
                firsttok := t^.kind; 
              END;
            tokgoto, tokrestore : firsttok := toklbldef;
            toklbldef : storelabel (token, t, toklabel);
            tokgosub : firsttok := toklabel;
            toklabel :  (* store PROCEDURE-name and parameters *)
              BEGIN
                IF (cntbrack = 0) THEN
                  storelabel (token, t, tokpname)
                ELSE
                  IF t^.kind = toksnerr THEN 
                    storepfvar (token, t, proctokp, NIL, typglobal)
              END;
            tokreturn :
              BEGIN
                IF proctokp <> NIL THEN
                  proctokp := NIL
                ELSE
                  IF functokp <> NIL THEN
                    BEGIN
                      t^.kind := tokfreturn;
                      firsttok := toksnerr;
                    END
                  ELSE
                    stmterr (buf, inbuf);
              END;
            tokproc :
              BEGIN
                IF functokp <> NIL THEN
                  stmterr (buf, inbuf)
                ELSE
                  BEGIN 
                    proctokp := buf;
                    proctokp^.fvar := NIL;
                    firsttok := tokpname;
                  END;
              END;
            tokpname :
              BEGIN (* check for formal parameter list in PROCEDURE *)
                IF (cntbrack = 0) THEN
                  storelabel (token, t, tokpname)
                ELSE
                  IF (cntbrack =1) AND (proctokp <> NIL) THEN
                    storevar (token, t, proctokp^.fvar, typformal)
                  ELSE
                    stmterr (buf, inbuf);
                (** writeln ('parse-PROC  ',token,cntbrack); *)
              END;
            tokfunc :
              BEGIN
                IF proctokp <> NIL THEN
                  stmterr (buf, inbuf)
                ELSE
                  BEGIN
                    functokp := buf;
                    functokp^.fvar := NIL;
                    firsttok := tokfname;
                  END;
              END;
            tokfname :
              BEGIN (* check for formal parameter list in FUNCTION *)
                IF (cntbrack = 0) THEN
                  storelabel (token, t, tokfname)
                ELSE
                  IF (cntbrack =1) AND (functokp <> NIL) THEN
                    storevar (token, t, functokp^.fvar, typformal)
                  ELSE
                    stmterr (buf, inbuf);
                (** writeln ('parse-PROC  ',token,cntbrack); *)
              END;
            toklocal: firsttok := tokloctype;
            tokloctype:
              BEGIN
                IF proctokp <> NIL THEN
                  storevar (token, t, proctokp^.fvar, typlocal)
                ELSE
                  IF functokp <> NIL THEN
                    storevar (token, t, functokp^.fvar, typlocal)
                  ELSE
                    stmterr (buf, inbuf);
                (** writeln ('parse-LOCAL ',token); *)
              END;
            tokdeffn :
              BEGIN
                deffntokp := buf;
                deffntokp^.fvar := NIL;
                firsttok := tokfn;
              END;
            tokfn :
              BEGIN (* store inline-function DEFFN *)
                IF (cntbrack = 0) THEN
                  storelabel (token, t, tokdefnam)
                ELSE
                  IF (cntbrack =1) AND (deffntokp <> NIL) THEN
                    storevar (token, t, deffntokp^.fvar, typformal)
                  ELSE
                    stmterr (buf, inbuf);
                  (** writeln ('parse-DEFFN  ',token,cntbrack); *)
              END;
            OTHERWISE
              BEGIN
                  IF lasttokn = toksnerr THEN
                    storepfvar (token, t, proctokp, functokp, typglobal); 
              END;  
            END; (* CASE firsttok OF *)
          END (*  ch IN kdchars  *)

        ELSE
        CASE ch OF (* ------------------- CASE ------------------- *)
          '''' :
            BEGIN          (* read Comment1 *)
               t^.kind := tokremp;
               readcomment (t^.sval, inbuf^, i);
            END;
          '!' :
            BEGIN          (* read Comment2 *)
              t^.kind := tokremx;
              t^.spnr := cntspace - 1;
              readcomment (t^.sval, inbuf^, i);
            END;
          '"' :
            BEGIN          (* read STRING *)
              t^.kind := tokstrg;
              readstring (t^.sval, inbuf^, i, ch);
            END;
          '0'..'9', '.' :
            BEGIN      (* read REAL or INTEGER *)
              readreal (n, inbuf^, i, d1, false);  
              IF d1 = 1.0 THEN
                BEGIN 
                  t^.kind := tokinum;
                  t^.ival := round(n);
                END
              ELSE
                BEGIN
                  t^.kind := tokrnum;
                  t^.rval := n;
                END;
            END;
          '+' : t^.kind := tokplus;
          '-' : t^.kind := tokminus;
          '*' : t^.kind := toktimes;
          '/' : t^.kind := tokdivide;
          '^' : t^.kind := tokup;
          '(' : BEGIN
                  IF (i <= inbuflen) and (inbuf^[i] = ')') THEN
                    BEGIN
                      t^.kind := tokarrtype;
                      i := i + 1;
                    END
                  ELSE
                    BEGIN
                       t^.kind := toklp;
                       cntbrack := cntbrack + 1;
                    END;
                END;
          ')' : BEGIN
                       t^.kind := tokrp;
                       cntbrack := cntbrack - 1;
                END; 
          ',' : t^.kind := tokcomma;
          ';' : t^.kind := toksemi;
          ':' : t^.kind := tokcolon;
          '?' : t^.kind := tokprint;
          '=' : BEGIN
                  IF (i+2 <= inbuflen) and 
                     (str(inbuf^, i, 2) = '=>') THEN
                    BEGIN  (*   read Statement-Error Line *)
                      i := i+2;
                      t^.kind := tokstmterr;
                      readcomment (t^.sval, inbuf^, i);
                    END
                  ELSE
                    BEGIN
                      t^.kind := tokeq;
                      equalsign := true;
                    END;
                END;
          '<' : BEGIN
                  IF (i <= inbuflen) and (inbuf^[i] = '=') THEN
                    BEGIN
                      t^.kind := tokle;
                      i := i + 1;
                    END
                  ELSE IF (i <= inbuflen) and (inbuf^[i] = '>') THEN
                    BEGIN
                      t^.kind := tokne;
                      i := i + 1;
                    END
                  ELSE
                    t^.kind := toklt;
                END;
          '>' : BEGIN
                  IF (i <= inbuflen) and (inbuf^[i] = '=') THEN
                    BEGIN
                      t^.kind := tokge;
                      i := i + 1;
                    END
                  ELSE
                    t^.kind := tokgt;
                END;
          '#' : BEGIN  (* read unit-number *)
                  j := 0;
                  while (i <= inbuflen) and (inbuf^[i] in ['0'..'9']) do
                    BEGIN
                      j := j * 10 + ord(inbuf^[i]) - ord('0');
                      i := i + 1;
                    END;
                  t^.kind := tokunit;
                  t^.unit := j;
                END;
          '@' : t^.kind := tokgosub;
          '&' : t^.kind := tokvartype;
          OTHERWISE
            BEGIN
              t^.kind := toksnerr;
              t^.sncx := ord(ch);
              stmterr (buf, inbuf);
              i := inbuflen + 1;
            END;
        END; (* CASE ch OF *)
        IF debug3flag THEN debugp2 ('parse>    ', t);
    END; (* IF CH <> ' ' *)
  UNTIL i > inbuflen;
  IF (buf <> NIL) AND (buf^.kind = tokdeffn) THEN
    nexttoken (buf, t, tptr, tokfn);
  IF (buf <> NIL) AND (buf^.kind = tokreturn) THEN
    proctokp := NIL;
  IF (buf <> NIL) AND (buf^.kind = tokfreturn) THEN
    BEGIN
      nexttoken (buf, t, tptr, tokfdef);
      functokp := NIL;
    END; 
END;

(* ---------------------------------------------------------- *)

PROCEDURE parseinput(var buf : tokenptr);
(* mod. for parsing statements without linenumbers *)
var
   l, l0, l1 : lineptr;
BEGIN
  inbuf^ := strltrim(inbuf^);
  IF directcom THEN
    curline := 0
  ELSE
    curline := curline + 1;
  (* parse rest of line *)
  parse (inbuf, buf);
 IF curline > 0 THEN  (* direct input with curline <= 0 *)
   BEGIN
     l := linebase;
     l0 := NIL;
     while (l <> NIL) and (l^.num < curline) do
       BEGIN
         l0 := l;
         l := l^.next;
       END;
     IF (l <> NIL) and (l^.num = curline) THEN
       BEGIN
         l1 := l;
         l := l^.next;
         IF l0 = NIL THEN
           linebase := l
         ELSE
           l0^.next := l;
         disposetokens(l1^.txt);
         dispose(l1);
       END;
     IF buf <> NIL THEN
       BEGIN
         new(l1);
         l1^.next := l;
         IF l0 = NIL THEN
           linebase := l1
         ELSE
           l0^.next := l1;
         l1^.num := curline;
         l1^.txt := buf;
       END;
     clearloops;
     restoredata;
   END;
END;

(* ================================================================= *)

PROCEDURE printheader (jph: char);
BEGIN
  CASE jph OF
    '0': write ('Types/Variables  ');
    '1': write ('Operations       ');
    '2': write ('Functions        ');
    '3': write ('Arithmetic       ');
    '4': write ('Structure        ');
    '5': write ('Instructions     ');
    '6': write ('direct commands  ');
    '7': write ('I/O-instructions ');
    '8': write ('System commands  ');
    '9': write ('Graphic Instr.   ');
  END; (* case *)
END;

PROCEDURE writelncnt (VAR lncnt: integer);
VAR chx: char;
BEGIN
  writeln;
  lncnt := lncnt + 1;
  IF lncnt > 20 THEN
    BEGIN
      lncnt := 0;
      write ('>');
      read (chx);
    END;
END;

PROCEDURE pntalltokens;
(* print all implemented keywords  === HELP 0 *)
const 
     linmax = 68;
     linext = 20;
var
    jtoken : tokenkinds;
    jc : char;
    linlen, lincnt, lentok : integer;
BEGIN
  writeln ('List of all internally used UNIX-commands');
  writeln ('  comedit  = ', comedit);
  writeln ('  comerase = ', comerase);
  writeln ('  comprint = ', comprint);
  writeln ('  comcat   = ', comcat);
  writeln ('  comsleep = ', comsleep);
  writeln;
  writeln ('List of all implemented KEYWORDS');
  lincnt := 7;
  FOR jc := '0' to '9' do
    BEGIN
      linlen := linmax;
      FOR jtoken := tokrvar to tokend DO
        BEGIN
          IF (tokenfunc[jtoken,1] = jc) THEN 
            BEGIN
              lentok := length(tokenname[jtoken]) + 1;
              IF (linlen+lentok >= linmax) THEN
                BEGIN
                  writelncnt (lincnt);
                  printheader (jc);
                  linlen := linext;
                END;
              linlen := linlen + lentok;
              write (' ', tokenname[jtoken]);
            END;
        END;
        writelncnt (lincnt);
    END;
END;

(* ----------------------------------------------------------- *)

PROCEDURE blockend (VAR lbl: integer; ltok: tokenkinds);
BEGIN
  IF ltok IN [tokreturn, tokfreturn, toknext, tokwend, tokloop,
              tokuntil, tokendif, tokelse, tokelseif, tokexitif] THEN
    lbl := lbl - 1;
END;

PROCEDURE blockanf (VAR lbl: integer; ltok: tokenkinds);
BEGIN
  IF ltok IN [tokproc, tokfunc, tokfor, tokwhile, tokdo, tokif,
              tokrepeat, tokelseif, tokelse, tokexitif] THEN
    lbl := lbl + 1;
END;

(* -------------------------------------------------------------- *)

PROCEDURE debugl1 (VAR l, lx: lineptr);
BEGIN
  writeln('stmtadr= ', lx^.num,' ',tokenname[lx^.txt^.kind],
                       l^.num, ' ',tokenname[l^.txt^.kind]);
END;

PROCEDURE debugl2 (VAR lx: lineptr; ltoks, ltoke: tokenkinds);
BEGIN
  writeln ('test block ', tokenname[ltoks], ' / ', tokenname[ltoke]);
  IF (lx <> NIL) THEN
    BEGIN
      write (lx^.num:6, ' ');   (**num*)
      listtokens(0, lx^.txt);
      writeln;
    END;
END;

(* -------------------------------------------------------------- *)

PROCEDURE searchtok (VAR l: lineptr; ltok: tokenkinds);
(* --------- search for next token "ltok" *)
VAR lx: lineptr;
BEGIN
  lx := NIL;
  while (l <> NIL) do
    BEGIN
      IF l^.txt = NIL THEN
        write (tfu[0],'===error== ',tokenname[ltok])
      ELSE
        IF l^.txt^.kind = ltok THEN
          BEGIN
            lx := l;
            l := NIL;
          END; 
      IF l <> NIL THEN
        l := l^.next;
    END; (* WHILE *)
  l := lx;
END;

(* -------------------------------------------------------------- *)

PROCEDURE searchlabel (VAR l: lineptr;
                       VAR lt:tokenptr;
                       nextsw: boolean;
                       stok: tokenkinds;
                       VAR lblname: varnamestring);
BEGIN
  searchtok (l, stok);
  lblname := '';
  IF l <> NIL THEN
    BEGIN
      lt := l^.txt;
      IF nextsw and (lt <> NIL) THEN
        lt := lt^.next;
      IF (lt <> NIL) and (lt^.linp <> NIL) THEN
        lblname := lt^.linp^.name;
    END;
END;

(*        structtest: assign "addresses" (lineptr) to  *)
(*                    elements in structure-blocks    === TEST 1..6 *)
(*            IF expr THEN     gets addr. from ELSEIF  *)
(*            ELSEIF expr      gets addr. from ELSE    *)
(*            ELSE             gets addr. from ENDIF   *)
(*            ENDIF            END of IF-block         *)                            
(*   FOR      WHILE   REPEAT   PROCEDURE     adr. END  *)
(*     EXITIF   EXITIF  EXITIF   EXITIF        adr. END*)
(*   NEXT     WEND    UNTIL    RETURN        END-block *)
PROCEDURE structtest (prtmode: integer;
                      ltokbstart, ltokmid1,
                      ltokmid2, ltokbend: tokenkinds);
var
    llinp : lablptr;
    varbs : varptr;
    l, lx, lz : lineptr;
    ltok : tokenkinds;
    btokstart : boolean;
    lblanks, lblbidx, lblmin, blcnt : integer;
    lblbuff : ARRAY[1..100] of lineptr;
BEGIN
  blcnt := 0;
  l := linebase;   (* scan lines => linerec *)
  REPEAT
    (* --------- search for next token "ltokbstart" *)
    btokstart := false;
    searchtok (l, ltokbstart);
    IF l <> NIL THEN
      blcnt := blcnt + 1;
    (* --------- search for "ltokmid1","ltokmid2" until "ltokbend" *)
    lz := l;
    IF debug2flag THEN debugl2 (l, ltokbstart, ltokbend);
    lblanks := 0;
    lx := NIL; 
    lblbidx := 1;
    lblbuff[lblbidx] := l;
    while (l <> NIL) do 
      BEGIN
        IF l^.txt = NIL THEN
          xrequired (toksnerr) 
        ELSE
          BEGIN (* look for first token in line *)
            btokstart := true;
            ltok := l^.txt^.kind;
            blockend (lblanks, ltok);
            IF ((ltokbstart <> tokproc) AND 
               (ltok IN [tokproc, tokreturn])) OR
               ((ltokbstart <> tokfunc) AND 
               (ltok IN [tokfunc, tokfreturn])) THEN
              BEGIN
                lx := l; 
                l := NIL;
                debugl2 (lx, ltokbstart, ltokbend);
                xrequired (ltokbend);
              END;
            IF (lblanks = 0) and
               ((ltok = ltokmid1) OR (ltok = ltokmid2)) THEN
              BEGIN
                lblbidx := lblbidx + 1;
                lblbuff[lblbidx] := l;
              END;
            IF (lblanks = 0) and (ltok = ltokbend) THEN
              BEGIN
                lblbidx := lblbidx + 1;
                lblbuff[lblbidx] := l;
                lx := l; 
                l := NIL;
              END;
            blockanf (lblanks, ltok);
          END;
        IF l <> NIL THEN
          l := l^.next;
    END; (* WHILE *)
    IF btokstart AND (lblbidx = 1) THEN
      BEGIN
        debugl2 (lz, ltokbstart, ltokbend); 
        xrequired (ltokbend);
      END;
    (* --------- set the next lineptr in tokenrec  *)
    IF (lx <> NIL) THEN
      IF (lblbidx < 2) THEN
        xrequired (ltokbend)
      ELSE
        IF ltokbstart = tokif THEN
          FOR lblanks := lblbidx DOWNTO 2 DO
            BEGIN
              lx := lblbuff[lblanks];
              l := lblbuff[lblanks-1];
              l^.txt^.goln := lx;
              IF debug2flag THEN debugl1 (l, lx);
            END
          ELSE
            BEGIN
              lx := lblbuff[lblbidx];
              lx^.txt^.goln := lblbuff[1]; 
              IF (ltokbstart = tokproc) OR (ltokbstart = tokfunc) THEN
                lblmin := 2
              ELSE
                lblmin := 1;
              FOR lblanks := lblbidx-1 DOWNTO lblmin DO
                BEGIN
                  l := lblbuff[lblanks];
                  l^.txt^.goln := lx;
                  IF debug2flag THEN debugl1 (l, lx);
                END
            END;
    l := lz;
    IF l <> NIL THEN
      l := l^.next;
  UNTIL l = NIL; 
  IF prtmode = 0 THEN
    writeln ('structtest with', blcnt:3, ' ', tokenname[ltokbstart],'/',
              tokenname[ltokbend], '-blocks');            
END;

(* -------------------------------------------------------------- *)

PROCEDURE setdefunc (mode: integer;
                     deftok: tokenkinds;
                     deftyp: vartype);
(* sets indicator on variables for DEFFN/FUNCTION-names === TEST 8..9 *)
VAR v, vx: varptr;
    lx : lineptr;
    tf : tokenptr;
    defname: varnamestring;
BEGIN
  IF mode = 0 THEN
    writeln (tokenname[deftok], ' declarations');
  lx := linebase;
  REPEAT
    searchtok (lx, deftok);
    IF (lx <> NIL) THEN
      BEGIN
        tf := lx^.txt^.next;
        IF (tf <> NIL) THEN
          BEGIN
            defname := tf^.linp^.name;
            searchvar (defname, varbase, vx, v);
            IF (v <> NIL) THEN
              BEGIN
                v^.numtype := deftyp;
                v^.defn := lx;
              END;
          END;
        IF mode = 0 THEN
          BEGIN
            write ('setdefunc ', defname, lx^.num, ' ');
            printvars (v); writeln;
          END;
        lx := lx^.next;
      END;
  UNTIL (lx = NIL);
END;
  
(* -------------------------------------------------------------- *)

PROCEDURE printltl (plin: integer; ptok: tokenkinds;
          VAR plbl: varnamestring; ptxt: integer; pon: boolean);
VAR ifill: integer;
BEGIN
  fillchars (auxfill, 10-length(tokenname[ptok]), ' ');
  write ('line', plin:6);
  IF pon THEN
    write (' ON-.-')
  ELSE
    write (' type ');
  write (tokenname[ptok], auxfill, ' name ', plbl);
  ifill := varnamelen-length(plbl);
  IF (ptok = toklbldef) THEN
    BEGIN
      write (':');
      ifill := ifill - 1;
    END;
  fillchars (auxfill, ifill, ' ');
  write (auxfill);
  IF (ptxt <> 0) THEN
    write (' => line', ptxt:6);
END;
  
PROCEDURE printlabels (ltok: tokenkinds; VAR lnc: integer);
var
    l1, l2 : lineptr;
    lblname : varnamestring;
    lt1, lt2: tokenptr;
    notlbldef: boolean;
    ltxt : integer;
BEGIN
  ltxt := 0;
  notlbldef := (ltok <> toklbldef);
  l1 := linebase;
  WHILE l1 <> NIL DO
    BEGIN
      searchlabel (l1, lt1, notlbldef, ltok, lblname);
      IF l1 <> NIL THEN
        BEGIN
          IF lt1^.goln <> NIL THEN
            BEGIN
              l2 := lt1^.linp^.lnpt;
              IF l2 <> NIL THEN
                ltxt := l2^.num;
            END;
          printltl (l1^.num, ltok, lblname, ltxt, FALSE);  
          writelncnt (lnc); 
          l1 := l1^.next;
        END;
    END;
END;

PROCEDURE setlbldef;
(* set reference for lbldef: *)
VAR lp : lineptr;
BEGIN
  lp := linebase;
  REPEAT
    searchtok (lp, toklbldef);
    IF lp <> NIL THEN
      BEGIN
        lp^.txt^.linp^.lnpt := lp;
        lp := lp^.next;
      END;
  UNTIL lp = NIL; 
END;

PROCEDURE pntlabellist;   (* === HELP 6 *)
VAR ll: lablptr;
    ln, lincnt : integer; 
    lp : lineptr;
BEGIN
  setlbldef;  (* set reference for lbldef: *)
  writeln ('List of all defined LABELS');
  lincnt := 1;
  ll := lablbase;
  WHILE ll <> NIL DO
    BEGIN
      IF ll^.lnpt = NIL
        THEN ln := 0
        ELSE ln := ll^.lnpt^.num;
      printltl (ln, ll^.ltyp, ll^.name, 0, FALSE);
      writelncnt (lincnt);
      ll := ll^.next;
    END;
END;

(* -------------------------------------------------------------- *)

PROCEDURE skiptokens (VAR lt: lineptr;
                      VAR st: tokenptr; 
                      stok: tokenkinds);
BEGIN
  st := NIL;
  IF lt <> NIL THEN
    st := lt^.txt;
  WHILE (st <> NIL) and (st^.kind <> stok) DO
    st := st^.next;
END;

PROCEDURE testgo (mode: integer;
                  ltokgo, ltokto: tokenkinds);
(* test:  GOTO label          === TEST 7 *)
(* test:  GOSUB label                    *)
var
    l1, l2: lineptr;
    lblname1, lblname2: varnamestring;
    lt1, lt2: tokenptr;
    found: boolean;
BEGIN
  IF mode = 0 THEN
    writeln ('assign: ', tokenname[ltokgo], ' ', tokenname[ltokto]);
  l1 := linebase;   (* scan lines => linerec *)
  REPEAT
    searchlabel (l1, lt1, true, ltokgo, lblname1);
    IF lblname1 <> '' THEN
      BEGIN
        l2 := linebase;
        found := false;
        REPEAT
          searchlabel (l2,lt2,(ltokto<>toklbldef),ltokto,lblname2);
          IF (lblname2 <> '') and (lblname1 = lblname2) THEN
            BEGIN
              IF mode = 0 THEN
                writeln('assign: ',tokenname[ltokgo],' ',
                        lblname1,l1^.num,' =>',l2^.num);
              found := true;
              lt1^.linp^.lnpt := l2;
            END;
          IF l2 <> NIL THEN
            l2 := l2^.next;
        UNTIL found OR (lblname2 = '');
        IF not found THEN
          xrequired (ltokto);
      END;
    IF l1 <> NIL THEN
      l1 := l1^.next;
  UNTIL (l1 = NIL);
END;

PROCEDURE testongo (mode: integer;
                    ltokon, ltokgo, ltokto: tokenkinds);
(* test: ON expr GOTO l1, l2, ...  === TEST 7 *)
(* test: ON expr GOSUB l1, l2, ... *)
(* test: ONMENU  GOSUB l1          *) 
var
    l1, l2: lineptr;
    lblname1, lblname2: varnamestring;
    lt1, lt2: tokenptr;
    found: boolean;
BEGIN
  IF mode = 0 THEN
    writeln ('assign: ', tokenname[ltokon], ' expr ', tokenname[ltokgo],
              ' ', tokenname[ltokto]);
  l1 := linebase;   (* scan lines => linerec *)
  REPEAT
    searchtok (l1, ltokon);
    IF l1 <> NIL THEN
    BEGIN
    skiptokens (l1, lt1, ltokgo);
    WHILE lt1 <> NIL DO
      BEGIN
        lblname1 := '';
        lt1 := lt1^.next;
        IF (lt1 <> NIL) and (lt1^.linp <> NIL) THEN
           lblname1 := lt1^.linp^.name;
        IF lblname1 <> '' THEN
          BEGIN
            l2 := linebase;
            found := false;
            REPEAT
              searchlabel (l2,lt2,(ltokto<>toklbldef),ltokto,lblname2);
              IF (lblname2 <> '') and (lblname1 = lblname2) THEN
                BEGIN
                  IF mode = 0 THEN
                    writeln('test-on-',tokenname[ltokgo],' - ',
                             tokenname[ltokto],' ',
                             lblname1,l1^.num,' =>', l2^.num);
                  found := true;
                  lt1^.linp^.lnpt := l2;
                END;
              IF l2 <> NIL THEN
                 l2 := l2^.next;
            UNTIL found OR (lblname2 = '');
            IF not found THEN
              xrequired (toklbldef);
          END;
          IF lt1 <> NIL THEN
            lt1 := lt1^.next;
      END;  (* WHILE *)
      l1 := l1^.next;
     END;
  UNTIL (l1 = NIL);
END;

(* -------------------------------------------------------------- *)

PROCEDURE printonlabl (ltokgo: tokenkinds; VAR lnc: integer);
var
    l1 : lineptr;
    lt1 : tokenptr;
BEGIN
  l1 := linebase;   (* scan lines => linerec *)
  REPEAT
    searchtok (l1, tokon);
    skiptokens (l1, lt1, ltokgo);
    WHILE  lt1 <> NIL DO
      BEGIN
        lt1 := lt1^.next;
        IF (lt1 <> NIL) and (lt1^.linp <> NIL) THEN
           BEGIN
             printltl (l1^.num, ltokgo, lt1^.linp^.name, 0, TRUE);
             writelncnt (lnc);
             lt1 := lt1^.next;
           END;
        END;
    IF l1 <> NIL THEN
      l1 := l1^.next;
  UNTIL (l1 = NIL);
END;

(* -------------------------------------------------------------- *)

PROCEDURE pntallabels;   (* === HELP 1 *)
VAR lincnt : integer;
BEGIN
  setlbldef;  (* set reference for lbldef: *)
  writeln (' LABELS ');
  lincnt := 1;
  printlabels (toklbldef, lincnt);
  printlabels (tokproc, lincnt);
  printlabels (tokfunc, lincnt);
  printlabels (tokgoto, lincnt);
  printlabels (tokgosub, lincnt);
  printlabels (tokrestore, lincnt);
  printonlabl (tokgoto, lincnt);
  printonlabl (tokgosub, lincnt);
END;

PROCEDURE pntallvars;   (* === HELP 2 *)
var
    lcount, lincnt : integer;
    varbs : varptr;
BEGIN
  writeln (' VARIABLES ');
  lincnt := 1;
  lcount := 0;
  varbs := varbase;
  WHILE (varbs <> NIL) DO
    BEGIN
      printvars (varbs);
      writelncnt (lincnt);
      lcount := lcount + 1;
      varbs := varbs^.next;
    END;
  writeln (lcount, ' VARIABLES');
END;

PROCEDURE pntallprocvars (ptok: tokenkinds);   (* === HELP 3..5 *)
(*  prints PROCEDURE / DEFFN / FUNCTION + LOCAL-variables *)
VAR
    lcount, lincnt : integer;
    varbs : varptr;
    lvar : lineptr;
    tproc : tokenptr;
BEGIN
  writeln (tokenname[ptok], ' FORMAL/LOCAL-variables');
  lincnt := 1;
  lcount := 0;
  lvar := linebase;
  WHILE lvar <> NIL DO
    BEGIN
      searchtok (lvar, ptok);
      IF lvar <> NIL THEN
        BEGIN
          tproc := lvar^.txt; 
          write (tokenname[ptok], ' ',tproc^.next^.linp^.name);
          writelncnt (lincnt);
          varbs := tproc^.fvar;
          WHILE (varbs <> NIL) DO
            BEGIN
              printvars (varbs);
              writelncnt (lincnt);
              lcount := lcount + 1;
              varbs := varbs^.next;
            END;
          lvar := lvar^.next;
        END;
    END;
  writeln (lcount, ' VARIABLES');
END;

(* ------------------------------------------------------ *)

PROCEDURE listprog (dunit: integer;
                    n1,n2: integer;
                    mode: boolean);
(*  === LIST, LLIST, EDIT, SAVE        *)
(*    listing indentation added with   *)
(*    PROCEDURE ... RETURN             *)
(*    WHILE ... WEND                   *)
(*    FOR ... NEXT                     *)
(*    IF .. ELSEIF .. ELSE .. ENDIF    *)
(*    REPEAT ... UNTIL                 *)
var
   l : lineptr;
   ltok : tokenkinds; 
   lblanks, lcnt : integer; 
BEGIN
   l := linebase;   (* scan lines => linerec *)
   lblanks := 0; (* indentation in program text **)
   while (l <> NIL) and (l^.num <= n2) do
     BEGIN
       IF (l^.num >= n1) THEN
         BEGIN
           IF mode THEN
             write(tfu[dunit],  l^.num:6, ' ');
           IF l^.txt = NIL 
             THEN
               write (tfu[dunit],  '===error===')
             ELSE
               BEGIN (* look for first token in line *)
                 ltok := l^.txt^.kind;
                 blockend (lblanks, ltok);
                 FOR lcnt := 1 TO lblanks DO
                   write (tfu[dunit],  '  ');
                 listtokens (dunit, l^.txt);
                 blockanf (lblanks, ltok);
               END;
             writeln (tfu[dunit]);
         END;
       l := l^.next;
     END;
END; 

(* ------------------------------------------------------ *)
PROCEDURE cplform (VAR cform: string255;
                   VAR lfidx: integer;
                   VAR cfxtr: string255;
                   VAR lf1, lf2: integer);
(* set lf1 and lf2 according to USING-Format  *)
(*     e.g. " #####.###" for number           *)
(*     e.g. " \.......\" for string           *)
VAR cx : char;
    cbp, cbn, cbs, done : boolean;
BEGIN
  cfxtr := '';
  lf1 := 0;
  lf2 := 0;
  cbp := false;
  cbs := false;
  cbn := false;
  done := false;
  while (lfidx < length(cform)) and (not done) DO
    BEGIN
      lfidx := lfidx + 1;
      cx := cform[lfidx];
      IF (cx = '#') THEN
        BEGIN
          cbn := true;
          lf1 := lf1 + 1;
          IF cbp THEN
            lf2 := lf2 + 1;
        END
      ELSE
      IF (cx = '\') THEN
        BEGIN
          cbs := true;
          lf1 := lf1 + 1;
          IF lf1 > 1 THEN done := true;
        END
      ELSE
      IF (cx = '.') THEN
        BEGIN
          IF cbs THEN
            lf1 := lf1 + 1
          ELSE
             IF cbn THEN
               BEGIN
                 cbp := true;
                 lf1 := lf1 + 1;
               END
             ELSE
               cfxtr := cfxtr + cx;
        END
      ELSE
        IF lf1 > 0 THEN
          done := true
        ELSE
          cfxtr := cfxtr + cx; 
    END;
  IF done THEN
    lfidx := lfidx - 1;
END;

(* -------------------------------------------------------------- *)

PROCEDURE cprintusval (dunit: integer;
                       VAR n : valrec;
                       VAR auxstr: string255;
                       lf1, lf2 : integer);
(*    PRINT USING "formatstring" varlist  => alpha-screen/device  *)
CONST intleng = 10;
      realeng = 20;
VAR
      cstr : string255;
      cl : integer;
BEGIN
  write (tfu[dunit], auxstr);
  CASE n.valkind OF
    tokrnum : IF lf1 = 0 THEN
                IF lf2 = 0 THEN
                  write (tfu[dunit], numtostr(n.rval))
                ELSE
                  write (tfu[dunit], n.rval:realeng:6) 
              ELSE
                write (tfu[dunit], n.rval:lf1:lf2);
    tokinum : IF lf1 = 0 THEN
                IF lf2 = 0 THEN
                  write (tfu[dunit], inumtostr(n.ival))
                ELSE
                  write (tfu[dunit], n.ival:intleng)
              ELSE
                write (tfu[dunit], n.ival:lf1);
    tokbnum : IF n.bval THEN
                write (tfu[dunit],  'TRUE ')
              ELSE
                write (tfu[dunit],  'FALSE ');
    tokstrg: BEGIN
               cstr := n.sval^;
               dispose (n.sval);
               IF lf1 = 0 THEN
                 BEGIN
                   IF lf2 <> 0 THEN
                     FOR cl := 1 TO (realeng-length(cstr)) DO
                       cstr := cstr + ' ';
                   write (tfu[dunit], cstr);
                 END
               ELSE
                 BEGIN
                   FOR cl := 1 TO (lf1-length(cstr)) DO
                     cstr := cstr + ' ';
                   write (tfu[dunit], cstr:lf1);
                 END;
             END;
  END; (* CASE *)
END;

(* -------------------------------------------------------------- *)

PROCEDURE cprinttxval (VAR txtstr: string255;
                       VAR n : valrec;
                       VAR auxstr: string255;
                       lf1, lf2 : integer);
(*    PRINT USING "formatstring"  => graphic-screen TEXT x,y,text *)
CONST intleng = 10;
      realeng = 20;
VAR
      cstr, tstr, xstr : string255;
      cl, ix : integer;
BEGIN
  txtstr := txtstr + auxstr;
  CASE n.valkind OF
    tokrnum : IF lf1 = 0 THEN
                IF lf2 = 0 THEN
                  tstr := numtostr(n.rval)
                ELSE
                  strwrite (tstr, 1, ix, n.rval:realeng:6) 
              ELSE
                strwrite (tstr, 1, ix, n.rval:lf1:lf2);
    tokinum : IF lf1 = 0 THEN
                IF lf2 = 0 THEN
                  tstr := inumtostr(n.ival)
                ELSE
                  strwrite (tstr, 1, ix, n.ival:intleng)
              ELSE
                strwrite (tstr, 1, ix, n.ival:lf1);
    tokbnum : IF n.bval THEN
                tstr := 'TRUE '
              ELSE
                tstr := 'FALSE ';
    tokstrg: BEGIN
               cstr := n.sval^;
               dispose (n.sval);
               xstr := '';
               IF lf1 = 0 THEN
                 BEGIN
                   IF lf2 <> 0 THEN
                     fillchars (xstr, realeng-length(cstr), ' ');
                   tstr := xstr + cstr;
                 END
               ELSE
                 BEGIN
                   fillchars (xstr, lf1-length(cstr), ' ');
                   tstr := cstr + xstr;
                 END;
             END;
  END; (* CASE *)
  txtstr := txtstr + tstr;
END;

PROCEDURE skipfpar (VAR t: tokenptr);
(* skip formal parameters in PROCEDURE-calls  *)
(* e.g. ON i% GOSUB p1(a,b,c),p2(d,e,f),...   *)
VAR cntbrack: integer;
BEGIN
  IF (t <> NIL) and (t^.kind = toklp) THEN
    BEGIN
      cntbrack := 1;
      t := t^.next;
      WHILE (t <> NIL) AND (cntbrack >=1) DO
        BEGIN
          IF t^.kind = toklp THEN
            cntbrack := cntbrack + 1;
          IF t^.kind = tokrp THEN
            cntbrack := cntbrack - 1;
          t := t^.next;
        END;
    END;
END;

(* ----------------------------------------------------------- *)

PROCEDURE inttoreal (VAR xval: valrec);
VAR
      intval : integer;
BEGIN
  IF (xval.valkind = tokstrg) OR 
     (xval.valkind = tokbnum) THEN
    snerror('(inttoreal) no int/real'); 
  IF (xval.valkind = tokinum) THEN
     BEGIN
       intval := xval.ival;
       xval.valkind := tokrnum;
       xval.rval := intval;
     END;
END;

PROCEDURE realtoint (VAR xval: valrec);
VAR
      realval : real;
BEGIN
  IF (xval.valkind = tokstrg) OR
     (xval.valkind = tokbnum) THEN
    snerror('(realtoint) no int/real'); 
  IF (xval.valkind = tokrnum) THEN
     BEGIN
       realval := xval.rval;
       xval.valkind := tokinum;
       xval.ival := trunc(realval);
     END;
END;

FUNCTION inot(i : integer) : integer;
BEGIN
  inot := -1 - i;
END;

FUNCTION ixor(a, b : integer) : integer;
BEGIN
  ixor := asm_ior(asm_iand(a, inot(b)), asm_iand(inot(a), b));
END;

(* ----------------------------------------------------------- *)

FUNCTION nextparam (VAR nt: tokenptr;
                    VAR nv: varptr): boolean;
(* check type of formal parameter for GOSUB/DEFFNcall *)
(* check if:  [&] variable [()]   => VALpar / VARpar  *)
BEGIN
  nextparam := false;
  nv := NIL;
  IF (nt <> NIL) AND (nt^.kind = tokvartype) THEN
    BEGIN
      nextparam := true;
      nt := nt^.next;
    END;
  IF (nt <> NIL) AND
     (nt^.kind IN [tokrvar,tokivar,tokbvar,toksvar]) THEN
    BEGIN
      nv := nt^.varp;
      nt := nt^.next;
    END;
  IF (nt <> NIL) AND (nt^.kind = tokarrtype) THEN
    BEGIN
      nextparam := true;
      nt := nt^.next;
    END;
  IF debug2flag THEN debugp4 ('nextparam ', nv); 
END;

(* ----------------------------------------------------------- *)

PROCEDURE procvarpar (VAR t: tokenptr;
                      VAR gvarp, pvarp: varptr);
(* transfer addresses of actual to formal parameters *)
(* for GOSUB and FUNCTION-call                       *)
VAR  pl, pd: integer;
     gadr: boolean;
BEGIN
  gadr := nextparam (t, gvarp);
  IF (pvarp <> NIL) AND (gvarp <> NIL) AND
     (pvarp^.varkind = gvarp^.varkind) THEN
    BEGIN
      pd := gvarp^.numdims;
      FOR pl := 1 TO pd DO
        pvarp^.dims[pl] := gvarp^.dims[pl];
      pvarp^.numdims := pd;
      pvarp^.rarr := gvarp^.rarr; 
      pvarp^.rval := gvarp^.rval; 
      pvarp^.rv   := gvarp^.rv;
    END
  ELSE
    snerror('(GOSUB) ill. parlist');
  IF debug2flag THEN debugp4 ('>procvarpar ', pvarp); 
END;

PROCEDURE procvalpar (VAR pvarp: varptr;
                      VAR gval: valrec);
(* transfer values of actual to formal parameters *)
(* for GOSUB, DEFFN-call and FUNCTION-call        *)
BEGIN
  CASE pvarp^.varkind OF
    tokrvar:
      BEGIN
        IF (gval.valkind = tokrnum) THEN
          pvarp^.rval^ := gval.rval
        ELSE
          IF (gval.valkind = tokinum) THEN
            pvarp^.rval^ := gval.ival
          ELSE
            snerror('(GOSUB) no real parameter');
      END;
    tokivar:
      BEGIN
        IF (gval.valkind = tokinum) THEN
          pvarp^.ival^ := gval.ival
        ELSE
          IF (gval.valkind = tokrnum) THEN
            pvarp^.ival^ := round(gval.rval)
          ELSE
            snerror('(GOSUB) no integer parameter');
      END;
    tokbvar:
      BEGIN
        IF (gval.valkind = tokbnum) THEN
          pvarp^.bval^ := gval.bval
        ELSE
          snerror('(GOSUB) no boolean parameter');
      END;                          
    toksvar:
      BEGIN
        IF (gval.valkind = tokstrg) THEN
          pvarp^.sval^ := gval.sval
        ELSE
          snerror('(GOSUB) no string parameter');
      END;
  END; (* CASE *)
  IF debug2flag THEN debugp4 ('procvalpar', pvarp); 
END;

(* -------------------------------------------------- *)

FUNCTION looptest (VAR lpr: looprec): boolean;
BEGIN
 looptest := false;
  with lpr do
    BEGIN
      IF vp^.varkind = tokivar THEN
        BEGIN
         IF ((step >= 0.0) and (vp^.ival^ > round(max))) or
            ((step <= 0.0) and (vp^.ival^ < round(max)))
           THEN looptest := true;
        END
      ELSE
        BEGIN
         IF ((step >= 0.0) and (vp^.rval^ > max)) or
            ((step <= 0.0) and (vp^.rval^ < max))
           THEN looptest := true;
        END;
    END;
  IF debug2flag THEN writeln('==LOOPTEST ',lpr.vp^.ival^,lpr.vp^.rval^);
END;

(* -------------------------------------------------- *)

PROCEDURE skipparen (VAR t: tokenptr);
label 1;
BEGIN
  repeat 
    IF t = NIL THEN
      snerror('(skipparen) no parenthesis');
    IF (t^.kind = tokrp) or (t^.kind = tokcomma) THEN
      goto 1;
    IF t^.kind = toklp THEN
      BEGIN
        t := t^.next;
        skipparen (t);
      END;
    t := t^.next;
  until false;
1 :
END;

PROCEDURE setvdims (VAR vr: varrec);
VAR k, adim, asize: integer;
BEGIN
  arraysize (vr, adim, asize);
  IF (asize = 0) THEN
    snerror('(setvdims) ill. variable type');
  WITH vr DO
    BEGIN
      CASE varkind OF
        tokrvar: BEGIN
                   hpm_new(rarr, asize);
                   FOR k := 0 to adim-1 do
                     rarr^[k] := 0.0;
                 END;
        tokivar: BEGIN
                   hpm_new(iarr, asize);
                   FOR k := 0 to adim-1 do
                     iarr^[k] := 0;
                 END;
        tokbvar: BEGIN
                   hpm_new(barr, asize);
                   FOR k := 0 to adim-1 do
                     barr^[k] := false;
                 END;
        tokstrg: BEGIN
                   hpm_new(sarr, asize);
                   FOR k := 0 to adim-1 do
                     sarr^[k] := NIL;
                 END;
      END; (* CASE *)
    END;
END;

PROCEDURE dimplicit (VAR v: varptr; VAR t: tokenptr);
(* (findvar)   make implicit DIM var (10,10,10,10) *)
VAR tok: tokenptr;
    i, k: integer;
BEGIN
  WITH v^ DO
    BEGIN
      (***) write ('==> implicit DIM ', name);
      tok := t;
      i := 0;
      REPEAT 
        IF i >= maxdims THEN
          snerror('(findvar) bad subscript');
        t := t^.next;
        skipparen (t);
        i := i + 1;
        dims[i] := 11;
        IF i=1 THEN
          (***) write ('(10')
        ELSE
          (***) write (',10'); 
      UNTIL t^.kind = tokrp;
      numdims := i;
      (***) writeln (')');
      setvdims (v^);
      t := tok;
    END;
END;

PROCEDURE returnadr (radrtok: tokenkinds);
VAR found : boolean;
BEGIN
  repeat
    IF loopbase = NIL THEN
      snerror('(RETURN) RETURN without GOSUB');
    found := (loopbase^.loopkind = radrtok);
    IF not found THEN
      delloop; 
  until found;
  stmtline := loopbase^.homeline;
  IF debug2flag THEN writeln('>returnadr', stmtline^.num);
END;

(* ----------------------------------------------------- *)

PROCEDURE getnum (VAR t: tokenptr; VAR num: integer);
BEGIN
  num := 0;
  IF (t <> NIL) and (t^.kind = tokinum) THEN 
    BEGIN
      num := t^.ival;
      t := t^.next;
    END;
END;

PROCEDURE getn1n2 (VAR t: tokenptr; VAR n1, n2: integer);
BEGIN
  getnum (t, n1);
  n2 := maxint;
  IF (t = NIL) or (t^.kind <> tokminus) THEN
    n2 := n1;
  IF (t <> NIL) and (t^.kind = tokminus) THEN
     BEGIN
       t := t^.next;
       getnum (t, n2); 
     END;
  IF n2 = 0 THEN
    n2 := maxint;
END;

(* ================================================================= *)

PROCEDURE exec;
VAR
   t : tokenptr;
   ioerrmsg : string255ptr;

FUNCTION factor : valrec;
   forward;

FUNCTION expr : valrec;
   forward;

FUNCTION realfactor : real;
var
   n : valrec;
   realf : real;
BEGIN
  n := factor;
  IF (n.valkind=tokstrg) or (n.valkind=tokbnum) THEN
    snerror('(realfactor) no int/real'); 
  IF (n.valkind=tokinum) THEN
    realf := n.ival
  ELSE
    realf := n.rval;
  realfactor := realf;
  IF debug3flag THEN writeln ('|realfactor       ', realf);
END;

FUNCTION upexpr : valrec;  (* for realupfactor *)
  forward;

FUNCTION realupfactor : real; (* unary "-" in factor *)
var
   n : valrec;
   realf : real;
BEGIN
  n := upexpr;
  IF (n.valkind=tokstrg) or (n.valkind=tokbnum) THEN
    snerror('(realupfactor) no int/real'); 
  IF (n.valkind=tokinum) THEN
    realf := n.ival
  ELSE
    realf := n.rval;
  realupfactor := realf;
  IF debug3flag THEN writeln ('|realupfactor     ', realf);
END;

FUNCTION strfactor : basicstring;
var
   n : valrec;
BEGIN
  n := factor;
  IF (n.valkind <> tokstrg) THEN
    snerror('(strfactor) no string'); 
  strfactor := n.sval;
  IF debug3flag THEN writeln ('|strfactor        ', n.sval^);
END;

FUNCTION stringfactor : string255;
var
   n : valrec;
BEGIN
  n := factor;
  IF (n.valkind <> tokstrg) THEN
    snerror('(stringfactor) no string'); 
  stringfactor := n.sval^;
  dispose (n.sval);
END;

FUNCTION intfactor : integer;
var intf : integer;
BEGIN
  intf := round(realfactor);
  intfactor := intf;
  IF debug3flag THEN writeln ('|intfactor        ', intf);
END;

FUNCTION boolfactor : boolean;
var
   n : valrec;
BEGIN
  n := factor;
  IF (n.valkind <> tokbnum) THEN
    snerror('(boolfactor) no boolean');
  boolfactor := n.bval;
END;

FUNCTION realexpr : real;
var
   n : valrec;
BEGIN
  n := expr;
  IF (n.valkind = tokstrg) OR 
     (n.valkind = tokbnum) THEN
    snerror('(realexpr) no int/real'); 
  IF (n.valkind = tokinum) THEN
    realexpr := n.ival
  ELSE
    realexpr := n.rval;
  IF debug3flag THEN debugp3 ('realexpr  ', n);
END;

FUNCTION strexpr : basicstring;
var
   n : valrec;
BEGIN
  n := expr;
  IF (n.valkind <> tokstrg) THEN
    snerror('(strexpr) no string');
  strexpr := n.sval;
  IF debug3flag THEN debugp3 ('strexpr   ', n);
END;

FUNCTION stringexpr : string255;
var
   n : valrec;
BEGIN
  n := expr;
  IF (n.valkind <> tokstrg) THEN
    snerror('(stringexpr) no string'); 
  stringexpr := n.sval^;
  dispose(n.sval);
  IF debug3flag THEN debugp3 ('stringexpr', n);
END;

FUNCTION intexpr : integer;
var
   n : valrec;
BEGIN
  n := expr;
  IF (n.valkind = tokstrg)  OR 
     (n.valkind = tokbnum) THEN
    snerror('(intexpr) no int/real'); 
  IF (n.valkind = tokinum) THEN
    intexpr := n.ival
  ELSE
    intexpr := round(n.rval);
  IF debug3flag THEN debugp3 ('intexpr   ', n);
END;

FUNCTION boolexpr : boolean;
var
   n : valrec;
BEGIN
  n := expr;
  IF (n.valkind = tokbnum) THEN
    boolexpr := n.bval
  ELSE
    snerror('(boolexpr) no boolean'); 
   IF debug3flag THEN debugp3 ('boolexpr  ', n);
END;

PROCEDURE require(k : tokenkinds);
BEGIN
  IF (t = NIL) or (t^.kind <> k) THEN
    srequired (k);
  t := t^.next;
END;

(* ------------------------------------------------------------------- *)

PROCEDURE callsubr (VAR t, tp: tokenptr;
                    deftok, namtok, endtok: tokenkinds);
(* transfer actual to formal parameters in      *)
(* PROCEDURE-call, DEFFN-call and FUNCTION-call *)
VAR
      gval : valrec;
      gvarp, pvarp : varptr;
      pvar : varrec;
      errtxt: errstring;
BEGIN
  errtxt := '(' + tokenname[deftok] + ') ill. parameter';
  savestmt (deftok);
  stmtline := NIL;
  IF (deftok = tokproc) AND (t^.linp <> NIL) THEN 
    stmtline := t^.linp^.lnpt;
  IF (deftok = tokdeffn) OR (deftok = tokfunc) THEN
    BEGIN
      gvarp := t^.varp;
      IF (gvarp <> NIL) THEN
        stmtline := gvarp^.defn;
    END;
  tp := NIL;
  (* === variable-list of PROCEDURE/FUNCTION/DEFFN-definition *)
  IF stmtline <> NIL THEN
    tp := stmtline^.txt
  ELSE
    snerror(errtxt);
  IF (tp <> NIL) AND (tp^.kind = deftok) THEN
    tp := tp^.next;
  IF (tp <> NIL) AND (tp^.kind = namtok) THEN
    tp := tp^.next;
  IF (tp <> NIL) AND (tp^.kind = toklp) THEN
    tp := tp^.next
  ELSE
    tp := NIL;
  t := t^.next;
  (* === variable-list of DEFFN-call *)
  IF (t <> NIL) AND (t^.kind = toklp) THEN
    t := t^.next
  ELSE
    t := NIL;
  WHILE ((tp <> NIL) AND (tp^.kind <> endtok)) DO
    BEGIN
      IF nextparam (tp, pvarp) THEN
        BEGIN
          IF deftok = tokdeffn THEN 
            snerror(errtxt)
          ELSE
            procvarpar (t, gvarp, pvarp);
        END
      ELSE
        BEGIN
          gval := expr;
          procvalpar (pvarp, gval)
        END;
      IF (t <> NIL) AND 
         ((t^.kind = tokcomma) OR (t^.kind = tokrp)) THEN
        t := t^.next
      ELSE
        snerror(errtxt);
      IF (tp <> NIL) AND
         ((tp^.kind = tokcomma) OR (tp^.kind = tokrp)) THEN
        tp := tp^.next
      ELSE
        snerror(errtxt);
    END; (* WHILE *)
  IF debug2flag THEN writeln('|callsubr    ', stmtline^.num); 
END;

(* ------------------------------------------------------------------- *)

PROCEDURE execdeffn (VAR t : tokenptr);
(* transfer actual to formal parameters in DEFFN-call *)
VAR
      tp : tokenptr;
BEGIN
  callsubr (t, tp, tokdeffn, tokdefnam, tokeq);
  loopbase^.rtok := t;   (* return-token *)
  t := tp; (* start with "="-sign *) 
  IF debug2flag THEN writeln('|execDEFFN 2 ', stmtline^.num); 
END;

PROCEDURE execfunc (VAR t : tokenptr);
(* transfer actual to formal parameters in FUNCTION-call *)
VAR
      tp : tokenptr;
BEGIN
  callsubr (t, tp, tokfunc, tokfname, tokend);
  loopbase^.rtok := t;   (* return-token *)
  stmtline := stmtline^.next;
  stmttok := stmtline^.txt;
  IF stmttok = NIL THEN
    snerror('execFUNCTION no function body');
  exec;  (* execute commands in FUNCTION-body  => fRETURN *)
  returnadr (tokfreturn);
  t := stmtline^.txt;
  delloop;
  IF debug2flag THEN writeln('|execFUNCTION ', stmtline^.num); 
END;

(* ------------------------------------------------------------------- *)

FUNCTION findvar : varptr;
var
   v : varptr;
   i, j, k : integer;
   tok : tokenptr;
BEGIN
  v := t^.varp;
  t := t^.next;
  IF (t <> NIL) and (t^.kind = toklp) THEN
    with v^ do
      BEGIN
        IF numdims = 0 THEN
          dimplicit (v, t);
        k := 0;  (* calculate position of element in array *)
        t := t^.next;
        FOR i := 1 to numdims do
          BEGIN
            j := intexpr;
            IF (j < 0) or (j >= dims[i]) THEN
              snerror('(findvar) bad subscript');
            k := k * dims[i] + j;
            IF i < numdims THEN
              require(tokcomma);
            (** writeln('FINDVAR ',name,i,j,k); *)
          END;
        require(tokrp);
        CASE varkind OF
          tokrvar: rval := addr(rarr^[k]);
          tokivar: ival := addr(iarr^[k]);
          tokbvar: bval := addr(barr^[k]);
          toksvar: BEGIN
                     IF sarr^[k] = NIL THEN
                       new (sarr^[k]);
                     sval := addr(sarr^[k]);
                   END;
        END; (* CASE *)
      END (* WITH v^ DO *)
  ELSE
    IF v^.numdims <> 0 THEN
      snerror('(findvar) bad subscript');
  findvar := v;
  IF debug2flag THEN debugp4 ('findvar   ', v);
END;

PROCEDURE getvars (VAR n: valrec; gtok: tokenkinds);
VAR v: varptr;
BEGIN
  n.valkind := gtok;
  v := findvar;
  CASE gtok OF
    tokrnum : n.rval := v^.rval^;
    tokinum : n.ival := v^.ival^;
    tokbnum : n.bval := v^.bval^;
    tokstrg :
      IF v^.sval^ = NIL THEN
        snerror('(getvars) no value assigned to string')
      ELSE
        BEGIN
          new(n.sval);
          n.sval^ := v^.sval^^;
      END;
  END;
END; (* getvars *)

(* --------------------------------------------------------------- *)
FUNCTION factor : valrec;
VAR
      v : varptr;
      n : valrec;
      i, j, k : integer;
      tok, tok1 : tokenptr;
      s, s1, s2 : basicstring;
      r1, r2 : real;
      feof : text;
BEGIN   (* --------------- factor ---------- *)  
  IF (t = NIL) THEN
    snerror('(factor) no variables');
  IF (t^.kind IN [tokrvar, tokivar, tokbvar, toksvar]) THEN
    BEGIN
      IF (t^.varp^.numtype = typdeffn) THEN
        execdeffn (t)
      ELSE
        IF (t^.varp^.numtype = typfunct) THEN
          execfunc (t);
    END; 
  tok := t;
  IF debug3flag THEN debugp2 ('factor1   ',tok);
  t := t^.next;
  n.valkind := tokrnum;
  case tok^.kind of
    tokeq   : BEGIN  (* execDEFFN =-sign *)
                n := expr;
                IF (t <> NIL) AND (t^.kind = tokfn) THEN
                  BEGIN
                    returnadr (tokdeffn);
                    t := loopbase^.rtok;
                    delloop;
                  END
                ELSE
                  snerror('(factor) ill. DEFFN-function'); 
              END;
    tokfreturn:
              BEGIN
                n := expr;
                IF (t <> NIL) AND (t^.kind = tokfdef) THEN
                  BEGIN
                    returnadr (tokfunc);
                    t := loopbase^.rtok;
                    delloop;
                  END
                ELSE
                  snerror('(factor) ill. FUNCTION-call'); 
              END;
    tokrnum : n.rval := tok^.rval;  
    tokinum : BEGIN
                n.valkind := tokinum;
                n.ival := tok^.ival;  
              END; 
    tokstrg : BEGIN
                n.valkind := tokstrg;
                new(n.sval);
                n.sval^ := tok^.sval^;  
              END;
    tokrvar : BEGIN
                t := tok;
                getvars (n, tokrnum);
              END;
    tokivar : BEGIN
                t := tok;
                getvars (n, tokinum);
              END;
    tokbvar : BEGIN
                t := tok;
                getvars (n, tokbnum);
              END;
    toksvar : BEGIN
                t := tok;
                getvars (n, tokstrg);
              END;
    toklp :   BEGIN
                n := expr;
                require(tokrp);
              END;
    tokminus : n.rval := - realupfactor; (****** unary "-" ****)
    tokplus : n.rval := realfactor;
    toknot : BEGIN                  
              n.valkind := tokbnum;
              n.bval := NOT boolfactor;
            END;
    toksqa : n.rval := sqr(realfactor);
    toksqrt : n.rval := sqrt(realfactor);
    toksin : n.rval := sin(realfactor);
    tokcos : n.rval := cos(realfactor);
    toktan : BEGIN
               n.rval := realfactor;
               n.rval := sin(n.rval) / cos(n.rval);
             END;
    tokatn : n.rval := arctan(realfactor);
    toklog : n.rval := ln(realfactor);
    toklog10 : n.rval := ln(realfactor) * 2.302585;
    tokexp : n.rval := exp(realfactor);
    tokabs : n.rval := abs(realfactor);
    tokint : BEGIN                          
               n.valkind := tokinum;
               n.ival := trunc (realfactor + 0.5);
             END;
    toktrunc : BEGIN                          
                 n.valkind := tokinum;
                 n.ival := trunc (realfactor);
               END;
    tokfrac : BEGIN                          
               n.rval := realfactor;
               n.rval := n.rval - trunc (n.rval);
             END;
    toksgn : BEGIN
               n.rval := realfactor;
               n.rval := ord(n.rval > 0.0) - ord(n.rval < 0.0);
             END;
    tokstr_ : BEGIN
                n.valkind := tokstrg;
                new (n.sval);
                n.sval^ := numtostr(realfactor);
              END;
    tokspace_ : BEGIN
                  n.valkind := tokstrg;
                  k := intfactor;
                  new (n.sval);
                  fillchars (n.sval^, k, ' ');
                END;
    tokstring_ : BEGIN
                  n.valkind := tokstrg;
                  require (toklp);
                  k := intexpr;
                  require (tokcomma);
                  s := strexpr;
                  require (tokrp);
                  new (n.sval);
                  fillchars (n.sval^, k, s^[1]);
                  dispose (s);
                END;
    tokpi : n.rval := 3.141592653;    
    toktrue : BEGIN
                n.valkind := tokbnum;
                n.bval := TRUE;
              END;
    tokfalse : BEGIN 
                 n.valkind := tokbnum;
                 n.bval := FALSE;
               END;
    tokodd :   BEGIN 
                 n.valkind := tokbnum;
                 n.bval := odd (intfactor);
               END;
    tokeof :   BEGIN                  (*  EOF (unit#)  *)
                 n.valkind := tokbnum;
                 require (toklp);
                 IF (t <> NIL) and (t^.kind = tokunit)
                   THEN
                     BEGIN
                       i := t^.unit;
                       t := t^.next;
                     END;
                 require (tokrp);
                 IF (i<1) or (i>99) THEN
                   i := 1;
                 feof := tfu[i];
                 n.bval := eof (feof);
                 feof := NIL; (* p2c closes the file at exit of PROCEDURE *)
               END;
    tokrandom : BEGIN                  (*  RANDOM (s)  0..1 *)
                  n.rval := sys_random (intfactor);
                END;
    toktimer : BEGIN
                 n.rval := sys_timer (0);
               END;
    toktime_ : BEGIN
                 n.valkind := tokstrg;
                 new (n.sval);
                 n.sval^ := sys_time (0)^;
               END;
    tokdate_ : BEGIN
                 n.valkind := tokstrg;
                 new (n.sval);
                 n.sval^ := sys_date (0)^;
               END;
    tokval : BEGIN                           (**VAL*)
               s := strfactor;
               i := 1;
               readreal (r1, s^, i, r2, true);
               n.rval := r1;
               dispose (s);
             END;
    tokchr_ : BEGIN                           (**CHR$*)
                n.valkind := tokstrg;
                new(n.sval);
                n.sval^ := ' ';
                n.sval^[1] := chr(intfactor);
              END;
    tokasc : BEGIN
               n.valkind := tokinum;
               s := strfactor;
               IF strlen(s^) = 0 THEN
                 n.ival := 0
               ELSE
                 n.ival := ord(s^[1]);
               dispose(s);
             END;
    tokinstr : BEGIN                    (*  INSTR (s$,t$)  *)
                 n.valkind := tokinum;
                 require(toklp);
                 new (s1);
                 s1^ := strexpr^;
                 require(tokcomma);
                 s2 := strexpr;
                 i := 1;
                 IF (t <> NIL) and (t^.kind = tokcomma) THEN
                   BEGIN
                     t := t^.next;
                     i := intexpr;
                   END;
                 k := strlen(s1^);
                 testival (i, 1, 255);
                 n.ival := 0;
                 IF i <= k THEN
                   BEGIN
                     new (s); 
                     s^ := str (s1^, i, k-i+1);
                     j := sys_instring (s, s2);
                     IF j > 0 THEN
                       n.ival := j + i - 1;
                     dispose (s);
                   END;
                 dispose (s1);
                 require (tokrp);
               END;
    tokmid_ : BEGIN                    (*  MID$ (s$,i,j)  *)
                n.valkind := tokstrg;
                require(toklp);
                n.sval := strexpr;
                require(tokcomma);
                i := intexpr;
                testival (i, 1, 255);
                j := 255;
                IF (t <> NIL) and (t^.kind = tokcomma) THEN
                  BEGIN
                    t := t^.next;
                    j := intexpr;
                  END;
               k := strlen(n.sval^);
               testival (j, 1, k-i+1);
               IF i > k THEN
                 n.sval^ := ''
               ELSE
                 n.sval^ := str(n.sval^, i, j);
               require(tokrp);
             END;
    tokleft_ : BEGIN                    (*  LEFT$ (s$,i)  *)
                n.valkind := tokstrg;
                require(toklp);
                n.sval := strexpr;
                i := 1; 
                IF (t <> NIL) and (t^.kind = tokcomma) THEN
                  BEGIN
                    t := t^.next;
                    i := intexpr;
                  END;
                testival (i, 1, 255);
                k := strlen(n.sval^);
                testival (i, 1, k);
                n.sval^ := str(n.sval^, 1, i);
                require(tokrp);
              END;
    tokright_ : BEGIN                    (*  RIGHT$ (s$,i)  *)
                  n.valkind := tokstrg;
                  require(toklp);
                  n.sval := strexpr;
                  i := 1;
                  IF (t <> NIL) and (t^.kind = tokcomma) THEN
                    BEGIN
                      t := t^.next;
                      i := intexpr;
                    END;
                  testival (i, 1, 255);
                  k := strlen(n.sval^);
                  testival (i, 1, k);
                  n.sval^ := str(n.sval^, k-i+1, i);
                  require(tokrp);
                END;
    tokupper_ : BEGIN                    (*  UPPER$ (s$)  *)
                  n.valkind := tokstrg;
                  require (toklp);
                  n.sval := strexpr;
                  upperstring (n.sval^);
                  require (tokrp);
                END;
    toklower_ : BEGIN                    (*  LOWER$ (s$)  *)
                  n.valkind := tokstrg;
                  require (toklp);
                  n.sval := strexpr;
                  lowerstring (n.sval^);
                  require (tokrp);
                END;
    toklen : BEGIN                       (* LEN (S$)   *)
               n.valkind := tokinum;
               s := strfactor;
               n.ival := strlen(s^);
               dispose(s);
             END;
    tokmin : BEGIN                    (*  MIN (ex,ex,..)  *)
                require(toklp);
                n.rval := realexpr;
                WHILE (t <> NIL) and (t^.kind = tokcomma) DO
                  BEGIN
                    t := t^.next;
                    r1 := realexpr;
                    IF n.rval > r1 THEN
                      n.rval := r1;
                  END;
                require (tokrp)
             END;
    tokmax : BEGIN                    (*  MAX (ex,ex,..)  *)
                require(toklp);
                n.rval := realexpr;
                WHILE (t <> NIL) and (t^.kind = tokcomma) DO
                  BEGIN
                    t := t^.next;
                    r1 := realexpr;
                    IF n.rval < r1 THEN
                      n.rval := r1;
                  END;
                require (tokrp)
             END;
    tokmousex: BEGIN
                 n.valkind := tokinum;
                 grf_mouse (n.ival, j, k);
               END;
    tokmousey: BEGIN
                 n.valkind := tokinum;
                 grf_mouse (i, n.ival, k);
               END;
    tokmousek: BEGIN
                 n.valkind := tokinum;
                 grf_mouse (i, j, n.ival);
               END;
    tokmenu : BEGIN                       (* MENU   *)
               n.valkind := tokinum;
               k := intexpr;
               n.ival := menuindex;
              END;
    tokexist: BEGIN
                n.valkind := tokbnum;
                s := strfactor;
                i := sys_exist (s);
                n.bval := (i > -1);
                dispose (s);
              END;
    otherwise
      snerror('(factor) ill. function');
    END; (* CASE *)
    factor := n;
    IF debug3flag THEN debugp3 ('factor    ', n);
 END;

(* ------------------------------------------------------------ *)

FUNCTION upexpr : valrec;
var
   n, n2 : valrec;
BEGIN
  n := factor;
  while (t <> NIL) and (t^.kind = tokup) do
    BEGIN      (* calculate:   n ^ n2  *)
      inttoreal (n);  
      t := t^.next;
      n2 := upexpr;
      inttoreal (n2);  
      IF n.rval < 0.0 THEN
        BEGIN
          IF n2.rval <> trunc(n2.rval) THEN
            n.rval := ln(n.rval);
          n.rval := exp(n2.rval * ln(-n.rval));
          IF odd(trunc(n2.rval)) THEN
            n.rval := - n.rval;
        END
      ELSE
        IF n.rval > 0.0 THEN
          n.rval := exp(n2.rval * ln(n.rval));
      IF debug3flag THEN debugp3 ('upexpr2   ', n2);
    END;
  upexpr := n;
  IF debug3flag THEN debugp3 ('upexpr    ', n);
END;

(* ------------------------------------------------------------ *)

FUNCTION term : valrec;  (*  val = val * / MOD val2 *)
var
   n, n2 : valrec;
   k : tokenkinds;
BEGIN
  n := upexpr;
  WHILE (t <> NIL) and (t^.kind in [toktimes,tokdivide,tokmod]) do
    BEGIN
      k := t^.kind;
      t := t^.next;
      n2 := upexpr;
      inttoreal (n);  
      inttoreal (n2);   
      IF k = tokmod THEN
        n.rval := round(n.rval) MOD round(n2.rval)
      ELSE
        IF k = toktimes THEN
          n.rval := n.rval * n2.rval
        ELSE
          n.rval := n.rval / n2.rval;
      IF debug3flag THEN debugp3 ('term2     ', n2);
    END;
  term := n;
  IF debug3flag THEN debugp3 ('term      ', n);
END;

(* -------------------------------------------------------- *)

FUNCTION sexpr : valrec;   (*  val = val + - val2 *)
var
      n, n2 : valrec;
      k : tokenkinds;
BEGIN
  n := term;
  while (t <> NIL) and (t^.kind in [tokplus, tokminus]) do
    BEGIN
      k := t^.kind;
      t := t^.next;
      n2 := term;
      IF (n.valkind = n2.valkind) THEN
        CASE n.valkind OF
          tokinum: IF (k = tokplus) THEN
                     n.ival := n.ival + n2.ival
                   ELSE
                     n.ival := n.ival - n2.ival;
          tokrnum: IF (k = tokplus) THEN
                     n.rval := n.rval + n2.rval
                   ELSE
                     n.rval := n.rval - n2.rval;
          tokstrg: IF (k = tokplus) THEN
                     BEGIN
                       n.sval^ := n.sval^ + n2.sval^;
                       dispose(n2.sval);
                     END
                   ELSE
                     snerror('(sexpr) ill. string-operation'); 
          tokbnum: snerror('(sexpr) no string/int/real'); 
        END
      ELSE
        BEGIN
          inttoreal (n);  
          inttoreal (n2);  
          IF (k = tokplus) THEN
            n.rval := n.rval + n2.rval
          ELSE
            n.rval := n.rval - n2.rval;
        END; 
      IF debug3flag THEN debugp3 ('sexpr2    ', n2);
    END; (* WHILE t *)
  sexpr := n;
  IF debug3flag THEN debugp3 ('sexpr     ', n);
END;

(* ----------------------------------------------------------- *)

FUNCTION relexpr : valrec;  (* bool = val compare val2 *)
var
  n, n2 : valrec;
  f : boolean;
  k : tokenkinds;
BEGIN
  n := sexpr;
  while (t <> NIL) and 
        (t^.kind in [tokeq,toklt,tokgt,tokle,tokge,tokne]) do
    BEGIN
      k := t^.kind;
      t := t^.next;
      n2 := sexpr;
      IF (n.valkind = tokbnum) OR (n2.valkind = tokbnum) THEN
        snerror('(relexpr) no real/int/string') 
      ELSE
      IF (n.valkind = tokstrg) AND (n2.valkind = tokstrg) THEN
        BEGIN
          f := ((n.sval^ = n2.sval^) and (k in [tokeq,tokge,tokle]) or
                (n.sval^ < n2.sval^) and (k in [toklt,tokle,tokne]) or
                (n.sval^ > n2.sval^) and (k in [tokgt,tokge,tokne]));
          dispose (n.sval);
          dispose (n2.sval);
          n.valkind := tokbnum;
          n.bval := f; (* return BOOLEAN as result of log. operation *)
        END
      ELSE
        BEGIN
          inttoreal (n);
          inttoreal (n2);
          f := ((n.rval = n2.rval) and (k in [tokeq,tokge,tokle]) or
                (n.rval < n2.rval) and (k in [toklt,tokle,tokne]) or
                (n.rval > n2.rval) and (k in [tokgt,tokge,tokne]));
          n.valkind := tokbnum;
          n.bval := f; (* return BOOLEAN as result of log. operation *)
       END;
      IF debug3flag THEN debugp3 ('relexpr2  ', n2);
    END;
    relexpr := n;
    IF debug3flag THEN debugp3 ('relexpr   ', n);
END;

(* ------------------------------------------------------------- *)

FUNCTION andexpr : valrec;  (* bval = bval AND bval2 *)
var
   n, n2 : valrec;
BEGIN
  n := relexpr;
  while (t <> NIL) and (t^.kind = tokand) do
    BEGIN
      t := t^.next;
      n2 := relexpr;
      IF (n.valkind <> n2.valkind) THEN
        snerror('(andexpr) unequal operands') 
      ELSE 
        IF (n.valkind = tokbnum) THEN
          n.bval := n.bval AND n2.bval
        ELSE
          IF (n.valkind = tokinum) THEN
            n.ival := asm_iand(n.ival, n2.ival)
          ELSE
            snerror('(andexpr) no int/bool'); 
      IF debug3flag THEN debugp3 ('andexpr2  ', n2);
    END;
  andexpr := n;
  IF debug3flag THEN debugp3 ('andexpr   ', n);
END;

(* ------------------------------------------------------------ *)

FUNCTION expr : valrec;  (* val = val OR/XOR val2 *) 
var
   n, n2 : valrec;
   k : tokenkinds;
BEGIN
  n := andexpr;
  WHILE (t <> NIL) and (t^.kind in [tokor, tokxor]) do
    BEGIN
      k := t^.kind;
      t := t^.next;
      n2 := andexpr;
      IF (n.valkind <> n2.valkind) THEN
        snerror('(expr) unequal operands') 
      ELSE 
        IF (n.valkind = tokbnum) THEN
          BEGIN
            IF k = tokor THEN
              n.bval := n.bval OR  n2.bval
            ELSE
              n.bval := n.bval XOR n2.bval
          END
        ELSE
          IF (n.valkind = tokinum) THEN
            BEGIN
              IF k = tokor THEN
                n.ival := asm_ior(n.ival, n2.ival)
              ELSE
                n.ival := ixor(n.ival, n2.ival);
            END
          ELSE
            snerror('(expr) no int/bool');
        IF debug3flag THEN debugp3 ('expr2     ', n2);
      END;
   expr := n;
   IF debug3flag THEN debugp3 ('expr      ', n);
END;

(* --------------------------------------------------------------- *)

PROCEDURE checkextra;
BEGIN
  IF t <> NIL THEN
    BEGIN
      writeln (chr(7));
      writeln ('###WARNING: Extra information on line');
      wstatement;
    END;
END;

FUNCTION iseos : boolean;   (* => ENDIF *)
BEGIN
  iseos := (t = NIL) or (t^.kind = tokremx);
END;

PROCEDURE skiptoeos;
BEGIN
  while not iseos do
    t := t^.next;
END;

(* ----------------------------------------------------- *)

PROCEDURE cmdend;
BEGIN
  IF stmtline <> NIL THEN
    writeln ('END ',stmtline^.num);
  stmtline := NIL;
  t := NIL;
END;

PROCEDURE cmdnew;
BEGIN
  initdevtable (true); (* close all open files *)
  cmdend;
  clearloops;
  restoredata;
  proctokp := NIL;
  functokp := NIL;
  dellabels;
  delprocvars;
  dellinebase (linebase);
  delvarbase (varbase);
END;

(* ------------------------------------------------------ *)
PROCEDURE cmdlist;   (*  LIST [ n1, n2 ]  *)
var
    n1, n2 : integer;
BEGIN
  getn1n2 (t, n1, n2);
  repeat 
    listprog (0, n1, n2, true);
    IF not iseos THEN
      require(tokcomma);
  until iseos;
END;

(* ---------------------------------------------------- *)
PROCEDURE cmdllist;
var
      dunit, n1, n2 : integer;
      f : text;
BEGIN
  IF basprogname <> '' THEN
    BEGIN
      dunit := 99;
      WHILE tfm[dunit] <> ' ' do
        dunit := dunit - 1;
      tfm[dunit] := 'O';
      rewrite (f, basprogname + '.list');
      tfu[dunit] := f;
      writeln('write listing file: ', basprogname, '.list');
      REPEAT 
        getn1n2 (t, n1, n2);
        listprog (dunit, n1, n2, true);
        IF not iseos THEN
          require(tokcomma);
      UNTIL iseos;
      close (f);
      tfm[dunit] := ' ';
      printlfile (basprogname + '.list', FALSE);    
    END;
END;
     
(* ------------------------------------------------------- *)
PROCEDURE cmdload (filnam : string255);
var
   f : text;
   buf : tokenptr;
   loadfilnam : string255;
   ll : integer;
BEGIN   (* load the file from EDIT *)
  IF filnam = '' THEN
    BEGIN
      basprogname := stringexpr;
      loadfilnam := basprogname + '.LIS';
    END
  ELSE
    loadfilnam := filnam;
  reset (f, loadfilnam);
  writeln ('read file ', loadfilnam);
  cmdnew;   (* erase the old BASIC-program *)
  directcom := false;
  while not eof(f) do
    BEGIN
      readln (f, inbuf^);
      (* delete ^M at END of line  *)
      ll := strlen (inbuf^);
      IF ((ll > 0) and (inbuf^[ll] < ' ')) THEN
        inbuf^[ll] := ' ';
        parseinput (buf);
        IF curline = 0 THEN
          BEGIN
            writeln ('Bad line in file');
            disposetokens (buf);
          END;
    END;
  close (f);
  directcom := true;
END;

(* ------------------------------------------------------- *)
PROCEDURE cmdsave (filnam: string255); 
var
   dunit: integer;
   chw : char;
   bsave : boolean;
   f: text;
BEGIN
  dunit := 99;
  while tfm[dunit] <> ' ' do
    dunit := dunit - 1;
  tfm[dunit] := 'O';
  IF filnam = ''
    THEN
      auxfill := stringexpr + '.LIS'
    ELSE
      auxfill := filnam;
  bsave := sys_exist (auxfill) <= -1;
  IF NOT bsave THEN
    BEGIN
      writeln ('File "', auxfill, '" exists! Overwrite=y');
      readln (chw);
      bsave := (chw='y') OR (chw='Y');
    END;
  IF bsave THEN
    BEGIN
      rewrite (f, auxfill);
      tfu[dunit] := f;
      listprog (dunit, 0, maxint, false);
      close (f);
      writeln ('File "', auxfill, '" written');
    END;
  tfm[dunit] := ' ';
END;

(* ------------------------------------------------------------- *)
PROCEDURE cmdsystem;
var iret: integer;
BEGIN
  iret := sys_system (stringexpr);
  IF iret <> 0 THEN
    writeln (' SYSTEM return-code=',iret);
END;

PROCEDURE cmdpause;
var iret, isec: integer;
BEGIN
  isec := intexpr;
  isec := (isec+50) div 50;
  (* 'sleep ' + inumtostr(isec) + 's' *)
  iret := sys_system (comsleep + inumtostr(isec) + 's');
END;

PROCEDURE cmdcls;
BEGIN
  IF grfopenw THEN
    grf_clearw (0)
  ELSE
    write (chr(ctrll));
END;

(* ---------------------------------------------------------- *)
PROCEDURE cmdhelp;
var
    n1 : integer;
BEGIN
  getnum (t, n1);
  IF (n1 = 0) THEN pntalltokens;
  IF (n1 = 1) THEN pntallabels;
  IF (n1 = 2) THEN pntallvars;
  IF (n1 = 3) THEN pntallprocvars (tokproc);
  IF (n1 = 4) THEN pntallprocvars (tokdeffn);
  IF (n1 = 5) THEN pntallprocvars (tokfunc);
  IF (n1 = 6) THEN pntlabellist;
END;

PROCEDURE cmdtest (mode: integer);
(* ------------- print existing labels ------------------------- *)
VAR
    ntest : integer;
    testall : boolean;
BEGIN
  testall := false;
  ntest := mode;
  IF mode = 0 THEN getnum (t, ntest);
  IF (ntest = 0) THEN
    BEGIN 
      writeln (' ====== Test all LABEL-references ');
      testall := true;
    END;
  IF testall OR (ntest = 1) THEN
    structtest (mode, tokif, tokelse, tokelseif, tokendif);
  IF testall OR (ntest = 2) THEN
    structtest (mode, tokwhile, tokexitif, tokexitif, tokwend);
  IF testall OR (ntest = 3) THEN
    structtest (mode, tokdo, tokexitif, tokexitif, tokloop);
  IF testall OR (ntest = 4) THEN
 structtest (mode, tokrepeat, tokexitif, tokexitif, tokuntil);
  IF testall OR (ntest = 5) THEN
 BEGIN
   structtest (mode, tokproc, tokexitif, tokexitif, tokreturn);
   structtest (mode, tokfunc, tokexitif, tokexitif, tokfreturn);
 END;
  IF testall OR (ntest = 6) THEN
 structtest (mode, tokfor, tokexitif, tokexitif, toknext);
  IF testall OR (ntest = 7) THEN
 BEGIN
   testgo (mode, tokgoto, toklbldef);
   testgo (mode, tokgosub, tokproc);
   testongo (mode, tokon, tokgoto, toklbldef);
   testongo (mode, tokon, tokgosub, tokproc);
   testongo (mode, tokonmenu, tokgosub, tokproc);
END;
  IF testall OR (ntest = 8) THEN
 setdefunc (mode, tokdeffn, typdeffn);
  IF testall OR (ntest = 9) THEN
 setdefunc (mode, tokfunc, typfunct);
END;

(* ---------------------------------------------------------- *)
PROCEDURE cmdrun;
BEGIN
  clearvars (varbase);(* clear variables and arrays (DIM) *)
  runtstflag := false;
  cmdtest (1); (* set jump-addresses FOR IF/ELSE/ELSEIF/ENDIF **)
  cmdtest (2);
  cmdtest (3);
  cmdtest (4);
  cmdtest (5);
  cmdtest (6);
  cmdtest (7);
  cmdtest (8);
  cmdtest (9);
  stmtline := linebase;
  gotoflag := true;
  clearloops;
  restoredata;
  proctokp := NIL;
  functokp := NIL;
  deffntokp := NIL;
  IF runtstflag THEN
 snerror('(RUN) ill. block-structure');
END;

(* -------------------------------------------------------------- *)
PROCEDURE cmdedit;
var editfilnam: string255;
 iret : integer;
BEGIN
  IF basprogname = '' THEN
 BEGIN
   writeln (' new file?  filename: ');
   readln (basprogname);
 END;
  IF basprogname <> '' THEN
 BEGIN 
   editfilnam := basprogname + '.~~~';
   cmdsave (editfilnam);
   (* comand := 'vi -c "set nu" ' + editfilnam;*) 
   iret := sys_system (comedit + editfilnam);
   cmdnew;
   cmdload (editfilnam);
   (* comand := 'rm ' + editfilnam;*) 
   iret := sys_system (comerase + editfilnam);
 END;
  directcom := true;  
END;

(* --------------------------------------------------------------- *)
PROCEDURE cmdprint;
VAR
   semiflag, commaflag, atflag, textflag : boolean;
   unitnr, lidx : integer;
   formatstr, auxstr, textstr : string255;
   lf1, lf2, ltx, lty : integer;
   nv : valrec;
BEGIN
   semiflag := false;
   commaflag := false;
   atflag := false;
   unitnr := 0;
   formatstr := '';
   lidx := 0;
   (*  ===== PRINT #unit,         *) 
   IF (not iseos) and (t^.kind = tokunit) THEN
     BEGIN
       unitnr := t^.unit;
       t := t^.next;
       IF NOT iseos THEN
         require (tokcomma);
     END;
   (*  ===== PRINT AT(x,y);       *)
   IF (not iseos) and (t^.kind = tokat) THEN
     BEGIN
       t := t^.next;
       require (toklp);
       lf1 := intexpr;
       testival (lf1, 1, 80);
       ltx := 8*lf1; 
       require (tokcomma);
       lf2 := intexpr;
       testival (lf2, 1, 25);
       lty := 16*lf2;
       require (tokrp);
       require (toksemi);
       (* the VT100 ESC-sequence does not work on "alpha-screen" *) 
       (* IF (unitnr = 0) THEN   *)
       (*  write (tfu[unitnr], chr(27),'[',chr(lf2),';',chr(lf1),'f'); *)
       IF unitnr = 0 THEN
         BEGIN
           atflag := true;
           gotoxy(lf1, lf2);
         END;
     END;
   (*  ===== PRINT USING "format" varlist        *)   
   IF (not iseos) and (t^.kind = tokusing) THEN
     BEGIN
       t := t^.next;
       IF (t <> NIL) and (t^.kind = tokstrg) THEN
         BEGIN
           formatstr := t^.sval^;
           t := t^.next;
         END
       ELSE
         snerror('(PRINT) USING "format"'); 
       require (tokcomma);
     END; 
   (*  ===== PRINT varlist                *)
   textstr := '';
   textflag := atflag AND grfopenw;
   WHILE not iseos do
      BEGIN
        semiflag := false;
        IF t^.kind in [toksemi, tokcomma] THEN
          BEGIN
            commaflag := (t^.kind = tokcomma);
            semiflag := true;
            t := t^.next;
          END
        ELSE
          IF (unitnr >= 0) AND (unitnr < 100) THEN
            BEGIN
              nv := expr;
              cplform (formatstr, lidx, auxstr, lf1, lf2);
              IF (lf1 = 0) and commaflag
                THEN lf2 := 1; 
              IF textflag THEN
                cprinttxval (textstr, nv, auxstr, lf1, lf2)
              ELSE
                cprintusval (unitnr, nv, auxstr, lf1, lf2);
            END
          ELSE
            snerror('(PRINT) #unitnr > 99'); 
      END;
   cplform (formatstr, lidx, auxstr, lf1, lf2);
   IF (auxstr <> '') THEN
     IF textflag THEN
       textstr := textstr + auxstr
     ELSE
       write (tfu[unitnr],auxstr); 
   IF not (semiflag or textflag) THEN 
     writeln (tfu[unitnr]);
   IF textflag THEN
     grf_text (ltx, lty, textstr);
END;

(* ---------------------------------------------------------------- *)
PROCEDURE cmdread;
var
      chw: char;
      v : varptr;
BEGIN
  REPEAT
    REPEAT 
      IF dataidx = 0 THEN
        BEGIN
          datastring := '';
          searchtok (dataline, tokdata);
          IF dataline = NIL THEN
              snerror('(READ) Out of Data')
          ELSE
            BEGIN
              datastring := dataline^.txt^.sval^;
              dataline := dataline^.next;
              dataidx := 1;
              (** writeln('cmdread0 ',dataidx,'|',datastring); *)
            END;
        END;
      skipsporcm (chw, datastring, dataidx);
    UNTIL dataidx > 0;
    (** writeln('cmdread1 ',dataidx,'|',datastring); *)
    v := findvar;
    storevalue (v, datastring, dataidx, false);
    (** writeln('cmdread2 ',dataidx,'|',datastring); *)
    skipsporcm (chw, datastring, dataidx);
    IF not iseos THEN
      require (tokcomma);
  until iseos;
END;

(* ---------------------------------------------------------------- *)
PROCEDURE cmdinput (mode: boolean);
var
      v : varptr;
      inputstr : string255;
      sb : basicstring;
      inputidx, unitnr : integer;
      chw : char;
      finput : text;
BEGIN
  unitnr := 100;
  (*  ===== INPUT unit#      *)
  IF (not iseos) and (t^.kind = tokunit) THEN
    BEGIN
      unitnr := t^.unit;
      t := t^.next;
      IF (not iseos) THEN
        require (tokcomma);
    END;
  (*  ===== INPUT "text"      *)
  IF (t <> NIL) and (t^.kind = tokstrg) THEN
     BEGIN
        write (t^.sval^);
        t := t^.next;
        require(toksemi);
     END;
  (*  ===== INPUT varlist  read values according to type of variable  *)
  IF (t = NIL) or NOT
     (t^.kind IN [tokrvar, tokivar, tokbvar, toksvar]) THEN
    snerror('(INPUT) ill. variable type') 
  ELSE
    BEGIN
      finput := tfu[unitnr];
      inputidx := 0;
      IF tfm[unitnr] = ' ' THEN
         snerror('(INPUT) FILE not open');
        REPEAT
          REPEAT
            IF inputidx = 0 THEN 
              BEGIN
                IF unitnr = 100 THEN
                  write ('? ');
                readln (finput, inputstr);
                inputidx := 1;
              END;
            (** writeln('cmdinput1 ',ord(finput),inputidx:3,'|',inputstr); *)
            IF not mode THEN
              skipsporcm (chw, inputstr, inputidx);
          UNTIL inputidx > 0;
          v := findvar;
          storevalue (v, inputstr, inputidx, mode);
          (** writeln('cmdinput2 ',inputidx:3,'|',inputstr); *)
          skipsporcm (chw, inputstr, inputidx);
        IF (not iseos) THEN
          require (tokcomma);
      until iseos;
    END;
    finput := NIL; (* p2c closes the file when leaving the PROCEDURE *)
END;

(* --------------------------------------------------------------- *)
PROCEDURE cmdopen;
VAR omode, tf : char;
    ounit : integer;
    f : text;
    filnam : string255;
BEGIN
  omode := ' ';
  ounit := 0;
  IF (t <> NIL) and (t^.kind = tokstrg) and (t^.sval <> NIL) THEN
    BEGIN
      omode := t^.sval^[1];
      IF omode IN ['a'..'z']
        THEN omode := chr(ord(omode)-ord('a')+ord('A'));
      t := t^.next;
    END
  ELSE
    snerror('(OPEN) no mode-string');
  IF not iseos THEN
    require (tokcomma);
  IF (t <> NIL) and (t^.kind = tokunit) THEN
    BEGIN
      ounit := t^.unit;
      t := t^.next;
    END
  ELSE
    snerror('(OPEN) no unit#');
  IF not iseos THEN
    require (tokcomma);
  tf := tfm[ounit];
  IF (ounit > 0) and (ounit < 100) and (tf = ' ') THEN
    BEGIN
      tf := omode;
      filnam := stringexpr;
      (** writeln('OPEN ',ounit:2,omode,' ',filnam); *)
      IF (omode = 'I') THEN
        BEGIN
          IF (filnam = 'CON:') OR (filnam = '') THEN 
            BEGIN
              f := input;
              tf := 'i';
            END
          ELSE 
            reset (f, filnam)
        END
      ELSE
      IF (omode = 'O') THEN
        BEGIN
          IF (filnam = 'CON:') OR (filnam = '') THEN
            BEGIN
              f := output;
              tf := 'o';
            END
          ELSE
            IF (filnam = 'PRN:') OR (filnam = 'LST:') THEN
              BEGIN
                tf := 'P';
                printname := basprogname + '.' + filnam;
                rewrite (f, printname);
              END
            ELSE 
              rewrite (f, filnam)
        END
        ELSE
          BEGIN
           tf := ' ';
           snerror('(OPEN) ill. unit#');
          END;
    END;
    tfu[ounit] := f;
    tfm[ounit] := tf;
    (** writeln('OPEN ',ounit, ' ',tf,ord(f));*)
    f := NIL; (* p2c closes the file when leaving the PROCEDURE *)
END;

(* ------------------------------------------------------------- *)
PROCEDURE cmdclose; 
VAR ounit : integer;
    tf : char;
    f : text;
BEGIN
  IF (t <> NIL) and (t^.kind = tokunit) THEN
    BEGIN
      ounit := t^.unit;
      t := t^.next;
      testival (ounit, 1, 99);
      f := tfu[ounit];
      tf := tfm[ounit];
      (** if(tf<>' ') THEN
        writeln('CLOSE #',ounit,' ',tf,' ',ord(f)); *)
      IF (tf='I') OR (tf='O') OR (tf='P') THEN
        close (f)
      ELSE
        IF NOT ((tf='i') OR (tf='o')) THEN
          snerror('(CLOSE) ill. unit#');
      IF (tf='P') THEN
        printlfile (printname, TRUE);
      tfm[ounit] := ' ';
      tfu[ounit] := output;
      f := NIL; (* p2c closes the file when leaving the PROCEDURE *)
    END
  ELSE
    initdevtable (true); (* close all open files *)
  (** writeln('CLOSE2 ', ounit); *)
END;

(* -------------------------------------------------------------- *)
PROCEDURE cmdlet (implied : integer);
var
   v : varptr;
   vr : varrec;
   old, new : basicstring;
BEGIN
  IF implied = 0 THEN  (* Variables *)
    t := stmttok;
  v := findvar;
  vr := v^;
  IF debug2flag THEN debugp4('>cmdlet   ',v); 
  require(tokeq);
  CASE vr.varkind OF
    tokrvar: vr.rval^ := realexpr;
    tokivar: vr.ival^ := intexpr;
    tokbvar: vr.bval^ := boolexpr;
    toksvar: BEGIN
               IF implied <= 1 THEN  (* LET =1  *)
                 BEGIN
                   old := vr.sval^;
                   vr.sval^ := strexpr;
                   IF old <> NIL THEN
                     dispose(old);
                 END
               ELSE
                 BEGIN  (*  LSET =2 / RSET =3  *)
                   IF vr.sval^ = NIL THEN
                     snerror('(LET) undefined string');
                   new := strexpr;
                   strlrncpy (vr.sval^^, new^, implied=2)
                 END;
             END;
  END;
  IF debug2flag THEN debugp4('cmdlet>   ',v); 
END;

(* --------------------------------------------------------- *)
PROCEDURE cmdif;
(* pointer to ELSE/ELSEIF/ENDIF-statement  in t^.goln   *)
var
   b : boolean;
   tok: tokenptr;
BEGIN
  tok := stmttok;
  elseflag := false;
  b := boolexpr;
  require (tokthen);
  IF not b THEN
    BEGIN
      elseflag := true;
      stmtline := tok^.goln;
    END; 
  t := NIL;
END;

PROCEDURE cmdelse;
BEGIN
  (** writeln('ELSE1 ',elseflag); *)
  IF elseflag THEN
    elseflag := FALSE
  ELSE
    BEGIN
      stmtline := stmttok^.goln;
      elseflag := TRUE;
    END;
  t := NIL;  
  (** writeln('ELSE2 ',elseflag); *)
END;

PROCEDURE cmdelseif;
var
   b : boolean;
   tok: tokenptr;
BEGIN
  tok := stmttok;
  elseflag := false;
  b := boolexpr;
  require(tokthen);
  IF not b THEN
    BEGIN
      elseflag := true;
      stmtline := tok^.goln;
    END;
  t := NIL; 
END;

PROCEDURE cmdendif; 
BEGIN
  elseflag := false;
  t := NIL;
END;

PROCEDURE cmdexitif;
var
      b : boolean;
      tok: tokenptr;
BEGIN
  tok := stmttok;
  xtifflag := false;
  b := boolexpr;
  IF b THEN
    BEGIN
      xtifflag := true;
      stmtline := tok^.goln;
    END; 
  t := NIL;
END;

(* ------------------------------------------------------------ *)

FUNCTION testvar : varptr;
(* test variables for DIM/ARRAYFILL/SWAP/ERASE                  *)
BEGIN
  IF (t = NIL) OR NOT
     (t^.kind IN [tokrvar, tokivar, tokbvar, toksvar]) THEN
    snerror('(testvar) ill. variable type');
  testvar := t^.varp;   
  t := t^.next;
END;

PROCEDURE getvarexp (VAR vpa : varptr;
                     VAR vxp : real;
                     VAR ars : integer);
(* gets variable and expression for: ADD, SUB, MUL, DIV *)
VAR  i, j : integer;
     tok : tokenptr;
BEGIN
  IF (t = NIL) or not (t^.kind in [tokrvar, tokivar]) THEN
    snerror('(ADD/SUB/MUL/DIV) no int/real');
  tok := t;
  vpa := t^.varp;
  t := t^.next;
  vxp := 1.0;
  ars := 0;
  IF (t <> NIL) and (t^.kind = tokarrtype) THEN
    BEGIN
      t := t^.next;
      ars := 1;
      with vpa^ DO
        BEGIN
          IF numdims = 0 THEN
            snerror('(ADD/SUB/MUL/DIV) no array');
          FOR i := 1 to numdims DO
            ars := ars * dims[i];
        END;
    END
  ELSE
    BEGIN
      t := tok;
      vpa := findvar;
    END;
  IF (t <> NIL) and (t^.kind = tokcomma) THEN
    BEGIN
      t := t^.next;
      vxp := realexpr;
    END;
END;

PROCEDURE cmdadd (bsub: boolean);
VAR vpa: varptr;
    adv: real;
    adi, ads, ix : integer;
BEGIN
  getvarexp (vpa, adv, ads);
  IF bsub THEN
    adv := - adv;
  IF (vpa^.varkind = tokrvar) THEN
    BEGIN
      IF ads = 0 THEN
        vpa^.rval^ := vpa^.rval^ + adv
      ELSE
        FOR ix := 0 to ads-1 DO
          vpa^.rarr^[ix] := vpa^.rarr^[ix] + adv;
    END
  ELSE
    BEGIN
      adi := round (adv);
      IF ads = 0 THEN
        vpa^.ival^ := vpa^.ival^ + adi
      ELSE
        FOR ix := 0 to ads-1 DO
          vpa^.iarr^[ix] := vpa^.iarr^[ix] + adi;
    END; 
END;
  
PROCEDURE cmdmul (bdiv: boolean);
VAR vpa: varptr;
    adv: real;
    adi, ads, ix : integer;
BEGIN
  getvarexp (vpa, adv, ads);
  IF bdiv THEN
    adv := 1.0 / adv;
  IF (vpa^.varkind = tokrvar) THEN
    BEGIN
      IF ads = 0 THEN
        vpa^.rval^ := vpa^.rval^ * adv
      ELSE
        FOR ix := 0 to ads-1 DO
          vpa^.rarr^[ix] := vpa^.rarr^[ix] * adv;
    END
  ELSE
    BEGIN
      adi := round (adv);
      IF ads = 0 THEN
        vpa^.ival^ := vpa^.ival^ * adi
      ELSE
        FOR ix := 0 to ads-1 DO
          vpa^.iarr^[ix] := vpa^.iarr^[ix] * adi;
    END; 
END;

PROCEDURE cmdinc (bsub: boolean);
VAR vpa: varptr;
    adi : integer;
BEGIN
  IF (t = NIL) OR NOT
     (t^.kind IN [tokrvar, tokivar]) THEN
    snerror('(INC) no int/real'); 
  vpa := findvar; 
  adi := 1;
  IF bsub THEN
    adi := - 1;
  IF (vpa^.varkind = tokrvar) THEN
    vpa^.rval^ := vpa^.rval^ + adi
  ELSE
    vpa^.ival^ := vpa^.ival^ + adi;
END;

(* ---------------------------------------------------------- *)
PROCEDURE cmdfor;
var
    lp : loopptr;
    lpr : looprec;
    saveline : lineptr;
    i, j : integer;
    forval : real;
    tok : tokenptr;
    downflag : boolean;
BEGIN
  xtifflag := false;
  downflag := false;
  IF loopflag THEN
    BEGIN
      loopflag := false;
      t := NIL;
    END
   ELSE
    BEGIN
      tok := stmttok;
      lpr.vp := findvar;      (* real or integer ! *)
      IF (lpr.vp^.varkind = toksvar) OR
         (lpr.vp^.varkind = tokbvar) THEN
        snerror('(FOR) no int/real');
      require(tokeq);
      forval := realexpr;            (* start-value *)
      IF (lpr.vp^.varkind = tokrvar) 
        THEN lpr.vp^.rval^ := forval
        ELSE lpr.vp^.ival^ := round(forval);
      IF (t <> NIL) and (t^.kind = tokto) THEN
        downflag := false
      ELSE
        IF (t<> NIL) and (t^.kind = tokdownto) THEN
          downflag := true
        ELSE
          snerror('(FOR) no TO/DOWNTO'); 
      t := t^.next;
      lpr.max := realexpr;
      IF (t <> NIL) and (t^.kind = tokstep) THEN
        BEGIN
          t := t^.next;
          lpr.step := realexpr;
        END
      ELSE
         lpr.step := 1.0;         (**!!*)
      IF downflag THEN   (*  DOWNTO  *)
        lpr.step := -lpr.step;
      lpr.homeline := stmtline;
      lpr.loopkind := tokfor;
      lpr.next := loopbase;
      new(lp);
      lp^ := lpr;
      loopbase := lp;
      IF debug2flag THEN pntloops;
      IF looptest (lpr) THEN
        BEGIN
          xtifflag := true;
          stmtline := tok^.goln; (* => NEXT *)
        END;
      (** writeln ('==FOR 2 ',forval,lpr.max,lpr.step); *)
    END;
END;

(* -------------------------------------------------- *)
PROCEDURE cmdnext;
(* xtifflag = true    from EXITIF => force END of loop *)
var
   v : varptr;
   found : boolean;
BEGIN
(** writeln ('==NEXT 1');  *)
  loopflag := false;
  IF not iseos THEN
    v := findvar
  ELSE
    v := NIL;
  repeat
    IF (loopbase = NIL) or (loopbase^.loopkind = tokgosub) THEN 
      snerror('(NEXT) NEXT without FOR');
    found := (loopbase^.loopkind = tokfor) and
             ((v = NIL) or (loopbase^.vp = v));
    IF not found THEN
       delloop;
  until found;
  IF xtifflag THEN (*  force END of FOR-NEXT-loop  *)
    delloop
  ELSE
    WITH loopbase^ do
      BEGIN
      (** writeln ('==NEXT 2 ', vp^.ival^, vp^.rval^); *)
      (*  increment FOR-Variable   *)
        IF vp^.varkind = tokivar
          THEN
            vp^.ival^ := vp^.ival^ + round (step)
          ELSE
            vp^.rval^ := vp^.rval^ + step;
        IF looptest (loopbase^) THEN
          delloop
        ELSE
          BEGIN
            stmtline := homeline;
            loopflag := true;
          END;
      END;
  xtifflag := false;
  (** writeln ('==NEXT 3 ',loopflag,xtifflag); *)
END;

(* -------------------------------------------------------- *)
PROCEDURE cmdwhile (loop: boolean);
(*  token WHILE has the lineptr to token WEND               *)
VAR tok: tokenptr;
BEGIN
  tok := stmttok; 
  xtifflag := false;
  IF not loop THEN
    IF NOT boolexpr THEN
      BEGIN
        stmtline := tok^.goln;
        xtifflag := true;
      END;
END;

PROCEDURE cmdwend;
(*  token WEND has the lineptr to token WHILE            *)
(*  xtifflag = false  from WHILE                         *)
(*  xtifflag = true   from EXITIF => force END of loop   *)
var
  tok : tokenptr;
BEGIN
  tok := stmttok;
  IF xtifflag THEN
    BEGIN
      t := NIL;
      xtifflag := false; 
    END
  ELSE
    BEGIN
      stmtline := tok^.goln;
      xtifflag := true;
    END;
END;

(* --------------------------------------------------- *)
PROCEDURE cmdrepeat;
BEGIN
  xtifflag := false; 
END;

PROCEDURE cmduntil;
VAR tok: tokenptr;
BEGIN
  tok := stmttok; 
  xtifflag := false;
  IF NOT boolexpr THEN
    BEGIN
      stmtline := tok^.goln;
      xtifflag := true;
    END;
END;
 
(* --------------------------------------------------- *)
PROCEDURE cmdgoto;
BEGIN
  IF t = NIL THEN
    snerror('(GOTO) no label')
  ELSE
    stmtline := t^.linp^.lnpt;    
  t := NIL;
  gotoflag := true;
  (** writeln('cmdgoto ', stmtline^.num); *)
END;

(* ------------------------------------------------ *)
 
PROCEDURE cmdgosub;
(*  loopflag is used by RETURN to execute the statement *)
(*           following GOSUB.                           *)
(*  gotoflag is used by GOSUB/GOTO to branch to the     *)
(*           statement set in stmtline.                 *)
   var
      tp : tokenptr;
BEGIN
  IF NOT loopflag THEN
    BEGIN
      callsubr (t, tp, tokproc, tokpname, tokend);
      gotoflag := true;
   END;
  loopflag := false;
  t := NIL;
  IF debug2flag THEN writeln('==GOSUB 2 ', stmtline^.num);
END;

(* -------------------  ------------------------------ *)
PROCEDURE cmdon;
var
      i : integer;
      gokind : tokenkinds;
      ltok : tokenptr;
BEGIN
  IF NOT loopflag THEN
    BEGIN
      i := intexpr;
      IF (t <> NIL) and
        ((t^.kind = tokgosub) OR (t^.kind = tokgoto)) THEN
        BEGIN
          gokind := t^.kind;
          t := t^.next;
          IF i < 1 THEN
            skiptoeos
          ELSE
            BEGIN
              ltok := t;
              (** writeln ('ON ',i:2,' ',tokenname[gokind],
                   '    ',ltok^.linp^.name,
                   '   line=',ltok^.linp^.lnpt^.num); *)
              while (i > 1) and not iseos do
                BEGIN
                  IF (gokind = tokgosub) THEN
                    BEGIN
                      require (tokpname);
                      skipfpar (t);
                    END;
                  IF (gokind = tokgoto) THEN
                    require (toklabel);
                  IF not iseos THEN
                    require (tokcomma);
                  i := i - 1;
                  ltok := t;
                  (** IF (ltok<>nil) THEN
                      writeln ('ON ',i:2,' ',tokenname[gokind],
                   '    ',ltok^.linp^.name,
                   '   line=',ltok^.linp^.lnpt^.num); *)
                END;
              IF not iseos THEN
                IF gokind = tokgosub THEN
                  BEGIN
                    t := ltok;
                    loopflag := false;
                    cmdgosub;
                  END
                ELSE
                  cmdgoto;
            END;
        END
        ELSE
          snerror('(ON) no GOTO/GOSUB');
  END
  ELSE
    t := NIL;
  loopflag := false;
END;

(* ----------------------------------------------------------------- *)
PROCEDURE cmdproc;
BEGIN
(**  writeln ('==PROCEDURE ',t^.linp^.name); *)
  skiptoeos;
  gotoflag := false;
END;

(* -------------------------------------------------------- *)
PROCEDURE cmdreturn;
BEGIN
  returnadr (tokproc);
  delloop;
  loopflag := true;
  skiptoeos;
  (** writeln ('==RETURN 1 ',ord(stmtline)); *)   
END;

PROCEDURE cmdfreturn;
BEGIN
  savestmt (tokfreturn);
  t := NIL;
  stmtline := NIL;  (* => exit from procedure exec *)
  (** writeln ('==FRETURN 1 ',ord(stmtline)); *)   
END;

PROCEDURE cmdrestore;
BEGIN
  restoredata;
  IF NOT iseos THEN
    dataline := t^.linp^.lnpt;
  t := NIL;
END;

(* ---------------------------------------------------------- *)
PROCEDURE cmddim;
var
   i, k, adim, asize : integer;
   v : varptr;
   vr : varrec;
   done : boolean;
BEGIN
  REPEAT
    v := testvar;
    vr := v^;
    with vr do
      BEGIN
        IF numdims <> 0 THEN
          snerror('(DIM) Array already dimensioned');
        i := 0;
        require(toklp);
        repeat                (* get dimension values *)
          k := intexpr + 1;
          IF (k < 1) OR (i >= maxdims) THEN
            snerror('(DIM) bad subscript');
          i := i + 1;
          dims[i] := k;
          done := (t <> NIL) and (t^.kind = tokrp);
          IF not done THEN
            require(tokcomma);
        until done;
        IF (numtype = typformal) OR (numtype = typdeffn) THEN
          snerror('(DIM) ill. variable type');   
        t := t^.next;
        numdims := i;
      END;
    arraysize (vr, adim, asize);
    IF asize = 0 THEN
      snerror('(ARRAY) ill. variable type');
    setvdims (vr);
    IF not iseos THEN
      require(tokcomma);
    v^ := vr;
  UNTIL iseos;
END;

(* ------------------------------------------------------- *)
PROCEDURE cmdarrayfill;
var
   i, adim, asize : integer;
   v : varptr;
   vr : varrec;
   valr : real;
   vali : integer;
   valb : boolean;
   vals, vold : basicstring;
BEGIN
  repeat
    v := testvar;
    vr := v^;
    require(tokarrtype);
    require(tokcomma);
    with vr do
      BEGIN
        IF numdims = 0 THEN
          snerror('(ARRAYFILL) no array');
        arraysize (vr, adim, asize);
        IF asize = 0 THEN
          snerror('(ARRAYFILL) ill. variable type');
        CASE varkind OF
          tokrvar: BEGIN
                     valr := realexpr;
                     FOR i := 0 to adim-1 do
                       rarr^[i] := valr;
                   END;
          tokivar: BEGIN
                     vali := intexpr;
                     FOR i := 0 to adim-1 do
                       iarr^[i] := vali;
                   END;
          tokbvar: BEGIN
                     valb := boolexpr;
                     FOR i := 0 to adim-1 do
                       barr^[i] := valb;
                   END;
          toksvar: BEGIN
                     vals := strexpr;
                     FOR i := 0 to adim-1 do
                       BEGIN
                         vold := sarr^[i];
                         sarr^[i] := NIL;
                         IF vals <> NIL THEN
                           BEGIN
                             new (sarr^[i]);
                             sarr^[i]^ := vals^;
                           END;
                         IF vold <> NIL THEN
                           dispose (vold);  
                       END;
                   END;
        END; (* CASE *)
      END;
    IF not iseos THEN
      require (tokcomma);
  until iseos;
END;

(* -------------------------------------------------- *)
PROCEDURE cmdswap;
var
    vp1, vp2 : varptr;
    rhelp : real;
    phelp : rarrayptr;
    noteq : boolean;
    k, ld : integer;
    tok : tokenptr;
BEGIN
  noteq := false;
  ld := 0;
  tok := t;
  vp1 := testvar;
  IF (t <> NIL) and (t^.kind = tokarrtype) THEN
    BEGIN
      ld := vp1^.numdims;
      noteq := true;
      t := t^.next;
    END
  ELSE
    BEGIN
      t := tok;
      vp1 := findvar;
    END;
  require (tokcomma);
  tok := t;
  vp2 := testvar;
  IF (t <> NIL) and (t^.kind = tokarrtype) THEN
    BEGIN
      noteq := NOT noteq;
      t := t^.next;
    END
  ELSE
    BEGIN
      t := tok;
      vp2 := findvar;
    END;
  noteq := noteq OR (vp1^.varkind <> vp2^.varkind);
  FOR k := 1 to ld DO
    noteq := noteq OR (vp1^.dims[k] <> vp2^.dims[k]);
  IF noteq THEN
    snerror('(SWAP) TYPE of variables are not equal');
  IF ld = 0 THEN
    BEGIN
      rhelp := vp1^.rv;
      vp1^.rv := vp2^.rv;
      vp2^.rv := rhelp;
    END
  ELSE
    BEGIN
      phelp := vp1^.rarr;
      vp1^.rarr := vp2^.rarr;
      vp2^.rarr := phelp;
    END;
END;

(* -------------------------------------------------------------- *)
PROCEDURE cmderase;
var
    v: varptr;
BEGIN
  repeat
    v := testvar;
    require(tokarrtype);
    clearvar (v);
    IF not iseos THEN
      require(tokcomma);
    IF debug2flag THEN debugp4('ERASE     ',v);
  until iseos;
END;

PROCEDURE cmdclr;
var
   v : varptr;
BEGIN
  REPEAT
    v := findvar;
    clearvar (v);
    IF not iseos THEN
      require (tokcomma); 
    IF debug2flag THEN debugp4('CLR       ',v);
  UNTIL iseos; 
END;

(* cmdpoke deleted *)

PROCEDURE cmdtron; 
BEGIN
  traceflag := true;
  tracemode := 0; 
  IF t <> NIL THEN
    BEGIN
      tracemode := t^.ival;
      t := t^.next;
    END;
  debug3flag := (tracemode >= 3); 
  debug2flag := (tracemode >= 2); 
END;

PROCEDURE cmdtroff;
var nlin: integer;
BEGIN
  getnum (t, nlin);
  IF nlin = 0 THEN
    BEGIN
      traceflag := false;
      debug3flag := false;
      debug2flag := false;
    END
  ELSE
    pntlwtok (nlin);
END;

(* -------------------------------------------------------- *)
PROCEDURE cmdbye;
BEGIN
  cmdnew;
  exitflag := true;
END;

(* -------------------------------------------------------- *)

PROCEDURE getvalue (VAR v, m: integer);
(*  v value returned for graphic commands  *)
(*  m=0 "," / m=1 "TO" / m=-1  END-of-line *)
BEGIN
  IF m >= 0 THEN
    BEGIN
      IF (t <> NIL) and (t^.kind <> tokcomma) THEN
        v := intexpr;
      m := -1;
      IF t <> NIL THEN
        BEGIN
          IF t^.kind = tokcomma THEN
            m := 0;
          IF t^.kind = tokto THEN
            m := 1;
          IF m >= 0 THEN
            t := t^.next;
        END; 
    END; 
END;

(* -------------------------------------------------------- *)
PROCEDURE cmdtitlew;
VAR n: integer;
    title: string255;
BEGIN
  grfgmode := 0;
  getvalue (n, grfgmode);
  title := stringexpr;
  grf_titlew (n, title);    
END;

PROCEDURE cmdinfow;
VAR n: integer;
    info: string255;
BEGIN
  grftestwin;
  getvalue (n, grfgmode);
  info := stringexpr;
  grf_infow (n, info);    
END;

PROCEDURE cmdopenw;
VAR n,x,y: integer;
BEGIN
  grfgmode := 0;
  n := 0;
  getvalue (n, grfgmode);
  x := 0;
  getvalue (x, grfgmode);
  y := 0;
  getvalue (y, grfgmode);
  IF (n <> 0) or not grfopenw
    THEN grf_openw (n, x, y);
  IF n = 0 THEN 
    BEGIN
      grfopenw := true;
      grflocator := 0;
      grf_defmouse (grflocator, 1);  (* enable locator *)
    END;
END;

PROCEDURE cmdclearw;
VAR n: integer;
BEGIN
  grftestwin;
  n := 0;
  getvalue (n, grfgmode);
  grf_clearw (n);
END;

PROCEDURE cmdclosew;
VAR n: integer;
BEGIN
  grfgmode := 0;
  n := 0;
  getvalue (n, grfgmode);
  grf_closew (n);
  IF n = 0 THEN 
    BEGIN
      grfopenw := false;
      grflocator := 1;
      grf_defmouse (grflocator, 0);  (* disable locator *)
    END;
END;

PROCEDURE cmdcolor;
VAR cd, cb: integer;
BEGIN
  grfgmode := 0;
  getvalue (cd, grfgmode);
  getvalue (cb, grfgmode);
  grf_color (cd, cb);
END;

PROCEDURE cmdsetcolor;
VAR i,r,g,b: integer;
BEGIN
  grfgmode := 0;
  getvalue (i, grfgmode);
  getvalue (r, grfgmode);
  getvalue (g, grfgmode);
  getvalue (b, grfgmode);
  grf_setcolor (i, r, g, b);
END;

PROCEDURE cmdgraphmode;
VAR n: integer;
BEGIN
  grfgmode := 0;
  n := 1;
  getvalue (n, grfgmode);
  grf_graphmode (n);
END;

PROCEDURE cmddeffill;
VAR c,a,b: integer;
BEGIN
  grfgmode := 0;
  c := 0;
  getvalue (c, grfgmode);
  getvalue (a, grfgmode);
  getvalue (b, grfgmode);
  grf_deffill (c, a, b);
END;

PROCEDURE cmddefline;
VAR s,b: integer;
BEGIN
  grfgmode := 0;
  s := 1;
  getvalue (s, grfgmode);
  b := 1;
  getvalue (b, grfgmode);
  grf_defline (s, b);
END;

PROCEDURE cmddefmark;
VAR c, a, g: integer;
BEGIN
  grfgmode := 0;
  c := 1; 
  getvalue (c, grfgmode);
  a := 1;
  getvalue (a, grfgmode);
  g := 10;
  getvalue (g, grfgmode);
  grf_defmark (c, a, g);
END;

PROCEDURE cmddeftext;
VAR c, s, r, g: integer;
BEGIN
  grfgmode := 0;
  C := 1;
  getvalue (c, grfgmode);
  s := 1;
  getvalue (s, grfgmode);
  getvalue (r, grfgmode);
  getvalue (g, grfgmode);
  grf_deftext (c, s, r, g);
END;

PROCEDURE cmdplot (mode: integer);
VAR x0,x1,y0,y1: integer;
BEGIN
  grftestwin;
  getvalue (x0, grfgmode);
  getvalue (y0, grfgmode);
  IF mode = 1 THEN
    grf_plot (x0, y0)
  ELSE
    BEGIN
      IF (mode = 3) and (grfgmode =-1) THEN
        grf_plot (x0, y0)
      ELSE
        BEGIN
          REPEAT    
            getvalue (x1, grfgmode);
            getvalue (y1, grfgmode);
            grf_line (x0, y0, x1, y1);
            x0 := x1;
            y0 := y1;
          UNTIL grfgmode < 0;
        END;
    END;
END;

(*   LINE x,y   *)
(*   LINE INPUT *)
PROCEDURE cmdline;
BEGIN
  IF (t <> NIL) and (t^.kind = tokinput) 
    THEN
      BEGIN
        t := t^.next;
        cmdinput (true);
      END
    ELSE
      cmdplot (2);
END;

PROCEDURE cmdtext;
VAR x,y: integer;
    s : string255;
BEGIN
  grftestwin;
  getvalue (x, grfgmode);
  getvalue (y, grfgmode);
  s := stringexpr;
  grf_text (x, y, s);
END;

PROCEDURE cmdfill;
VAR x, y: integer;
BEGIN
  grftestwin;
  getvalue (x, grfgmode);
  getvalue (y, grfgmode);
  grf_fill (x, y);
END;

PROCEDURE cmdbox (mode: integer);
VAR x0,x1,y0,y1: integer;
BEGIN
  grftestwin;
  getvalue (x0, grfgmode);
  getvalue (y0, grfgmode);
  getvalue (x1, grfgmode);
  getvalue (y1, grfgmode);
  CASE mode OF
    1: grf_box (x0, y0, x1, y1);
    2: grf_pbox (x0, y0, x1, y1);
    3: grf_rbox (x0, y0, x1, y1);
    4: grf_prbox (x0, y0, x1, y1);
  END;
END;

PROCEDURE cmdcircle (mode: integer);
VAR x, y, r, p0, p1: integer;
BEGIN
  grftestwin;
  getvalue (x, grfgmode);
  getvalue (y, grfgmode);
  getvalue (r, grfgmode);
  p0 := 0;
  getvalue (p0, grfgmode);
  p1 := 0;
  getvalue (p1, grfgmode);
  CASE mode OF
    1: grf_circle  (x, y, r, p0, p1);
    2: grf_pcircle (x, y, r, p0, p1);
  END;
END;

PROCEDURE cmdellipse (mode: integer);
VAR x, y, rx, ry, p0, p1: integer;
BEGIN
  grftestwin;
  getvalue (x, grfgmode);
  getvalue (y, grfgmode);
  getvalue (rx, grfgmode);
  getvalue (ry, grfgmode);
  p0 := 0;
  getvalue (p0, grfgmode);
  p1 := 0;
  getvalue (p1, grfgmode);
  CASE mode OF
    1: grf_ellipse  (x, y, rx, ry, p0, p1);
    2: grf_pellipse (x, y, rx, ry, p0, p1);
  END;
END;

PROCEDURE cmddefmouse (mode: integer);
VAR n: integer;
BEGIN
  grftestwin;
  n := 0;
  IF mode = 4 THEN  (* DEFMOUSE *)
    BEGIN
      getvalue (n, grfgmode);
      IF n < 0 THEN n := 0;
    END;
  grf_defmouse (grflocator, mode+n);  (* HIDEM:0, SHOWM:1 *)
END;

PROCEDURE cmdmouse;
VAR vx, vy, vk: varptr;
    gx, gy, gk: integer;
BEGIN
  grftestwin;
  grf_defmouse (grflocator, 1);
  vx := findvar;
  IF vx^.varkind <> tokivar THEN
    snerror('(MOUSE) no int value');
  require (tokcomma);
  vy := findvar;
  IF vy^.varkind <> tokivar THEN
    snerror('(MOUSE) no int value');
  require (tokcomma);
  vk := findvar;
  IF vk^.varkind <> tokivar THEN
    snerror('(MOUSE) no int value');
  grf_mouse (gx, gy, gk);
  vx^.ival^ := gx;
  vy^.ival^ := gy;
  vk^.ival^ := gk;
END;

PROCEDURE cmdpolyline (mode: integer);
VAR n: integer;
    gx, gy : iarrayptr;
BEGIN
  grftestwin;
  getvalue (n, grfgmode);
  IF (t <> NIL) and (t^.kind = tokivar) and (t^.varp^.numdims = 1)
    THEN
      BEGIN
        gx := t^.varp^.iarr; 
        t := t^.next;
      END;
  require (tokarrtype);
  require (tokcomma);
  IF (t <> NIL) and (t^.kind = tokivar) and (t^.varp^.numdims = 1)
    THEN
      BEGIN
        gy := t^.varp^.iarr;
        t := t^.next;
      END; 
  require (tokarrtype); 
  CASE mode OF
    1: grf_polyline (n, gx, gy);
    2: grf_polyfill (n, gx, gy);
    3: grf_polymark (n, gx, gy);
  END;
END;

PROCEDURE cmdalert;
VAR ga, gb, gloc: integer;
    gst, gsb: string255;
    vv : varptr;
BEGIN
  grftestwin;
  gloc := grflocator;
  grf_defmouse (grflocator, 1); (* switch on cursor *)
  getvalue (ga, grfgmode);
  gst := stringexpr;
  require (tokcomma);
  getvalue (gb, grfgmode);
  gsb := stringexpr;
  require (tokcomma);
  vv := findvar;
  IF vv^.varkind <> tokivar THEN
    snerror('(ALERT) no int value');
  grf_alert (ga, gst, gb, gsb, vv^.ival^);
  (* writeln('grf_alert ',ga,gst,gb,gsb,vv^.ival^); *)
  IF gloc = 0 THEN
    grf_defmouse (grflocator, 0); (* switch off cursor *)
END;

PROCEDURE cmdfileselect;
VAR
    gss, gsn: string255;
    vv : varptr;
    gloc : integer;
BEGIN
  grftestwin;
  gloc := grflocator;
  grf_defmouse (grflocator, 1); (* switch on cursor *)
  gss := stringexpr;
  require (tokcomma);
  gsn := stringexpr;
  require (tokcomma);
  vv := findvar;
  IF vv^.varkind <> toksvar THEN
    snerror('(FILESELECT) no string');
  IF (vv^.sval^ = NIL) THEN
    new(vv^.sval^);
  grf_fileselect (gss, gsn, vv^.sval^^);
  IF gloc = 0 THEN
    grf_defmouse (grflocator, 0); (* switch off cursor *)
END;

PROCEDURE cmdmenu;
VAR sfield: varptr;
    mn, mx : integer;
BEGIN
  grftestwin;
  IF (t = NIL) THEN
    snerror('(MENU) no parameter');
  IF (t^.kind = toksvar) THEN
    BEGIN  (* MENU array() *)
      sfield := t^.varp;
      t := t^.next;
      IF (t <> NIL) and (t^.kind = tokarrtype) THEN
        grf_menu (0, mn, sfield^.sarr);
    END
  ELSE
    BEGIN
      IF (t^.kind = tokstop) THEN
        grf_menu (2, mx, NIL)
      ELSE
        BEGIN  (*  MENU n,x  *)
          getvalue (mn, grfgmode);
          getvalue (mx, grfgmode);
          IF (mx < 0) THEN mx := 0; 
          grf_menu (mx+4, mn, NIL);
        END;
    END;
  t := NIL;
END;

PROCEDURE cmdonmenu;
VAR  l : loopptr;
     gloc : integer; 
BEGIN
 (* writeln('cmdonmenu-1'); *)
  grftestwin;
  IF NOT loopflag THEN
    BEGIN
      IF (t <> NIL) THEN
        BEGIN  (* define menu-interrupt-PROCEDURE *)
          IF (t^.kind = tokgosub) THEN
            t := t^.next;
            (** writeln('cmdonmenu- define interrupt ',
               tokenname[t^.kind], ' ',t^.linp^.name); *)
          IF (t <> NIL) and (t^.kind = tokpname) and (t^.linp <> NIL) THEN
            menuprocp := t^.linp^.lnpt
          ELSE
            snerror('(ONMENU) no procedure'); 
        END
      ELSE
        BEGIN  (* execute the menu, wait for action *)
          (*  writeln('cmdonmenu MENU'); *)
          gloc := grflocator;
          grf_defmouse (grflocator, 1); (* switch on cursor *)
          grf_menu (1, menuindex, NIL);
          IF gloc = 0 THEN
            grf_defmouse (grflocator, 0); (* switch off cursor *)
          (*  execute GOSUB menu-PROCEDURE *)
          (* writeln('cmdonmenu MENUindex= ',menuindex); *)
          new (l);
          l^.next := loopbase;
          loopbase := l;
          l^.loopkind := tokgosub;
          l^.homeline := stmtline;
          stmtline := menuprocp;
          gotoflag := true;
          (* writeln('cmdonmenu GOSUB => ',stmtline^.num); *)
        END;
    END;
    loopflag := false;
    t := NIL;
END;
   
BEGIN {---------------------------exec-------------------------}
  try
    gotoflag := false;
    elseflag := false;
    exitflag := false;
    xtifflag := false;
    loopflag := false;
    (*  loopflag is used by RETURN to execute the statement *)
    (*           following GOSUB.                           *)
    (*  gotoflag is used by GOSUB/GOTO to branch to the     *)
    (*           statement set in stmtline.                 *)
    REPEAT
      gotoflag := false;
      IF traceflag THEN
        listline (0, stmtline);
      REPEAT 
        t := stmttok;
        IF t <> NIL THEN
          BEGIN
            t := t^.next;
            IF debug3flag THEN
              BEGIN
                debugp2 ('exec1     ',stmttok);
                debugp2 ('exec2     ',t);
              END;
            CASE stmttok^.kind of
              toklbldef  : ;
              tokrem, tokremp, tokremx : ;
              tokstmterr : t := NIL;
              toklist    : cmdlist;
              tokllist   : cmdllist;
              tokhelp    : cmdhelp;
              tokrun     : cmdrun;
              toknew     : cmdnew;
              tokload    : cmdload('');
              toksave    : cmdsave('');
              tokbye, tokexit : cmdbye;
              toksystem  : cmdsystem;
              tokpause   : cmdpause;
              tokcls     : cmdcls; 
              tokrvar, tokivar, tokbvar, toksvar : cmdlet(0);
              toklet     : cmdlet (1);
              toklset    : cmdlet (2);
              tokrset    : cmdlet (3);  
              tokprint   : cmdprint;
              tokinput   : cmdinput (false);
              tokopen    : cmdopen;
              tokclose   : cmdclose;
              tokgoto    : cmdgoto;
              tokif      : cmdif;
              tokelse    : cmdelse;
              tokelseif  : cmdelseif;
              tokendif   : cmdendif;       
              tokend     : cmdend;
              tokstop    : escape(-20);
              tokfor     : cmdfor;
              toknext    : cmdnext;
              tokexitif  : cmdexitif;
              tokwhile   : cmdwhile (false);
              tokwend    : cmdwend;
              tokdo      : cmdwhile (true);
              tokloop    : cmdwend;
              tokrepeat  : cmdrepeat;
              tokuntil   : cmduntil;
              tokgosub   : cmdgosub;
              tokproc    : cmdproc; 
              toklocal, tokdeffn : t := NIL;    
              tokreturn  : cmdreturn;
              tokfreturn : cmdfreturn;
              tokread    : cmdread;
              tokdata    : ;
              tokrestore : cmdrestore;
              tokon      : cmdon;
              tokdim     : cmddim;
              tokarray   : cmdarrayfill;
              tokswap    : cmdswap;
              tokclr     : cmdclr;
              tokerase   : cmderase;
              tokadd     : cmdadd (false);   
              toksub     : cmdadd (true);   
              tokmul     : cmdmul (false);   
              tokdiv     : cmdmul (true);   
              tokinc     : cmdinc (false);   
              tokdec     : cmdinc (true);   
              toktest    : cmdtest (0);  
              tokedit    : cmdedit;  
              toktron    : cmdtron;  
              toktroff   : cmdtroff;  
              toktitlew  : cmdtitlew;
              tokinfow   : cmdinfow;
              tokopenw   : cmdopenw;
              tokclearw  : cmdclearw;
              tokclosew  : cmdclosew;
              tokcolor   : cmdcolor;
              toksetcolor : cmdsetcolor;
              tokgraphmode : cmdgraphmode;
              tokdeffill : cmddeffill;
              tokdefline : cmddefline;
              tokdefmark : cmddefmark;
              tokdeftext : cmddeftext;
              tokplot    : cmdplot (1);
              tokline    : cmdline;
              tokdraw    : cmdplot (3);
              toktext    : cmdtext;
              tokfill    : cmdfill;
              tokbox     : cmdbox (1);
              tokpbox    : cmdbox (2);
              tokrbox    : cmdbox (3);
              tokprbox   : cmdbox (4);
              tokcircle  : cmdcircle (1);
              tokpcircle : cmdcircle (2);
              tokellipse  : cmdellipse (1);
              tokpellipse : cmdellipse (2);
              tokdefmouse : cmddefmouse (4);
              tokhidem    : cmddefmouse (0);
              tokshowm    : cmddefmouse (1);
              tokmouse    : cmdmouse;
              tokpolyline : cmdpolyline (1);
              tokpolyfill : cmdpolyline (2);
              tokpolymark : cmdpolyline (3);
              tokalert    : cmdalert;
              tokfileselect : cmdfileselect;
              tokmenu     : cmdmenu;
              tokonmenu   : cmdonmenu;
              otherwise
                snerror('(exec) Illegal command');
            END; (* CASE *)
          END; (* IF t <> NIL *)
        stmttok := t;
      UNTIL t = NIL;
      IF stmtline <> NIL THEN
        BEGIN
          IF NOT (gotoflag OR xtifflag OR elseflag OR loopflag) THEN
            stmtline := stmtline^.next;
          IF stmtline <> NIL THEN
            stmttok := stmtline^.txt;
        END;
      IF traceflag and (tracemode > 0) THEN
        BEGIN
          IF stmtline <> NIL THEN
            writeln(' g',ord(gotoflag):1,
                    ' x',ord(xtifflag):1,
                    ' e',ord(elseflag):1,
                    ' l',ord(loopflag):1,
                    '  next',stmtline^.num);
            read (tracechar);
          IF tracechar = '|' THEN
            tracemode := 0;
        END;
      UNTIL stmtline = NIL;
  recover
    BEGIN
      IF escapecode = -20 THEN
        BEGIN
          write(tfu[dunit], 'Break');
        END
      ELSE IF escapecode = 42 THEN
        BEGIN END
      ELSE
        CASE escapecode of
          -4 : write(#7'Integer overflow');
          -5 : write(#7'Divide by zero');
          -6 : write(#7'Real math overflow');
          -7 : write(#7'Real math underflow');
          -8, -19..-15 : write(#7'Value range error');
          -10 : BEGIN
                  new(ioerrmsg);
                  misc_getioerrmsg(ioerrmsg^, ioresult);
                  write(#7, ioerrmsg^);
                  dispose(ioerrmsg);
                END;
          otherwise
            BEGIN
              IF excp_line <> -1 THEN
                writeln (tfu[dunit], excp_line);
                escape(escapecode);
            END;
        END; (* CASE *)
        IF stmtline <> NIL THEN
           write(tfu[dunit], ' in ', stmtline^.num:1);
        writeln (tfu[dunit]);
      END;
END; {exec}

BEGIN (* -----------------------------main-------------------------------*)
  initdevtable (false);
  dunit := 0;
  inittoktable;         (* fill token-tables *)
  new(inbuf);
  linebase := NIL;
  varbase := NIL;
  loopbase := NIL;
  lablbase := NIL;
  directcom := true;
  basprogname := '';
  debug3flag := false;
  debug2flag := false;
  runtstflag := false;
  exitflag := false;
  directcom := true;
  curline := 0;
  traceflag := false;
  grfopenw := false;
  grflocator := 0;
  menuindex := -1;
  restoredata;
  proctokp := NIL;
  functokp := NIL;
  writeln;
  writeln (bastitle);
  writeln;
(* ----------------------------------------------------------- *)
 REPEAT 
   try
     REPEAT
       IF directcom THEN
         write ('direct>')
       ELSE
         write (curline:6,'>');
       readln (inbuf^);
       IF inbuf^ = '' THEN
         directcom := true;
       parseinput (buf);
       IF curline = 0 THEN
         BEGIN
           stmtline := NIL;
           stmttok := buf;
           IF stmttok <> NIL THEN
             exec;
           disposetokens (buf);
         END;
     UNTIL exitflag or eof (input);
   recover
   IF escapecode <> -20 THEN
     misc_printerror(escapecode, ioresult)
   ELSE
     writeln;
  UNTIL exitflag or eof(input);
END.

