/*  filesel.c   v.9   with SRGP           12.07.1996  */
/* Routines for stbasic  Structured-BASIC-Interpreter */
/*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation (any version).

* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*   FILESELECT s$,n$,x$  fileselect-box      */
/*   additional functions for gfbasic         */
/*   filter added                             */
/*   display-features / select  added         */
/*   general routines extracted      25.05.96 */
/*   EDIT for filename added         26.05.96 */
/*   selectfile can be mod.          08.07.96 */
/*   setColor, setLineWidth added    22.12.96 */

/* coordinate-system on the screen canvas :   */
/*  SRGP:  (0,0) is lower left point          */
/*  Atari: (0,0) is upper left point          */
/*    Ynew = GRF_YMAX - Yold                  */

#include "srgp.h"

#include <stdio.h>  /* scanf, printf          */
#include <ctype.h>  /* toupper                */
#include <string.h> /* strcpy()               */
#include <stdlib.h> /* random, RAND_MAX       */
#include <unistd.h>
#include <sys/file.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <dirent.h>   /* scandir */
#include <fcntl.h>
#include <limits.h>
/* ------------------------------------------ */
#define GRF_XMAX 640
#define GRF_XMIN 160
#define GRF_YMAX 400
#define GRF_YMIN 100
#define GRF_MAXW 10
#define GRF_MAXP 500

#define BUFFERSIZE 4096
#define MAX_PATH   255
#define MAX_FILES  1024
#define NAME_LENG  32
#define BLOCK_LEN  16
#define FALSE 0
#define TRUE 1

#define FS_YSTXT 368
#define FS_YPATH 344
#define FS_YFSEL 320
#define FS_YFIL1 56
#define FS_YFIL2 312
#define FS_YSFIL 32
#define FS_YFSOK 8
#define FS_XFIL1 48
#define FS_XFIL2 304
#define FS_XDMAX 320
#define FS_YDMAX 400
#define FS_XCANV 160
#define FS_YCANV 0
#define FS_XTBOX 256
#define FS_YTBOX 16 
#define FS_BLENG 44
#define FS_WINDOW 9
#define FS_BUTNS BLOCK_LEN+6

/* ------------------------------------------------------------ */

static char dfnames[MAX_FILES][NAME_LENG];
char   pathname[MAX_PATH], selectfiles[MAX_PATH], filename[MAX_PATH];
char   auxstring[MAX_PATH];
int    fsbutx[22], fsbuty[22], fsbutw[22], fsbuth[22];

/* ------------------------------------------------------------ */
/* check, if locator is in one of the itmax boxes               */
/* position of boxes in: xb[i], yb[i]                           */
/* size of boxes in:     xw[i], xh[i]                           */ 
void
grfsevent (int itmax, int *vr, int *xb, int *yb, int *xw, int *yh);

/*   make new canvas #win, size (xmax,ymax) at (xcnv,ycnv)      */
void
grfnewcanvas (int win, int xmax, int ymax, int xcnv, int ycnv);

/* restore the original window                                  */
void
grfoldcanvas (int win, int xmax, int ymax, int xcnv, int ycnv);

/* ------------------------------------------------------------ */
/* Namefilter: select filenames according to mask               */
/*  e.g.:  mask = "*@*" selects all names containing '@'        */
int
namefilter (char *name, char *mask)
{
  int kname, kmask, wmask, wres, kskip;
  wmask = FALSE;
  wres = TRUE;
  kmask = 0;
  kskip = 0;
  for (kname=0; kname<=strlen(name); kname++) {
    if (wres == TRUE) {
      if (mask[kmask] == '*') {
        wmask = TRUE;
        kmask++;
      }
      if (wmask == TRUE) {
        if (name[kname] == mask[kmask]) { wmask = FALSE; kmask++; }
        else { kskip++; }
      }
      else {
        if (name[kname] == mask[kmask]) { kmask++; }
        else { wres = FALSE; }
      }
    }
  }
  if (mask[strlen(mask)-1] != '*') {
    if ( mask[strlen(mask)-1] != name[strlen(name)-1]) { wres = FALSE; }
    if ( kskip >= strlen(name)-1) { wres = FALSE; }
  }
  if ( kmask < strlen(mask)) { wres = FALSE; }
  return wres;
}

/* ------------------------------------------------------------ */
/* pack to fixed length: fpack = fidx + fname                   */
void
packfilnam (char *fpack, char *fidx, char *fname)
{
  int tmp;
  char filename[MAX_PATH];
  strcpy (filename, fidx);
  strcat (filename, fname);
  tmp = NAME_LENG - strlen (filename) - 1;
  if (tmp > 0)
    strncat (filename, "                                ", tmp);
  strncpy (fpack, filename, NAME_LENG);
  fpack[NAME_LENG] = '\0';
}

/* pack string:  fulldir = fpath + "/" + fdir                  */
void
packfuldir (char *fulldir, char *fpath, char *fdir)
{
  strcpy (fulldir,fpath);
  if (fpath[strlen(fpath)-1] != '/') 
    strcat (fulldir, "/");
  strcat (fulldir, fdir);
}

/*   delete trailing spaces    */
void
delspace (char *xname)
{
  int i, j;
  i = strlen(xname)-1;
  j = i;
  while (i>0) {
    j = i;
    if (xname[i] != ' ') i = 0;
    i--;
  }
  xname[j+1] = '\0';
}

/*   delete trailing name in pathname    */
void
deltname (char *xname)
{
  int i, j;
  if (strcmp(xname, "/") != 0) {
    i = strlen(xname)-1;
    j = i;
    while (i > 0) {
      j = i;
      if (xname[i] == '/') i = 0;
      i--; 
    }
    xname[j] = '\0';
  }   
}

/* ------------------------------------------------------------ */
/* get entries from directory "pathname"                        */
/* select filenames according to mask "selectfiles"             */
/* store filenames in table dfnames[i][j]                       */
static void
getdirentry (char *pathname, char *selectfiles, \
             int *cntdirfilx)
{
  struct stat fstats;   /* file status*/
  struct dirent **dirp; /* array of sorted dir-entries */
  char   dirname[MAX_PATH], fulldirnam[MAX_PATH];
  int    nroffiles, cntdirfil, i, j;
  /* printf (" getdirentry:  test file-selector\n"); */
  nroffiles=0;
  nroffiles = scandir (pathname, &dirp, NULL, alphasort);
  /* printf (" DIR  %d Directory-entries \n", nroffiles); */
  cntdirfil = 0;
  for (i=0; i<nroffiles; i++) {
    strcpy (dirname, dirp[i]->d_name);
    packfuldir (fulldirnam, pathname, dirname);
    if (lstat(fulldirnam,&fstats) > -1) {
      if ( S_ISDIR(fstats.st_mode) ) {
        if (strcmp(dirname, ".") != 0) {
          packfilnam (dfnames[cntdirfil], "/", dirname);
          if (cntdirfil < MAX_FILES) cntdirfil++;
        } 
      }
    }
  }
  /* printf (" TEST %s - %s \n", pathname, selectfiles); */
  for (i=0; i<nroffiles; i++) {
    strcpy (dirname, dirp[i]->d_name);
    packfuldir (fulldirnam, pathname, dirname);
    if(lstat(fulldirnam,&fstats) > -1) {
      if( !( S_ISLNK(fstats.st_mode) ||
             S_ISDIR(fstats.st_mode) ||
             S_ISCHR(fstats.st_mode) ||
             S_ISBLK(fstats.st_mode) ||
             S_ISSOCK(fstats.st_mode) )) {
               if (namefilter (dirname, selectfiles) == TRUE) {
                 packfilnam (dfnames[cntdirfil], " ", dirname);
                 if (cntdirfil < MAX_FILES) cntdirfil++;
               } 
      }
    }
  }
  *cntdirfilx = cntdirfil;
}

/* --------------------------------------------- */
/*   draw rectangle at (x,y) with size (dx,dy)   */
void
fs_rectangle (int x, int y, int dx, int dy)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  SRGP_rectangleCoord (bx, by, bx+dx, by+dy); 
}

/*   clear box at (x0,y0, x1,y1)                 */
void
fs_clrbox (int x0, int y0, int x1, int y1)
{
  SRGP_setColor (0) ;  /* COLOR_WHITE */
  SRGP_setFillStyle (SOLID);
  SRGP_setWriteMode (WRITE_REPLACE);
  SRGP_fillRectangleCoord (x0, y0, x1, y1);
  SRGP_setColor (1);  /* BLACK */
}

/*   write text "btxt" into box at (x,y)         */
void
fs_box (int x, int y, int dx, char *btxt)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  fs_clrbox (bx+1, by+1, bx+dx-1, by+FS_YTBOX-1);
  SRGP_rectangleCoord (bx, by, bx+dx, by+FS_YTBOX); 
  SRGP_text (SRGP_defPoint (bx+2, by+2), btxt);
} 

/*   write text "btxt" at (x,y)                  */
void
fs_tbox (int x, int y, int dx, char *btxt)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  SRGP_text (SRGP_defPoint (bx+2, by+2), btxt);
} 

/* display operation-buttons and set select-box-coord.  */
void
fs_xbox (int x, int y, int dx, char *btxt)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  SRGP_rectangleCoord (bx, by, bx+FS_BLENG, by+FS_YTBOX); 
  SRGP_text (SRGP_defPoint (bx+2, by+2), btxt);
  fsbutx[dx] = bx;
  fsbuty[dx] = by;
  fsbutw[dx] = FS_BLENG;
  fsbuth[dx] = FS_YTBOX;
} 

/*   get text from keyboard in field at (x,y)          */
void
fs_qbox (int x, int y, int dx, char *btxt)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  fs_clrbox (bx+1, by+1, bx+dx-1, by+FS_YTBOX-1);
  SRGP_setKeyboardEchoOrigin (SRGP_defPoint(bx+2, by+2));
  SRGP_setInputMode (KEYBOARD, EVENT);
  SRGP_waitEvent (-1);
  SRGP_getKeyboard (btxt, NAME_LENG);
  SRGP_setInputMode (KEYBOARD, INACTIVE);
} 

/* ------------------------------------------- */
/* display filename and set select-box-coord.  */
/*   indicator no text: fsbutx[i] < 0            */
void
fs_fbox (int x, int y, int dx, char *btxt)
{
  int bx, by;
  bx = FS_XCANV+x;
  by = FS_YCANV+y;
  fs_clrbox (bx+1, by+1, bx+FS_XTBOX-2, by+FS_YTBOX-2);
  if (strlen(btxt) > 0) {
    SRGP_text (SRGP_defPoint (bx+2, by+2), btxt);
  }
  else  
   { bx = -1; }
  fsbutx[dx] = bx;
  fsbuty[dx] = by;
  fsbutw[dx] = FS_XTBOX;
  fsbuth[dx] = FS_YTBOX;
} 

/* --------------------------------------------- */
/* display part of directory-list                */
void
displayname (int namidx1, int cntdirfil)
{
  int    i, j, namidx2, namidx3, yfbox;
  char   dname[NAME_LENG], filename[MAX_PATH];
  namidx2 = namidx1 + BLOCK_LEN-1;
  namidx3 = namidx2;
  if (namidx2 > cntdirfil) namidx2 = cntdirfil - 1;
  yfbox = FS_YFIL2 - FS_YTBOX;
  for (i=namidx1; i<=namidx3; i++) {
    if (i <= namidx2)
      { fs_fbox (FS_XFIL1, yfbox, i-namidx1, dfnames[i]); }
    else
      { fs_fbox (FS_XFIL1, yfbox, i-namidx1, ""); }
    yfbox = yfbox - FS_YTBOX;
  }
}

/* ---------------------------------------------------------- */
/* separate path and selector-mask from BASIC input-string s$ */
/*  e.g.:  "/disk/*.LIS" => path "/disk" + mask "*.LIS"       */
void
filxps (char *pathsel, char *path, char *sel)
{
  int i, j, k;
  strcpy (path, "/");
  strcpy (sel, "*");
  i = strlen(pathsel)-1;
  k = i; 
  j = i;
  while (i>0) {
    j = i;
    if (pathsel[i] == '/') i = 0;
    i--;
  }
  if (j>0) strncpy (path, pathsel, j);
  path[j] = '\0'; 
  if (k-j>0) {
    for (i=0; i<k-j;i++) {
      sel[i] = pathsel[i+j+1];
    }
    sel[k-j+1] = '\0';
  }
  /* printf (" filxps  %s | %s | %s \n",pathsel,path,sel); */
}

/* ----------------------------------------------------------------- */
/*   FILESELECT s$,n$,x$  fileselect-box                             */
/*                        s$  (string) search-path                   */
/*                        n$  (string) filename                      */
/*                        x$  (string) return selected filename      */
void
grf_fileselect ( char *sfs, char *nfs, char *xfile)
{
  int nroffiles;
  int cntdirent; 
  int i, j, namindex, boxnr;
  char dname[NAME_LENG+1], qname[NAME_LENG+1];
  /* printf("grf_fileselect  %s  %s  %s  \n",sfs,nfs,filename); */
  /*   get path-name and mask for select-file */
  strcpy(filename,nfs);
  filxps (sfs, pathname, selectfiles);
  /*   make new canvas for file-selector      */
  grfnewcanvas (FS_WINDOW, FS_XDMAX, FS_YDMAX, FS_XCANV, FS_YCANV);
  SRGP_setColor (1);
  SRGP_setLineWidth (1);
  /*  draw contents of FILSELECTOR-window   */
  fs_rectangle (1, 1, FS_XDMAX-2, FS_YDMAX-2);
  fs_rectangle (FS_XFIL1, FS_YFIL1, FS_XTBOX, FS_YTBOX*BLOCK_LEN);
  fs_tbox (FS_XFIL1, FS_YSTXT, FS_XTBOX, "         FILE-SELECTOR");
  fs_tbox (FS_XFIL1-FS_BLENG-2, FS_YPATH, FS_BLENG, "PATH:");
  fs_box (FS_XFIL1, FS_YPATH, FS_XTBOX, pathname);
  fs_tbox (FS_XFIL1-FS_BLENG-2, FS_YFSEL, FS_BLENG, "SEL.:");
  fs_box (FS_XFIL1, FS_YFSEL, FS_XTBOX, selectfiles);
  fs_tbox (FS_XFIL1-FS_BLENG-2, FS_YSFIL, FS_BLENG, "FILE:");
  fs_box (FS_XFIL1, FS_YSFIL, FS_XTBOX, filename);
  fs_box (FS_XFIL1-FS_BLENG-2, (FS_YFIL2+FS_YFIL1)/2-FS_YTBOX,\
          FS_BLENG, "FILES");
  /* select boxes: "filename" "UP" "DOWN" "OK" "EXIT"   */
  fs_fbox (FS_XFIL1, FS_YFSEL, BLOCK_LEN+0, selectfiles);
  fs_fbox (FS_XFIL1, FS_YSFIL, BLOCK_LEN+1, filename);
  fs_xbox (FS_XFIL1-FS_BLENG-2, FS_YFIL2-FS_YTBOX, BLOCK_LEN+2, "/\\_/\\");
  fs_xbox (FS_XFIL1-FS_BLENG-2, FS_YFIL1, BLOCK_LEN+3, "\\/~\\/");
  fs_xbox (FS_XFIL1, FS_YFSOK, BLOCK_LEN+4, " OK ");
  fs_xbox (FS_XFIL2-FS_BLENG, FS_YFSOK, BLOCK_LEN+5, "EXIT");
  SRGP_refresh();
  /*   printf("fileselect displayname \n"); */
  getdirentry (pathname, selectfiles, &cntdirent);
  sprintf (auxstring, "%d\0", cntdirent);
  fs_box (FS_XFIL1-FS_BLENG-2, (FS_YFIL2+FS_YFIL1)/2,\
          FS_BLENG, auxstring);
  namindex = 0; 
  displayname (namindex, cntdirent);
  SRGP_refresh();

  /* =========  wait for the selection of the file */
  boxnr = -1;
  while (boxnr < BLOCK_LEN+4) {
    grfsevent (BLOCK_LEN+6, &boxnr, fsbutx, fsbuty, fsbutw, fsbuth);
    /* ---------------------- filename is selected   */
    if ((boxnr < BLOCK_LEN) && (namindex+boxnr < cntdirent)) {
      i = boxnr + namindex;
      strcpy (dname, dfnames[i]);
      delspace (dname);
      if (strcmp (dname, "/..") == 0) {
        deltname (pathname);
        getdirentry (pathname, selectfiles, &cntdirent);
        sprintf (auxstring, "%d\0", cntdirent);
        fs_box (FS_XFIL1-FS_BLENG-2, (FS_YFIL2+FS_YFIL1)/2,\
                FS_BLENG, auxstring);
        namindex = 0; 
      }
      else { /* -------------------- Directory is selected  */  
        if (dname[0] == '/') {
          if (strcmp(pathname, "/") == 0) { strcpy (pathname, dname); }
          else { strcat (pathname, dname); }
          getdirentry (pathname, selectfiles, &cntdirent);
          sprintf (auxstring, "%d\0", cntdirent);
          fs_box (FS_XFIL1-FS_BLENG-2, (FS_YFIL2+FS_YFIL1)/2,\
                  FS_BLENG, auxstring);
          namindex = 0; 
        }
        else { /*   return whole path for file-name   | OK |  */
          strcpy (filename, "");
          if (strcmp (pathname, "/") != 0)
            strcpy (filename, pathname);
          dname[0] = '/';
          strcat (filename, dname);  
        }
      }
    }
    /* ---------------------- test for "selectfile" EDIT-input */
   if (boxnr == BLOCK_LEN+0) {
      fs_qbox (FS_XFIL1, FS_YFSEL, FS_XTBOX, qname);
      delspace (qname);
      strcpy (selectfiles,qname);   
      getdirentry (pathname, selectfiles, &cntdirent);
      sprintf (auxstring, "%d\0", cntdirent);
      fs_box (FS_XFIL1-FS_BLENG-2, (FS_YFIL2+FS_YFIL1)/2,\
              FS_BLENG, auxstring);
      namindex = 0; 
    }
    /* ---------------------- test for "filename" EDIT-input */
   if (boxnr == BLOCK_LEN+1) {
      fs_qbox (FS_XFIL1, FS_YSFIL, FS_XTBOX, qname);
      delspace (qname);
      packfuldir (filename, pathname, qname);
    }
    /* ---------------------- test for function  |^^^|   */
   if (boxnr == BLOCK_LEN+2) {
      namindex = namindex - BLOCK_LEN/2;
      if (namindex < 0) namindex = 0;
    }
    /* ---------------------- test for function  |vvv|   */
    if (boxnr == BLOCK_LEN+3) {
      namindex = namindex + BLOCK_LEN/2;
      if (namindex > cntdirent-BLOCK_LEN) \
          namindex = cntdirent-BLOCK_LEN;
    }
    /* ---------------------- test for function  |EXIT| */
    if (boxnr == BLOCK_LEN+5) {
      strcpy(filename,"");
    }
      /* printf("cntd %d nam %d  boxnr %d\n",cntdirent,namindex,boxnr); */
      fs_box (FS_XFIL1, FS_YFSEL, FS_XTBOX, selectfiles);
      fs_box (FS_XFIL1, FS_YPATH, FS_XTBOX, pathname);
      fs_box (FS_XFIL1, FS_YSFIL, FS_XTBOX, filename);
      displayname (namindex, cntdirent);
      SRGP_refresh();
  } /* *** while (boxnr < BLOCK_LEN+4) *** */
  /*   restore the original window */
  grfoldcanvas (FS_WINDOW, FS_XDMAX, FS_YDMAX, FS_XCANV, FS_YCANV);

  strcpy (xfile, filename);
  /* printf (" PATHNAME:|%s| \n", pathname); */
  /* printf (" SELECTED |%s| \n", filename); */ 
}

