/*  alertbox.c   v.5     with SRGP         12.07.1996  */
/*  Routines for stbasic  Structured-BASIC-Interpreter */
/*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation (any version).

* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*   ALERT a,ms$,b,b$,var  ALERT-BOX                */
/*   included general routines i          25.05.96  */
/*   ms$ with 4 lines of text             10.06.96  */
/*   grfevent mod. for exit in MENU       18.06.96  */
/*   fillstyle added                      22.12.96  */

/* coordinate-system on the screen canvas :   */
/*  SRGP:  (0,0) is lower left point          */
/*  Atari: (0,0) is upper left point          */
/*    Ynew = GRF_YMAX - Yold                  */

#include <stdio.h>
#include <string.h>
#include "srgp.h"

#define GRF_XMAX 640
#define GRF_XMIN 160
#define GRF_YMAX 400
#define GRF_YMIN 100
#define GRF_MAXW 10
#define GRF_MAXP 500

#define AL_BTW 55
#define AL_BTH 25
#define AL_XDMAX 200
#define AL_YDMAX 150
#define AL_XATXT 100    /* AL_XDMAX/2 */
#define AL_XBTXT  67    /* AL_XDMAX/3 */
#define AL_XDTXT  57    /* AL_XBTXT-10 */
#define AL_YATXT 130
#define AL_YTEXT 110
#define AL_TXDIF 16
#define AL_YSIGN 40
#define AL_WINDOW  9    /* alertbox-window */
#define AL_XCANV 220    /* (GRF_XMAX-AL_XDMAX)/2 */
#define AL_YCANV 125    /* (GRF_YMAX-AL_YDMAX)/2 */

struct {
  int grfwindx[GRF_MAXW];
  int grfwindy[GRF_MAXW];
  attribute_group grfclwbund, grfalrbund;
  canvasID grfwindow[GRF_MAXW];
} grf_comm1;

static locator_measure grfevent;
int albutx[3], albuty[3], albutw[3], albuth[3];
char altxt[32];

extern void
grf_openw (int n, int x, int y);

extern void
grf_closew (int n);

/* ------------------------------------------------------------ */
/*   make new window #win size (xmax, ymax) at (xcnv,ycnv)      */
void
grfnewcanvas (int win, int xmax, int ymax, int xcnv, int ycnv)
{
  /*  ------ make new canvas         */
  grf_openw (win, 2*xmax, ymax);
  SRGP_useCanvas (grf_comm1.grfwindow[win]); 
  /*   save graphic parameter values */
  SRGP_inquireAttributes (&grf_comm1.grfalrbund);
  SRGP_setFillStyle (SOLID);
  SRGP_setWriteMode (WRITE_REPLACE);
  SRGP_copyPixel (grf_comm1.grfwindow[0], \
    SRGP_defRectangle(xcnv, ycnv,\
                      xcnv+xmax-1, ycnv+ymax-1), \
    SRGP_defPoint(xmax, 0) ); 
  /* printf(" ----- clear new window \n"); */
  SRGP_setColor (SRGP_BLACK);
  SRGP_setPenStyle (SOLID);
  SRGP_setWriteMode (WRITE_REPLACE);
  /* printf(" ----- show new window \n"); */
  SRGP_useCanvas (0);
  SRGP_setWriteMode (WRITE_REPLACE);
  SRGP_copyPixel (grf_comm1.grfwindow[win], \
      SRGP_defRectangle(0,0,xmax-1,ymax-1),\
      SRGP_defPoint(xcnv,ycnv));
  SRGP_setClipRectangle ( \
      SRGP_defRectangle(xcnv, ycnv, xcnv+xmax-1, ycnv+ymax-1));
  SRGP_refresh();
}

/* ------------------------------------------------------------ */
/*   restore the original window                                */
void
grfoldcanvas (int win, int xmax, int ymax, int xcnv, int ycnv)
{
  SRGP_useCanvas (0);
  SRGP_setWriteMode (WRITE_REPLACE);
  SRGP_copyPixel (grf_comm1.grfwindow[win], \
      SRGP_defRectangle (xmax, 0, 2*xmax-1, ymax),\
      SRGP_defPoint (xcnv, ycnv) );
  SRGP_setAttributes (&grf_comm1.grfalrbund);
  SRGP_refresh();
  grf_closew (win);
  SRGP_useCanvas (0);
  SRGP_setClipRectangle( \
      SRGP_defRectangle (0,0,grf_comm1.grfwindx[0]-1,\
                             grf_comm1.grfwindy[0]-1) );
}

/* ------------------------------------------------------------ */
/* switch on LOCATOR(1) with CURSOR(0) / LEFT_BUTTON(0)         */
/*  SAMPLE(3) mode                                              */
void
grfsamploc (void)
{
  SRGP_setLocatorEchoType (CURSOR);
  SRGP_setLocatorButtonMask (LEFT_BUTTON_MASK|RIGHT_BUTTON_MASK);
  SRGP_setInputMode (LOCATOR, SAMPLE);
}

/* switch off LOCATOR(1) with CURSOR(0) / LEFT_BUTTON(0)        */
void
grfsampoff (void)
{
  SRGP_setInputMode (LOCATOR,INACTIVE);
}

/*  read locator values x, y , key                             */
void
grfsamples (int *x, int *y, int *k)
{
  int kk;
  SRGP_sampleLocator (&grfevent);
  *x = grfevent.position.x;
  *y = grfevent.position.y;
  kk = 0;
  if (grfevent.button_chord[0] == DOWN ) kk = 1;
  if (grfevent.button_chord[2] == DOWN ) kk = kk + 2;
  *k = kk;
}

/*   check, if locator is within rectangle (tx0,ty0, txw,txh)  */
int
grftstloc (int tx0, int ty0, int txw, int tyh)
{ int lretx, lrety;
  lretx = 0;
  lrety = 0;
  if (tx0 > 0) {
    SRGP_sampleLocator (&grfevent);
    if ((grfevent.position.x > tx0) && \
        (grfevent.position.x < tx0+txw)) { lretx = 1; }
    if ((grfevent.position.y > ty0) && \
        (grfevent.position.y < ty0+tyh)) { lrety = 1; }
  }
  return (lretx * lrety);
}

/*   fill given rectangle in mode XOR                          */
void
grfboxfil (int tx0, int ty0, int txw, int tyh)
{ 
  SRGP_setColor (1);
  SRGP_setFillStyle (SOLID);
  SRGP_setWriteMode (WRITE_XOR);
  SRGP_fillRectangleCoord (tx0+1, ty0+1, tx0+txw-1, ty0+tyh-1);
  SRGP_refresh();
}

/*   test button #nbut on locator (mouse)                      */
int
grftestbut (int nbut)
{ 
  int event;
  event = 0;
  SRGP_sampleLocator (&grfevent);
  if (grfevent.button_chord[nbut-1] == DOWN ) {
    while (event == 0) {
      SRGP_sampleLocator (&grfevent);
      if (grfevent.button_chord[nbut-1] == UP) { event = 1; }
    }
    event = nbut;
  }
  return event;
}

/* ------------------------------------------------------------ */
/* check, if locator is in one of the itmax boxes               */
/* position of boxes in: xb[i], yb[i]                           */
/* size of boxes in:     xw[i], xh[i]                           */ 
/*    if xb[i] < 0 then no check                                */
/*    if itmax<0: allow exit from box-selection with boxnr=-1   */
void
grfsevent (int itmax, int *vr, int *xb, int *yb, int *xw, int *yh)
{
  int itx, event, filled, boxnr, bexit, bitmax;
  bexit = 0;
  bitmax = itmax;
  if (itmax < 0) {
    bitmax = -itmax;
    bexit = -1;
  }
  /* wait for the event ----------------------------- */
  grfsamploc ();
  event = 0;
  filled = -1;
  while (event == 0) {
    boxnr = -1;
    for (itx=0; itx < bitmax; itx++) {
      if (xb[itx] >= 0) {
        /*  test for locator-POSITION  */
        event = grftstloc (xb[itx], yb[itx], xw[itx], yh[itx]);
        if (event == 1) { boxnr = itx; }
      }
    }
    if (boxnr >= 0) {
      if (boxnr != filled) {
        grfboxfil (xb[boxnr], yb[boxnr], xw[boxnr], yh[boxnr]);
        if (filled >= 0) {
          grfboxfil (xb[filled], yb[filled], xw[filled], yh[filled]);
        }
        filled = boxnr;
      }
      /*  test for locator-BUTTON  */
      event = 0;
      if (grftestbut (1) == 1) {
        event = -1;
        grfboxfil (xb[boxnr], yb[boxnr], xw[boxnr], yh[boxnr]);
      }
    }
    else {
      if (filled >= 0) {
        grfboxfil (xb[filled], yb[filled], xw[filled], yh[filled]);
        filled = -1;
      }
      if ((bexit < 0) && (grftestbut (1) == 1)) {
        event = -1;
        boxnr = -1;
      }
    }
  }  /*  end while(event==0)  */
  *vr = boxnr;
}

/* ------------------------------------------------------------ */
/*   read Text for ALERT-BOX, separate text for buttons         */
/*  format: "text1|text2|text3"                                 */
/*  copy txt1 => txt2 up to "|", length max. "maxch"            */
void
grfatext (int *tcnt, char txt1[], char txt2[], int maxch)
{
  int tlen, t1ln, t2ln;
  char tcx;
  tlen = strlen (txt1);
  t1ln = *tcnt;
  t2ln = 0;
  while ( t1ln < tlen ) {
    tcx = txt1[t1ln];
    t1ln++;
    if (tcx == '|') { tlen = 0; }
    else {
      txt2[t2ln] = tcx;
      if (t2ln < maxch) { t2ln++; }
    }
  }
  txt2[t2ln] = '\0'; 
  *tcnt = t1ln;
}

/*   write text centered in box at (bxc,byc)                    */
/*   character-width = 8                                        */
void
grfcentxt (int bxc, int byc, char *btx)
{ 
  int bxx;
  bxx = bxc - (strlen (btx) *8) / 2,
  SRGP_text (SRGP_defPoint (AL_XCANV+bxx, AL_YCANV+byc), btx);
}

/* ------------------------------------------------------------ */
/*   display an alert-button with text at (btxcc,btycc)         */     
void
grfbutton (int bnum, int bval, char *albutxt, int btxcc, int btycc)
{
  int blw, btxc, btyc;
  /*   draw box and text   */
  btxc = btxcc + AL_XCANV;
  btyc = btycc + AL_YCANV; 
  if (albutxt[0] != '\0') {
    if (bnum == bval) { blw = 2; } else { blw = 1; }
    SRGP_setLineWidth (blw);
    SRGP_rectangleCoord (btxc, btyc, btxc+AL_BTW, btyc+AL_BTH);
    grfcentxt (btxcc+AL_BTW/2, btycc+5, albutxt);
  }
  else { btxc = -1; }
  albutx [bnum-1] = btxc;
  albuty [bnum-1] = btyc;
  albutw [bnum-1] = AL_BTW;
  albuth [bnum-1] = AL_BTH;
}

/* ------------------------------------------------------------ */
/*   ALERT a,ms,b,b$,vr   ALERT-BOX                             */
/*                        a       sign: 1=! 2=? 3=STOP          */
/*                        ms$     textstring                    */
/*                        b       button frame (0,1,2,3)        */
/*                        bs$     string for buttons "b1|b2|b3" */
/*                        vr      return # of button selected   */ 
void
grf_alert (long a, char *ms, long b, char *bs, long *vr)
{
  int  boxnr, ctx, itx;
  /*  printf("grf_alert  %d  %s  %d  %s  %d \n",a,ms,b,bs,*vr); */
  /*    make new canvas for the alert-box        */
  grfnewcanvas (AL_WINDOW, AL_XDMAX, AL_YDMAX, AL_XCANV, AL_YCANV);
  /*   fill alert-box */
  SRGP_setColor (1);
  SRGP_setLineWidth (1);
  SRGP_rectangleCoord(AL_XCANV+1, AL_YCANV+1,\
                      AL_XCANV+AL_XDMAX-2, AL_YCANV+AL_YDMAX-2);
  grfcentxt (AL_XATXT, AL_YATXT, "A L E R T");
  /*   write max. 4 lines of text           */
  ctx = AL_YTEXT;
  itx = 0;
  for (boxnr=1; boxnr<=4; boxnr++) {
    grfatext (&itx, ms, altxt, 28);
    grfcentxt (AL_YTEXT, ctx, altxt);
    ctx -= AL_TXDIF;
  }
  strcpy (altxt ,"    ");
  if (a == 1) { strcpy (altxt, "!!!"); }
  if (a == 2) { strcpy (altxt, "???"); }
  if (a == 3) { strcpy (altxt, "STOP"); }
  grfcentxt (AL_XATXT, AL_YSIGN, altxt);
  /*   scan text for number of the button infos */
  ctx = 3*AL_XBTXT/2 + 5;
  itx = 0;
  for (boxnr=1; boxnr<=3;  boxnr++) {
    grfatext (&itx, bs, altxt, 7);
    if (altxt[0] != '\0') ctx -= AL_XBTXT/2;
  }
  /*   scan text for the button infos */
  itx = 0;
  for (boxnr=1; boxnr<=3;  boxnr++) {
    grfatext (&itx, bs, altxt, 7);
    grfbutton (boxnr, b, altxt, ctx, 10);
    ctx += AL_XBTXT;
  }
  /*   wait for the event ----------------------------- */
  grfsevent (3, &boxnr, albutx, albuty, albutw, albuth);
  /*   restore old canvas */
  grfoldcanvas (AL_WINDOW, AL_XDMAX, AL_YDMAX, AL_XCANV, AL_YCANV);
  *vr = (long) boxnr + 1;

  /* printf("grf_alert  %d  %s  %d  %s  %d \n",a,ms,b,bs,*vr); */
}

